/* CMDINPUT.H
 * handles command input (tab completion, history, etc.)
 * Tim Norman
 * 1-14-95
*/

#define BS 8
#define DELETE 256+83
#define TAB 9
#define HOME 256+71
#define END 256+79
#define UP 256+72
#define DOWN 256+80
#define LEFT 256+75
#define RIGHT 256+77
#define ENTER 13
#define ESC 27

#define BEEP printf ("\a")

/* this is inefficient to call each time something is changed */
/* make it better */
void reprint (char *str, int x, int *y, int place)
{
   int gox, goy;

   str[127] = 0;        /* truncate in case it's too long */

   gotoxy (x, *y);

   /* figure out if it's going to scroll... */
   gox = x + strlen (str);
   goy = *y;

   while (gox > 80)
   {
      gox -= 80;
      goy++;
   }

   while (goy > 25)
   {
      goy--;
      (*y)--;
   }

   printf (str);
   clreol ();

   gox = x + place;
   goy = *y;

   while (gox > 80)
   {
      gox -= 80;
      goy++;
   }

   gotoxy (gox, goy);
}

void reposition (int curx, int cury, int place)
{
   int gox, goy;

   gox = curx + place;
   goy = cury;

   while (gox > 80)
   {
      gox -= 80;
      goy++;
   }

   gotoxy (gox, goy);
}

void readcommand (char *str, int maxlen)
{
   struct ffblk file;
   static char buffer[80][128] = {""};
   static int bufstart = 0, bufend = 0;
   int place = 0, len = 0, ch, bufplace = bufend;
   int curx, cury, gox, goy, count, y;

   curx = wherex ();
   cury = wherey ();

   str[0] = 0;

   do
   {
      ch = getch ();

      if (ch == 0)      /* special key */
	 ch = 256 + getch ();

      switch (ch)
      {
	 case BS:
	    /* delete character to left of cursor */
	    if (place != 0)
	    {
	       place--;

	       for (count = place; count < len; count++)
		  str[count] = str[count + 1];

	       len--;

	       if (wherex () != 1)
		  printf ("\b \b");
	       else
	       {
		  y = wherey ();
		  gotoxy (80, y - 1);
		  printf (" ");
		  gotoxy (80, y - 1);
	       }

	       reprint (str, curx, &cury, place);
	    }

	    break;

	 case DELETE:
	    /* delete character under cursor */
	    if (place != len)
	    {
	       for (count = place; count < len; count++)
		  str[count] = str[count + 1];

	       len--;

	       if (place != 0)
	       if (wherex () != 1)
		  printf ("\b \b");
	       else
	       {
		  y = wherey ();
		  gotoxy (80, y - 1);
		  printf (" ");
		  gotoxy (80, y - 1);
	       }

	       reprint (str, curx, &cury, place);
	    }

	    break;

	 case HOME:
	    /* goto beginning of string */
	    gotoxy (curx, cury);

	    place = 0;

	    break;

	 case END:
	    /* goto end of string */
	    place = len;

	    reposition (curx, cury, place);

	    break;

	 case TAB:
	    /* expand current file name */
	    if (place == len)  /* only works at end of line */
	    {
	       char path[128], fname[14], maxmatch[13] = "", directory[128];
	       int found_dot = 0, curplace = 0, start, perfectmatch = 1;

	       count = len;

	       while (str[count] != ' ' && count > 0) /* find front of word */
		  count--;

	       if (str[count] == ' ')  /* if not at beginning, go forward 1 */
		  count++;

	       start = count;

	       /* extract directory from word */
	       strcpy (directory, &str[start]);
	       curplace = strlen (directory) - 1;
	       while (curplace >= 0 && directory[curplace] != '\\' &&
		      directory[curplace] != ':')
	       {
		  directory[curplace] = 0;
		  curplace--;
	       }

	       strcpy (path, &str[start]);

	       for (count = 0; path[count] != 0; count++)
		  if (path[count] == '.')
		  {
		     found_dot = 1;
		     break;
		  }

	       if (found_dot)
		  strcat (path, "*");
	       else
		  strcat (path, "*.*");

	       curplace = 0;    /* current fname */
	       if (findfirst (path, &file, 0x3F) == 0)  /* find anything */
	       {
		  do
		  {
		     if (file.ff_name[0] == '.')  /* ignore . and .. */
			continue;

		     strcpy (fname, file.ff_name);
		     if (file.ff_attrib == FA_DIREC)
			strcat (fname, "\\");
		     else
			strcat (fname, " ");

		     if (!maxmatch[0] && perfectmatch)
			strcpy (maxmatch, fname);
		     else
		     {
			for (count = 0; maxmatch[count] && fname[count];
			     count++)
			   if (maxmatch[count] != fname[count])
			   {
			      perfectmatch = 0;
			      maxmatch[count] = 0;
			      break;
			   }
		     }
		  }
		  while (findnext (&file) == 0);

		  strcpy (&str[start], directory);
		  strcat (&str[start], maxmatch);
		  len = strlen (str);
		  place = len;

		  reprint (str, curx, &cury, place);

		  if (!perfectmatch)
		     BEEP;
	       }
	       else
		  BEEP;
	    }
	    else
	       BEEP;

	    break;

	 case ENTER:
	    /* end input, return to main */
	    if (str[0])
	       history (0, str);  /* add to the history */

	    place = len;
	    reprint (str, curx, &cury, place);

	    printf ("\n\n");

	    break;

	 case ESC:
	    /* clear str */
	    gotoxy (curx, cury);

	    for (count = 0; count < strlen (str); count++)
	       printf (" ");

	    place = len = str[0] = 0;

	    gotoxy (curx, cury);

	    break;

	 case UP:
	    /* get previous command from buffer */
	    gotoxy (curx, cury);

	    for (count = 0; count < strlen (str); count++)
	       printf (" ");

	    history (-1, str);

	    len = strlen (str);

	    place = len;

	    reprint (str, curx, &cury, place);

	    break;

	 case DOWN:
	    /* get next command from buffer */
	    gotoxy (curx, cury);

	    for (count = 0; count < strlen (str); count++)
	       printf (" ");

	    history (1, str);

	    len = strlen (str);

	    place = len;

	    reprint (str, curx, &cury, place);

	    break;

	 case LEFT:
	    /* move cursor left */
	    if (place != 0)
	       place--;
	    else
	       BEEP;

	    reposition (curx, cury, place);

	    break;

	 case RIGHT:
	    /* move cursor right */
	    if (place != len)
	       place++;

	    reposition (curx, cury, place);

	    break;

	 default:
	    if (ch >= 32 && ch <= 255 && len != maxlen - 2)
	    {
	       /* insert character into string... */
	       for (count = len + 1; count > place; count--)
		  str[count] = str[count - 1];

	       str[place] = ch;
	       place++;
	       len++;

	       reprint (str, curx, &cury, place);
	    }
	    else
	       BEEP;
      }
   }
   while (ch != ENTER);
}
