;==============================================================================
;==
;==     Project                 : 286 XMS driver
;==     Module name             : HM286.HM
;==     Author(s)               : Mark E. Huss
;==     Purpose                 : HM.ASM strucs, macros & equates
;==
;==     Created                 : 11/5/90
;==
;==                              Revision history
;==                              ================
;==
;==============================================================================
	page 65,132

AVERSION 	equ	"2.10"
XMS_VERSION	equ	200h
OUR_VERSION	equ	XMS_VERSION + 10h

DEBUG		equ	0	; 1 for extra debug info at runtime
MOLDY_286	equ	0	; 1 to avoid 286 B-step bug

MIN_XMEM	equ	384		; minimum usable memory
MAX_HANDLES	equ	8
XMEM_BASE	equ	440h		; 110000h base (110000 / 1K)

DD_INIT		equ	00h
DD_DONE		equ	0100h
DD_ERROR	equ	8000h
DD_CMD_ERR	equ	DD_ERROR + 3	; unknown command

PIC_MASK	equ	21h		; PIC mask register

SYSTEM_CONTROL_PORT_A	equ	92h
A20_ENABLE_BIT		equ	2
CARRY_FLAG		equ	1

VDISK_OFS		equ	12h

KC_A20_BIT	equ	02h
KC_RESET_BIT	equ	01h
KC_WR_OUTPORT	equ	0D1h
KBD_DATA	equ	60h
KBD_STATUS	equ	64h
KBD_COMMAND	equ	64h
KS_INPORT_FULL	equ	02h

; hm_flags

INIT_DONE	equ	01h
INT15_HOOKED	equ	02h
HMA_IN_USE	equ	04h
IN_MOVE		equ	08h

; xms_handle flgs

XH_IN_USE	equ	01h		; handle in use
XH_LAST		equ	02h		; last handle in chain
;------------------------------------------------------------------------------

Rest	MACRO
	jmp	$+2
	ENDM

@Print	MACRO	s1
	IFNB	<s1>
	  mov	dx,offset s1
	ENDIF
	mov	ah,9
	int	21h
	ENDM

@popf	MACRO
if MOLDY_286
	push	cs
	call	popf_iret	; popf for 286 B-step bug
else
	popf			; normal popf
endif
	ENDM

;------------------------------------------------------------------------------

words	struc			; for accessing 1/2 dwords
lsw	dw	?
msw	dw	?
words	ends

bytes	struc			; for accessing 1/2 words
lsb	db	?
msb	db	?
bytes	ends

reqhdr	struc
	db	?		; length
	db	?		; unit #
 cmd	db	?		; command
 stat	dw	?		; status
	db	8 dup(?)	; reserved
reqhdr	ends

inithdr	struc
	db	(type reqhdr) dup(?)
 units	db	0
 endofs	dw	0
 endseg	dw	0
 bpbofs	dw	0
 bpbseg	dw	0
inithdr	ends

regframe	struc
 r_es	dw	?
 r_ds	dw	?
 r_di	dw	?
 r_si	dw	?
 r_bp	dw	?
 r_sp	dw	?
 r_bx	dw	?
 r_dx	dw	?
 r_cx	dw	?
 r_ax	dw	?
regframe	ends

xms_handle	struc
 xbase	dw	?
 xsize	dw	?
 xlocks	db	?
 xflags	db	?
xms_handle	ends

xmem_move	struc
 length_lo	dw	?
 length_hi	dw	?
 source_handle	dw	?
 source_lo	dw	?
 source_hi	dw	?
 dest_handle	dw	?
 dest_lo	dw	?
 dest_hi	dw	?
xmem_move	ends

xmem_sub_move	struc
 xhandle	dw	?
 xaddr_lo	dw	?
 xaddr_hi	dw	?
xmem_sub_move	ends

desc		struc
 limit		dw	0FFFFh
 basel		dw	0
 baseh		db	0
 acc		db	93h	; present, cpl0, r/w
 resv		dw	0
desc		ends

;------------------------------------------------------------------------------
; XMS 2.0 spec defined errors
;------------------------------------------------------------------------------

ERR_BAD_FN		equ	80h
ERR_VDISK		equ	81h
ERR_A20_GATE		equ	82h
ERR_GENERAL		equ	8Eh
ERR_UNREC_DRV		equ	8Fh
ERR_HMA_NOT_THERE	equ	90h
ERR_HMA_IN_USE		equ	91h
ERR_HMA_NOT_ALLOCATED	equ	93h
ERR_A20_STILL_ENABLED	equ	94h
ERR_OUT_OF_XMEM		equ	0A0h
ERR_OUT_OF_XHNDL	equ	0A1h
ERR_BAD_XHNDL		equ	0A2h
ERR_BAD_SRC_XHNDL	equ	0A3h
ERR_BAD_SRC_OFS		equ	0A4h
ERR_BAD_DEST_XHNDL	equ	0A5h
ERR_BAD_DEST_OFS	equ	0A6h
ERR_BAD_LEN		equ	0A7h
ERR_MOV_OVERLAP		equ	0A8h
ERR_PARITY		equ	0A9h
ERR_BLOCK_NOT_LOCKED	equ	0AAh
ERR_BLOCK_LOCKED	equ	0ABh
ERR_OUT_OF_LOCKS	equ	0ACh
ERR_LOCK_FAILURE	equ	0ADh

;------------------------------------------------------------------------------
