
Here is the decompression code I promised. (if you didn't get the compression
code yet, its on its way)
The .tga files are readable by Graphics Workshop.  Note that they are
atleast 3 times the necessary size, but I wrote this a long time ago 
before I know the specs for 256x256x256 .tga files.  GWS will handle it though.
It will be updated in the next release at lyapunov.ucsd.edu (in fact it
may be already)
The .ifs files created with the version of fracpack I sent you are not 
compatible with the ones at lyapunov. ( i think...)
Enjoy.


----------------  Cut here ------------------


/* This program decodes .IFS files into TARGA files */
 
#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
int main(int argc, char **argv)
{
   unsigned char domain [256][256], range [256][256];
   FILE *in, *out;
   char *inf, *outf, rmsstr[13];
   int xsize=256, ysize=256, xhi=1, xlo=0, yhi=1, ylo=0;
   int x, y, dx, dy, rx, ry, tsx, tsy;
   int ii[32][32], ddxx[32][32], ddyy[32][32];
   int transx[32][32], transy[32][32];
   float ss[32][32], oo[32][32], z;
   int ix, iy, iddxx, iddyy, n, i, nflips=8, niterations;
   float s, o;
   int f11[] = {1, 0, -1, 0, 1, 0, -1, 0}, f12[] = {0, 1, 0, -1, 0, -1, 0, 1};
   int f21[] = {0, -1, 0, 1, 0, -1, 0, 1}, f22[] = {1, 0, -1, 0, -1, 0, 1, 0};
   struct trans_t {
      unsigned char dx;
      unsigned char dy;
      signed char scale;
      short int offset : 13;
      unsigned short int flip : 3;
      } trans[1];
 
   if ((argc < 3)||(argc > 4)) {
      printf("usage: unfracpk iterations infile.ext [outfile.ext]");
      return 1;
      }
   niterations = atoi(argv[1]);
   inf = argv[2]; if (argc == 4) outf = argv[3];
   
   if ((in = fopen(inf, "rb")) == NULL) {
      fprintf(stderr, "Cannot open input file.\n");
      return 1;
      }
   if (argc == 4) if ((out = fopen(outf, "wb")) == NULL) {
      fprintf(stderr, "Cannot open output file.\n");
      return 1;
      }
   GrSetMode(GR_default_graphics);
   for (y = 0; y < ysize; y++)
      GrSetColor(y,y,y,y);
   for (ry = 0; ry < 32; ry++)
   for (rx = 0; rx < 32; rx++)
      {
      fread(trans, sizeof(struct trans_t), 1, in);
      ddxx[ry][rx] = dx = trans[0].dx;
      ddyy[ry][rx] = dy = trans[0].dy;
      ii[ry][rx] = i = trans[0].flip;
      ss[ry][rx] = (trans[0].scale/127.) * 1.2;
      oo[ry][rx] = trans[0].offset;
      transx[ry][rx] = 2*8*rx + 7 - (f11[i]*(dx+7) + f12[i]*(dy+7));
      transy[ry][rx] = 2*8*ry + 7 - (f21[i]*(dx+7) + f22[i]*(dy+7));
      }
   fclose(in);
   printf("file loaded\n");
/* Initialize 8-bit-grey-scale pixels in "from" array.  */
   printf("Init Array\n");
   for (y = 0; y < ysize; y++)
   for (x = 0; x < xsize; x++)
      {
       GrPlot(x,y,127);
       domain[y][x] = 127;
      }
   printf("\n\n");
   for (n = 0; n < niterations; n++)
   {
/* Run through all non-overlapping 8x8 "R" blocks in the image  */
    for (ry = 0; ry < 32; ry+=1)
        {
        GrLine(256, 8*ry, 256, 8*ry + 8, 340);
        for (rx = 0; rx < 32; rx+=1)
            {
            s = ss [ry] [rx];
            o = oo [ry] [rx];
            i = ii [ry] [rx];
            tsx = transx [ry] [rx];
            tsy = transy [ry] [rx];
            iddyy = ddyy [ry] [rx];
            iddxx = ddxx [ry] [rx];
/*************************************************************************/
/*                Average & Transform the 256 2x2 "pixels"               */
/*************************************************************************/
            for (y = 0; y < 16; y+=2)
            for (x = 0; x < 16; x+=2)
                {
                dy = iddyy + y;
                dx = iddxx + x;
                z = (float)((domain[dy  ][dx  ]
                           + domain[dy  ][dx+1]
                           + domain[dy+1][dx  ]
                           + domain[dy+1][dx+1]) >> 2);
 
                ix = (f11[i]*dx + f12[i]*dy + tsx) >> 1;
                iy = (f21[i]*dx + f22[i]*dy + tsy) >> 1;
                z = s*z + o;
                if (z > 255.) z = 255.; else if (z < 0.) z = 0.;
                range[iy][ix] = (unsigned char)z;
                if (range[iy][ix] != domain[iy][ix]) GrPlot(ix,iy,(int)z);
                }
            }
        }
        for (y = 0; y < ysize; y++)
        for (x = 0; x < xsize; x++)
            domain[y][x] = range[y][x];
    }
 
/* Write it out. */
   if (argc == 4) {
      if ((out = fopen(outf, "wb")) == NULL) {
      fprintf(stderr, "Cannot open output file.\n");
      return 1;
      }
/*Write header info.  This seems to work; I've yet to check TARGA specs. */
   fputc(0, out); fputc(0, out);
   fputc(2, out); fputc(0, out);
   fputc(0, out); fputc(0, out);
   fputc(0, out); fputc(0, out);
   fputc(0, out); fputc(0, out);
   fputc(0, out); fputc(0, out);
   fputc(xlo, out); fputc(xhi, out);
   fputc(ylo, out); fputc(yhi, out);
   fputc(24, out); fputc(32, out);
   
 
   for (y = 0; y < ysize; y++)
   for (x = 0; x < xsize; x++)
      {fputc(range[y][x],out); fputc(range[y][x],out); fputc(range[y][x],out);}
   fclose(out); 
   }
   getch();
   GrSetMode(GR_default_text);
/* All done. Whew... */
   return 0;
}

