
/*
  PERSONAL ADDRESS MANAGER
  Written by JanBaptist VanOpstal
  Compuserve 73354,3661
  InterNet 73354.3661@compuserve.com
*/

#include "FRANKIE.CH"
#include "INKEY.CH"

#define TRUE .T.
#define FALSE .F.
#define SAYCOLOR "GR+/W"

STATIC nPBEngine                   // file wide static for push button engine
STATIC cTipTypeString, nTipTypeRec // filewide static for browse tiptype

*
FUNCTION UDEMO04()
*
local Getlist:={}, bConfig, aGet:={}
local aScn
local aAN := AlphaNumeric(),aSpots,aAbout
/* we dismantle the Alt-C key so that we do not abort the program when we
   happen to press Alt-C as a hotkey.
*/
local lCancel := setCancel(FALSE)

// clear the screen
ADcls(" ","B/W,GR+/B,nil,nil,B+/B")

// Create array for display in ADmessage() in the bDispEnd block of the browse
aAbout:= {   "    Personal Address Manager " ,;
             "" ,;
             "     By JanBaptist VanOpstal " ,;
             "       (say'YaanBaaptist')    " ,;
             "     6821 North Ashland Avenue" ,;
             "         Chicago IL 60626         " ,;
             "       Day: (708) 317-2253      " ,;
             "     Evening: (312) 743-8245  " ,;
             "     Compuserve : 73354,3661  " ,;
             "InterNet: 73354.3661@compuserve.com";
          }
// Open the PAM file and create the index (PAM1.NTX)
OpenPam()

/* Now we are going to create the push button engine using the special
   function that automatically creates a vertical pushbutton set.
   The Alt key equivalent become the trigger keys in ADpb_setalt()
*/
nPBEngine := ADpb_vertical( 1, 1,;
                            { "Edit",;
                              "Add/Del",;
                              "Report",;
                              "Help",;
                              "Exit";
                            },;
                            {1,1,1,1,2},;
                            ,;
                             {||ADpb_setalt( TRUE ), ;
                                ADpb_colors({"BG+/B","GR+"});
                             };
                          );
// Fill array aSpots with the hotspots of the pushbutton engine
aSpots :=ADpb_spots( nPBEngine )

/* Add to the hotspots array the screen region for the get area.
   This makes it possible to click anywhere in the get-area and make the
   gets active
*/
aadd(aSpots,{11,1,23,76})

/* The big configuration block for the browse!
   -First we intialize the variables for the tip-type search and define the
    color string.
   -In ADdb_Keys we define what the hot keys are. These are
    defined in array aAN. The function AlphaNumeric() fills this array with
    all the alphabet characters needed for the tiptype search.
   -Next a calculated field is defined for the browse ADdb_fields()/_defcolumn()
   -Redefine the move behavior
   -Make the enter key call the edit function (same action as pressing Alt-E)
   -The extra function: in the dispbegin block we paint the get screen
                        in the dispend   block we display the push button
    engine, next we define the hotspots for the left mouse click, next we
    add to the browse hotkeys the pushbutton alt-keys. Next we paint the
    browse screen bpx with Wbox() and display the about message.
*/

bConfig:={||   nTipTypeRec := recno() ,;
               cTipTypeString:="",;
               ADdb_color("B/W,GR+/B,nil,nil,B+/B"),;
               ADdb_keys( aAN ,{|n,k|TipType(k) } ),;
               ADdb_fields({0}),;
               ADdb_defcolumn(1,;
                                 "Name           Phone1                Phone2",;
                                 {|| Left(alltrim(Pam->Last)+","+Pam->first+space(15),15);
                                     +""  +;
                                    left(Pam->Phone1,22) +"" + Pam->Phone2;
                                 };
                             ),;
              ADdb_move({|| iif(alltrim(str(NextKey())) $ "5 24",nothing(TRUE),DispFields(FALSE) ) }),;
              ADdb_enter({||PBAction(1,nPBEngine) }),;
              ADdb_extra( {||dispbegin(),;
                               aScn := ADbox( 1,0,10,9,;
                                              "W+/W",;
                                              space(9),;
                                              .f.,;
                                              .f.;
                                            ),;
                                  WBox(11,1,23,76,"W"),;
                                  WBox(12,3,22,74,"W",2),;
                                  ADcsay(0,0,maxcol(),"","B/W");
                                  },;
                            {||ADpb_show( nPBEngine, "W" ),;
                               ADdb_lbuttons( aSpots,;
                                                    {|n| PBAction(n,nPBEngine ) };
                                            ),;
                               ADdb_keys( ADpb_altkeys( nPBEngine ),;
                                                 {|n| PBAction(n,nPBEngine ) },TRUE;
                                        ),;
                               WBox(0,09,09,76,"W"),;
                               WBox(1,11,08,74,"W",2),;
                               dispend(),Admessage(aAbout);
                            };
                         );
          }

// here is the engine and heart of the program where it all happens
ADdbview( 1,11,08,74,bConfig)

//When we're done the pushbutton engine is killed
ADpb_kill( nPBEngine )

// Clear the screen
ADcls()

//Alt-C aborts again
setCancel(lCancel)

// close the present workarea
use

RETURN NIL

*
static func PBAction( n, nPBEngine )
*
/* This function handles all the action requests for editing, adding, deleting
   help and exit
*/
local nSel
if n < 5
  ADpb_push( nPBEngine, n )
endif

if n == 1  //EDIT
     DispFields(TRUE)
     ADdb_stabilize(TRUE,FALSE)
elseif n == 2 //ADD/DELETE
    nSel := ADboxmenu("Add or Delete?",{"Add","Delete","Cancel"})
    IF nSel == 1 //ADD
        Pam->(dbappend())
        DispFields(TRUE)
        ADdb_stabilize(TRUE,FALSE)
    ELSEIF nSel == 2 //DELETE
     if ADboxmenu("Delete record?",{"NO","YES"} ) == 1
        Pam->(dbdelete())
        DispFields(FALSE)
        ADdb_stabilize(TRUE,TRUE)
     endif
    ENDIF
elseif n == 3 //REPORT
    Report()
elseif n == 4   //I WANT HELP!
    HELPME()
elseif n == 5
    ADdb_exit()  //GET ME OUT OF HERE
else        // ACTION FOR THE TIP-TYPE FUNCTION OF THE BROWSE
     DispFields(TRUE)
     ADdb_stabilize(TRUE,FALSE)
endif
return NIL

*
FUNCTION DispFields(lRead)
*
local nCol := 4, nRow := 12, getlist := {}
local nOldColor := setcolor("B/W,GR+/B,nil,nil,B+/W")

// define array for the pushbutton hotspot #5 (=EXIT)
local aLButton := { ADpb_spots( nPBEngine )[5] }

/* Add browse region to hotspots so when in a get and the browse is clicked
   the focus goes to the browse again by invoking an exit from the get system.
*/
aadd(aLButton,{0,08,09,76})

// Just in case we did not pass lread to this function
if lRead==NIL
   lRead:=FALSE
endif

//Repaint bottom inner line from left browse corner to clear tiptype characters
ADsay(08,12,"","W+/W")

/* Lets get the say the says with MySay, get the data with ADget and
   define the Alt keys with JumpKey
*/
@ nRow+1 ,nCol say MySay("    Last:",1) ADget Pam->LAst JUMPKEY K_ALT_L
@ row()+1,nCol say Mysay("   First:",1) Adget Pam->first JUMPKEY K_ALT_F
@ row()+1,nCol say Mysay("   Title:",1) Adget Pam->title JUMPKEY K_ALT_T
@ row()+1,nCol say Mysay("  Middle:",1) Adget Pam->middle JUMPKEY K_ALT_M
@ row()+1,nCol say Mysay("     Sex:",1) Adget Pam->sex  PICTURE '@!'  JUMPKEY K_ALT_S
@ row() ,nCol+13 say Mysay("Birthday:",1) Adget Pam->birthday JUMPKEY K_ALT_B
@ row()+1,nCol say Mysay(" Company:",7) Adget Pam->Company  PICTURE '@s24' JUMPKEY K_ALT_Y
@ row()+1,nCol say Mysay("  Spouse:",4) Adget Pam->spouse   PICTURE '@s24' JUMPKEY K_ALT_U
@ row()+1,nCol say Mysay("Children:",5) Adget Pam->children  JUMPKEY K_ALT_D
@ row()+1,nCol say Mysay("   Notes:",1) Adget Pam->notes    PICTURE '@s46'   JUMPKEY K_ALT_N

//right column of the gets
nCol :=nCol+38
@ nRow+1,nCol say  Mysay("Street1:",1) Adget Pam->street1   PICTURE '@s23' JUMPKEY K_ALT_S
@ row()+1,nCol say Mysay("Street2:",1) Adget Pam->street2  PICTURE '@s23'  JUMPKEY K_ALT_S
@ row()+1,nCol say Mysay("   City:",1) Adget Pam->city  JUMPKEY K_ALT_C
@ Row()+1,nCol say Mysay("  State:",1) Adget Pam->state    PICTURE '@!' JUMPKEY K_ALT_S
@ row()  ,nCol+15 say Mysay("Zip:",1) Adget Pam->Zip  PICTURE '99999-99999' JUMPKEY K_ALT_Z
@ row()+1,nCol say Mysay(" Phone1:",1) Adget Pam->phone1   PICTURE '@s23 !(999)999-9999/XXXXXXXXXXXX' JUMPKEY K_ALT_P
@ row()+1,nCol say Mysay(" Phone2:",1) Adget Pam->phone2   PICTURE '@s23 !(999)999-9999/XXXXXXXXXXXX'  JUMPKEY K_ALT_P
@ row()+1,nCol say Mysay(" Phone3:",1) Adget Pam->phone3   PICTURE '@s23 !(999)999-9999/XXXXXXXXXXXX'  JUMPKEY K_ALT_P
@ row()+1,nCol say Mysay(" Phone4:",1) Adget Pam->phone4   PICTURE '@s23 !(999)999-9999/XXXXXXXXXXXX'  JUMPKEY K_ALT_P


if lRead // If we are 'reading' the gets we go into here else we clear them.

   DispBegin()
   // Un hilite the 4 top pushbuttons
   ADpb_chgcolor( nPBEngine, 1, "B+/B","B+/B" )
   ADpb_chgcolor( nPBEngine, 2, "B+/B","B+/B" )
   ADpb_chgcolor( nPBEngine, 3, "B+/B","B+/B" )
   ADpb_chgcolor( nPBEngine, 4, "B+/B","B+/B" )
   DispEnd()
   // Do a read and define the left mouse button hotspots and the Alt-X key
      ADread(getlist,{||;
                        ADr_lbuttons( aLButton,{|| Exitread() } ),;
                        ADr_Keys( {K_ALT_X},{|| ExitRead() } );
                     };
            )
   // We are done reading and restore the color of the 4 top pushbuttons
   DispBegin()
   ADpb_restcolor( nPBEngine, 1 )
   ADpb_restcolor( nPBEngine, 2 )
   ADpb_restcolor( nPBEngine, 3 )
   ADpb_restcolor( nPBEngine, 4 )
   DispEnd()
else
   clear gets
endif
setcolor(nOldcolor)

RETURN(NIL)

*
FUNCTION ExitRead()
*
   /* When we exit the read by pressing the Esc key or Alt-X push or click
      we first press down the Exit pushbutton. Then we make sure we do an
      enter so that what we just entered into a get sticks there
   */
   ADpb_push( nPBEngine, 5 )
   Keyboard Chr(13)+chr(27)

RETURN TRUE

*
FUNCTION MySay(cSay,nPos)
*
//This function paints the say using ADdisplist()

local nSpaceLen:=0, i, cBegin:="", cHighlight:="", cEnd:=""
for i:=1 to len(cSay)
    if !(substr(cSay,i,1) == " ")
       nSpaceLen := i-1
       exit
    endif
next i

if nPos = 1 .and. nSpaceLen==0
   cBegin    :=  ""
else
   cBegin    :=  substr(cSay,1,nSpaceLen+nPos-1)
endif

cHighLight:=  substr(cSay,nSpaceLen+nPos,1)

if nPos+nSpaceLen==len(cSay)
   cEnd := ""
else
   cEnd := substr(cSay,nSpaceLen+nPos+1)
endif

ADdisplist(cBegin     ,SAYCOLOR,;
           cHighLight ,"R/W",  ;
           cEnd       ,SAYCOLOR ;
          )

RETURN("")


*
function WBox(nT,nL,nB,nR,cBackColor,nDisplay)
*
  // Function to paint the delight illusion of raised borders.
  local cLeft
  local cRight
  local i
  nDisplay := iif(nDisplay==NIL,1,nDisplay)
  IF nDisplay == 2
     cLeft  := "N/"+iif(cBackColor==NIL,"W",cBackColor)
     cRight := "W+/"+iif(cBackColor==NIL,"W",cBackColor)

  ELSE
     cLeft  := "W+/"+iif(cBackColor==NIL,"W",cBackColor)
     cRight := "N/"+iif(cBackColor==NIL,"W",cBackColor)

     Adsay(nB+1,nL+1,replicate(chr(223),nR-nL+1),"N/"+cBackColor)
     for i:=nT+1 to nB
        Adsay(i,nR+1,chr(219) ,"N/"+cBackColor)
     next i

 ENDIF
     ADhorline(nT,nL,nR,"",cLeft)
     for i:=nT+1 to nB-1
         Adsay(i,nL,"",cLeft)
     next i
     Adsay(nB,nL,"",cLeft)

     ADhorline(nB,nL+1,nR,"",cRight)
     for i:=nT+1 to nB-1
         Adsay(i,nR,"",cRight)
     next i
     Adsay(nT,nR,"",cLeft)





Return NIL



*
FUNCTION TipType(k,cPrefix)
*
local nLen, nSpace
// Seek fuction for the tipe ype capability of the browse

cPrefix := iif(cPrefix==NIL,"",upper(cPrefix))

//first time calling
if (nTipTypeRec == NIL)
     nTipTypeRec := recno()
     cTipTypeString:= ""
     nSpace := len(cTipTypeString)
// if we are on a different record act as first time calling
elseif !(recno() == nTipTypeRec)
     nTipTypeRec := recno()
     nSpace := len(cTipTypeString)
     cTipTypeString:= ""
else
     nSpace := len(cTipTypeString)
endif

// if we entered a Backspace adjust the seek string
if k=K_BS
   nLen := len(cTipTypeString)
   if nLen < 2
      cTipTypeString:= ""
   else
      cTipTypeString := left(cTipTypeString,nLen-1)
   endif
endif

dispbegin()
// if we can find the strin go repaint the screen and reset variables
if dbseek(cPrefix+cTipTypeString+iif(k=K_BS,"",upper(chr(k) ) ) )
   nTipTypeRec := recno()
   cTipTypeString:= cTipTypeString+iif(k=K_BS,"",upper(chr(k) ) )
   ADdb_stabilize(TRUE,FALSE)
   DispFields(FALSE)
// Nope, can't find what you typed, back to start record and beep
else
   tone(555,1)
   dbgoto(nTipTypeRec)
endif

// display the typed and found characters on the inner left bottom browse line
  if len(cTipTypeString) < (ADdb_right() - ADdb_left() - 2)
   ADsay(ADdb_bottom(),ADdb_left()+1,Replicate("",nSpace),"W+/W")
   ADsay(ADdb_bottom(),ADdb_left()+1,cTipTypeString,"GR+/W")
  endif
dispend()
RETURN(NIL)

*
FUNCTION Report()
*
adMessage({;
"This demo does not contain a report.",;
"I took it out because I wrote one specific for my day planner using",;
"the Escape 3.0 library and an HP laserjet 3. I you are interested in",;
"this report and you do have the escape library do not hesitate ",;
"to give me an e-mail and I will send it to you free of charge.",;
"",;
"This report is printed double sided and creates ",;
"half sheet landscape pages on letter format.",;
"",;
"My e-Mail address is 73354.3661@compuserve.com (JanBaptist VanOpstal)";
})
Return NIL

*
FUNCTION NOTHING(xVar)
*
 /*This function returns what you pass it. Used in code blocks to get
   a return value. Code blocks need a function to evaluate.
 */
RETURN(xVar)


*
FUNCTION AlphaNumeric()
*
// Hotkey array for tip-type in browse
local aAN:={ asc("A"),asc("a"),;
             asc("B"),asc("b"),;
             asc("C"),asc("c"),;
             asc("D"),asc("d"),;
             asc("E"),asc("e"),;
             asc("F"),asc("f"),;
             asc("G"),asc("g"),;
             asc("H"),asc("h"),;
             asc("I"),asc("i"),;
             asc("J"),asc("j"),;
             asc("K"),asc("k"),;
             asc("L"),asc("l"),;
             asc("M"),asc("m"),;
             asc("N"),asc("n"),;
             asc("O"),asc("o"),;
             asc("P"),asc("p"),;
             asc("Q"),asc("q"),;
             asc("R"),asc("r"),;
             asc("S"),asc("s"),;
             asc("T"),asc("t"),;
             asc("U"),asc("u"),;
             asc("V"),asc("v"),;
             asc("W"),asc("w"),;
             asc("X"),asc("x"),;
             asc("Y"),asc("y"),;
             asc("Z"),asc("z"),;
             asc("1"),asc("2"),;
             asc("3"),asc("4"),;
             asc("5"),asc("6"),;
             asc("7"),asc("8"),;
             asc("9"),asc("0"),;
             asc("?"),         ;
             K_BS,32           ;
           }
RETURN( aAN )


*
FUNCTION HELPME()
*
   ADmessage({;
"                         H E L P  F I L E     ",;
"This Program was created in Clipper 5.2c using the Frankie Library.         ",;
"It was inspired by a need to organize the address portion of my day planner.",;
"The program is not perfect but very functional (at least for me).           ",;
"",;
"How does it work: The top box is a scroll browse for your addresses. You can",;
"use the mouse to scroll by clicking on the inner top and bottom lines just  ",;
"around the browse. If you want to edit a record click on the 'Edit' button  ",;
"or press 'Alt-E'. You can also go to any field directly by clicking on ",;
"the data portion of the field twice (not a double click).                 ",;
"",;
"The browse has 'TipType' capability. When typing the first letters of the ",;
"last name an automatic seek is performed. The character before the phone",;
"numbers can be used to classify the number: W=Work, H=Home, B=Beeper, F=Fax.",;
"",;
"You can use this demo freely and I would appreciate your reaction. You can",;
"reach me at 73354.3661@compuserve.com";
})
RETURN NIL

*
FUNCTION OpenPam()
*
if "F_TOUR.EXE" $ ADprogName()
    use userdemo\PAM.DBF
    if !(file("userdemo\PAM1.NTX"))
        INDEX ON UPPER(Pam->last+Pam->first) TO userdemo\PAM1
    endif
    SET INDEX TO userdemo\PAM1
else
    USE PAM.DBF
    if !(file("PAM1.NTX"))
        INDEX ON UPPER(Pam->last+Pam->first) TO PAM1
    endif
    SET INDEX TO PAM1
endif
RETURN NIL
