**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**
*
*    Program Name: udem03.prg
*         Version: 1.1
*      Written By: Michael Stephens
*            Date: April 1994
*         Purpose: double click detection routine
*     Last Change: 11APR94 2200
*
*                  Stephens Publishing Company
*                  7717 1/2 W 16 ST
*                  Tulsa, Ok 74127-4810
*                  (918) 241-1142
*                  CompuServe 73303,2410
*
**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**

/*

        This routine demonstrates a method of trapping double clicks. 
        Refer also to the bProcess in TB_FILES.PRG for another example. 
        
        Anyone who finds it useful may use all or parts of the following 
        code in applications they write. 

        Please feel free to contact me with any comments, questions, etc.
        
*/    

#include "inkey.ch"
#include "common.ch"
#include "frankie.ch"

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**

PROC udemo03

LOCAL nTime, aFirst[4], aSecond[4], aScn
LOCAL aScn2 := ADsaveScn( 0, 0, MaxRow(), MaxCol() )
LOCAL aCursor := ADsaveCsr( 0 )

SET CURSOR OFF
ADcls( "", "W+/B" )

ADsay( MaxRow(), 0, Replicate( " ", 80 ), "B/W" )
ADcSay( MaxRow(), 0, MaxCol(), "The Frankie Library of Mouseable User " ;
        +"Interfaces for Clipper 5.xx", "B/W" )

ADmessage( { " ", ;
             " Now you can add double click detection to your apps!  ", ;
             " ", ;
             " Double click the left mouse button to begin the demo. ", ;
             " " }, 3,, FALSE, FALSE, { "B/W" } )

DO WHILE TRUE

  ADm_rWait()  
  aFirst := ADwait( 30, { || ADblankScn( { " Frankie 2.2   ", ;
                                           " Double Click  ", ;
                                           " Demonstration " } ) } )
  ADm_rWait()
  nTime := Seconds()
  
  IF aFirst[1] == K_ESC .OR. aFirst[2] == 2
     EXIT
  ELSEIF aFirst[2] == 1
     aSecond := ADwait( .34 ) 

     IF Seconds() - nTime < .34 .AND. aFirst[3] == aSecond[3] .AND. ;
                                      aFirst[4] == aSecond[4]
        aScn := ADmessage( { " ", ;
                             " Double Click detected! ", ;
                             " ", ;
                             " Try again when this message disappears... ", ;
                             " " }, 14,, FALSE, FALSE, { "R/W" } )
        ADm_rWait()
        ADwait( 2 )
        ADrestScn( aScn )

     ENDIF

  ENDIF
     
ENDDO

ADrestScn( aScn2 )

ADrestCsr( aCursor )

RETURN
