/*
    VM_DEM10.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    This program demonstrates how easy it is to implement cascading menus
    with ADvermenu().
*/




//--------------
func vm_demo10()
local nTop := 0, nLeft := 10
local aMenu := {;
                    "News *",;
                    "Test Drives *",;
                    "Features *";
               }
local aTrigger := { 1,1,1 }
local aBlock := {;
                    {|n| Xnews(n)},;
                    {|n| Xtest(n)},;
                    {|n| Xfeatures(n)};
                }

cls
Xinfo()
ADvermenu( nTop, nLeft, aMenu, aTrigger, aBlock )
return nil


//----------------
func Xnews(n)
local nTop := ADvm_row() + 1, nLeft := ADvm_left() + 5
local aMenu := {;
                    "Dataline",;
                    "Editor on the Go",;
                    "Database Confidential";
               }
local aTrigger := { 1,1,10 }
ADvermenu( nTop, nLeft, aMenu, aTrigger )
return nil


//----------------
func Xtest(n)
local nTop := ADvm_row() + 1, nLeft := ADvm_left() + 5
local aMenu := {;
                    "New!",;
                    "Update",;
                    "Field Report";
               }
local aTrigger := { 1,1,1 }
ADvermenu( nTop, nLeft, aMenu, aTrigger )
return nil


//----------------
func Xfeatures(n)
local nTop := ADvm_row() + 1, nLeft := ADvm_left() + 5
local aMenu := {;
                    "Object-Oriented Programming *",;
                    "First Look";
               }
local aTrigger := { 1,1 }
local aBlock := {;
                    {|n| Xoop(n)},;
                    {|n| ADvm_abort()};
                }
ADvermenu( nTop, nLeft, aMenu, aTrigger, aBlock )
return nil



//----------------
func Xoop(n)
local nTop := ADvm_row() + 1, nLeft := ADvm_left() + 5
local aMenu := {;
                    "The Oop Primer for Xbase Programmers *",;
                    "Oop: What's the Next Step?";
               }
local aTrigger := { 9,17 }
local aBlock := {;
                    {|n| Xchapter(n)},;
                    {|n| ADvm_abort()};
                }
ADvermenu( nTop, nLeft, aMenu, aTrigger, aBlock )
return nil


//----------------
func Xchapter(n)
local nTop := ADvm_row() + 1, nLeft := ADvm_left() + 5
local aMenu := {;
                    "Chapter 1",;
                    "Chapter 2",;
                    "Chapter 3",;
                    "Chapter 4",;
                    "Chapter 5",;
                    "Chapter 6";
               }
local aTrigger := { 9,9,9,9,9,9 }
ADvermenu( nTop, nLeft, aMenu, aTrigger )
return nil

//----------
static func Xinfo()
ADmessage( {;
                "Implementation of cascading menus is a breeze.  The",;
                "starred (*) options go down another menu level";
           }, 14,0, .f., .f. )
return nil


