/*
    VM_DEM06.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    This program demonstrates how to configure ADvermenu() to behave as
    a taglist. 
*/




//--------------
func vm_demo06()
local nTop := 0, nLeft := 0
local aMenu := {;
                    "On the Cover",;
                    "News",;
                    "Test Drives",;
                    "Features",;
                    "The Experts",;
                    "Application Development",;
                    "The Basics",;
                    "Departments";
               }
local aTrigger := { 8,1,1,1,5,1,5,1 }
local bProcess := {|a| if( len( a ) > 0,;
                           (;
                              ADamodify( a, {|x| x := aMenu[x]} ),;
                              ADmessage( a );
                           ),;
                           ADmessage( {"Nothing was selected"} );
                         );
                  }
local bConfig := {|| ADvm_taglist() }

Xinfo()
ADvermenu( nTop, nLeft, aMenu, aTrigger, bProcess, bConfig )
return nil

//-----------------
static func Xinfo()
ADmessage( {;
              "This ADvermenu is a taglist.  Press the Spacebar or",;
              "click an option with the left button to tag/untag it.",;
              "Press the Enter key or click the top/left corner of",;
              "the screen to select all tagged options.  The return",;
              "value is an array of selected options.";
           }, 14,, .f. )
return nil



