/*
    PB_DEM06.PRG
    Copyright (c) The Programmer's Desk, 1993-94.  All rights reserved.
*/



// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

//---------------
func pb_demo06()
local aScn          // screen occupied by push buttons
local nPBEngine     // push button engine ID
local aPBKeys       // push buttons triggers
local nArea := select()

select 0

if "F_TOUR.EXE" $ ADprogname()
    use demo
else
    ADset_help( "..\f_tour", { 4,10,20,69 } )
    use ..\demo
endif

ADdbview( 10,10,20,79,;
          {||ADdb_extra( {||dispbegin(),;
                            aScn := ADbox( 10,0,20,9,;
                                           "W+/B",;
                                           space(9),;
                                           .f.,;
                                           .f.;
                                         ),;
                            nPBEngine := ADpb_vertical( 11, 2,;
                                                        { "Edit  ",;
                                                          "Add   ",;
                                                          "Delete",;
                                                          "Recall",;
                                                          "Pack  ";
                                                        };
                                                      );
                         },;
                         {||ADpb_show( nPBEngine, "B" ),;
                            ADdb_lbuttons( ADpb_spots( nPBEngine ),;
                                                       {|n|Xdb_shandler(n,nPBEngine)};
                                                     ),;
                            ADdb_keys( ADpb_triggers( nPBEngine ),;
                                                      {|n|Xdb_khandler(n,nPBEngine)};
                                                    ),;
                            ADcsay( 20, 10, 79,;
                                    " Push Buttons With ADdbview() Demo ",;
                                    "GR+/B";
                                  ),;
                            dispend();
                         },;
                         {||ADpb_kill( nPBEngine ),;
                            ADrestscn( aScn );
                         };
                       );
          };
        )
use
select (nArea)
return NIL




//--------------------------------------
static func Xdb_shandler( n, nPBEngine )
ADpb_push( nPBEngine, n )

if n == 1
    ADnotyet( "Edit" )
elseif n == 2
    ADnotyet( "Add" )
elseif n == 3
    ADnotyet( "Delete" )
elseif n == 4
    ADnotyet( "Recall" )
elseif n == 5
    ADnotyet( "Pack" )
endif
return NIL


//--------------------------------------
static func Xdb_khandler( n, nPBEngine )
ADpb_push( nPBEngine, ADround( n, 2 ) )

if n == 1 .or. n == 2
    ADnotyet( "Edit" )
elseif n == 3 .or. n == 4
    ADnotyet( "Add" )
elseif n == 5 .or. n == 6
    ADnotyet( "Delete" )
elseif n == 7 .or. n == 8
    ADnotyet( "Recall" )
elseif n == 9 .or. n == 10
    ADnotyet( "Pack" )
endif
return NIL


