/*
    GM_DEM04.PRG
    Copyright (c) The Programmer's Desk, 1993-94.  All rights reserved.
    Adds colors, labels, valids, and whens to the Gets.
*/



// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

//--------------
func gm_demo04()
local aScn
local aLabels := {;
                    "Library",;
                    "Author",;
                    "Impression!";
                 }
local aGets := {;
                    "Frankie Clipper Library",;
                    "The Programmer's Desk",;
                    "Excellent!";
               }
local aValids := {;
                    {|| Xvalid() },;
                    {|| Xvalid() },;
                    {|| Xvalid() };
                 }
local aWhens := {;
                    {|| Xwhen() },;
                    {|| Xwhen() },;
                    {|| Xwhen() };
                }
local bConfig := {||ADgm_labels( aLabels ),;
                    ADgm_valids( aValids ),;
                    ADgm_whens( aWhens ),;
                    ADgm_corner( 6 ),;
                    ADgm_color( { "W+/B", "GR+/R", "W/B" } );
                 }
aScn := Xinfo()
ADg_many( aGets, bConfig )
ADrestscn( aScn )
return nil


//-----------
static func Xvalid()
local nthGet :=  ADr_nthget()
local lValid := .t.

if nthGet == 1
    if left( ADr_varget(), 1 ) != "F"
        ADmessage( { "The first letter must be an 'F'" }, 0 )
        lValid := .f.
    endif
elseif nthGet == 2
    // no validation
elseif nthGet == 3
    if right( trim( ADr_varget() ), 1 ) != "!"
        ADmessage( { "The last character must be an '!'" }, 0 )
        lValid := .f.
    endif
endif
return lValid


//-----------
static func Xwhen()
local nthGet :=  ADr_nthget()
local lValid := .t.

if nthGet == 1
    // no pre-validation
elseif nthGet == 2
    // no pre-validation
elseif nthGet == 3
    if empty( ADr_varget(2) )
        lValid := .f.
    endif
endif
return lValid

//----------
static func Xinfo()
local aScn := ADmessage( { "Validation",;
                           "----------",;
                           "'Library' must start with an 'F'",;
                           "'Impression' must end with an '!'",;
                           "",;
                           "Pre-validation",;
                           "--------------",;
                           "'You cannot go to 'Impression' if 'Author' is blank";
                         }, 12,, .f. )
return aScn
