/*
    DB_DEM04.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    Drags the browse box with the arrow keys.

    Note the following:

    1.  The F10 key is configured to initiate the dragging operation.
        The db engine is made aware of this configuration via the API,
        ADdb_keys().
    2.  The API message is sent to the engine via the Configuration
        Specifier, [bConfig].
*/

#include "inkey.ch"

// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"


//-------------
func db_demo04()
local bConfig := {|| ADdb_keys( { K_F10 }, {|nth,nkey| Xkeys(nth,nkey)} )}
local aScn

if "F_TOUR.EXE" $ ADprogname()
    use demo
else
    use ..\demo
    ADset_help( "..\f_tour", { 4,10,20,69 } )
endif

aScn = ADmessage( { "Press F10 to drag browse box" }, 22,, .f., .f. )
ADdbview( 4,4,20,76, bConfig )
ADrestscn( aScn )
use
return nil


//---------------------------------
func Xkeys( nth, nkey )
local aScn := ADmessage( {;
                            "Press any key to close this message box...",;
                            "",;
                            "...Then use the arrows to move the browse box.",;
                            "Press Enter when it is in the desired location.",;
                            "Or press Esc to abort.";
                         },,, .f., .f. )

inkey(0)
ADrestscn( aScn )
ADdb_drag()
return nil

