/*
    BM_DEM02.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    This demo reconfigures the basic attributes of ADboxmenu(), and
    interrogates the engine with the use of these APIs:

    ADbm_colors() - changes the default colors
    ADbm_boxAttr() - changes the box attributes. In this demo, the
        box frame is single-line, the box does not cast a shadow and 
        does not explode.
    ADbm_isEscape() - activates the Esc key and the right button mouse
        to abort the menu.
    ADbm_abort() - tells the engine to abort.
    ADbm_current() - returns the index position of the currently 
        highlighted option.

    The demo also demonstrates the use of the optional attributes
        [aTrigger], [bProcess], and [bConfig].
*/


// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

//---------
func bm_demo02()
local bConfig := {|| ADbm_colors( { "N+/W*", "GR+/R", "B+" }  ),;
                     ADbm_boxAttr( { "Ŀ ", "Ĵ³", .f., .f., 1 } ),;
                     ADbm_isEscape( .t. );
                 }

local lBlink := setblink( .f. )
ADboxmenu( "Which is better?",;
           { "Alert()", "ADboxmenu()", "Give up" },;
           { 1,3,1 },;
           { || Xsel2_handler() },;
           6, 6,;
           bConfig;
         )
setblink( lBlink )
return nil

//------------------
func Xsel2_handler()
local nSel := ADbm_current()

if nSel = 1
    tone( 40,6 )
    ADmessage( {"Wrong!"} )
elseif nSel = 2
    tone( 100, 1 )
    tone( 500, 1 )
    tone( 1000, 1 )
    ADmessage( {"Correct!"} )
else
    ADbm_abort()
endif
return nil


