/*
    FDEM08.PRG
*/

#include "inkey.ch"

//-----------
func fdemo08()
if "F_TOUR.EXE" $ ADprogname()
    ADset_help( "newdemo\newdemos" )                  
else
    ADset_help( "newdemos" )                  
endif

ADhelp( "ABOUT08", "About This Demo" )
ADhelp( "ABOUT08-MOUSE", "Polling for Mouse Movement" )

do while .t.
    Xpollmouse()
    if ADboxmenu( "Poll Mouse Again?", { "Yes", "No" } ) == 2
        exit
    endif
enddo

ADhelp( "ABOUT08-TIME", "Polling the Time" )

do while .t.
    Xpolltime()
    if ADboxmenu( "Poll Time Again?", { "Yes", "No" } ) == 2
        exit
    endif
enddo
return NIL

//----------------------
static func Xpollmouse()
local aWait, mRow, mCol, aScn

ADmessage( { "Do not hold the mouse" },,,,,, "MESSAGE" )
aScn := ADmessage( { "Waiting for an event" },,, .f. )
mRow := ADm_row()
mCol := ADm_col()

do while .t.
    aWait := ADwait( ,,{||if(mRow != ADm_row() .or. mCol != ADm_col(), 1, 0)} )

    if aWait[1] == K_F1
        ADhelp( "ABOUT08-MOUSEHELP", "What is Currently Happening?" )
        loop
    elseif aWait[5] != 0
        ADmessage( { "The mouse moved" },,,,,, "MESSAGE" )
    else
        ADmessage( { "The mouse did not move" },,,,,, "MESSAGE" )
    endif

    ADrestscn( aScn )
    exit
enddo
return NIL

//---------------------
static func Xpolltime()
local cMinute := substr( time(), 4, 2 ), aWait

Xdisptime(0)

do while .t.
    aWait := ADwait( ,,;
                     {||if( substr( time(), 4, 2 ) == cMinute, 0, 1 )},;
                     {||Xdisptime(1)};
                   )
    if aWait[1] == K_F1
        ADhelp( "ABOUT08-TIMEHELP", "What is Currently Happening?" )
    elseif aWait[5] == 1
        Xdisptime(2)
        Xwakeup()
        exit
    else
        ADmessage( { "It's about time you woke up!" },,,,,, "MESSAGE" )
        Xdisptime(2)
        exit
    endif
enddo
return NIL

//--------------------------
static func Xdisptime(nMode)
static aScn
local nT := 10, nL := 32, nB := 12, nR := 43, cColor := "R+/W"

if nMode == 0
   aScn := ADbox( nT, nL, nB, nR, cColor )
elseif nMode == 1
   ADsay( nT+1, nR - 9, time(), cColor )
   return NIL
elseif nMode == 2
   ADrestscn( aScn )
   aScn := NIL
endif

return aScn

//-------------------
static func Xwakeup()
local aScn := ADmessage( { "WAKE UP!" },,, .f., .f. )

do while .t.
    if ADwait( ,,, {||tone(100,1)})[1] == K_F1
        ADhelp( "ABOUT08-ALARMHELP", "What's Currently Happening?" )
    else
        exit
    endif
enddo

ADrestscn( aScn )
return NIL
