/*
    FDEM04.PRG
    Copyright 1993, Angelito Dizon.  All rights reserved.


    This demo illustrates the use of push buttons and the boxed Get/Read
    engine with a browse.
    
    It also illustrates various other Frankie engine APIs like: ADdb_move(),
    ADdb_extra(), ADdb_keys(), ADdb_lbuttons(), ADdb_seek(), ADdb_softseek(),
    ADpb_horizontal(), ADpb_colors(), ADpb_show(), ADpb_spots(),
    ADpb_triggers(), ADpb_push(), ADgm_labels(), ADgm_color(),
    ADgm_readconfig() and the gather/scatter functions ADgetrec(), ADputrec().

    To use this demo, you should have Frankie v2.1.  A full-featured
    shareware version is available in these two electronic locations:

        1. CompuServe, Clipper forum, Lib 7
        2. RRR BBS, (301)464-1372, Vendor Support Area

    Look for Frank.zip (Library) and Frankg.zip (NG file).

    To compile: clipper fdem04 /a /b /n /v /w
    To link: blinker (or rtlink) file fdem04 lib frankie 

    Other files needed to run the demo: FDEM04.HLP and FDEM04.HLX (Help files),
    EMPLOYEE.DBF, EMP_NUM.NTX, EMP_NAME.NTX, EMP_FNAM.NTX.
*/


#include "inkey.ch"

// browse hot keys/spots
#define HOT_HELP        1
#define HOT_ADD         2
#define HOT_EDIT        3
#define HOT_SORT        4
#define HOT_SEEK        5
#define HOT_SOFTSEEK    6
#define HOT_DELREC      7
#define HOT_PACK        8
#define HOT_EXIT        9

// add/edit timeout duration
#define READ_TIMEOUT        10      //seconds


//-----------
func fdemo04()
field idnum, first_name, last_name
local aArea := ADsavearea()
local aScn
local nPBEngine // push button engine
local nT := 1, nL:= 0, nR := maxcol(), nB := maxrow() - 2   // browse coordinates

// configure the browse
local bConfig := {||ADdb_move( {||Xshow_delmsg()} ),;       // show 'deleted' message
                    ADdb_extra(;
                                 {||nPBEngine := ADpb_horizontal( nB + 1, nL + 2,;                      // create push button engine
                                                                  {;
                                                                    ' Help ',;
                                                                    ' Add ',;
                                                                    ' Edit ',;
                                                                    ' sorT ',;
                                                                    ' seeK ',;
                                                                    ' Softseek ',;
                                                                    ' Del/Rec ',;
                                                                    ' Pack ',;
                                                                    ' eXit ';
                                                                  }, ;
                                                                  { 2,2,2,5,5,2,2,2,3},;
                                                                  2,;
                                                                  {||ADpb_colors( { 'W+/R', 'BG+' } )}; // def the push buttons color
                                                                );
                                 },;
                                 {||aScn := ADbox( nB+1, nL, maxrow(), nR, "W+/B", "         ", .f., .f. ),;
                                    ADsay( nT-1, nL,;
                                           padc( "Frankie 2 Browse Demo by The Programmer's Desk", maxcol()+1 ),;
                                           "GR+/W";
                                         ),;
                                    ADpb_show( nPBEngine, "B" ),;                                       // show the push buttons
                                    ADdb_lbuttons( ADpb_spots( nPBEngine ),;                            // def push buttons as browse hot spots 
                                                   { |n| Xhots( nPBEngine, n ) };
                                                 ),;
                                    ADdb_keys( ADpb_triggers( nPBEngine ),;                             // def push buttons as browse hot keys
                                               { |n| Xhots( nPBEngine, ADround( n, 2 ) ) };
                                             ),;
                                   ADdb_keys( { K_F10 }, {||ADhelp( "ABOUT04", "About This Demo" )}, .t. );
                                 },;
                                 {||ADrestscn( aScn )};
                              );
                 }

if "F_TOUR.EXE" $ ADprogname()
    ADset_help( "newdemo\newdemos" )                  
    ADhelp( "ABOUT04", "About This Demo" )    
    use employee share alias fdem04

    if !neterr()
        set index to emp_num, emp_name, emp_fnam
        ADdbview( nT, nL, nB, nR, bConfig,, "BROWSE"  )
        use
    endif
else
    ADset_help( "newdemos" )
    ADhelp( "ABOUT04", "About This Demo" )    
    use ..\employee share alias fdem04

    if !neterr()
        set index to ..\emp_num, ..\emp_name, ..\emp_fnam
        ADdbview( nT, nL, nB, nR, bConfig,, "BROWSE"  )
        use
    endif
endif

ADrestarea( aArea )
return NIL


//-----------------
static func Xshow_delmsg()
local nT := ADdb_top()
local nL := ADdb_left()

if deleted()
    ADsay( nT, nL+2, "Deleted", "R+/B" )
else
    ADsay( nT, nL+2, "", "W+/B" )
endif
return NIL


//------------------
static func Xhots( nPB, n )
ADpb_push( nPB, n )     // _pushes_ the selected button

if n == HOT_HELP
    keyboard chr( K_F1 )
elseif n == HOT_ADD
    Xadd()
elseif n == HOT_EDIT
    Xedit()
elseif n == HOT_SORT
    Xsort()
elseif n == HOT_SEEK
    Xseek()
elseif n == HOT_SOFTSEEK
    Xsoftseek()
elseif n == HOT_DELREC
    Xdelrec()
elseif n == HOT_PACK
    Xpack()
elseif n == HOT_EXIT
    ADdb_exit()
endif
return NIL

//----------
static func Xedit()
local aRec

// configure the boxed Gets/Read
local bConfig := {||ADgm_color( { "W+/W", "GR+/R", "W+/N" } ),;                             
                    ADgm_labels( ADdb_colheadings() ),;                                  // labels the Gets with the browse column headings
                    ADgm_readconfig( {||ADr_timeout( READ_TIMEOUT, {||Xabort()} ),;      // aborts the Read after READ_TIMEOUT seconds of idle time
                                        ADr_expattr( {8,10,14,69}, "GR+/R" );            // configures the memoedit
                                     };
                                   );
                 }

if rlock()
    dbgoto( recno() )       // force refresh of record buffer
    aRec := ADgetrec( 80 )  // gather the record to edit

    if ADg_many( aRec, bConfig, "EDIT" )    // edit the record
        ADputrec( aRec )                    // scatter the record if it was changed
        dbcommit()
        ADdb_stabilize( .f., .t. )          // refresh the browse with the new record value
    endif

    dbunlock()
endif
return NIL


//-----------
static func Xabort()
local nSel
local bConfig := {||ADbm_timeout( 10, {||ADbm_abort()} )}

tone(100,1)
nSel := ADboxmenu( "Will Abort in 10 Seconds.",;
                   { "Do Not Abort", "Go Ahead" },;
                   ,;
                   ,;
                   ,;
                   ,;
                   bConfig;
                 )

if nSel == 0 .or. nSel == 2     // if no selection was made within
    ADr_abort()                 //  10 secs, it will abort anyway
endif                           
return NIL


//---------
static func Xadd()
local aRec, nRecno := recno()
local bConfig := {||ADgm_color( { "W+/W", "GR+/R", "W+/N" } ),;
                    ADgm_labels( ADdb_colheadings() ),;                                  // labels the Gets with the browse column headings
                    ADgm_readconfig( {||ADr_timeout( READ_TIMEOUT, {||Xabort()} ),;   // aborts the Read after READ_TIMEOUT seconds of idle time
                                        ADr_expattr( {8,10,14,69}, "GR+/R" );            // configures the memoedit
                                     };
                                   );
                 }

append blank

if !neterr()
    aRec := ADgetrec( 80 )
    
    if ADg_many( aRec, bConfig, "ADD" )
        ADputrec( aRec )
        dbcommit()
        ADdb_stabilize( .f., .t. )
    else
        goto nRecno
    endif

    dbunlock()
endif
return NIL


//----------
static func Xsort()
local xx := 1, cKey
local aKey[0]

// build the menu options with index key values
do while !empty( cKey := indexkey(xx++) )
    aadd( aKey, ADn2s( len( aKey ) + 1 ) + " " + cKey )
enddo

xx := ADvermenu( ,, aKey,,,, "SORT" )

if xx > 0
    set order to xx
    ADdb_stabilize( .f., .t. )
endif
return NIL



//------------
static func Xdelrec()
if rlock()
    if deleted()
        recall
        Xshow_delmsg()
    else
        delete
        Xshow_delmsg()
    endif
    
    dbunlock()
endif
return NIL


//------------------
static func Xpack()
// close and reopen exclusively for safe indexing
if "F_TOUR.EXE" $ ADprogname()
    use employee exclusive
else
    use ..\employee exclusive
endif

if !neterr()
    if "F_TOUR.EXE" $ ADprogname()
        set index to emp_num, emp_name, emp_fnam
    else
        set index to ..\emp_num, ..\emp_name, ..\emp_fnam
    endif

    pack 
    use
    
    if "F_TOUR.EXE" $ ADprogname()
        use employee shared
        if neterr()
        else
            set index to emp_num, emp_name, emp_fnam
        endif    
    else
        use ..\employee shared
        if neterr()
        else
            set index to ..\emp_num, ..\emp_name, ..\emp_fnam
        endif
    endif
    ADdb_stabilize( .f., .t. )
    Xshow_delmsg()
endif
return NIL


//----------
static func Xseek()
local cPrompt
local nOrder := indexord()
local bNoMatch := {||tone(100,1), ADmessage( { "No match found!" } )}

if nOrder == 1
    cPrompt := "ID Number"
elseif nOrder == 2
    cPrompt := "Last Name"
elseif nOrder == 3
    cPrompt := "Last Name - First Name"
endif
 
ADdb_seek( cPrompt + " To Seek", bNoMatch,,, "SEEK" )
return NIL


//--------------
static func Xsoftseek()
local aScn
local nT := ADdb_bottom()
local nL := ADdb_left()
local nB := nT + 2
local nR := ADdb_right()

ADdb_softseek( nT + 1, nL + 2,;
               indexkey(0) + ":",;
               { "W+/BG", "R/BG" },;
               {||aScn := ADbox( nT, nL, nB, nR,,, .f., .f. )},;
               "SOFTSEEK";
             )
ADrestscn( aScn )
return NIL

