unit ViewToolbars;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, TFloatPanel;

type
  TViewToolbarsDlg = class(TForm)
    sbxCheckBoxes: TScrollBox;
    cmdClose: TButton;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ckbClick(Sender: TObject);
  end;



var
  ViewToolbarsDlg: TViewToolbarsDlg;


procedure ShowViewToolbarsDlg;

implementation


{$R *.DFM}

procedure ShowViewToolbarsDlg;
var
  tflpnl : TFloatpnl;
  tcb    : TCheckBox;
  i : integer;
begin

  ViewToolbarsDlg := TViewToolbarsDlg.Create(Application);

  for i := 0 to ToolbarList.count -1 do
  begin
    tflpnl := Toolbarlist.items[i];
    tcb := TCheckBox.Create(ViewToolbarsDlg.sbxCheckBoxes);
    tcb.Parent := ViewToolbarsDlg.sbxCheckBoxes;
    tcb.left := 4;
    tcb.height := 21;
    tcb.width := 223;
    tcb.name := 'ckb' + InttoStr(i);
    tcb.top := 2 +  (i * 21);
    tcb.caption := tflpnl.caption;
    tcb.checked := tflpnl.VisibleDock;
    tcb.onclick := ViewToolbarsDlg.ckbClick;

  end ;
  ViewToolbarsDlg.ShowModal;
end;

procedure TViewToolbarsDlg.ckbClick(Sender: TObject);
var
  tflpnl : TFloatpnl;
  tcb    : TCheckBox;
  i : integer;
begin
  i := StrToInt(Copy((Sender as TCheckbox).name,4,2));
  tflpnl := Toolbarlist.items[i];
  tflpnl.VisibleDock := (sender as TCheckbox).checked;
end;

end.
