{****************************************************************************

                   Copyright (c) 1994,96 by Florian Klaempfl

 ****************************************************************************}

{****************************************************************************
               functions for heap management in the data segment
 ****************************************************************************}
{**** 10/06/97 added checkings and corrected some bugs in getmem/freemem ****}
{**** Pierre Muller *********************************************************}
    type
       pheapinfo = ^theapinfo;
       theapinfo = record
         heaporg,heapptr,heapend,freelist : pointer;
         memavail,heapsize : longint;
         end;
    type
       pfreerecord = ^tfreerecord;

       tfreerecord = record
          next : pfreerecord;
          size : longint;
       end;

    var
       baseheap,tempheap : theapinfo;
       curheap,otherheap : pheapinfo;

    const
       heap_split : boolean = false;
       max_size = 256;
       maxblock = max_size div 8;

    var
       blocks : array[1..maxblock] of pointer;
       nblocks : array[1..maxblock] of longint;
       _memavail : longint;
       _heapsize : longint;

    function getheapsize : longint;

      begin
         asm
            movl HEAPSIZE,%eax
            leave
            ret
         end ['EAX'];
      end;

    function heapsize : longint;

      begin
         heapsize:=_heapsize;
      end;

    function cal_memavail : longint;

      var
         hp : pfreerecord;
         i,ma: longint;

      begin
         ma:=heapend-heapptr;
         for i:=1 to maxblock do
           ma:=ma+i*8*nblocks[i];
         hp:=freelist;
         while assigned(hp) do
           begin
              ma:=ma+hp^.size;
{$IfDef CHECKHEAP}
              if longint(hp^.next)<>0 then
		if longint(hp^.next)<=(longint(hp)+hp^.size) then
                  writeln('error in freerecord list ');
{$EndIf CHECKHEAP}
              hp:=hp^.next;
           end;
         cal_memavail:=ma;
      end;

    procedure split_heap;
    begin
    if not heap_split then
      begin
      baseheap.heaporg:=heaporg;
      baseheap.heapptr:=heapptr;
      baseheap.freelist:=freelist;
      longint(baseheap.heapend):=((longint(heapend)+longint(heapptr)) div 16)*8;
      tempheap.heaporg:=baseheap.heapend;
      tempheap.freelist:=nil;
      tempheap.heapptr:=tempheap.heaporg;
      tempheap.memavail:=longint(tempheap.heapend) - longint(tempheap.heaporg);
      tempheap.heapsize:=tempheap.memavail;
      tempheap.heapend:=heapend;
      heapend:=baseheap.heapend;
      _memavail:=cal_memavail;
      baseheap.memavail:=_memavail;
      baseheap.heapsize:=longint(baseheap.heapend)-longint(baseheap.heaporg);
      curheap:=@baseheap;
      otherheap:=@tempheap;
      heap_split:=true;
      end;
    end;

    procedure switch_to_temp_heap;
    begin
    if curheap = @baseheap then
      begin
      baseheap.heaporg:=heaporg;
      baseheap.heapend:=heapend;
      baseheap.heapptr:=heapptr;
      baseheap.freelist:=freelist;
      baseheap.memavail:=_memavail;
      heaporg:=tempheap.heaporg;
      heapptr:=tempheap.heapptr;
      freelist:=tempheap.freelist;
      heapend:=tempheap.heapend;
      _memavail:=cal_memavail;
      curheap:=@tempheap;
      otherheap:=@baseheap;
      end;
    end;

    procedure switch_to_base_heap;
    begin
    if curheap = @tempheap then
      begin
      tempheap.heaporg:=heaporg;
      tempheap.heapend:=heapend;
      tempheap.heapptr:=heapptr;
      tempheap.freelist:=freelist;
      tempheap.memavail:=_memavail;
      heaporg:=baseheap.heaporg;
      heapptr:=baseheap.heapptr;
      freelist:=baseheap.freelist;
      heapend:=baseheap.heapend;
      _memavail:=cal_memavail;
      curheap:=@baseheap;
      otherheap:=@tempheap;
      end;
    end;

    procedure switch_heap;
    begin
    split_heap;
    if curheap = @tempheap then
      switch_to_base_heap
      else
      switch_to_temp_heap;
    end;

    procedure gettempmem(var p : pointer;size : longint);

    begin
       split_heap;
       switch_to_temp_heap;
       allow_special:=true;
       getmem(p,size);
       allow_special:=false;
    end;

    function memavail : longint;

      begin
         memavail:=_memavail;
      end;

    procedure unsplit_heap;
    var hp,hp2,thp : pfreerecord;
    begin
    {heapend can be modified by HeapError }
    if baseheap.heapend = tempheap.heaporg then
      begin
      switch_to_base_heap;
      hp:=pfreerecord(freelist);
      if assigned(hp) then
        while assigned(hp^.next) do hp:=hp^.next;
      hp^.next:=tempheap.freelist;
      hp^.size:=heapend-heapptr;
      heapend:=tempheap.heapend;
      heapptr:=tempheap.heapptr;
      _memavail:=cal_memavail;
      heap_split:=false;
      end else
      begin
      hp:=pfreerecord(baseheap.freelist);
      hp2:=pfreerecord(tempheap.freelist);
      while assigned(hp) and assigned(hp2) do
        begin
        if hp=hp2 then break;
        if hp>hp2 then
          begin
          thp:=hp2;
          hp2:=hp;
          hp:=thp;
          end;
        while assigned(hp^.next) and (hp^.next<hp2) do
            hp:=hp^.next;
        if assigned(hp^.next) then
            begin
            thp:=hp^.next;
            hp^.next:=hp2;
            hp:=thp;
            end else
            begin
            hp^.next:=hp2;
            hp:=nil;
            end;
          end ;
      if heapend < tempheap.heapend then
        heapend:=tempheap.heapend;
      if heapptr < tempheap.heapptr then
        heapptr:=tempheap.heapptr;
      _memavail:=cal_memavail;
      heap_split:=false;
      end;
    end;

    procedure releasetempheap;
    begin
    switch_to_temp_heap;
{$ifdef CHECKHEAP}
    if heapptr<>heaporg then
      writeln('Warning in releasetempheap : ',longint(tempheap.heapsize)-longint(tempheap.memavail),' bytes used !');
    release(heaporg);
    fillchar(heaporg^,longint(heapend)-longint(heaporg),#0);
{$endif CHECKHEAP }
    unsplit_heap;
    split_heap;
    end;

    function maxavail : longint;

      var
         hp : pfreerecord;

      begin
         maxavail:=heapend-heapptr;
         hp:=freelist;
         while assigned(hp) do
           begin
              if hp^.size>maxavail then
                maxavail:=hp^.size;
              hp:=hp^.next;
           end;
      end;

{$ifdef CHECKHEAP}
     procedure test_memavail;

       begin
          if _memavail<>cal_memavail then
            begin
               writeln('Memavail error in getmem/freemem');
            end;
       end;
{$endif CHECKHEAP}

    procedure getmem(var p : pointer;size : longint);[public,alias: 'GETMEM'];


      function call_heaperror(size : longint) : integer;
{$ifdef DOS}
        begin
           asm
              pushl 12(%ebp)
              { movl HEAPERROR,%eax doesn't work !!}
              leal U_SYSTEM_HEAPERROR,%eax
              call (%eax)
              leave
              ret $8
           end;
        end;
{$endif}
{$ifdef LINUX}
        begin
           asm
              pushl 12(%ebp)
              leal U_SYSLINUX_HEAPERROR,%eax
              call (%eax)
              leave
              ret $8
           end;
        end;
{$endif}

      var
         last,hp : pfreerecord;
         nochmal : boolean;
         s : longint;

      begin
         if size=0 then
           begin
              p:=heapend;
              exit;
           end;
         if heap_split and not allow_special then
           begin
           if (@p < otherheap^.heapend) and
              (@p > otherheap^.heaporg) then
              { useful line for the debugger }
             writeln('warning : p and @p are in different heaps !');
           end;
         { calc to multiply of 8 }
         if (size mod 8)<>0 then
           size:=size+(8-(size mod 8));
         dec(_memavail,size);
         { search cache }
         if size<=max_size then
           begin
              s:=size div 8;
              if assigned(blocks[s]) then
                begin
                   p:=blocks[s];
{$ifdef VER0_6}
                   move(blocks[s]^,blocks[s],4);
{$else VER0_6}
                   blocks[s]:=pointer(blocks[s]^);
{$endif VER0_6}
                   dec(nblocks[s]);
                   exit;
                end;
           end;
         repeat
           nochmal:=false;
           { search the freelist }
           if assigned(freelist) then
             begin
                last:=nil;
                hp:=freelist;
                while assigned(hp) do
                  begin
                     { take the first fitting block }
                     if hp^.size>=size then
                       begin
                          p:=hp;
                          { need we the whole block ? }
                          if hp^.size>size then
                            begin
                               (hp+size)^.size:=hp^.size-size;
                               (hp+size)^.next:=hp^.next;
                               if assigned(last) then
                                 last^.next:=hp+size
                               else
                                 freelist:=hp+size;
                            end
                          else
                            begin
                               if assigned(last) then
                                 last^.next:=hp^.next
                               else
                                 {this was wrong !!}
                                 {freelist:=nil;}
                                 freelist:=hp^.next;
                            end;
                          exit;
                       end;
                     last:=hp;
                     hp:=hp^.next;
                  end;
             end;
           { zuletzt wird an der Heapspitze nachgeschaut, ob }
           { noch Speicher frei ist                          }
           if heapend-heapptr<size then
             begin
                if assigned(heaperror) then
                  begin
                     case call_heaperror(size) of
                        0 : runerror(203);
                        1 : p:=nil;
                        2 : nochmal:=true;
                     end;
                  end
                else
                  runerror(203);
             end
           else
             begin
                p:=heapptr;
                heapptr:=heapptr+size;
             end;
         until not nochmal;
{$ifdef CHECKHEAP}
     test_memavail;
{$endif CHECKHEAP}
      end;

    procedure freemem(var p : pointer;size : longint);[public,alias: 'FREEMEM'];

      var
         hp : pfreerecord;
         heap_switched : boolean;
         s : longint;

      type
         ppointer = ^pointer;

      begin
         if size=0 then
           begin
              p:=nil;
              exit;
           end;
         heap_switched:=false;
         if heap_split and not allow_special then
           begin
              if (p <= heapptr) and
                 ( p >= heaporg) and
                 (@p <= otherheap^.heapend) and
                 (@p >= otherheap^.heaporg) then
                begin
                   writeln('warning : p and @p are in different heaps !');
                end;
           end;
         if (p<heaporg) or (p>heapptr) then
           begin
              if heap_split and (p<otherheap^.heapend) and
                 (p>otherheap^.heaporg) then
                begin
                   if (@p >= heaporg) and
                      (@p <= heapptr) and
                      not allow_special then
                      writeln('warning : p and @p are in different heaps !');
                   switch_heap;
                   heap_switched:=true;
                end
              else
                begin
                   writeln('pointer ',hexstr(longint(@p),8),' at ',
		     hexstr(longint(p),8),' doesn''t points to the heap');
                   runerror(203);
                end;
           end;
         { calc to multiple of 8 }
         if (size mod 8)<>0 then
           size:=size+(8-(size mod 8));
         inc(_memavail,size);
         if p+size>=heapptr then
           heapptr:=p
         { insert into cache }
         else if size<=max_size then
           begin
              s:=size div 8;
              ppointer(p)^:=blocks[s];
              blocks[s]:=p;
              inc(nblocks[s]);
           end
         else
           begin
              { size can be allways set }
              pfreerecord(p)^.size:=size;

              { if there is no free list }
              if not assigned(freelist) then
                begin
                   { then generate one }
                   freelist:=p;
                   pfreerecord(p)^.next:=nil;
{$ifdef CHECKHEAP}
                   test_memavail;
{$endif CHECKHEAP}
                   p:=nil;
                   { we are ready }
                   if heap_switched then switch_heap;
                   exit;
                end;
              if p+size<freelist then
                begin
                pfreerecord(p)^.next:=freelist;
                freelist:=p;
{$ifdef CHECKHEAP}
                   test_memavail;
{$endif CHECKHEAP}
                p:=nil;
                if heap_switched then switch_heap;
                exit;
                end
              else
              if p+size=freelist then
                begin
                inc(pfreerecord(p)^.size,pfreerecord(freelist)^.size);
                pfreerecord(p)^.next:=pfreerecord(freelist)^.next;
                freelist:=p;
                { but now it can also connect the next block !!}
                if p+pfreerecord(p)^.size=pfreerecord(p)^.next then
                  begin
                     inc(pfreerecord(p)^.size,pfreerecord(p)^.next^.size);
                     pfreerecord(p)^.next:=pfreerecord(freelist)^.next^.next;
                  end;
{$ifdef CHECKHEAP}
                test_memavail;
{$endif CHECKHEAP}
                p:=nil;
                if heap_switched then switch_heap;
                exit;
                end;
              { search the insert position }
              hp:=freelist;
              while assigned(hp) do
                begin
                   if p<hp+hp^.size then
                      begin
                      writeln('pointer to dispose at ',hexstr(longint(p),8),
                        ' has already been disposed');
                      runerror(203);
                      end;
                   { connecting two blocks ? }
                   if hp+hp^.size=p then
                      begin
                         inc(hp^.size,size);
                         { connecting also to next block ? }
                         if hp+hp^.size=hp^.next then
                           begin
                              inc(hp^.size,hp^.next^.size);
                              hp^.next:=hp^.next^.next;
                           end;
                         break;
                      end
                   { if the end is reached, then concat }
                   else if hp^.next=nil then
                     begin
                        hp^.next:=p;
                        pfreerecord(p)^.next:=nil;
                        break;
                     end
                   { falls der nchste Zeiger grer ist, dann }
                   { Einhngen                                 }
                   else if hp^.next>p then
                     begin
                        { connect to blocks }
                        if p+size=hp^.next then
                          begin
                             pfreerecord(p)^.next:=hp^.next^.next;
                             inc(pfreerecord(p)^.size,hp^.next^.size);
                             { we have to reset the right position }
                             hp^.next:=pfreerecord(p);
                          end
                        else
                          begin
                             pfreerecord(p)^.next:=hp^.next;
                             hp^.next:=p;
                          end;
                        break;
                     end;
                   hp:=hp^.next;
                end;
           end;
{$ifdef CHECKHEAP}
         test_memavail;
{$endif CHECKHEAP}
         p:=nil;
         if heap_switched then switch_heap;
      end;

    function getheapstart : pointer;

      begin
         asm
            leal HEAP,%eax
            leave
            ret
         end ['EAX'];
      end;

    procedure release(var p : pointer);

      begin
         heapptr:=p;
         freelist:=nil;
         _memavail:=cal_memavail;
      end;

    procedure mark(var p : pointer);

      begin
         p:=heapptr;
      end;

    procedure markheap(var oldfreelist,oldheapptr : pointer);

      begin
         oldheapptr:=heapptr;
         oldfreelist:=freelist;
         freelist:=nil;
         _memavail:=cal_memavail;
      end;

    procedure releaseheap(oldfreelist,oldheapptr : pointer);

      begin
         heapptr:=oldheapptr;
         if longint(freelist) < longint(heapptr) then
           begin
           {here we should reget the freed blocks}
           end;
         freelist:=oldfreelist;
         _memavail:=cal_memavail;
      end;

{ this function should be moved to the system.pp
as it is system dependent !! }
{ this function allows to extend the heap by calling
___sbrk in v2prt0.s that resize the data segment }

{ this function allows to extend the heap by calling
___sbrk in v2prt0.s that resize the data segment }

  function Sbrk(size : longint) : longint;

    begin
       asm
         movl size,%ebx
	 movl $0x4a01,%eax
	 int  $0x21
         movl %eax,__RESULT
       end;
    end;

Function growheap(size :longint) : integer;
Var NewPos,wantedsize : longint;
         hp : pfreerecord;
    Newlimit : longint;

begin
   wantedsize:=size;
   size:=size+$ffff;
   size:=size and $ffff0000;
   { Allocate by 64K size }
   { first try 1Meg }
   NewPos:=Sbrk($100000);
   if NewPos=-1 then
     NewPos:=Sbrk(size)
   else
     size:=$100000;
   if (NewPos = -1) then
     begin
        GrowHeap:=0;
        {$IfDef CHECKHEAP}
        writeln('Call to GrowHeap failed');
        readln;
        {$EndIf CHECKHEAP}
        Exit;
     end
   else
     begin
     { make the room clean }
{$ifdef CHECKHEAP}
        Fillword(pointer(NewPos)^,size div 2,$ABCD);
        Newlimit:= (newpos+size) or $3fff;
{$else }
        Fillchar(pointer(NewPos)^,size,#0);
{$endif }
        hp:=pfreerecord(freelist);
        if not assigned(hp) then
          begin
          if pointer(newpos) = heapend then
            heapend:=pointer(newpos+size)
          else
            begin
               if heapend - heapptr > 0 then
                 begin
                    freelist:=heapptr;
                    hp:=pfreerecord(freelist);
                    hp^.size:=heapend-heapptr;
                    hp^.next:=nil;
                 end;
               heapptr:=pointer(newpos);
               heapend:=pointer(newpos+size);
            end;
          end
        else
          begin
             if pointer(newpos) = heapend then
               heapend:=pointer(newpos+size)
             else
               begin
                  while assigned(hp^.next) and (longint(hp^.next) < longint(NewPos)) do
                    hp:=hp^.next;
                  if hp^.next = nil then
                    begin
                       hp^.next:=pfreerecord(heapptr);
                       hp:=pfreerecord(heapptr);
                       hp^.size:=heapend-heapptr;
                       hp^.next:=nil;
                       heapptr:=pointer(NewPos);
                       heapend:=pointer(NewPos+Size);
                    end
                  else
	            begin
                       pfreerecord(NewPos)^.Size:=Size;
                       pfreerecord(NewPos)^.Next:=hp^.next;
                       hp^.next:=pfreerecord(NewPos);
                    end;
               end;
          end;
        { the wanted size has to be substracted }
        _memavail:=cal_memavail-wantedsize;
        { set the total new heap size }
        asm
        movl Size,%ebx
        movl HEAPSIZE,%eax
        addl %ebx,%eax
        movl %eax,HEAPSIZE
        end;
        GrowHeap:=2;{ try again }
        _Heapsize:=size+_heapsize;
{$IfDef CHECKHEAP}
        writeln('Call to GrowHeap succedeed : HeapSize = ',_HeapSize,' MemAvail = ',memavail);
        writeln('New heap part begins at ',Newpos,' with size ',size);
        readln;
{$EndIf CHECKHEAP}
        exit;
     end;
end;

