{$ifdef tp}
{E+,N+}
{$endif}
{****************************************************************************

                     Copyright (c) 1993,97 by Florian Klaempfl

 ****************************************************************************}

{
  This units exports some routines to manage the parse tree
  History:
      19th october 1996:
          + adapted to version 0.9.0
}
unit tree;

  interface

    uses
       objects,globals,symtable,cobjects,aasm,errors,files
{$ifdef i386}
       ,i386
{$endif}
{$ifdef alpha}
       ,alpha
{$endif}
       ;

    type
       tconstset = array[0..31] of byte;
       
       pconstset = ^tconstset;

       ttreetyp = (addn,muln,subn,divn,
                   modn,assignn,loadn,rangen,
                   ltn,lten,gtn,gten,
                   equaln,unequaln,inn,orn,
                   xorn,shrn,shln,slashn,
                   andn,subscriptn,derefn,addrn,
                   ordconstn,typeconvn,calln,callparan,
                   realconstn,fixconstn,umminusn,asmn,vecn,
                   stringconstn,funcretn,selfn,
                   notn,inlinen,niln,errorn,
                   typen,hnewn,hdisposen,newn,
                   simpledisposen,setelen,setconstrn,blockn,
                   anwein,loopn,ifn,breakn,
                   continuen,repeatn,whilen,forn,
                   exitn,withn,casen,labeln,
                   goton,simplenewn,tryexceptn,raisen,
                   switchesn,tryfinallyn,isn,asn);

       tconverttype = (tc_equal,tc_not_possible,tc_u8bit_2_s32bit,
                       tc_only_rangechecks32bit,tc_s8bit_2_s32bit,
                       tc_u16bit_2_s32bit,tc_s16bit_2_s32bit,
                       tc_s32bit_2_s16bit,tc_s32bit_2_u8bit,
                       tc_s32bit_2_u16bit,tc_string_to_string,
                       tc_cstring_charpointer,tc_string_chararray,
                       tc_array_to_pointer,tc_pointer_to_array,
                       tc_char_to_string,tc_u8bit_2_s16bit,
                       tc_u8bit_2_u16bit,tc_s8bit_2_s16bit,
                       tc_s16bit_2_s8bit,tc_s16bit_2_u8bit,
                       tc_u16bit_2_s8bit,tc_u16bit_2_u8bit,
                       tc_s8bit_2_u16bit,tc_s32bit_2_s8bit,
                       tc_int_2_real,tc_real_2_fix,
		       tc_fix_2_real,tc_int_2_fix,tc_real_2_real,
                       tc_chararray_2_string,tc_cchar_chararray);

       { gibt an, welche Nachfolger eines Knotens }
       { gelscht werden mssen }
       tdisposetyp = (dt_nothing,dt_leftright,dt_left,
                      dt_mbleft,dt_string,dt_typeconv,dt_inlinen,
                      dt_mbleft_and_method,dt_constset,dt_loop,dt_case,
                      dt_with);

       pcaserecord = ^tcaserecord;

       tcaserecord = record

          { range }
          _low,_high : longint;

          { only used by gentreejmp }
          _at : longint;

          { lable of instruction }
          statement : longint;

          { left and right tree node }
          less,greater : pcaserecord;
       end;

       ptree = ^ttree;

       ttree = record
          error : boolean;
          disposetyp : tdisposetyp;
          { is true, if the right and left operand are swaped }
          swaped : boolean;

          { the location of the result of this node }
          location : tlocation;

          { the number of registers needed to evalute the node }
          registers32,registersfpu : longint;  { must be longint !!!! }
          left,right : ptree;
          resulttype : pdef;
          inputfile : pinputfile;
          line : longint;
          pragmas : pcswitches;
          case treetype : ttreetyp of
             callparan : (is_colon_para : boolean);
             loadn : (symtableentry : psym;symtable : psymtable;
                      is_absolute,is_first : boolean);
             calln : (symtableprocentry : pprocsym;
                      symtableproc : psymtable;procdefinition : pprocdef;
                      methodpointer : ptree);
             ordconstn : (value : longint);
             realconstn : (valued : double;labnumber : longint);
             fixconstn : (valuef: longint);
             subscriptn : (vs : pvarsym);
             stringconstn : (values : pstring);
             typeconvn : (convtyp : tconverttype;explizit : boolean);
             inlinen : (inlinenumber : longint);
             setconstrn : (constset : pconstset);
             loopn : (t1,t2 : ptree;backward : boolean);
             asmn : (p_asm : paasmoutput);
             casen : (nodes : pcaserecord;elseblock : ptree;ranges : boolean);
             labeln,goton : (labelnr : longint);
             withn : (withsymtable : psymtable);
       end;

    procedure init_tree;
    function gennode(t : ttreetyp;l,r : ptree) : ptree;
    function genlabelnode(t : ttreetyp;nr : longint) : ptree;
    function genloadnode(v : pvarsym;st : psymtable) : ptree;
    function gensinglenode(t : ttreetyp;l : ptree) : ptree;
    function gensubscriptnode(varsym : pvarsym;l : ptree) : ptree;
    function genordinalconstnode(v : longint;def : pdef) : ptree;
    function genfixconstnode(v : longint;def : pdef) : ptree;
    function gentypeconvnode(node : ptree;t : pdef) : ptree;
    function gencallparanode(expr,next : ptree) : ptree;
    function genrealconstnode(v : double) : ptree;
    function gencallnode(v : pprocsym;st : psymtable) : ptree;
    {
    function geninlinenode(v : pprocsym;st : psymtable) : ptree;
    }
    function genmethodcallnode(v : pprocsym;st : psymtable;mp : ptree) : ptree;
    function genstringconstnode(const s : string) : ptree;
    function genzeronode(t : ttreetyp) : ptree;
    function geninlinenode(number : longint;l : ptree) : ptree;
    function gentypedconstloadnode(sym : ptypedconstsym;st : psymtable) : ptree;
    function genaufzaehlnode(v : paufzaehlsym) : ptree;
    function genselfnode(_class : pdef) : ptree;
    function gensetconstruktnode(settype : pdef;p : pconstset) : ptree;
    function genloopnode(t : ttreetyp;l,r,n1: ptree;back : boolean) : ptree;
    function genasmnode(p_asm : paasmoutput) : ptree;
    function gencasenode(l,r : ptree;nodes : pcaserecord) : ptree;
    function genwithnode(symtable : psymtable;l,r : ptree) : ptree;

    function getcopy(p : ptree) : ptree;

    procedure disposetree(p : ptree);
    procedure putnode(p : ptree);
    function getnode : ptree;
    procedure clearnodes;
{$ifdef CleanUp}
    Procedure Set_location(var destloc,sourceloc : tlocation);
    Procedure Swap_location(var destloc,sourceloc : tlocation);
{$endif * CleanUp *}

    {$I innr.inc}

  implementation

    const
       oldswitches : tcswitches = [];

{****************************************************************************
        this is a pool for the tree nodes to get more performance
 ****************************************************************************}

    var
       root : ptree;

    procedure init_tree;

      begin
         root:=nil;
      end;

    procedure clearnodes;

      var
         hp : ptree;

      begin
         hp:=root;
         while assigned(hp) do
           begin
              root:=hp^.left;
              dispose(hp);
              hp:=root;
           end;
      end;

    function getnode : ptree;

      var
         hp : ptree;

      begin
         if root=nil then
           new(hp)
         else
           begin
              hp:=root;
              root:=root^.left;
           end;

         { makes error tracking easier }
         fillchar(hp^,sizeof(ttree),#0);
         hp^.location.loc:=LOC_INVALID;

         { new node is error free }
         hp^.error:=false;

         { we know also the position }
         hp^.line:=current_module^.current_inputfile^.line_no;
         hp^.inputfile:=current_module^.current_inputfile;
         hp^.pragmas:=nil;

         { switches modified ? }
         { FPKPascal doesn't know set comperations }
{$ifndef ver0_6}
         if aktswitches<>oldswitches then
{$endif}
           begin
              new(hp^.pragmas);
              hp^.pragmas^:=aktswitches;
              oldswitches:=aktswitches;
           end;
         getnode:=hp;
      end;

    procedure putnode(p : ptree);

      begin
         { clean up the contents of a node }
         if p^.treetype=asmn then
           if assigned(p^.p_asm) then
             dispose(p^.p_asm,done);

         if p^.treetype=setconstrn then
          if assigned(p^.constset) then
            dispose(p^.constset);

         if (p^.location.loc=LOC_MEM) or (p^.location.loc=LOC_REFERENCE) and
           assigned(p^.location.reference.symbol) then
           stringdispose(p^.location.reference.symbol);

         if p^.disposetyp=dt_string then
           stringdispose(p^.values);

         p^.left:=root;
         root:=p;
      end;

    function getcopy(p : ptree) : ptree;

      var
         hp : ptree;

      begin
         hp:=getnode;
         hp^:=p^;
         if assigned(p^.location.reference.symbol) then
           hp^.location.reference.symbol:=stringdup(p^.location.reference.symbol^);
         case p^.disposetyp of
              dt_leftright
                        : begin
                              if assigned(p^.left) then
                                hp^.left:=getcopy(p^.left);
                              if assigned(p^.right) then
                                hp^.right:=getcopy(p^.right);
                           end;
            dt_nothing : ;
            dt_left    : if assigned(p^.left) then
                           hp^.left:=getcopy(p^.left);
            dt_mbleft : if assigned(p^.left) then
                          hp^.left:=getcopy(p^.left);
            dt_mbleft_and_method : begin
                                      if assigned(p^.left) then
                                        hp^.left:=getcopy(p^.left);
                                      hp^.methodpointer:=getcopy(p^.methodpointer);
                                   end;
            dt_loop : begin
                         if assigned(p^.left) then
                           hp^.left:=getcopy(p^.left);
                         if assigned(p^.right) then
                           hp^.right:=getcopy(p^.right);
                         if assigned(p^.t1) then
                           hp^.t1:=getcopy(p^.t1);
                         if assigned(p^.t2) then
                           hp^.t2:=getcopy(p^.t2);
                      end;
            dt_string : hp^.values:=stringdup(p^.values^);
            dt_typeconv : hp^.left:=getcopy(p^.left);
            dt_inlinen : if assigned(p^.left) then
                           hp^.left:=getcopy(p^.left);
            else internalerror(11);
         end;
         getcopy:=hp;
      end;

    procedure deletecaselabels(p : pcaserecord);

      begin
         if assigned(p^.greater) then
           deletecaselabels(p^.greater);
         if assigned(p^.less) then
           deletecaselabels(p^.less);
         dispose(p);
      end;

    procedure disposetree(p : ptree);

      begin
         if not(assigned(p)) then
           exit;
         case p^.disposetyp of
            dt_leftright : begin
                              if assigned(p^.left) then
                                disposetree(p^.left);
                              if assigned(p^.right) then
                                disposetree(p^.right);
                           end;
            dt_case      : begin
                              if assigned(p^.left) then
                                disposetree(p^.left);
                              if assigned(p^.right) then
                                disposetree(p^.right);
                              if assigned(p^.nodes) then
                                deletecaselabels(p^.nodes);
                              if assigned(p^.elseblock) then
                                disposetree(p^.elseblock);
                           end;
            dt_nothing : ;
            dt_left    : if assigned(p^.left) then
                           disposetree(p^.left);
            dt_mbleft : if assigned(p^.left) then
                          disposetree(p^.left);
            dt_mbleft_and_method : begin
                                      if assigned(p^.left) then disposetree(p^.left);
                                        disposetree(p^.methodpointer);
                                   end;
            dt_string : stringdispose(p^.values);
            dt_typeconv : disposetree(p^.left);
            dt_inlinen : if assigned(p^.left) then
                           disposetree(p^.left);
            dt_loop : begin
                         if assigned(p^.left) then
                           disposetree(p^.left);
                         if assigned(p^.right) then
                           disposetree(p^.right);
                         if assigned(p^.t1) then
                           disposetree(p^.t1);
                         if assigned(p^.t2) then
                           disposetree(p^.t2);
                      end;
            dt_with : begin
                         if assigned(p^.left) then
                           disposetree(p^.left);
                         if assigned(p^.right) then
                           disposetree(p^.right);
                         if assigned(p^.withsymtable) then
                           dispose(p^.withsymtable,done);
                      end;
            else internalerror(12);
         end;
         putnode(p);
      end;

    function genwithnode(symtable : psymtable;l,r : ptree) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_with;
         p^.treetype:=withn;
         p^.left:=l;
         p^.right:=r;
         p^.registers32:=0;
         { p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         p^.withsymtable:=symtable;
         genwithnode:=p;
      end;

    function genfixconstnode(v : longint;def : pdef) : ptree;

      var
	 p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_nothing;
         p^.treetype:=fixconstn;
	 p^.registers32:=0;
         { p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
	 p^.resulttype:=def;
	 p^.value:=v;
	 genfixconstnode:=p;
      end;

    function gencallparanode(expr,next : ptree) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_leftright;
         p^.treetype:=callparan;
         p^.left:=expr;
         p^.right:=next;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         p^.is_colon_para:=false;
         gencallparanode:=p;
      end;

    function gennode(t : ttreetyp;l,r : ptree) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_leftright;
         p^.treetype:=t;
         p^.left:=l;
         p^.right:=r;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         gennode:=p;
      end;

    function gencasenode(l,r : ptree;nodes : pcaserecord) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_case;
         p^.treetype:=casen;
         p^.left:=l;
         p^.right:=r;
         p^.nodes:=nodes;
         p^.registers32:=0;
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         gencasenode:=p;
      end;

    function genloopnode(t : ttreetyp;l,r,n1 : ptree;back : boolean) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_loop;
         p^.treetype:=t;
         p^.left:=l;
         p^.right:=r;
         p^.t1:=n1;
         p^.t2:=nil;
         p^.registers32:=0;
         p^.backward:=back;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         genloopnode:=p;
      end;

    function genordinalconstnode(v : longint;def : pdef) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_nothing;
         p^.treetype:=ordconstn;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=def;
         p^.value:=v;
         genordinalconstnode:=p;
      end;

    function genaufzaehlnode(v : paufzaehlsym) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_nothing;
         p^.treetype:=ordconstn;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=v^.definition;
         p^.value:=v^.value;
         genaufzaehlnode:=p;
      end;

    function genrealconstnode(v : double) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_nothing;
         p^.treetype:=realconstn;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=c64floatdef;
         p^.valued:=v;
         p^.labnumber:=-1;
         genrealconstnode:=p;
      end;

    function genstringconstnode(const s : string) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_string;
         p^.treetype:=stringconstn;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=cstringdef;
         p^.values:=stringdup(s);
         genstringconstnode:=p;
      end;

    function gensinglenode(t : ttreetyp;l : ptree) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_left;
         p^.treetype:=t;
         p^.left:=l;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         gensinglenode:=p;
      end;

    function genasmnode(p_asm : paasmoutput) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_nothing;
         p^.treetype:=asmn;
         p^.registers32:=4;
         p^.p_asm:=p_asm;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=8;
         p^.resulttype:=nil;
         genasmnode:=p;
      end;

    function genloadnode(v : pvarsym;st : psymtable) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.treetype:=loadn;
         p^.resulttype:=v^.definition;
         p^.symtableentry:=v;
         p^.symtable:=st;
         p^.is_first := False;
         p^.disposetyp:=dt_nothing;
         genloadnode:=p;
      end;

    function gentypedconstloadnode(sym : ptypedconstsym;st : psymtable) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.treetype:=loadn;
         p^.resulttype:=sym^.definition;
         p^.symtableentry:=pvarsym(sym);
         p^.symtable:=st;
         p^.disposetyp:=dt_nothing;
         gentypedconstloadnode:=p;
      end;

    function gentypeconvnode(node : ptree;t : pdef) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_typeconv;
         p^.treetype:=typeconvn;
         p^.left:=node;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=t;
         p^.explizit:=false;
         gentypeconvnode:=p;
      end;

    function gencallnode(v : pprocsym;st : psymtable) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.treetype:=calln;

         p^.symtableprocentry:=v;
         p^.symtableproc:=st;
         p^.disposetyp := dt_leftright;
         p^.methodpointer:=nil;
         p^.left:=nil;
         p^.right:=nil;
         p^.procdefinition:=nil;
         gencallnode:=p;
      end;

    function genmethodcallnode(v : pprocsym;st : psymtable;mp : ptree) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.treetype:=calln;

         p^.symtableprocentry:=v;
         p^.symtableproc:=st;
         p^.disposetyp:=dt_mbleft_and_method;
         p^.left:=nil;
         p^.right:=nil;
         p^.methodpointer:=mp;
         p^.procdefinition:=nil;
         genmethodcallnode:=p;
      end;

    function gensubscriptnode(varsym : pvarsym;l : ptree) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_left;
         p^.treetype:=subscriptn;
         p^.left:=l;
         p^.registers32:=0;
         p^.vs:=varsym;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         gensubscriptnode:=p;
      end;

   function genzeronode(t : ttreetyp) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_nothing;
         p^.treetype:=t;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         genzeronode:=p;
      end;

   function genlabelnode(t : ttreetyp;nr : longint) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_nothing;
         p^.treetype:=t;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         p^.labelnr:=nr;
         genlabelnode:=p;
      end;

    function genselfnode(_class : pdef) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_nothing;
         p^.treetype:=selfn;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=_class;
         genselfnode:=p;
      end;

    function geninlinenode(number : longint;l : ptree) : ptree;

      var
         p : ptree;

      begin
         p:=getnode;
         p^.disposetyp:=dt_inlinen;
         p^.treetype:=inlinen;
         p^.left:=l;
         p^.inlinenumber:=number;
         p^.registers32:=0;
{         p^.registers16:=0;
         p^.registers8:=0; }
         p^.registersfpu:=0;
         p^.resulttype:=nil;
         geninlinenode:=p;
      end;

   function gensetconstruktnode(settype : pdef;p : pconstset) : ptree;

{     var
        p : ptree; }

     begin
{         p:=getnode;
         p^.disposetyp:=dt_constset;
         p^.treetype:=constsetn;
         p^.registers32:=0;
         p^.registersfpu:=0;
         p^.resulttype:=settype;
         p^.setdata:=p;         }
     end;

   function equal_trees(t1,t2 : ptree) : boolean;

     begin
        if t1^.treetype=t2^.treetype then
          begin
             case t1^.treetype of
                addn,
                muln,
                equaln,
                orn,
                xorn,
                andn,
                unequaln:
                   begin
                      equal_trees:=(equal_trees(t1^.left,t2^.left) and
                                    equal_trees(t1^.right,t2^.right)) or
                                   (equal_trees(t1^.right,t2^.left) and
                                    equal_trees(t1^.left,t2^.right));
                   end;
                subn,
                divn,
                modn,
                assignn,
                ltn,
                lten,
                gtn,
                gten,
                inn,
                shrn,
                shln,
                slashn,
                rangen:
                   begin
                      equal_trees:=(equal_trees(t1^.left,t2^.left) and
                                    equal_trees(t1^.right,t2^.right));
                   end;
                umminusn,
                notn,
                derefn,
                addrn:
                   begin
                      equal_trees:=(equal_trees(t1^.left,t2^.left));
                   end;
                loadn:
                   begin
                      equal_trees:=(t1^.symtableentry=t2^.symtableentry)
                                   { unntig }
                                     and (t1^.symtable=t2^.symtable);
                   end;
                {

                   subscriptn,
                   ordconstn,typeconvn,calln,callparan,
                   realconstn,asmn,vecn,
                   stringconstn,funcretn,selfn,
                   inlinen,niln,errorn,
                   typen,hnewn,hdisposen,newn,
                   disposen,setelen,setconstrn
                }
                else equal_trees:=false;
             end;
          end
        else
          equal_trees:=false;
     end;

{$ifdef CleanUp}
     {This is needed if you want to be able to delete the string with the nodes !!}
     Procedure Set_location(var destloc,sourceloc : tlocation);
     Begin
     if assigned(destloc.reference.symbol) then stringdispose(destloc.reference.symbol);
     destloc:= sourceloc;
     if sourceloc.loc in [LOC_MEM,LOC_REFERENCE] then
       begin
       if assigned(sourceloc.reference.symbol) then
         destloc.reference.symbol:=stringdup(sourceloc.reference.symbol^);
       end else destloc.reference.symbol:=nil;
     End;

     Procedure Swap_location(var destloc,sourceloc : tlocation);
     var swapl : tlocation;
     Begin
     swapl := destloc;
     destloc := sourceloc;
     sourceloc := swapl;
     End;
{$endif * CleanUp *}
end.
