{****************************************************************************

                    Copyright (c) 1996,97 by Florian Klaempfl

 ****************************************************************************}

{

  this unit implements an extended file management

  + feature added
  - removed
  * bug fixed or changed

  History (started with version 0.9.0):
       2th december 1996:
         + unit started
      22th december 1996:
         + tinputfile added
}

unit files;

  interface

    uses
       dos,cobjects,systems,verbose,globals;

    const
{$ifdef FPK}
       maxunits = 1024;
{$else}
       maxunits = 128;
{$endif}

    type
       pextfile = ^textfile;

       { this isn't a text file, this is t-ext-file }
       { which means a extended file                }
       { this files can be handled by a file        }
       { manager                                    }
       textfile = object(tbufferedfile)
          path,name,ext : pstring;
          { this is because there is a name conflict }
          { with the older next from tinputstack     }
          _next : pextfile;

          { p must be the complete path (with ending \ (or / for unix ...) }
          constructor init(const p,n,e : string);
          destructor done;virtual;
       end;

       pinputfile = ^tinputfile;

       tinputfile = object(textfile)
          filenotatend : boolean;
          line_no : longint;

          { next input file in the stack of input files }
          next : pinputfile;

          constructor init(const p,n,e : string);
          { writes the file name and line number to t }
          procedure write_file_line(var t : text);
          function get_file_line : string;
       end;

       pfilemanager = ^tfilemanager;

       tfilemanager = object
          files : pextfile;
          constructor init;
          destructor done;
          procedure close_all;
          procedure register_file(f : pextfile);
       end;

    type
       pmodule = ^tmodule;
       pused_unit = ^tused_unit;

       tused_unit = object(tlinkedlist_item)
          u : pmodule;
          in_interface : boolean;
          unitid : word;
          constructor init(_u : pmodule;f : byte);
          destructor done;virtual;
       end;

       tunitmap = array[0..maxunits-1] of pointer;
       punitmap = ^tunitmap;

       tmodule = object(tlinkedlist_item)

          { the PPU file }
          ppufile : pextfile;

          { mapping of all used units }
          map : punitmap;
          { local unit counter }
          unitcount : word;
          { this is a pointer because symtable uses this unit }
          { it should be psymtable                            }
          symtable : pointer;

          { PPU version, handle different versions }
          ppuversion : longint;

          { check sum written to the file }
          crc : longint;

          { flags }
          flags : byte;

          { to see if we inset this to the symtablestack }
          in_uses : boolean;

          { for interpenetrated units }
          in_implementation : boolean;
          compiled : boolean;
          { true, if it's needed to compile the sources }
          do_compile : boolean;

          { true, if all sources are reachable }
          sources_avail : boolean;

          { only used, if the module is compiled by this compiler call }
          sourcefiles : tfilemanager;
          used_units : tlinkedlist;
          current_inputfile : pinputfile;

          { name of the module }
          name : pstring;

          { main source file, contains the name of the main source file }
          msource : pstring;

          constructor init_program;
          constructor init_unit(const n : string);
          { this is to be called only when
           compiling again }
          destructor special_done;virtual;
          { this extra method avoids }
          { a bug of FPKPascal with nested procedures of methods }
          procedure search_source(const n : string);
       end;

    var
       main_module : pmodule;
       current_module : pmodule;
       loaded_units : tlinkedlist;

    type
       tunitheader = array[0..19] of char;

    const
                                   {                compiler version }
                                   {             format      |       }
                                   { signature    |          |       }
                                   {  |           |          |       }
                                   { /-------\   /-------\  /---\    }
       unitheader : tunitheader  = ('P','P','U','0','1','2',#0,#9,
                                     #0,#0,#0,#0,#0,#0,#255,#255,
                                   { |   | \---------/ \-------/    }
                                   { |   |    |             |        }
                                   { |   |    check sum     |        }
                                   { |   \--flags        unused      }
                                   { target system                   }
                                    #0,#0,#0,#0);
                                   {\---------/                      }
                                   {  |                              }
                                   {  start of machine language      }

    const
       ibloadunit = 1;
       iborddef = 2;
       ibpointerdef = 3;
       ibtypesym = 4;
       ibarraydef = 5;
       ibprocdef = 6;
       ibprocsym = 7;
       iblinkofile = 8;
       ibstringdef = 9;
       ibvarsym = 10;
       ibconstsym = 11;
       ibinitunit = 12;
       ibaufzaehlsym = 13;
       ibtypedconstsym = 14;
       ibrecorddef = 15;
       ibfiledef = 16;
       ibformaldef = 17;
       ibobjectdef = 18;
       ibaufzaehldef = 19;
       ibsetdef = 20;
       ibprocvardef = 21;
       ibsourcefile = 22;
       ibdbxcount = 23;
       ibfloatdef = 24;
       ibend = 255;

       { unit flags }
       uf_init = 1;
       uf_uses_dbx = 2;

  implementation

{****************************************************************************
                                  TFILE
 ****************************************************************************}

    constructor textfile.init(const p,n,e : string);

      begin
{$ifdef FPK}
         inherited init(p+n+e,65536);
{$else}
         inherited init(p+n+e,10000);
{$endif}
         path:=stringdup(p);
         name:=stringdup(n);
         ext:=stringdup(e);
      end;

    destructor textfile.done;

      begin
         inherited done;
      end;

{****************************************************************************
                                  TINPUTFILE
 ****************************************************************************}

    constructor tinputfile.init(const p,n,e : string);

      begin
         inherited init(p,n,e);
         filenotatend:=true;
         line_no:=1;
         next:=nil;
      end;

    procedure tinputfile.write_file_line(var t : text);

      begin
         write(t,name^,ext^,'(',line_no,')');
      end;

    function tinputfile.get_file_line : string;
    
      var temp : string;
      
      begin
        get_file_line:=name^+ext^+'('+tostr(line_no)+')' 
      end;
      
{****************************************************************************
                                TFILEMANAGER
 ****************************************************************************}

    constructor tfilemanager.init;

      begin
         files:=nil;
      end;

    destructor tfilemanager.done;

      var
         hp : pextfile;

      begin
         hp:=files;
         while assigned(hp) do
           begin
              files:=files^._next;
              dispose(hp,done);
              hp:=files;
           end;
      end;

    procedure tfilemanager.close_all;

      begin
      end;

    procedure tfilemanager.register_file(f : pextfile);

      begin
         f^._next:=files;
         files:=f;
      end;

{****************************************************************************
                                  TMODULE
 ****************************************************************************}

    constructor tmodule.init_program;

      begin
         name:=stringdup('');
         sourcefiles.init;
         used_units.init;
         ppufile:=nil;
         current_inputfile:=nil;
         in_implementation:=false;
         map:=nil;
         symtable:=nil;
         msource:=nil;
         flags:=0;
         compiled:=false;
      end;

{$I-}

    procedure tmodule.search_source(const n : string);

      var
         unit_path : string;
         found : boolean;

      begin
         ppufile:=nil;
         do_compile:=true;

         { search the PP file }
         unit_path:=search(n+target_info.sourceext,unitsearchpath,found);
         if found then
           begin
              { setup some stuff }
              msource:=stringdup(unit_path+n+target_info.sourceext);
           end
         else
           begin
{$ifdef LINUX}
              unit_path:=search(n+'.pas',unitsearchpath,found);
              if found then
                begin
                   { setup some stuff }
                   msource:=stringdup(unit_path+n+'.pas');
                end
              else
                begin
                unit_path:=search(lowercase(n)+target_info.sourceext,unitsearchpath,found);
                if found then
                  begin
                     { setup some stuff }
                     msource:=stringdup(unit_path+lowercase(n)+target_info.sourceext);
                  end
                else
                  begin
                  unit_path:=search(lowercase(n)+'.pas',unitsearchpath,found);
                  if found then
                    begin
                       { setup some stuff }
                       msource:=stringdup(unit_path+lowercase(n)+'.pas');
                    end
                  else
                     begin
                        sources_avail:=false;
                        msource:=nil;
                     end;
                  end;
                end;
           end;
{$else}
              unit_path:=search(n+'.PAS',unitsearchpath,found);
              if found then
                begin
                   { setup some stuff }
                   msource:=stringdup(unit_path+n+'.PAS');
                end
              else
                begin
                   sources_avail:=false;
                   msource:=nil;
                end;
           end;
{$endif}
      end;

    constructor tmodule.init_unit(const n : string);

      var
         found : boolean;
         unit_path,hs,temp : string;
         header : tunitheader;
         count : longint;
         b : byte;
         code : word;
         timestamp,source_time : longint;
         f : file;

      begin
         name:=stringdup(n);
         unitcount:=1;
         do_compile:=false;
         sources_avail:=true;
         current_inputfile:=nil;
         in_implementation:=false;
         compiled:=false;
         map:=nil;
         in_uses:=false;
         used_units.init;
         sourcefiles.init;
         symtable:=nil;
         flags:=0;
         { search the PPU file }
{$ifdef LINUX}
         unit_path:=search(lowercase(n)+target_info.unitext,unitsearchpath,found);
{$else}
         unit_path:=search(n+target_info.unitext,unitsearchpath,found);
{$endif LINUX}
         if found then
           begin
               comment(v_used,'Loading '+unit_path+n+target_info.unitext);
{$ifdef LINUX}
               ppufile:=new(pextfile,init(unit_path,lowercase(n),target_info.unitext));
{$else}
               ppufile:=new(pextfile,init(unit_path,n,target_info.unitext));
{$endif LINUX}
              ppufile^.reset;
              ppufile^.flush;
              { load the header }
              ppufile^.read_data(header,sizeof(header),count);

              if count<>sizeof(header) then
                begin
                   ppufile^.done;
                   if veryverbose then
                     writeln('PPU file to short : '+n+target_info.unitext);
                   search_source(n);
                   exit;
                end;

              { check for a valid PPU file }
              if (header[0]<>'P') or (header[1]<>'P') or (header[2]<>'U') then
                begin
                   ppufile^.done;
                   Comment(V_Debug,'Invalid PPU file no "PPU" at begin : '+n+target_info.unitext);
                   search_source(n);
                   exit;
                end;

              { load some informations }
              hs:=header[3]+header[4]+header[5];
              val(hs,ppuversion,code);
              if ppuversion<>12 then
                begin
                   ppufile^.done;
                   Comment (V_Debug,'Invalid version of PPU file not "12" at begin : '+n+target_info.unitext);
                   search_source(n);
                   exit;
                end;

              crc:=plongint(@header[10])^;
              flags:=byte(header[9]);
              str (flags,temp);
              Comment (V_Debug,'PPU flags = '+temp);

              ppufile^.read_data(b,1,count);

              timestamp:=ppufile^.getftime;
              if veryverbose then
                writeln(filetimestring(timestamp));
              { search source files               }
              { there is at least one source file }
              while b<>ibend do
                begin
                   ppufile^.read_data(hs[0],1,count);
                   ppufile^.read_data(hs[1],ord(hs[0]),count);

                   { check the date of the source files }
                   assign(f,unit_path+hs);
                   reset(f,1);

                   if ioresult<>0 then
                     begin
                        sources_avail:=false;
                        comment (V_Tried,'Source '+unit_path+hs+' not found');
                     end
                   else
                     begin
                        getftime(f,source_time);
                        close(f);
                        Comment (V_Tried,'Source '+unit_path+hs+'  time  '+filetimestring(source_time));
{ problem with getFTime }
                        if source_time>timestamp then
                          do_compile:=true;
                     end;

                   ppufile^.read_data(b,1,count);
                end;
              msource:=stringdup(ppufile^.path^+hs);
           end
         else
           begin
           Comment (V_tried,' PPU file not found : '+n+target_info.unitext);
           search_source(n);
           end;
      end;

    destructor tmodule.special_done;

      begin
         if assigned(map) then dispose(map);
         { cannot remove that because it is linked
         in the global chain of used_objects
         used_units.done; }
         sourcefiles.done;
         if assigned(ppufile) then
           begin
              dispose(ppufile,done);
           end;
         inherited done;
      end;

{****************************************************************************
                              TUSED_UNIT
 ****************************************************************************}


    constructor tused_unit.init(_u : pmodule;f : byte);

      begin
         u:=_u;
         in_interface:=false;
         unitid:=f;
      end;

    destructor tused_unit.done;

      begin
         inherited done;
      end;
{$I+}

end.
