{****************************************************************************

                      Copyright (c) 1996,97 by Florian Klaempfl

 ****************************************************************************}

{
  This unit implements an asmoutput class for AT&T syntax with
  Intel i386+.

  History:
      30th september 1996:
         + unit started
      15th october 1996:
         + ti386attasmoutput class started
      28th november 1996:
         ! debugging for simple programs
      26th february 1997:
         + op2str array completed with work of Daniel Manitone

  What's to do:
    o write lines numbers and file names to output file
    o generate debugging informations
    o omit problem of some GNU ASes with pushw $1243
}
unit attasmi3;

  interface

    uses
       dos,globals,systems,errors,cobjects,aasm,i386,strings,files
{$ifdef GDB}
       ,gdb
{$endif GDB}
       ;

    const
       firstop = A_MOV;
       lastop = A_FADDS;

       op2str : array[firstop..lastop] of string[7] =
         ('mov','movz','movs','','add',
          'call','idiv','imul','jmp','lea','mul','neg','not',
          'pop','popal','push','pushal','ret','sub','xchg','xor',
          'fild','cmp','jz','inc','dec','sete','setne','setl',
          'setg','setle','setge','je','jne','jl','jg','jle','jge',
          'or','fld','fadd','fmul','fsub','fdiv','fchs','fld1',
          'fidiv','cltd','jnz','fstp','and','jno','','',
          'enter','leave','cld','movs','rep','shl','shr','bound',
          'jns','js','jo','sar','test',
          'fcom','fcomp','fcompp','fxch','faddp','fmulp','fsubp','fdivp',
          'fnsts','sahf','fdivrp','fsubrp','setc','setnc','jc','jnc',
          'ja','jae','jb','jbe','seta','setae','setb','setbe',
          'aaa','aad','aam','aas','cbw','cdq','clc','cli',
          'clts','cmc','cwd','cwde','daa','das','hlt','iret','lahf',
          'lods','lock','nop','pusha','pushf','pushfd',
          'stc','std','sti','stos','wait','xlat','xlatb','movsb',
          'movsbl','movsbw','movswl','movsb','movzwl','popa','in',
          'out','lds','lcs','les','lfs','lgs','lss','popf','sbb','adc',
          'div','ror','rol','rcl','rcr','sal','shld','shrd',
          'lcall','ljmp','lret','jnae','jnb','jna','jnbe','jb','jnp',
          'jpe','jpo','jnge','jng','jnl','jnle','jcxz','jecxz',
          'loop','cmps','ins','outs','scas','bsf','bsr','bt','btc',
          'btr','bts','int','int3','into','boundl','boundw',
          'loopz','loope','loopnz','loopne','seto','setno','setnae',
	  'setnb','setz','setnz','setna','setnbe','sets','setns','setp',
	  'setpe','setnp','setpo','setnge','setnl','setng','setnle',
	  'arpl','lar','lgdt','lidt','lldt','lmsw','lsl','ltr','sgdt',
	  'sidt','sldt','smsw','str','verr','verw','fabs','fbld','fbstp',
	  'fclex','fnclex','fcos','fdecstp','fdisi','fndisi','fdivr',
	  'feni','fneni','ffree','fiadd','ficom','ficomp','fidivr',
	  'fimul','fincstp','finit','fninit','fist','fistp','fisub',
	  'fisubr','fldcw','fldenv','fldlg2','fldln2','fldl2e','fldl2t',
	  'fldpi','flds','fldz','fnop','fpatan','fprem','fprem1','fptan',
	  'frndint','frstor','fsave','fnsave','fscale','fsetpm','fsin',
	  'fsincos','fsqrt','fst','fstcw','fnstcw','fstenv','fnstenv',
	  'fstsw','fnstsw','ftst','fucom','fucomp','fucompp','fwait',
	  'fxam','fxtract','fyl2x','fyl2xp1','f2xm1','fildq','filds',
	  'fildl','fldl','fldt','fistq','fists','fistl','fstl','fsts',
	  'fstps','fistpl','fstpl','fistps','fistpq','fstpt','fcomps',
	  'ficompl','fcompl','ficomps','fcoms','ficoml','fcoml','ficoms',
	  'fiaddl','faddl','fiadds','fisubl','fsubl','fisubs','fsubs',
	  'fsubr','fsubrs','fisubrl','fsubrl','fisubrs','fmuls','fimull',
	  'fmull','fimuls','fdivs','fidivl','fdivl','fidivs','fdivrs',
	  'fidivrl','fdivrl','fidivrs','repe','repne','fadds');

       opsize2str : array[topsize] of string[2] = ('','b','w','l','bw',
          'bl','wl','q','s');

       _reg2str : array[R_NO..R_ST7] of string[6] =
         ('','%eax','%ecx','%edx','%ebx','%esp','%ebp','%esi','%edi',
          '%ax','%cx','%dx','%bx','%sp','%bp','%si','%di',
          '%al','%cl','%dl','%bl','%ah','%ch','%bh','%dh',
          '','%cs','%ds','%es','%fs','%gs','%ss',
          '%st','%st(0)','%st(1)','%st(2)','%st(3)','%st(4)',
          '%st(5)','%st(6)','%st(7)');

    type
       pi386attasmoutput = ^ti386attasmoutput;

       ti386attasmoutput = object(taasmoutput)
          procedure write_to_file(outfile : pbufferedfile);virtual;
       end;

    { inits the datasegment etc with the output specific list types }
    procedure asmoutlists_init;

    { writes the asmlists to an output file }
    procedure writeasmlists(outfile : pbufferedfile);

  implementation

    var
       infile : pextfile;
       includecount,lastline : longint;

    function getreferencestring(const ref : treference) : string;

      var
         s : string;

      begin
         if ref.isintvalue then
           s:='$'+tostr(ref.offset)
         else
{$ifdef ver0_6}
            begin
               { do we have a segment prefix ? }
               if ref.segment<>R_DEFAULT_SEG then
                 s:=_reg2str[ref.segment]+':'
               else s:='';

               if assigned(ref.symbol) then
                 s:=s+ref.symbol^;
               if ref.offset<0 then s:=s+tostr(ref.offset)
                 else if (ref.offset>0) then
                   begin
                      if (ref.symbol=nil) then s:=tostr(ref.offset)
                      else s:=s+'+'+tostr(ref.offset);
                   end;
               if (ref.index<>R_NO) and (ref.base=R_NO) then
                 s:=s+'(,'+_reg2str[ref.index]+','+tostr(ref.scalefactor)+')'
               else if (ref.index=R_NO) and (ref.base<>R_NO) then
                 s:=s+'('+_reg2str[ref.base]+')'
               else if (ref.index<>R_NO) and (ref.base<>R_NO) then
                 s:=s+'('+_reg2str[ref.base]+','
                  +_reg2str[ref.index]+','+tostr(ref.scalefactor)+')';
            end;
{$else}             
           with ref do
             begin
                { have we a segment prefix ? }
                if segment<>R_DEFAULT_SEG then
                  s:=_reg2str[segment]+':'
                else s:='';

                if assigned(symbol) then
                  s:=s+symbol^;

                if offset<0 then s:=s+tostr(offset)
                  else if (offset>0) then
                    begin
                       if (symbol=nil) then s:=tostr(offset)
                       else s:=s+'+'+tostr(offset);
                    end;
                if (index<>R_NO) and (base=R_NO) then
                  s:=s+'(,'+_reg2str[index]+','+tostr(scalefactor)+')'
                else if (index=R_NO) and (base<>R_NO) then
                  s:=s+'('+_reg2str[base]+')'
                else if (index<>R_NO) and (base<>R_NO) then
                  s:=s+'('+_reg2str[base]+','
                    +_reg2str[index]+','+tostr(scalefactor)+')';
             end;
{$endif}             
         getreferencestring:=s;
      end;

    function getopstr(t : byte;o : pointer) : string;

      var
         hs : string;

      begin
         case t of
            top_reg : getopstr:=_reg2str[tregister(o)];
            top_ref : getopstr:=getreferencestring(preference(o)^);
            top_const : getopstr:='$'+tostr(longint(o));
            top_symbol : begin
                            hs[0]:=chr(strlen(pchar(pcsymbol(o)^.symbol)));
                            move(pchar(pcsymbol(o)^.symbol)^,hs[1],byte(hs[0]));
                            hs:='$'+hs;
                            if pcsymbol(o)^.offset>0 then
                              hs:=hs+'+'+tostr(pcsymbol(o)^.offset)
                            else if pcsymbol(o)^.offset<0 then
                              hs:=hs+tostr(pcsymbol(o)^.offset);
                            getopstr:=hs;
                         end;
            else internalerror(10001);
         end;
      end;

    function getopstr_jmp(t : byte;o : pointer) : string;

      var
         hs : string;

      begin
         case t of
            top_reg : getopstr_jmp:=_reg2str[tregister(o)];
            top_ref : getopstr_jmp:='*'+getreferencestring(preference(o)^);
            top_const : getopstr_jmp:=tostr(longint(o));
            top_symbol : begin
                            hs[0]:=chr(strlen(pchar(pcsymbol(o)^.symbol)));
                            move(pchar(pcsymbol(o)^.symbol)^,hs[1],byte(hs[0]));
                            if pcsymbol(o)^.offset>0 then
                              hs:=hs+'+'+tostr(pcsymbol(o)^.offset)
                            else if pcsymbol(o)^.offset<0 then
                              hs:=hs+tostr(pcsymbol(o)^.offset);
                            getopstr_jmp:=hs;
                         end;
            else internalerror(10001);
         end;
      end;

    function ibm2ascii(const s : string) : string;

      var
         i : integer;
         hs : string;
         b : byte;

      begin
         hs:='';
         for i:=1 to length(s) do
           if ((ord(s[i])>127) or (ord(s[i])<32)) or (s[i]='"') then
             begin
                b:=ord(s[i]);
                hs:=hs+'\'+tostr(b div 64);
                b:=b mod 64;
                hs:=hs+tostr(b div 8);
                b:=b mod 8;
                hs:=hs+tostr(b);
                if (i<length(s)) and
                  (ord(s[i+1])>=48) and  (ord(s[i+1])<=57) then
                  hs:=hs+'","';
             end
           else if s[i]='\' then
             hs:=hs+'\\'
           else hs:=hs+s[i];
         ibm2ascii:=hs;
      end;

{****************************************************************************
                             TI386ATTASMOUTPUT
 ****************************************************************************}


    var
       { different types of source lines }
       n_line : byte;

    procedure ti386attasmoutput.write_to_file(outfile : pbufferedfile);

      var
         hp : pai;
         s : string;
         pos,l : longint;
{$ifdef GDB}
         funcname : pchar;
         linecount : longint;
{$endif GDB}

      begin
{$ifdef GDB}
         funcname:=nil;
         linecount:=1;
{$endif GDB}
         hp:=pai(first);
         while assigned(hp) do
           begin
              { write debugger informations }
              if cs_debuginfo in aktswitches then
                begin
{$ifdef GDB}
                if not (hp^.typ in  [ait_external,ait_stabn,ait_stabs,
                                  ait_stab_function_name]) then
                   begin
                      if assigned(hp^.infile) and (pextfile(hp^.infile)<>infile)  then
                        begin
                           infile:=hp^.infile;
                           inc(includecount);
                            if (hp^.infile^.path^<>'') then
                              begin
                                 outfile^.write_string(target_info.newline+#9'.stabs "'
                                   +globals.lowercase(BsToSlash(hp^.infile^.path^))+'",');
                                 outfile^.write_string(tostr(n_includefile)+',0,0,Ltext'+ToStr(IncludeCount));
                              end;
                            outfile^.write_string(target_info.newline+#9'.stabs "'+globals.lowercase(hp^.infile^.name^
                                                  +hp^.infile^.ext^)+'",');
                            outfile^.write_string(tostr(n_includefile)+',0,0,Ltext'+ToStr(IncludeCount));
                            outfile^.write_string(target_info.newline+'Ltext'+Tostr(IncludeCount)+':'+target_info.newline);
                         end;
                       { file name must be there before line number ! }
                      if (hp^.line<>lastline) and (hp^.line<>0) then
                         begin
                            if (n_line = n_textline) and assigned(funcname) and
                               (target_info.use_function_relative_addresses) then
                              begin
                              outfile^.write_string(target_info.labelprefix+'l'+tostr(linecount)+':'+target_info.newline);
                              outfile^.write_string(#9'.stabn'#9+tostr(n_line)+',0,'
                                   +tostr(hp^.line)+','+target_info.labelprefix+'l'+tostr(linecount)+' - ');
                              inc(linecount);
                              outfile^.write_pchar(funcname);
                              outfile^.write_string(target_info.newline);
                              end else
                              outfile^.write_string(#9'.stabd'#9+tostr(n_line)+',0,'+tostr(hp^.line)+target_info.newline);
                            lastline:=hp^.line;
                            { for simple debuggers }
                            {outfile^.write_string(#9'.ln '+tostr(lastline)+target_info.newline);}
                         end;
                      end;
{$endif GDB}
                end;
              case hp^.typ of
                 { external is ignored }
                 ait_external : ;

                 ait_datablock : begin
                                    if pai_datablock(hp)^.is_global then
                                      outfile^.write_string(#9'.comm'#9)
                                    else
                                      outfile^.write_string(#9'.lcomm'#9);
                                    outfile^.write_pchar(pai_datablock(hp)^.name);
                                    outfile^.write_string(','+tostr(pai_datablock(hp)^.size));
                                 end;
                 ait_const_32bit : outfile^.write_string(#9'.long'#9+tostr(pai_const(hp)^.value));
                 ait_const_16bit : outfile^.write_string(#9'.short'#9+tostr(pai_const(hp)^.value));
                 ait_const_8bit : outfile^.write_string(#9'.byte'#9+tostr(pai_const(hp)^.value));
                 ait_const_symbol : begin
                                       outfile^.write_string(#9'.long'#9);
                                       outfile^.write_pchar(pchar(pai_const(hp)^.value));
                                    end;
                 ait_real_64bit : outfile^.write_string(#9'.double'#9+double2str(pai_double(hp)^.value));
                 ait_direct : begin
                                 outfile^.write_pchar(pai_direct(hp)^.str);
{$IfDef GDB}
                                 if strpos(pai_direct(hp)^.str,'.data')<>nil then
                                   n_line:=n_dataline
                                 else if strpos(pai_direct(hp)^.str,'.text')<>nil then
                                   n_line:=n_textline
                                 else if strpos(pai_direct(hp)^.str,'.bss')<>nil then
                                   n_line := n_bssline;
{$endif GDB}
                              end;
                 ait_string : begin
                                 l:=pai_string(hp)^.len;
                                 pos:=0;
                                 while l>32 do
                                   begin
                                      move(pai_string(hp)^.str[pos],s[1],32);
                                      s[0]:=#32;
                                      outfile^.write_string(#9'.ascii'#9'"'+ibm2ascii(s)+'"');
                                      outfile^.write_string(target_info.newline);
                                      dec(l,32);
                                      inc(pos,32);
                                   end;
                                 if l>0 then
                                   begin
                                      move(pai_string(hp)^.str[pos],s[1],l);
                                      s[0]:=chr(l);
                                      outfile^.write_string(#9'.ascii'#9'"'+ibm2ascii(s)+'"');
                                   end;
                              end;
                 ait_label : outfile^.write_string(lab2str(pai_label(hp)^.l)+':');
                 ait_labeled_instruction : outfile^.write_string(#9+op2str[pai_labeled386(hp)^._operator]+#9+
                                             lab2str(pai_labeled386(hp)^.lab));
                 { we ignore comments because some GNU AS can't handle this }
                 ait_comment : ;
                 ait_symbol : begin
                                 if pai_symbol(hp)^.is_global then
                                   begin
                                      outfile^.write_string('.globl ');
                                      outfile^.write_pchar(pai_symbol(hp)^.name);
                                      outfile^.write_string(target_info.newline);
                                   end;
                                 outfile^.write_pchar(pai_symbol(hp)^.name);
                                 outfile^.write_string(':');
                              end;
                 { writes an instruction, highly table driven }
                 ait_instruction : begin
                                      if (pai386(hp)^._operator=A_PUSH) and
                                         (pai386(hp)^.size=S_W) and
                                         (pai386(hp)^.op1t=top_const) then
                                        begin
                                           outfile^.write_string(#9'.byte 0x66,0x68');
                                           outfile^.write_string(target_info.newline);
                                           outfile^.write_string(#9'.word '+tostr(longint(pai386(hp)^.op1)));
                                        end
                                      else
                                        begin
                                           s:=#9+op2str[pai386(hp)^._operator]+opsize2str[pai386(hp)^.size];
                                           if pai386(hp)^.op1t<>top_none then
                                             begin
                                                { call and jmp need an extra handling                          }
                                                { this code is only callded if jmp isn't a labeled instruction }
                                                if pai386(hp)^._operator in [A_CALL,A_JMP] then
                                                  begin
                                                     s:=s+#9+getopstr_jmp(pai386(hp)^.op1t,pai386(hp)^.op1);
                                                  end
                                                else
                                                  begin
                                                     s:=s+#9+getopstr(pai386(hp)^.op1t,pai386(hp)^.op1);
                                                     if pai386(hp)^.op2t<>top_none then
                                                       begin
                                                          s:=s+','+getopstr(pai386(hp)^.op2t,pai386(hp)^.op2);
                                                          if pai386(hp)^.op3t<>top_none then
                                                            begin
                                                               s:=s+','+getopstr(pai386(hp)^.op3t,pai386(hp)^.op3);
                                                            end;
                                                       end;
                                                  end;
                                             end;
                                           outfile^.write_string(s);
                                        end;
                                   end;
{$ifdef GDB}
		 ait_stabs : begin
                                outfile^.write_string(#9'.stabs ');
                                outfile^.write_pchar(pai_stabs(hp)^.str);
                             end;
		 ait_stabn : begin
                                outfile^.write_string(#9'.stabn ');
                                outfile^.write_pchar(pai_stabn(hp)^.str);
                             end;
                 ait_stab_function_name : funcname := pai_stab_function_name(hp)^.str;
{$endif GDB}
                 else internalerror(10000);
              end;
              { omit extra new lines }
              if hp^.typ<>ait_external then
                outfile^.write_string(target_info.newline);
              hp:=pai(hp^.next);
           end;
      end;

    procedure write_source_filename(outfile : pbufferedfile);

      var
         p : dirstr;
         n : namestr;
         e : extstr;

      begin
{$ifdef GDB}
         if assigned(current_module^.msource) then
           begin
              fsplit(current_module^.msource^,p,n,e);
              if (p<>'') then
                begin
                   outfile^.write_string(target_info.newline+#9'.stabs "'+globals.lowercase(BsToSlash(p))+'",');
                   outfile^.write_string(tostr(n_sourcefile)+',0,0,Ltext0');
                end;
              outfile^.write_string(target_info.newline+#9'.stabs "'+globals.lowercase(n+e)+'",');
           end
         else
           begin
              if (inputdir<>'') then
                begin
                   outfile^.write_string(target_info.newline+#9'.stabs "'+globals.lowercase(BsToSlash(inputdir))+'",');
                   outfile^.write_string(tostr(n_sourcefile)+',0,0,Ltext0');
                end;
              outfile^.write_string(target_info.newline+#9'.stabs "'+globals.lowercase(inputfile
                +inputextension)+'",');
           end;
         outfile^.write_string(tostr(n_sourcefile)+',0,0,Ltext0');
         outfile^.write_string(target_info.newline+'Ltext0:'+target_info.newline);
         infile:=current_module^.sourcefiles.files;

         { to get symify to work }
         if assigned(current_module^.msource) then
           outfile^.write_string(#9'.file "'+globals.lowercase(n+e)+'"'+target_info.newline)
         else
           outfile^.write_string(#9'.file "'+globals.lowercase(inputfile+inputextension)+'"'+target_info.newline);
{$endif GDB}
         { main source file is last in list }
         while assigned(infile^._next) do
           infile:=infile^._next;
      end;

    procedure asmoutlists_init;

      begin
         datasegment:=new(pi386attasmoutput,init);
         codesegment:=new(pi386attasmoutput,init);
         bsssegment:=new(pi386attasmoutput,init);
         debuglist:=new(pi386attasmoutput,init);
         externals:=new(pi386attasmoutput,init);
         consts:=new(pi386attasmoutput,init);
      end;

    procedure writeasmlists(outfile : pbufferedfile);

      begin
{$ifdef EXTDEBUG}
         writeln('Start writing att-styled assembler output');
{$endif}
         infile:=nil;
         includecount:=0;
{$ifdef GDB}
         n_line:=n_bssline;
{$endif GDB}
         write_source_filename(outfile);
         lastline:=0;
         externals^.write_to_file(outfile);
         debuglist^.write_to_file(outfile);
         outfile^.write_string('.text');
         outfile^.write_string(target_info.newline);
         outfile^.write_string(#9'.align 4');
         outfile^.write_string(target_info.newline);
{$ifdef GDB}
         n_line:=n_textline;
{$endif GDB}
         codesegment^.write_to_file(outfile);

         outfile^.write_string('.data');
         outfile^.write_string(target_info.newline);
         outfile^.write_string(#9'.align 4');
         outfile^.write_string(target_info.newline);

         { some AS versions don't like comments, so we write }
         { an ascii string                                    }
         outfile^.write_string(#9'.ascii "compiled by FPKPascal '+version_string+'\0"');
         outfile^.write_string(target_info.newline);
         outfile^.write_string(#9'.ascii "target: '+target_info.target_name+'\0"');
         outfile^.write_string(target_info.newline);

         outfile^.write_string(#9'.align 4');
         outfile^.write_string(target_info.newline);
{$ifdef GDB}
         n_line:=n_dataline;
{$endif GDB}
         datasegment^.write_to_file(outfile);
         consts^.write_to_file(outfile);

         { makes problems with old GNU ASes
         outfile^.write_string('.bss');
         outfile^.write_string(target_info.newline);
         outfile^.write_string(#9'.align 4');
         }
         outfile^.write_string(target_info.newline);
{$ifdef GDB}
         n_line:=n_bssline;
{$endif GDB}
         bsssegment^.write_to_file(outfile);
{$ifdef EXTDEBUG}
         writeln('Ready with writing output');
{$endif}
      end;

end.
