{****************************************************************************

                      Copyright (c) 1996,97 by Florian Klaempfl

 ****************************************************************************}

{
  this unit implements an abstract asmoutput class for all processor types

  History:
      30th september 1996:
         + unit started
}
unit aasm;

  interface

    uses
       globals,strings,cobjects,errors,files;

    type
       tait = (
          ait_string,
          ait_label,
          ait_direct,
          ait_labeled_instruction,
          ait_comment,
          ait_instruction,
          ait_datablock,
          ait_symbol,
          ait_const_32bit,
          ait_const_symbol,
          ait_const_16bit,
          ait_const_8bit,
          ait_real_64bit,
          ait_external,
          { the following must is system depended }
{$ifdef I386}
{$endif}
{$ifdef M68K}
{$endif M68K}
{$ifdef GDB}
          ait_stabn,
          ait_stabs,
          ait_stab_function_name,
{$endif GDB}
          { never used, makes insertation of new ait_ easier to type }
          ait_dummy);

       { type for a temporary label }
       tlabel = longint;

       { the short name makes typing easier }
       pai = ^tai;

       tai = object(tlinkedlist_item)
          typ : tait;
          line : longint;
          infile : pinputfile;
          constructor init;
       end;

       pai_string = ^tai_string;

       tai_string = object(tai)
          str : pchar;
          { extra len so the string can contain an \0 }
          len : longint;
          constructor init(const _str : string);
          constructor init_pchar(_str : pchar);
          destructor done;virtual;
       end;

       pai_symbol = ^tai_symbol;

       { generates a common label }
       tai_symbol = object(tai)
          name : pchar;
          is_global : boolean;
          constructor init(const _name : string);
          constructor init_global(const _name : string);
          destructor done;virtual;
       end;

       pai_external = ^tai_external;

       { generates an symbol which is marked as external }
       tai_external = object(tai)
          name : pchar;
          constructor init(const _name : string);
          destructor done; virtual;
       end;

       { simple temporary label }
       pai_label = ^tai_label;

       tai_label = object(tai)
          l : tlabel;
          constructor init(_l : tlabel);
       end;

       pai_direct = ^tai_direct;
       tai_direct = object(tai)
          str : pchar;
          constructor init(_str : pchar);
          destructor done; virtual;
       end;

       pai_datablock = ^tai_datablock;

       { generates an uninitilizised data block }
       tai_datablock = object(tai)
          size : longint;
          name : pchar;
          is_global : boolean;
          constructor init(const _name : string;_size : longint);
          constructor init_global(const _name : string;_size : longint);
          destructor done; virtual;
       end;

       pai_const = ^tai_const;

       { generates a long integer (32 bit) }
       tai_const = object(tai)
          value : longint;
          constructor init_32bit(_value : longint);
          constructor init_16bit(_value : word);
          constructor init_8bit(_value : byte);
          constructor init_symbol(p : pchar);
          destructor done;virtual;
       end;

       pai_double = ^tai_double;

       { generates a double (64 bit real) }
       tai_double = object(tai)
          value : double;
          constructor init(_value : double);
       end;

       paasmoutput = ^taasmoutput;

       taasmoutput = object(tlinkedlist)
          procedure write_to_file(outfile : pbufferedfile);virtual;
       end;

    var
       { self explaining }
       { must initilizied anywhere }
       datasegment,codesegment,bsssegment : paasmoutput;
       debuglist,externals,consts : paasmoutput;

  implementation

{****************************************************************************
                             TAI
 ****************************************************************************}

    constructor tai.init;

      begin
{$ifdef GDB}
         infile:=pointer(current_module^.current_inputfile);
         if assigned(infile) then
           line:=current_module^.current_inputfile^.line_no;
{$endif GDB}
      end;

{****************************************************************************
                             TAI_DATABLOCK
 ****************************************************************************}

    constructor tai_datablock.init(const _name : string;_size : longint);

      begin
         inherited init;
         typ:=ait_datablock;
         name:=strpnew(_name);
         size:=_size;
         is_global:=false;
      end;

    constructor tai_datablock.init_global(const _name : string;_size : longint);

      begin
         inherited init;
         typ:=ait_datablock;
         name:=strpnew(_name);
         size:=_size;
         is_global:=true;
      end;

    destructor tai_datablock.done;

      begin
         strdispose(name);
         inherited done;
      end;

{****************************************************************************
                               TAI_SYMBOL
 ****************************************************************************}

    constructor tai_symbol.init(const _name : string);

      begin
         inherited init;
         typ:=ait_symbol;
         name:=strpnew(_name);
         is_global:=false;
      end;

    constructor tai_symbol.init_global(const _name : string);

      begin
         inherited init;
         typ:=ait_symbol;
         name:=strpnew(_name);
         is_global:=true;
      end;

    destructor tai_symbol.done;

      begin
         strdispose(name);
         inherited done;
      end;

{****************************************************************************
                               TAI_EXTERNAL
 ****************************************************************************}

    constructor tai_external.init(const _name : string);

      begin
         inherited init;
         typ:=ait_external;
         name:=strpnew(_name);
      end;

    destructor tai_external.done;

      begin
         strdispose(name);
         inherited done;
      end;

{****************************************************************************
                               TAI_CONST
 ****************************************************************************}

    constructor tai_const.init_32bit(_value : longint);

      begin
         inherited init;
         typ:=ait_const_32bit;
         value:=_value;
      end;

    constructor tai_const.init_16bit(_value : word);

      begin
         inherited init;
         typ:=ait_const_16bit;
         value:=_value;
      end;

    constructor tai_const.init_8bit(_value : byte);

      begin
         inherited init;
         typ:=ait_const_8bit;
         value:=_value;
      end;

    constructor tai_const.init_symbol(p : pchar);

      begin
         inherited init;
         typ:=ait_const_symbol;
         value:=longint(p);
      end;

    destructor tai_const.done;

      begin
         if typ=ait_const_symbol then
           strdispose(pchar(value));
         inherited done;
      end;

{****************************************************************************
                               TAI_DOUBLE
 ****************************************************************************}

    constructor tai_double.init(_value : double);

      begin
         inherited init;
         typ:=ait_real_64bit;
         value:=_value;
      end;

{****************************************************************************
                               TAI_STRING
 ****************************************************************************}

     constructor tai_string.init(const _str : string);

       begin
          inherited init;
          typ:=ait_string;
          getmem(str,length(_str)+1);
          strpcopy(str,_str);
          len:=length(_str);
       end;

     constructor tai_string.init_pchar(_str : pchar);

       var
          l : longint;

       begin
          inherited init;
          typ:=ait_string;
          str:=_str;
          len:=strlen(_str);
       end;

    destructor tai_string.done;

      begin
         strdispose(str);
         inherited done;
      end;

     constructor tai_label.init(_l : tlabel);

       begin
          inherited init;
          typ:=ait_label;
          l:=_l;
       end;

{****************************************************************************
                              TAASMOUTPUT
 ****************************************************************************}

     constructor tai_direct.init(_str : pchar);

       begin
          inherited init;
          typ:=ait_direct;
          str:=_str;
       end;

    destructor tai_direct.done;

      begin
         strdispose(str);
         inherited done;
      end;

{****************************************************************************
                              TAASMOUTPUT
 ****************************************************************************}

    procedure taasmoutput.write_to_file(outfile : pbufferedfile);

      begin
      end;

end.
