program testgraf;

uses crt,graph,watch,hex;

const
  { The ten fonts available }
  Fonts : array[0..10] of string[17] =
  ('DefaultFont', 'TriplexFont', 'SmallFont', 'SansSerifFont', 'GothicFont',
   'ScriptFont', 'SimplexFont', 'TriplexScriptFont', 'ComplexFont', 
   'EuropeanFont', 'BoldFont');

  { The five predefined line styles supported }
  LineStyles : array[0..4] of string[9] =
  ('SolidLn', 'DottedLn', 'CenterLn', 'DashedLn', 'UserBitLn');

  { The twelve predefined fill styles supported }
  FillStyles : array[0..11] of string[14] =
  ('EmptyFill', 'SolidFill', 'LineFill', 'LtSlashFill', 'SlashFill',
   'BkSlashFill', 'LtBkSlashFill', 'HatchFill', 'XHatchFill',
   'InterleaveFill', 'WideDotFill', 'CloseDotFill');

  { The two text directions available }
  TextDirect : array[0..1] of string[8] = ('HorizDir', 'VertDir');

  { The Horizontal text justifications available }
  HorizJust  : array[0..2] of string[10] = ('LeftText', 'CenterText', 'RightText');

  { The vertical text justifications available }
  VertJust   : array[0..2] of string[10] = ('BottomText', 'CenterText', 'TopText');

var maxx,maxy : longint;
    i,j,gd,gm : integer;
    Filename,
    Header    : String;
    PRF       : Text;
    MaxColors : Longint;
{$IFDEF TURBO}
{$I STDCOLOR.PPI}
{$ENDIF}

procedure Dummy;begin end;

function Int2Str(value:LongInt):String;
var s:string;
begin
 str(value,s);
 int2str:=s;
end; 

procedure WaitToGo;
begin
readkey;
end;

procedure SetStandartColor(Nr:Integer);
begin
  nr:=nr and $ff;
  if MaxColors>256 then SetColor(stdcolors[nr]) else SetColor(nr);
end;

procedure SetStandartFillStyle(a:word;b:longint);
begin
  b:=b and $FF;
  if MaxColors>256 then SetFillStyle(a,stdcolors[b]) else SetFillStyle(a,b);
end;

procedure SetStandartFillPattern(a:FillPatternType;b:longint);
begin
  b:=b and $ff;
  if MaxColors>256 then SetFillPattern(a,stdcolors[b]) else SetFillPattern(a,b);
end;

procedure DefaultColors;
{ Select the maximum color in the Palette for the drawing color }
begin
  SetColor(MaxColors);
end; { DefaultColors }

procedure DrawBorder;
{ Draw a border around the current view port }
var
  ViewPort : ViewPortType;
begin
  SetStandartColor(white);
  SetLineStyle(SolidLn, 0, NormWidth);
  GetViewSettings(ViewPort);
  Rectangle(0, 0, viewport.x2-viewport.x1, viewport.y2-viewport.y1);
end; { DrawBorder }

procedure FullPort;
{ Set the view port to the entire screen }
begin
  SetViewPort(0, 0, MaxX, MaxY, ClipOn);
end; { FullPort }

procedure MainWindow(Header : string);
{ Make a default window and view port for demos }
begin
  SetStandartColor(White);
  ClearDevice;                             { Clear the screen }
  SetTextStyle(DefaultFont, HorizDir, 1);  { Default text font }
  SetTextJustify(CenterText, TopText);     { Left justify text }
  FullPort;                                { Full screen view port }
  DrawBorder;
  OutTextXY(MaxX div 2, 2, Header);        { Draw the header }
  SetViewPort(0, TextHeight('M')+4, MaxX, MaxY-(TextHeight('M')+4), ClipOn);
  DrawBorder;                              { Put a border around it }
  SetViewPort(1, TextHeight('M')+5, MaxX-1, MaxY-(TextHeight('M')+5), ClipOn);
end; { MainWindow }

procedure ReportStatus;
{ Display the status of all query functions after InitGraph }
const
  X = 10;
var
  ViewInfo   : ViewPortType;     { Parameters for inquiry procedures }
  LineInfo   : LineSettingsType;
  FillInfo   : FillSettingsType;
  TextInfo   : TextSettingsType;
  Palette    : PaletteType;
  DriverStr  : string;           { Driver and mode strings }
  ModeStr    : string;
  Y          : word;

procedure WriteOut(S : string);
{ Write out a string and increment to next line }
begin
  OutTextXY(X, Y, S);
  Inc(Y, TextHeight('M')+2);
end; { WriteOut }

begin { ReportStatus }
  Driverstr:=GetDriverName;
  ModeStr:=GetModeName(GetGraphMode);
  GetViewSettings(ViewInfo);
  GetLineSettings(LineInfo);
  GetFillSettings(FillInfo);
  GetTextSettings(TextInfo);
  GetPalette(Palette); 
  Y := 4;
  MainWindow('Status report after InitGraph');
  SetTextJustify(LeftText, TopText);
  WriteOut('Graphics device    : '+DriverStr);
  WriteOut('Graphics mode      : '+ModeStr);
  WriteOut('Screen resolution  : (0, 0, '+Int2Str(GetMaxX)+', '+Int2Str(GetMaxY)+')');
    WriteOut('Current view port  : ('+Int2Str(viewinfo.x1)+', '+Int2Str(viewinfo.y1)+', '
                                     +Int2Str(viewinfo.x2)+', '+Int2Str(viewinfo.y2)+')');
    if Viewinfo.Clip then
      WriteOut('Clipping           : ON')
    else
      WriteOut('Clipping           : OFF');
  WriteOut('Current position   : ('+Int2Str(GetX)+', '+Int2Str(GetY)+')');
  WriteOut('Palette entries    : '+Int2Str(Palette.Size)); 
  WriteOut('GetMaxColor        : '+Int2Str(GetMaxColor));
  WriteOut('Current color      : '+HexStr(GetColor,8));
  WriteOut('Line style         : '+LineStyles[Lineinfo.LineStyle]);
  WriteOut('Line thickness     : '+Int2Str(LineInfo.Thickness));
  WriteOut('Current fill style : '+FillStyles[FillInfo.Pattern]);
  WriteOut('Current fill color : '+Int2Str(FillInfo.Color));
  WriteOut('Current font       : '+Fonts[TextInfo.Font]);
  WriteOut('Text direction     : '+TextDirect[TextInfo.Direction]);
  WriteOut('Character size     : '+Int2Str(TextInfo.CharSize));
  WriteOut('Horizontal justify : '+HorizJust[TextInfo.Horiz]);
  WriteOut('Vertical justify   : '+VertJust[TextInfo.Vert]);
  WaitToGo;
end; { ReportStatus }

procedure AspectRatioPlay;
{ Demonstrate  SetAspectRatio command }
var
  ViewInfo   : ViewPortType;
  CenterX    : integer;
  CenterY    : integer;
  Radius     : word;
  Xasp, Yasp : word;
  i          : integer;
  RadiusStep : word;
begin
  MainWindow('SetAspectRatio demonstration');
  GetViewSettings(ViewInfo);
    CenterX := (ViewInfo.x2-ViewInfo.x1) div 2;
    CenterY := (ViewInfo.y2-ViewInfo.y1) div 2;
    Radius := 3*((ViewInfo.y2-ViewInfo.y1) div 5);
  RadiusStep := (Radius div 30);
  Circle(CenterX, CenterY, Radius);
  GetAspectRatio(Xasp, Yasp);
  SetFillstyle(0,0);
  SetTextJustify(lefttext,toptext);
  for i := 1 to 30 do
  begin
    SetAspectRatio(Xasp, Yasp+(I*MaxX));    { Increase Y aspect factor }
    Circle(CenterX, CenterY, Radius);
    Radius:=Radius-RadiusStep;              { Shrink radius }
  end;
  Radius:=Radius+RadiusStep*30;
  for i := 1 to 30 do
  begin
    SetAspectRatio(Xasp+(I*MaxX), Yasp);    { Increase X aspect factor }
    if Radius > RadiusStep then
      Radius:=Radius-RadiusStep;            { Shrink radius }
    Circle(CenterX, CenterY, Radius);
  end;
  SetAspectRatio(Xasp, Yasp);                { back to original aspect }
  WaitToGo;
end; { AspectRatioPlay }

procedure LineToPlay;
{ Demonstrate MoveTo and LineTo commands }
const
  MaxPoints = 15;
var
  Points     : array[0..MaxPoints] of PointType;
  ViewInfo   : ViewPortType;
  I, J       : integer;
  CenterX    : integer;   { The center point of the circle }
  CenterY    : integer;
  Radius     : word;
  StepAngle  : word;
  Xasp, Yasp : word;
  Radians    : real;

function AdjAsp(Value : integer) : integer;
{ Adjust a value for the aspect ratio of the device }
begin
  AdjAsp := (LongInt(Value) * Xasp) div Yasp;
end; { AdjAsp }

begin
  MainWindow('MoveTo, LineTo demonstration');
  GetAspectRatio(Xasp, Yasp);
  GetViewSettings(ViewInfo);
    CenterX := (ViewInfo.x2-ViewInfo.x1) div 2;
    CenterY := (ViewInfo.y2-ViewInfo.y1) div 2;
    Radius := CenterY;
    while (CenterY+AdjAsp(Radius)) < (ViewInfo.y2-ViewInfo.y1)-20 do
      Inc(Radius);
  StepAngle := 360 div MaxPoints;
  for I := 0 to MaxPoints - 1 do
  begin
    Radians := (StepAngle * I) * Pi / 180;
    Points[I].X := CenterX + round(Cos(Radians) * Radius);
    Points[I].Y := CenterY - AdjAsp(round(Sin(Radians) * Radius));
  end;
  Circle(CenterX, CenterY, Radius);
  for I := 0 to MaxPoints - 1 do
  begin
    for J := I to MaxPoints - 1 do
    begin
      MoveTo(Points[I].X, Points[I].Y);
      LineTo(Points[J].X, Points[J].Y);
    end;
  end;
  WaitToGo;
end; { LineToPlay }

procedure WriteModePlay;
{ Demonstrate the SetWriteMode procedure for XOR lines }
const
  DelayValue = 50;  { milliseconds to delay }
var
  ViewInfo      : ViewPortType;
  Left, Top     : integer;
  Right, Bottom : integer;
  Step          : integer; { step for rectangle shrinking }
begin
  MainWindow('SetWriteMode demonstration');
  GetViewSettings(ViewInfo);
  Left := 0;
  Top := 0;
    Right := ViewInfo.x2-ViewInfo.x1;
    Bottom := ViewInfo.y2-ViewInfo.y1;
  Step := Bottom div 50;
  SetStandartColor($F);
  Line(Left, Top, Right, Bottom);
  Line(Left, Bottom, Right, Top);
  SetWriteMode(XORPut);                    { Set XOR write mode }
  repeat
    Line(Left, Top, Right, Bottom);        { Draw XOR lines }
    Line(Left, Bottom, Right, Top);
    Rectangle(Left, Top, Right, Bottom);   { Draw XOR rectangle }
    Delay(50);
{$IFDEF FPK}
    WaitRetrace;
{$ENDIF}    
    Line(Left, Top, Right, Bottom);        { Erase lines }
    Line(Left, Bottom, Right, Top);
    Rectangle(Left, Top, Right, Bottom);   { Erase rectangle }
    if (Left+Step < Right) and (Top+Step < Bottom) then
      begin
        Left:=Left+Step;                   { Shrink rectangle }
        Top:=Top+Step;
        Right:=Right-Step;
        Bottom:=Bottom-Step;
      end
    else
      begin
        SetStandartColor(random(254)+1);
        Left := 0;                         { Original large rectangle }
        Top := 0;
        Right := ViewInfo.x2-ViewInfo.x1;
        Bottom := ViewInfo.y2-ViewInfo.y1;
      end;
  until keypressed;
  SetWriteMode(CopyPut);                   { back to overwrite mode }
  WaitToGo;
end; { WriteModePlay }

procedure TextPlay;
{ Demonstrate text justifications and text sizing }
var
  Size : word;
  W, H, X, Y : word;
  ViewInfo : ViewPortType;
begin
  MainWindow('SetTextJustify / SetUserCharSize demo');
  GetViewSettings(ViewInfo);
    SetTextStyle(TriplexFont, VertDir, 4);
    Y := (ViewInfo.y2-ViewInfo.y1) - 2;
    SetTextJustify(CenterText, BottomText);
    OutTextXY(2*TextWidth('M'), Y, 'Vertical');
    SetTextStyle(TriplexFont, HorizDir, 4);
    SetTextJustify(LeftText, TopText);
    OutTextXY(2*TextWidth('M'), 2, 'Horizontal');
    SetTextJustify(CenterText, CenterText);
    X := (ViewInfo.x2-ViewInfo.x1) div 2;
    Y := TextHeight('H');
    for Size := 1 to 4 do
    begin
      SetTextStyle(TriplexFont, HorizDir, Size);
      H := TextHeight('M');
      W := TextWidth('M');
      Inc(Y, H);
      OutTextXY(X, Y, 'Size '+Int2Str(TextHeight('MEqg')));
    end;
    Inc(Y, H div 2);
    SetTextJustify(CenterText, TopText);
    SetUserCharSize(5, 6, 3, 2);
    SetTextStyle(TriplexFont, HorizDir, UserCharSize);
    OutTextXY((ViewInfo.x2-ViewInfo.x1) div 2, Y, 'User defined size!');
  WaitToGo;
end; { TextPlay }

procedure TextDump;
{ Dump the complete character sets to the screen }
const
  NormSizes : array[0..10] of word = (1, 4, 7, 4, 4, 4, 4, 4, 4, 2, 2);
var
  Font : word;
  ViewInfo : ViewPortType;
  S : string;
  b  : byte;
begin
  for Font := 0 to 10 do
  begin
    MainWindow(Fonts[Font]+' character set');
    GetViewSettings(ViewInfo);
      SetTextJustify(LeftText, TopText);
      MoveTo(2, 3);
      if Font = DefaultFont then
        begin
          SetTextStyle(Font, HorizDir, 1);
          b:=0;
          repeat
            s := chr(b);
            OutText(s);
            if (GetX + TextWidth('M')) > (ViewInfo.x2-ViewInfo.x1) then
              MoveTo(2, GetY + TextHeight('M')+3);
            b:=b+1;
          until (b>=255);
        end
      else
        begin
          SetTextStyle(Font, HorizDir, NormSizes[Font]);
          b := ord('!');
          repeat
            s:=chr(b);
            OutText(s);
            if (GetX + TextWidth('M')) > (ViewInfo.x2-ViewInfo.x1) then
              MoveTo(2, GetY + TextHeight('M')+3);
            b:=b+1;
          until (b>= 255);
        end;
    WaitToGo;
  end; { for loop }
end; { TextDump }

procedure FillStylePlay;
{ Display all of the predefined fill styles available }
var
  Style    : word;
  Width    : word;
  Height   : word;
  X, Y     : word;
  I, J     : word;
  ViewInfo : ViewPortType;

procedure DrawBox(X, Y : word);
begin
  SetStandartFillStyle(Style, white);
  Bar(X, Y, X+Width, Y+Height);
  Rectangle(X, Y, X+Width, Y+Height);
  OutTextXY(X+(Width div 2), Y+Height+4, Int2Str(Style));
  Inc(Style);
end; { DrawBox }

begin
  MainWindow('Pre-defined fill styles');
  GetViewSettings(ViewInfo);
  Width := 2 * ((viewinfo.x2+1) div 13);
  Height := 2 * ((viewinfo.y2-10) div 10);
  X := Width div 2;
  Y := Height div 2;
  Style := 0;
  for J := 1 to 3 do
  begin
    for I := 1 to 4 do
    begin
      DrawBox(X, Y);
      Inc(X, (Width div 2) * 3);
    end;
    X := Width div 2;
    Inc(Y, (Height div 2) * 3);
  end;
  SetTextJustify(LeftText, TopText);
  WaitToGo;
end; { FillStylePlay }

procedure FillPatternPlay;
{ Display some user defined fill patterns }
const
  Patterns : array[0..11] of FillPatternType = (
  ($AA, $55, $AA, $55, $AA, $55, $AA, $55),
  ($33, $33, $CC, $CC, $33, $33, $CC, $CC),
  ($F0, $F0, $F0, $F0, $F, $F, $F, $F),
  (0, $10, $28, $44, $28, $10, 0, 0),
  (0, $70, $20, $27, $25, $27, $4, $4),
  (0, 0, 0, $18, $18, 0, 0, 0),
  (0, 0, $3C, $3C, $3C, $3C, 0, 0),
  (0, $7E, $7E, $7E, $7E, $7E, $7E, 0),
  (0, 0, $22, $8, 0, $22, $1C, 0),
  ($FF, $7E, $3C, $18, $18, $3C, $7E, $FF),
  (0, $10, $10, $7C, $10, $10, 0, 0),
  (0, $42, $24, $18, $18, $24, $42, 0));
var
  Style    : word;
  Width    : word;
  Height   : word;
  X, Y     : word;
  I, J     : word;
  ViewInfo : ViewPortType;

procedure DrawBox(X, Y : word);
begin
  SetStandartFillPattern(Patterns[Style], white);
  Bar(X, Y, X+Width, Y+Height);
  Rectangle(X, Y, X+Width, Y+Height);
  Inc(Style);
end; { DrawBox }

begin
  MainWindow('User defined fill styles');
  GetViewSettings(ViewInfo);
  Width := 2 * ((viewinfo.x2+1) div 13);
  Height := 2 * ((viewinfo.y2-10) div 10);
  X := Width div 2;
  Y := Height div 2;
  Style := 0;
  for J := 1 to 3 do
  begin
    for I := 1 to 4 do
    begin
      DrawBox(X, Y);
      Inc(X, (Width div 2) * 3);
    end;
    X := Width div 2;
    Inc(Y, (Height div 2) * 3);
  end;
  SetTextJustify(LeftText, TopText);
  WaitToGo;
end; { FillPatternPlay }

procedure ProfilePixel(Count:Longint);
var VP:Viewporttype;
    x,y:Integer;
    color:longint;
begin
MainWindow('Pixel-Demo');
GetViewSettings(VP);
x:=VP.x2-VP.x1;
y:=VP.y2-VP.y1;
StartTime;
for gd:=1 to Count do
  for i:=0 to y do begin
{$ifdef turbo}
    color:=i+(gd shl 3);
{$else}    
    color:=convert(i+(gd shl 3));
{$endif}    
    for j:=0 to x do PutPixel(j,i,color);
  end;
EndTime; Writeln(PRF,longint((x+1)*(y+1)*gd):8,' mal Putpixel               : ',TotalTime);
end;

procedure RandomLines;
var VP:Viewporttype;
    x,y:Integer;
begin
  MainWindow('Randomline-Demo');
  GetViewSettings(VP);
  x:=VP.x2-VP.x1;
  y:=VP.y2-VP.y1;
  Randomize;
  repeat  
    setstandartcolor(random(254)+1);
    line(random(x),random(y),random(x),random(y));
  until keypressed;
  waittogo;
end;

{$IFDEF FPK}
procedure RandomTriangles;
var VP:Viewporttype;
    x,y:Integer;
    a,b,c:pointtype; 
begin
  MainWindow('Filltriangle-Demo');
  GetViewSettings(VP);
  x:=VP.x2-VP.x1;
  y:=VP.y2-VP.y1;
  Randomize;
  repeat  
    setstandartfillstyle(random(11),random(254)+1);
    a.x:=random(x); a.y:=random(y);
    b.x:=random(x); b.y:=random(y);
    c.x:=random(x); c.y:=random(y);
    filltriangle(a,b,c);
  until keypressed;
  waittogo;
end;
{$ENDIF}

procedure ProfileHorizontalNormalLine(Count:longint);
var VP:Viewporttype;
    x,y:Integer;
begin
  MainWindow('Horizontal-NormalLine-Demo');
  GetViewSettings(VP);
  x:=VP.x2-VP.x1;
  y:=VP.y2-VP.y1;
  StartTime;
  for i:=1 to Count do begin
    SetStandartColor(i);
    for j:=0 to Y do line(0,j,x,j);
  end;
  EndTime; Writeln(PRF,longint((y+1)*Count):8,' mal Line normalput y1=y2   : ',TotalTime);
  WaitToGo;
end;

procedure ProfileHorizontalXorLine(Count:longint);
var VP:Viewporttype;
    x,y:Integer;
begin
MainWindow('Horizontal-XorLine-Demo');
  GetViewSettings(VP);
  x:=VP.x2-VP.x1;
  y:=VP.y2-VP.y1;
SetWriteMode(xorput);
SetStandartColor(white);
StartTime;
for i:=1 to Count do 
  for j:=0 to Y do line(0,j,x,j);
EndTime; Writeln(PRF,longint((y+1)*Count):8,' mal Line xorput y1=y2      : ',TotalTime);
SetWriteMode(normalput);
WaitToGo;
end;

procedure ProfileDiagonalNormalLine(Count:longint);
var VP:Viewporttype;
    x,y:Integer;
begin
MainWindow('Diagonal-NormalLine-Demo');
  GetViewSettings(VP);
  x:=VP.x2-VP.x1;
  y:=VP.y2-VP.y1;
StartTime;
for i:=1 to Count do begin
  SetStandartColor(i);
  for j:=0 to y do line(0,y-j,x,j);
end;
EndTime; Writeln(PRF,longint((y+1)*Count):8,' mal Line normalput y1<>y2  : ',TotalTime);
WaitToGo;
end;

procedure ProfileDiagonalXorLine(Count:longint);
var VP:Viewporttype;
    x,y:Integer;
begin
MainWindow('Diagonal-XorLine-Demo');
  GetViewSettings(VP);
  x:=VP.x2-VP.x1;
  y:=VP.y2-VP.y1;
SetWriteMode(xorput);
StartTime;
for i:=1 to Count do begin
  SetStandartColor(red);
  for j:=0 to y do line(0,y-j,x,j);
end;
EndTime; Writeln(PRF,longint((y+1)*Count):8,' mal Line xorput y1<>y2     : ',TotalTime);
SetWriteMode(normalput);
WaitToGo;
end;

procedure ProfileEllipse(count:Integer);
begin
MainWindow('FillEllipse-Demo');
setwritemode(normalput);
StartTime;
SetStandartColor(white);
for i:=0 to count do begin
  SetStandartFillStyle(i mod 12,i);
  FillEllipse(maxx shr 1,maxy shr 1,maxx shr 1,maxy shr 1);
end;
EndTime; Writeln(PRF,longint(Count):8,' mal FillEllipse            : ',TotalTime);
WaitToGo;
end;

procedure filldemo;
var CurPort:ViewPortType;
    x,y:integer;
    border: longint;
begin
 Border:=yellow;
 MainWindow('FillDemo');
 GetViewSettings(CurPort);
 x:=(curport.x2-curport.x1) shr 1;
 y:=(curport.y2-curport.y1) shr 1;
 SetStandartColor(border);
 SetStandartFillstyle(6,brown);
 Bar(0,0,maxx,maxy);
 SetTextJustify(CenterText, CenterText);
 SetTextStyle(10, HorizDir, UserCharSize);
 SetUserCharSize(5, 1, 5, 1);
 OutTextXY(x,y,'W');
 SetStandartFillstyle(solidfill,red);
 floodfill(x,y,stdcolors[border]);
 SetStandartFillstyle(solidfill,lightred);
 floodfill(10,10,stdcolors[border]);
 waittogo;
end;
 
procedure GetPutDemo;
var P         : Pointer;
    Size,wx,wy: word;
    Color     : longint;
    Curport   : Viewporttype;
    x,y,i     : integer;
begin
MainWindow('GetImage / PutImagedemo');
GetViewSettings(Curport);
wx:=CurPort.x2 - CurPort.x1;
wy:=CurPort.y2 - CurPort.y1;
SetStandartColor(White);
SetStandartFillStyle(2,blue);
Circle(30,20,10);
Line(30,5,30,10);
Line(20,30,10,50);
Line(40,30,50,50);
FillEllipse(30,30,20,10);
Size:=ImageSize(0,0,50,50);
Getmem(P,Size);
GetImage(0,0,50,50,P^); 
PutImage(0,0,P^,XorPut);
{$IFDEF TURBO}
color:=white;
{$ELSE}
color:=convert(stdcolors[white]);
{$ENDIF}
for i:=0 to 1000 do PutPixel(random(wx),random(wy),Color);
x:=wx shr 1;
y:=wy shr 1;
i:=1;
repeat 
  x:=x+i;
  PutImage(x,y,P^,XorPut);
  Delay(100);
{$IFDEF FPK}
  WaitRetrace;
{$ENDIF}
  PutImage(x,y,P^,XorPut);
  if (x<=0) or (x>=wx) then i:=-i;
until keypressed;
FreeMem(P,Size);
WaitToGo;
end;

begin
{$IFDEF TURBO}
 GD := InstallUserDriver('BGI256',@Dummy);
 GM := 3;
 Filename:='BOR-PAS.PRF';
 Header:='Profiling Daten Borland-Pascal';
{$ELSE}
 { Sollte eine Aufloesung von 1024x768 zu hoch fuer den Monitor sein
   'GD:=detect' auskommentieren und eigenen Wert fuer Grafikmodus an-
    geben z.b. GM:=$103 = 800x600x256 }
 GD:=1;
 GM:=$103;
 Filename:='FPK-PAS.PRF';
 Header:='Profiling Daten FPK-Pascal    ';
{$ENDIF}
 InitGraph(GD,GM,'E:\PP\VESA\char');
 maxx:=GetMaxX; maxy:=GetMaxY;
 MaxColors:=GetMaxColor;
 Assign(PRF,Filename);
 Rewrite(PRF);
 Writeln(PRF,' ******* ' + Header + ' ******* bei ',maxX+1,'x',maxY+1,'x',MaxColors); 
 Writeln(PRF);
 ReportStatus;
 Profilepixel(5);
 ProfileHorizontalNormalLine(6);
 ProfileHorizontalXorLine(6);
 ProfileDiagonalNormalLine(3);
 ProfileDiagonalXorLine(3);
 ProfileEllipse(100);
 GetPutDemo;
 AspectRatioPlay;
 RandomLines;
{$IFDEF FPK} 
 RandomTriangles;
{$ENDIF} 
 Linetoplay;
 Writemodeplay;
 Fillpatternplay;
 FillStylePlay;
 TextPlay;
 TextDump;
 FillDemo;
 Writeln(PRF); 
 Close(PRF);
 CloseGraph;
end.
