************************************************************************
** Demo program for Foxsqz.PLB/.FLL									   *
** (c) 1993-94 Master Creative Software, Inc.						   *
** Please feel free to use any or all of this code in your app		   *
************************************************************************
* Last Updated 2/16/94 6:22pm WSM Added more Comments and Formating Code



Set Echo off
Clear
Set Talk off

_ExitBtn  = 0													&& Button status

SqzPage   =  .T.												&& Page Listing
SqzArc    =  Padr("FOXSQZ.SQZ",20," ")							&& Archive File Name
SqzPass   =  Space(15)											&& Password for Encryption
SqzFSpec  =  "*.*"+Space(17)									&& Files to Act on
SqzXClude =  Space(15)											&& Files to Exclude
SqzINCFile=  Space(15)											&& Include File Name
SqzFnct   =  1													&& Function to Perform
SqzCmpTyp =  1													&& Compression Method
SqzOver   =  .F.												&& OverWrite Existing files when decompressing
SqzDst    =  Space(15)											&& destination for Decompression
SqzRestDT =  .F.												&& restore Orginal Date time of File
SqzQuiet  =  .F.												&& Operate quietly
SqzSpan   =  .F.												&& Span Disks
SqzWipe   =  .F.												&& Wipe disk used for spanning
SqzFmtTyp =  1													&& Format MEthod
SqzLowDens=  .F.												&& LowDensity Disks Used
SqzVerify =  .F.												&& DOS Verfy Flag
SqzTDrv   =  "  "												&& Temp Drive
SqzIncSub =  .F.												&& Include Subdirectories
SqzStoPath=  .F.												&& Store PathNames
SqzResTree=  .F.												&& Restore Directory Tree
SqzStorSpec= .F.
SqzLowMem  = .F.

* Intialize Error Strings Foxsqz returnes offset-1 into this array
* so you need to add one when indexing the array, this is because
* foxpro arrays start at offset 1 and Foxsqz returns 0 for success..

Dime FoxSqzErr[50]

FoxSqzErr[1] = "No Errors Were Detected"
FoxSqzErr[2] = "Invalid or Bad Input File "
FoxSqzErr[3] = "Invalid or Bad Output File"
FoxSqzErr[4] = "Invalid or Bad Global Header in SQZ file"
FoxSqzErr[5] = "Error Writing Global Header"
FoxSqzErr[6] = "Invalid or Bad Local Header"
FoxSqzErr[7] = "Error Writing Local Header"
FoxSqzErr[8] = "Error allocating Local Memory"
FoxSqzErr[9] = "Error Allocating Foxpro memory"
FoxSqzErr[10] = "File Read Error Type 1"
FoxSqzErr[11] = "File Read Error Type 2"
FoxSqzErr[12] = "File Read Error Type 3"
FoxSqzErr[13] = "DosFile Size Error"
FoxSqzErr[14] = "File Write Error Type 1"
FoxSqzErr[15] = "File Write Error Type 2"
FoxSqzErr[16] = "File Write Error Type 3"
FoxSqzErr[17] = "Error In Parameter 1 (Options String)"
FoxSqzErr[18] = "Error In Parameter 2 (SQZ file Name)"
FoxSqzErr[19] = "Error In Parameter 3 (File Specifiers)"
FoxSqzErr[20] = "Error Opening Input"
FoxSqzErr[21] = "Error Opening OutPut"
FoxSqzErr[22] = "No Parameters Passed "
FoxSqzErr[23] = "Error Opening WorkFile"
FoxSqzErr[24] = "File Write Error"
FoxSqzErr[25] = "Create Aborted By User"
FoxSqzErr[26] = "Error Allocating Transfer Memory"
FoxSqzErr[27] = "Error InValid/Unknown Parameter"
FoxSqzErr[28] = "UnKnown compression type"
FoxSqzErr[29] = "Error in Password"
FoxSqzErr[30] = "InValid PassWord"
FoxSqzErr[31] = "Not a FOXSQZ Archive or Incompatible version"
FoxSqzErr[32] = "Error in specified destination drv/path"
FoxSqzErr[33] = "Unable to select target	drive/path"
FoxSqzErr[34] = "Could not Open Include File"
FoxSqzErr[35] = "Invalid Inclusion argument"
FoxSqzErr[36] = "Invalid Exclusion argument"
FoxSqzErr[37] = "Max Exclusions is 5"
FoxSqzErr[38] = "I needed disk #1 to Start"
FoxSqzErr[39] = "User aborted"
FoxSqzErr[40] = "No Spanning support for this function"
FoxSqzErr[41] = "Unable to Format Disk"
FoxSqzErr[42] = "Nothing to do "
FoxSqzErr[43] = "Exceeded max files allowed in demo"
FoxSqzErr[44] = "Disk is Not Removable, will not format"
FoxSqzErr[45] =  "No More Internal FoxSqz Memory Handles"
FoxSqzErr[46] =  "Invalid Drive"

Do while .T.
	Clear
	SqzFSpec  =  "*.*"+Space(17)	
	do sqz.spx
	if Lastkey()=27 OR _ExitBtn=1
		Exit
	Endif
	Set Libr to Foxsqz

	** Build FoxSqz Arguments ***

	*Get Main FoxSqz Funtion  Squeeze , UnSqueeze, Delete, List , etc *

	Fnct = iif(SqzFnct = 1,"S",iif(SqzFnct = 2,"U",iif(SqzFnct=3,"L","D")))
	Arg1 = Fnct													&& Add To Argument One List

	*Now Create Arguments that affect all Foxsqz Function

	if !Empty(SqzPass)											&& Is Password Encryption Requested ?
		Arg1 = Arg1 + "E("+allTrim(SqzPass)+")"
	Endif

	if SqzQuiet
		Arg1 = Arg1 + "Q"
	Endif 

	if SqzLowMem 
		Arg1 = Arg1 + "$"
	Endif

	if SqzVerify												&& Need Dos Verify Flag Set ?
		Arg1 = Arg1 + "V"
	Endif

	if !Empty(SqzTDrv)											&& Want to Redirect Foxsqz Tmp Files ?
		Arg1 = Arg1 + "G("+Trim(SqzTDrv)+")"
	Endif

	if !Empty(SqzXClude)										&& Was there any files to Exclude
		Ex1 = ""
		l = len(Trim(SqzXClude))
		for i = 1 to l
			tmp = Substr(SqzXClude,i,1)
			if tmp = " "
				if !Empty(Ex1)
					Arg1 = Arg1 + "X("+Ex1+")"
					Ex1 = ""
				else
					*ignore leading trailing space
				Endif
			else
				Ex1 = Ex1 + tmp
			Endif
		EndFor
		if !Empty(Ex1)											&& Get Last Arg
			Arg1 = Arg1 + "X("+Ex1+")"
		Endif
	Endif

	* Now Proccess Squeeze Modifiers
	if Fnct = "S"												&& Compression Modifiers

		** compression Type Fast Maximum or None
		Arg1 = Arg1 + iif(SqzCmpTyp=1,"M",iif(SqzCmpTyp=2,"F","N"))

		** Use a Include File ?
		if !Empty(SqzINCFile)
			Arg1 = Arg1 + "@("+allTrim(SqzINCFile)+")"
		Endif

		** Recurse into Subdirectories ?
		if SqzIncSub
			Arg1 = Arg1 + "R"
		Endif

		**Store Paths Recursed Into ?
		if SqzIncSub AND SqzStoPath
			Arg1 = Arg1 + "P"

			** What about paths specified
			if SqzStorSpec
				Arg1 = Arg1 + "*"
			Endif
		Endif

		** Span Multiple Floppies
		if SqzSpan
			Arg1 = Arg1 + "&"
		Endif

		** Format the Target if Removable ?
		if SqzWipe
			Arg1 = Arg1 + "W("

			** How do we eant to Format it QUICK , Conditionaly or Unconditionaly
			do case
			case SqzFmtTyp = 1
				Arg1 = Arg1 + "q"
			case SqzFmtTyp = 2
				Arg1 = Arg1 + "c"
			case SqzFmtTyp = 3
				Arg1 = Arg1 + "u"
			EndCase

			** format Low Density disks ?
			if SqzLowDens
				Arg1 = Arg1 + "l"
			Endif

			** Close Wipe Modifiers
			Arg1 = Arg1 + ")"
		Endif

	Endif

	** Process UnSqueeze Function

	if Fnct="U"

		* Overwrite Existing Files ?
		if SqzOver
			Arg1 = Arg1 + "O"
		Endif

		** Restore Original File Date and Time ?
		if SqzRestDT
			Arg1 = Arg1 + "R"
		Endif

		** Restore to Driver/Directory other than Default ?
		if !Empty(SqzDst)
			if Right(AllTrim(SqzDst),1)!="\"
				SqzDst = Padr(AllTrim(SqzDst)+"\",15," ")
			Endif
			Arg1 = Arg1 + "T("+allTrim(SqzDst)+")"
		Endif

		** Restore Directory Tree ?
		if SqzResTree
			Arg1 = Arg1 + "P"
		Endif

	Endif

	** Proccess List Option
	if Fnct="L" AND SqzPage										&& Page the Display "More Like"
		Arg1 = Arg1 + "P"
	Endif

	* Make FOXSQZ part of Foxpro
	Set Libr to Foxsqz


	Define Window SQZ from 2,-1 to 22,80
	@1,3 Say ' Will Execute -> =FoxSqz("'+ Arg1 + '","'+allTrim(SqzArc) +'","' + allTrim(SqzFSpec)+'")'
	Activate Window SQZ
	if Empty(SqzFSpec)
		SRet = FoxSqz(Arg1,allTrim(SqzArc))
	Else
		SRet = FoxSqz(Arg1,allTrim(SqzArc),allTrim(SqzFSpec))
	Endif

	Set Libr to

	Clear TypeAhead
	Wait "FOXSQZ Return = ["+Ltrim(Str(SRet))+"] - "+SqzError(SRet) Window NoWait

	if SRet=0 AND Fnct = "L"
		Wait "Strike Any Key " Window
	Endif

	Release Window SQZ
Enddo

Define Window PRNWIND from 0,0 to 23,79 TITLE ;
" [ FOXSQZ Documentation ]"  PANEL COLOR w/n,n/w,w/n
modi file FOXSQZ.DOC NOMOD WINDOW PRNWIND
Release Window PRNWIND

Return



*******************************************
Procedure SqzError
*******************************************
Param _Er

return FoxSqzErr[_er+1]



