Unit Fossil;
{

Copyright (c) 1993, DS:SI
FidoNet Address: 1:396/85
(504) 454-6578

All routines are invoked via Turbo BASM or direct Inline procedures
to insure the fasted and most reliable results.  Routines and some
documentation were taken from the FidoNet Standards Committee's
FOSSIL.CHT associated with FSC-0015.

                 Fundamentals of FOSSIL implementation and use

                        Version 5,  February 11,  1988

                       Rick Moore,  Solar Wind Computing
                          FidoNet Address:  1:115/333

                 FidoNet Standards Committee index:  FSC-0015

Copyright (C) 1987, VEP Software, Naugatuck, CT 06770. All rights reserved.
Copyright (C) 1988, Rick Moore,  Homewood,  IL, 60430. All rights reserved.

}
Interface

Const

   (* FOSSIL STATUS BITS *)

   TIMEOUT    = $8000;  { Time out                    }
   BUFF_EMPTY = $4000;  { Output Buffer Empty         }
   HOLD_EMPTY = $2000;  { Output Buffer Not Full      }
   PARITY_ERR = $0400;  { Parity Error                }
   OVERRUN    = $0200;  { Input Buffer Overrun        }
   DATA_READY = $0100;  { Characters in Input Buffer  }
   CARRIER    = $0080;  { Carrier Detect              }
   RING       = $0040;  { Ring Indicator              }

   (* FLOW CONTROL BITS *)

     (***********************************************)
     (*  Bit 0 : Enables Remote to Restrain FOSSIL  *)
     (*          Transmitter using XON/XOFF.        *)
     (*  Bit 1 : Enables Modem Restraint of FOSSIL  *)
     (*          Transmitter using CTS and FOSSIL   *)
     (*          Restraint of Modem using RTS.      *)
     (*  Bit 3 : Enales FOSSIL to Restrain Remote   *)
     (*          Using XON/XOFF.                    *)
     (***********************************************)

   XON_XOFF   = $09;    { XON/XOFF Flow Control       }
   CTS_RTS    = $02;    { CTS/RTS Flow Control        }

   (* BREAK CONTROL BITS *)

     (***********************************************)
     (*  Bit 0 : Enable/disable CtlC/CtlK check     *)
     (*          (driver will set internal flag     *)
     (*          which is returned by FossilCtlC    *)
     (*          when it detects a CtlC/CtlK).      *)
     (*  Bit 1 : 1 = stop transmitter               *)
     (*          0 = release previous stop          *)
     (***********************************************)

   CTL_C_K    = $01;    { Enable Ctl-C/K Checking     }
   STOP_TRANS = $02;    { Stop Transmitting           }

Type
{
    For Turbo Pascal 6.0, uncomment the following line.
}{
   PChar = ^Char;
}
   FossInfoRec = Record
      StrucSize  : Word;    { Structure size       }
      Version    : Byte;    { FOSSIL spec version  }
      RevLevel   : Byte;    { Driver rev level     }
      FossName   : PChar;   { Pointer to ASCII ID  }
      InBuffSiz  : Word;    { Input buffer size    }
      InAvail    : Word;    { Bytes avail (input)  }
      OutBuffSiz : Word;    { Output buffer size   }
      OutAvail   : Word;    { Bytes avail (output) }
      ScrWidth   : Byte;    { Screen width, chars  }
      ScrHeight  : Byte;    { Screen height, chars }
      BaudRate   : Byte;    { Baud rate mask       }
      End;

(*************************************************************************)
(*  Function Set Baud Rate                                               *)
(*                                                                       *)
(*     Supported baud rates are 300, 600, 1200, 2400, 4800, 9600,        *)
(*     19200, 38400.  This function assumes No Parity, 8 bit             *)
(*     Character Length, and 1 Stop Bit.                                 *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*           Baud      Baud Rate to Initialize Port                      *)
(*  Output:  Word      SEE FOSSIL STATUS BITS ABOVE                      *)
(*************************************************************************)
Function FossilBaud(Port, Baud: Word): Word;

(*************************************************************************)
(*  Function Transmit Character (Wait for room in the buffer)            *)
(*                                                                       *)
(*     Character is queued for transmission.  If there is room           *)
(*     in the transmitter buffer when this call is made, the             *)
(*     character will be stored and control returned to caller.          *)
(*     If the buffer is full, the driver will wait for room.             *)
(*     This can be dangerous when used in combination with flow          *)
(*     control (see FossilPortFlow).                                     *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*           Chr       Character                                         *)
(*  Output:  Word      SEE FOSSIL STATUS BITS ABOVE                      *)
(*************************************************************************)
Function FossilTransWait(Port: Word; Chr: Byte): Word;

(*************************************************************************)
(*  Function Receive Character (Wait for available)                      *)
(*                                                                       *)
(*     The next character in the input ring buffer is returned           *)
(*     to the caller. If none available, the driver will wait            *)
(*     for input.                                                        *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  Byte      Input Character                                   *)
(*************************************************************************)
Function FossilReceiveWait(Port: Word): Byte;

(*************************************************************************)
(*  Function Status Request                                              *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  Word      SEE FOSSIL STATUS BITS ABOVE                      *)
(*************************************************************************)
Function FossilStatus(Port: Word): Word;

(*************************************************************************)
(*  Function Initialize Driver (port)                                    *)
(*                                                                       *)
(*     Required before I/O can take place on comm port.                  *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  Word      Result  =   0  : Fossil Driver not Present        *)
(*                     Result DIV 256 : FOSSIL Revision level of driver  *)
(*                     Result MOD 256 : Max Function Supported           *)
(*************************************************************************)
Function FossilInit(Port: Word): Word;

(*************************************************************************)
(*  Function Deinitialize Driver (port)                                  *)
(*                                                                       *)
(*     Disengages driver from comm port.  Should be done when            *)
(*     operations on the port are complete.                              *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  None      DTR Not Changed                                   *)
(*************************************************************************)
Procedure FossilDeInit(Port: Word);

(*************************************************************************)
(*  Function Raise/Lower DTR                                             *)
(*                                                                       *)
(*     Used to control Data Terminal Ready signal line on com            *)
(*     port. This line usually has some effect on modem operation        *)
(*     (most modems will drop carrier if DTR is lowered, for             *)
(*     example).                                                         *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*           Status    1 = Raise, 0 = Lower                              *)
(*  Output:  None      DTR Changed                                       *)
(*************************************************************************)
Procedure FossilDTR(Port: Word; Status: Byte);

(*************************************************************************)
(*  Function Flush Output Buffer (Wait for all output to end)            *)
(*                                                                       *)
(*     This is used to wait for all output to complete                   *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  None                                                        *)
(*************************************************************************)
Procedure FossilFlushOut(Port: Word);

(*************************************************************************)
(*  Function Purge Output Buffer (Immediately zero buffer)               *)
(*                                                                       *)
(*     Zero the output buffer. Returns to the caller immediately.        *)
(*     Characters that have not been transmitted yet are lost.           *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  None                                                        *)
(*************************************************************************)
Procedure FossilPurgeOut(Port: Word);

(*************************************************************************)
(*  Function Purge Input Buffer                                          *)
(*                                                                       *)
(*     Zeroes the input buffer. If any flow control restraint has        *)
(*     been employed (dropping RTS or transmitting XOFF) the port        *)
(*     will be "released" (by doing the reverse, raising RTS or          *)
(*     sending XON). Returns to caller immediately.                      *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  None                                                        *)
(*************************************************************************)
Procedure FossilPurgeInput(Port: Word);

(*************************************************************************)
(*  Function Transmit Character ("no wait")                              *)
(*                                                                       *)
(*     Character is queued for transmission.  If there is room in        *)
(*     the transmitter buffer when this call is made, the character      *)
(*     will be stored and control returned to caller with a result       *)
(*     of TRUE. If the buffer is full, control is returned to caller     *)
(*     with a result of FALSE. This allows the application to make       *)
(*     its own decisions on how to deal with "buffer full".              *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*           Chr       Character                                         *)
(*  Output:  Boolean   TRUE  = Sent                                      *)
(*                     FALSE = Not Sent                                  *)
(*************************************************************************)
Function FossilTransmit(Port: Word; Chr: Byte): Boolean;

(*************************************************************************)
(*  Function "Peek Ahead" Input Buffer                                   *)
(*                                                                       *)
(*     The next character in the input ring buffer is returned to        *)
(*     the caller. If none available, the function returns a value       *)
(*     of FALSE. This "read" does not actually remove a character        *)
(*     from the input buffer!                                            *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  Chr       Input Character (If available)                    *)
(*           Boolean   TRUE  = Character Available                       *)
(*                     FALSE = Character Not Available                   *)
(*************************************************************************)
Function FossilPeekIn(Port: Word; Var Chr: Byte): Boolean;

(*************************************************************************)
(*  Function Enable/Disable Com Port Flow Control                        *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*           Status    Flow Control Bit Mask (SEE FLOW CONTROL BITS)     *)
(*  Output:  None                                                        *)
(*************************************************************************)
Procedure FossilPortFlow(Port: Word; Status: Byte);

(*************************************************************************)
(*  Function Enable/Disable Ctl-C/Ctl-K Check,                           *)
(*           Enable/Disable Transmitter                                  *)
(*                                                                       *)
(*     This is used primarily for programs that can't trust XON/XOFF     *)
(*     at FOSSIL level (such as BBS software).                           *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*           Status    Flags Byte (SEE BREAK CONTROL BITS)               *)
(*  Output:  Boolean   TRUE  = CtlC/K Detected Since Last Call           *)
(*                     FALSE = CtlC/K Not Detected Since Last Call       *)
(*************************************************************************)
Function FossilCtlC(Port: Word; Status: Byte): Boolean;

(*************************************************************************)
(*  Function Enable/Disable "Watchdog"                                   *)
(*                                                                       *)
(*     FOSSIL will force the system to reboot if Carrier Detect on       *)
(*     the specified port drops while "watchdog" is ON.                  *)
(*                                                                       *)
(*     It is not necessary for the port to be "active" (FossilInit)      *)
(*     for this function to be used.                                     *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*           Status    1 = Enable "Watchdog"                             *)
(*                     0 = Disable "Watchdog"                            *)
(*  Output:  None                                                        *)
(*************************************************************************)
Procedure FossilWatchdog(Port: Word; Status: Byte);

(*************************************************************************)
(*  Function Reboot System                                               *)
(*                                                                       *)
(*     Provides a machine-independent way for a "troubled"               *)
(*     application to reset the system. Some machines may not            *)
(*     support both "flavors" of bootstrap, in which case the            *)
(*     setting of Status will not have any effect.                       *)
(*                                                                       *)
(*  Input:   Status    0 = Cold Boot                                     *)
(*                     1 = Warm Boot                                     *)
(*                     2 = Jump to Reset Vector                          *)
(*  Output:  None                                                        *)
(*************************************************************************)
Procedure FossilReboot(Status: Byte);

(*************************************************************************)
(*  Function Start/Stop Sending Break                                    *)
(*                                                                       *)
(*     Used for special applications such as certain high speed          *)
(*     modems. Resets all transmit flow control restraints (such as      *)
(*     an XOFF received from remote).  FossilInit or FossilDeInit        *)
(*     will stop an in-progress Break.                                   *)
(*                                                                       *)
(*    Note: the application must determine the "length" of the BREAK.    *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*           Status    1 = Start Break                                   *)
(*                     0 = Stop Break                                    *)
(*  Output:  None                                                        *)
(*************************************************************************)
Procedure FossilBreak(Port: Word; Status: Byte);

(*************************************************************************)
(*  Function Get Driver Info                                             *)
(*                                                                       *)
(*  WARNING: The FOSSIL needs to be active on the COM port selected      *)
(*           for the information returned to be accurate.                *)
(*                                                                       *)
(*  Input:   Port      COM Port (0 = COM1, 1 = COM2, etc.)               *)
(*  Output:  InfoRec   Driver Info Structure (If result = 0)             *)
(*           Word      Number of bytes transfered to InfoRec greater     *)
(*                     than the record size itself.  If 0, InfoRec       *)
(*                     contains the FOSSIL Driver information.           *)
(*************************************************************************)
Function FossilInfo(Port: Word; Var InfoRec: FossInfoRec): Word;

Implementation

(*

       These procedure's may be used in application software free
       of charge providing this registration form is completed
       and mailed via USPS at the below address or NetMail'ed to
       1:396/85.  Source code is available upon request ...

______________________________________________________________________________


       Please use your real name only!

          NAME:
       ADDRESS:
              :
          CITY:                  STATE:      ZIP:

         PHONE: (   )    -

       Where did you obtain a copy of this program?  (Be specific,
       BBS name, FidoNet address, Phone, etc.):


       If you are a BBS SysOp, Please complete the following:

                 BBS NAME:
                    PHONE: (   )    -
       FRONT END SOFTWARE:
             BBS SOFTWARE:
          FIDONET ADDRESS:

______________________________________________________________________________

       For a copy of the source code, please send $15 along with
       disk preference (3.5 or 5.25) and this registration form
       to:

       David Dunson
       2221 Houma Blvd., Apt. 102
       Metairie, LA  70001

       FidoNet 1:396/85, DS:SI, (504) 454-6578 (14,400bps)

*)

End.
