{$M 16384,0,655360}
program UpdFile;
uses
  ApiInt, Types,
  TParam,
  Bits,
  DOS, Crt;

type
  PUpdFiles        = ^TUpdFiles;
  TUpdFiles        = object
    SkipDate       : Boolean;
    SkipSize       : Boolean;
    CheckExist     : Boolean;
    CheckAction    : ( actAutofix, actDelete, actAutofixLong  );
    AreaCode       : string;
    FileSpec       : string;
    Cfg            : SysCfgT;

    constructor Init;
    destructor Done;

    procedure ReadParams;
    procedure UpdateFiles;
  end;

var
  UpdFiles         : PUpdFiles;

constructor TUpdFiles.Init;
begin
  dllInit( '', 0 );
  fioReadMainCfg( Cfg );
end;

destructor TUpdFiles.Done;
begin
end;

procedure TUpdFiles.ReadParams;
begin
  if Par^.SwAct['C'] then
  begin
    CheckExist := TRUE;
    case S2C( UpStr( Par^.SwStr['C'] )) of
      'A': CheckAction := actAutofix;
      'D': CheckAction := actDelete;
      'L': CheckAction := actAutofixLong;
    else
      CheckExist := FALSE;
    end;
  end
  else CheckExist := FALSE;

  if Par^.SwAct['D'] then SkipDate := TRUE
  else SkipDate := FALSE;

  if Par^.SwAct['S'] then SkipSize := TRUE
  else SkipSize := FALSE;

  if Par^.SwAct['A'] then AreaCode := Par^.SwStr['A']
  else AreaCode := 'MAIN';

  FileSpec := UpStr( Par^.Str[1] );
end; { procedure ReadParams }

procedure TUpdFiles.UpdateFiles;
var
  AreaRec          : Area_Config_Record;
  DirRec           : Area_Directory_Record;
  FileRec          : TFileRec;
  FPos             : LongInt;
  SRec             : SearchRec;
  Changed          : Boolean;
  OldSize          : LongInt;
  OldDate          : T_Date;
  FilePath         : string;

{}procedure ScanCD( FromDir : string );
  type
    OneDirType     = array[0..1999] of string[12];
  var
    ThisDir        : ^OneDirType;
    SR             : SearchRec;
    RecNo          : Word;
    TempStr        : string;
  begin
    New( ThisDir );
    FillChar( ThisDir^, SizeOf( ThisDir^ ), 0 );
    RecNo := 0;
    FindFirst( FromDir + '\*.*', AnyFile, SR );
    while ( DosError = 0 ) do
    begin
      if not ( SR.Name = '.' ) and
         not ( SR.Name = '..' ) and
         ( SR.Attr and Directory = Directory ) then
      begin
        ThisDir^[RecNo] := SR.Name;
        Inc( RecNo );
      end;
      FindNext( SR );
    end;

    RecNo := 0;
    while not ( ThisDir^[RecNo] = '' ) do
    begin
      ScanCD( FromDir + '\' + ThisDir^[RecNo] );
      with FileRec do
        if FileExist( Copy( FromDir, 1, 3 ) + CDPath ) and
           FindStr( FileName, CDPath ) then Break;

      Inc( RecNo );
    end;
    Dispose( ThisDir );

    if FileExist( FromDir + '\' + FileRec.FileName ) then
    begin
      with FileRec do
        CDPath := Copy( FromDir, 4, Length( FromDir )) + '\' + FileRec.FileName;
    end;
{}end; { function ScanCD }

{}function  Autofix : Boolean;
  var
    CDLoop         : Byte;
    Dirloop        : LongInt;
    Fixed          : Boolean;
  begin
    with FileRec do
    begin
      if not ( CDPath = '' ) then
        for CDLoop := 1 to 10 do
        begin
          FindFirst( Cfg.CDROM[CDLoop] + ':\' + CDPath, AnyFile, SRec );
          if ( DosError = 0 ) then
          begin
            CDROM := CDLoop;
            Autofix := TRUE;
            Exit;
          end;
        end;

      DirLoop := 0;
      while fioReadDirCfg( DirRec, AreaRec, DirLoop ) do
      begin
        FindFirst( DirRec.DiskDir + '\' + FileName, AnyFile, SRec );
        if ( DosError = 0 ) then
        begin
          DirNo := DirRec.DirNo;
          CDROM := 0;
          Autofix := TRUE;
          Exit;
        end;

        Inc( DirLoop );
      end;

      if ( CheckAction = actAutofixLong ) then
        for CDLoop := 1 to 10 do
        begin
          if ( Cfg.CDROM[CDLoop] in ['A'..'Z'] ) then
          begin
            ScanCD( Cfg.CDROM[CDLoop] + ':' );
            with FileRec do
              if FileExist( Cfg.CDROM[CDLoop] + ':\' + CDPath ) and
                 FindStr( FileName, CDPath ) then
              begin
                CDROM := CDLoop;
                Autofix := TRUE;
                Exit;
              end;
          end;
        end;

      Autofix := FALSE;
    end;
{}end; { function Autofix }

begin
  if SkipSize or SkipDate then
  begin
    if SkipSize then Writeln( '- No size update will be done' );
    if SkipDate then Writeln( '- No date update will be done' );
  end
  else Writeln( '- Both size and date will be updated' );
  if CheckExist then
  begin
    case CheckAction of
      actAutofix: Writeln( '- Check files, attempt to autofix' );
      actAutofixLong: Writeln( '- Check files, attempt to autofix, scan CD''s' );
      actDelete: Writeln( '- Check files, delete if not found' );
    end;
  end;
  fioFindAreaCode( AreaRec, AreaCode, 0 );
  Writeln( '- Searching for files in ' + AreaRec.AreaName );
  Writeln;

  FPos := 0;
  while fioReadFileRec( FileRec, AreaRec, FPos ) do
  begin
    Inc( FPos );
    if ( KilledFile in FileRec.FileFlags ) then Continue;

    with FileRec do
    begin
      if LookInIf( UpStr( FileName ), FileSpec ) then
      begin
        Changed := FALSE;
        Write( Fill( FileName, 16, ' ' ));

        if fioFindDirNo( DirRec, DirNo, AreaRec, 0 ) then
        begin
          if ( CDROM = 0 ) then FilePath := DirRec.DiskDir + '\' + FileName
          else FilePath := Cfg.CDROM[CDROM] + ':\' + CDPath;

          if FileExist( FilePath ) then
          begin
            FindFirst( FilePath, AnyFile, SRec );

            if not SkipSize then
            begin
              OldSize := Size;
              Size := SRec.Size;

              if ( OldSize <> Size ) then
              begin
                Write( '  ', Size:10, '>', SRec.Size:10 );
                Changed := TRUE;
              end;
            end;

            if not SkipDate then
            begin
              OldDate := Date.Date;
              with Date.Date do
                Bits.Date( Year, Month, Day );
              if not ( LongInt( OldDate ) = LongInt( Date.Date )) then
              begin
                with Date.Date do
                  Write( '  ', I2S( Day, 2 ) + I2S( Month, 2 ) + I2S( Year, 4 ) +'>' );
                with OldDate do
                  Write( I2S( Day, 2 ) + I2S( Month, 2 ) + I2S( Year, 4 ));
                Changed := TRUE;
              end;
            end;
          end
          else
          begin
            Write( '  not found' );
            if CheckExist then
            begin
              case CheckAction of
                actAutofix,
                actAutofixLong:
                begin
                  if Autofix then
                  begin
                    Write( ', path fixed' );
                    Changed := TRUE;
                  end
                  else Write( ', unable fix path' );
                end;
                actDelete:
                begin
                  FileFlags := FileFlags + [KilledFile];
                  Write( ', killed' );
                  Changed := TRUE;
                end;
              end;
            end;
          end;
        end
        else
          Write( '  can''t find directory' );

        if Changed then
        begin
          fioWriteFileRec( FileRec, AreaRec, FileRec.RecPos );
          Write( '  updated' );
        end;

        if ( WhereX = 17 ) then Write( Fill( '', 16, #8 ))
        else Writeln( '.' );
      end;
    end;
  end;
end; { procedure UpdateFile }

begin
  Writeln;
  Writeln('UpdFile v1.05 - Update file date and size information in FOSS/2 filedatabase');
  Writeln;

  if not ( Par^.Count = 1 ) then
  begin
    Writeln( 'Usage:' );
    Writeln( '   UPDFILE {{-C[D|P]}|{-D} {-S}} {-A[area]} [filespec]' );
    Writeln;
    Writeln( '   -CD          Check if file(s) exists, delete files not found' );
    Writeln( '   -CA          Check if file(s) exists, attempt to fix files not found' );
    Writeln( '   -CL          Check if file(s) exists, attempt to fix files not found' );
    Writeln( '                Scan CD''s (time consuming)' );
    Writeln( '   -D           Do not update "date" information' );
    Writeln( '   -S           Do not update "size" information' );
    Writeln( '   -A           Area code of area to update files in' );
    Writeln( '                (Default: MAIN)' );
    Writeln( '   [filespec]   Name of the file to update (wildchars accepted) ');
    Exit;
  end;

  New( UpdFiles, Init );
  UpdFiles^.ReadParams;
  UpdFiles^.UpdateFiles;
  Dispose( UpdFiles, Done );
end. { Write DumpDir }