T1ASM (1)                                               T1ASM (1)


NAME
     t1asm - assemble type-1 font

SYNOPSIS
     t1asm [-b][-l length][input[output]]

DESCRIPTION
     t1asm assembles Adobe type-1 font programs into either PFA
     (hexadecimal) or PFB (binary) formats from a human-readable
     form.  If the file output is not specified output goes to
     the standard output.  If the file input is not specified
     input comes from the standard input.  In this way t1asm can
     be used as a filter.

     t1asm tokenizes the charstring data and performs eexec and
     charstring encryption as specified in the Adobe Type 1 Font
     Format, the Adobe black book.

     The input is required to have a line of the form

     /-|{string currentfile exch readstring pop}executeonly def

     which defines the command, in this case `-|', that is to
     start charstring data.  It is an error not to define such a
     command.  Another common name for this command is `RD'.

     After the start of the Subrs array in the input, all open
     braces `{' not in a comment begin a charstring.  Such a
     charstring is terminated by the next non-comment close brace
     `}'.  Within such a charstring, only comments, integers, and
     valid charstring commands are allowed.  The format within a
     charstring is unimportant as long as integers and commands
     are separated by at least a one whitespace (space, tab, new-
     line) character.  Note that within charstrings, comments are
     discarded because they cannot be encoded.

OPTIONS
     -b
        Output in PFB (binary) format.
     -l length
        Set the maximum length of sections in PFB output to
        length.  Default value is 32 KB.  This option has no
        effect on PFA output.

EXAMPLES
     t1asm Utopia-Regular.raw Utopia-Regular.pfa
     t1asm -b Utopia-Regular.raw Utopia-Regular.pfb

SEE ALSO
     t1disasm (1), t1ascii (1), t1binary(1),
     Adobe Type 1 Font Format

BUGS
     None known.

AUTHOR
     Lee Hetherington (ilh@lcs.mit.edu)

     Ported to Microsoft C/C++ Compiler and MS-DOS operating
     system by Kai-Uwe Herbing (herbing@netmbx.netmbx.de)

                          June 12, 1992
