Nicolas Leblanc #2 @20302
Sun Jun 18 23:43:15 1995
             
                       Alternative Worlds Presents                      
   Ŀ
    Mod Name        FMD-41a.MOD                                        
    Difficulty      ۱ (3/10)                                 :
    WWIV Version    4.24                                               
    Date Affected   06/01/95                                           
   : Files Affected  BBS.C / BBSOVL1.C / VARS.H / VARDEC.H              
    Description     Time Window Modification                           
    ſ
           A French Mod Division Release - (C) 1995 FMD Software         
          


 Ϳ
  Long Description 
  

  This modification will allow your users to reserve themselves a time on your
system, so they will be sure to have the line. This modification will keep a
"time window" of 15 minutes (configurable) so this user can call, and only
that user. If a user logs before the time window and he has more time
available than the time left before the time window, his time will be
truncated and saved for later use.


NOTE: This modification is an update of a previous modification released for
      WWIV v4.11 and has been updated by several authors so far. This is the
      original update for the version v4.23 and v4.24 of WWIV. The original
      filename was TIMEMOD2.DOC

Revision A:

 - Updated for WWIV v4.24
 - Fixed the problem when the user who reserved a time log on

 Ϳ
  Tests 
  

  This modification has been tested on a virgin WWIV v4.24 source using
  Borland C++ v4.5


                                   Legend
                          Ϳ
                           +  Add This Line    
                           -  Delete This Line 
                           *  Modify This Line 
                           =  Existing Line    
                          ͼ
[Step 1]

Load BBSOVL1.C and copy the following functions at the end of the file.

#include <dir.h>

void timeedit(void)
{
  char ch, s1[81];
  tmod t;
  int  f, t2file, i, j, done;
  long currrec;
  char save2[81], save1[81];

  done = 0;
  do
  {
    if ((sysstatus_expert & thisuser.sysstatus)==0)
     printmenu(40);
    tleft(1);
    nl();
    npr("1T 0- 1%s\r\n",ctim(nsl()));
    prt(2, "TimeWindow: Q,A,E,D,L,?: ");
    ch=onek("Q?AEDL");
    switch(ch)
    {
      case 'Q': done=1; break;
      case 'A':
        prt(1, "Hour (0-24)? ");
        input(save1, 2);
        nl();
        prt(2, "Minute (0-59)? ");
        input(save2, 2);
        nl();
        j=(60*(atoi(save1)) + (atoi(save2)));
        sprintf(s1, "%sTIMEMOD.DAT", syscfg.datadir);
        f = sh_open(s1, O_RDWR | O_CREAT | O_APPEND | O_BINARY, S_IREAD | S_IWRITE);
        currrec = filelength(f) / (long)sizeof(tmod);
        /* Check to see if user already signed up for time. */
        while ((currrec > 0) && (!hangup))
        {
          sh_lseek(f, (currrec - 1) * (long)sizeof(tmod), SEEK_SET);
          currrec--;
          sh_read(f, (void *)(&t), sizeof(tmod));
          /* If thisuser.name = t.username then exit */
          if (!strcmp(thisuser.name, t.username))
          {
            prt(2, "You've already reserved a time!");
            nl();
            sh_close(f);
            done=1;
            break;
          }

          /* If time already taken then exit */
          /* j = requested time...i=one of the taken times.  */
          i = 60*(atoi(t.userhour)) + (atoi(t.usermin));
          if ((j>=i) && (j<=i+15))
          {
            prt(2, "Time span already reserved! Try another time.");
            nl();
            sh_close(f);
            done=1;
            break;
          }
        }
        sh_close(f);
        if (!done)
        {
          sprintf(s1, "%sTIMEMOD.DAT", syscfg.datadir);
          f = sh_open(s1, O_RDWR | O_CREAT | O_APPEND | O_BINARY, S_IREAD | S_IWRITE);
          t.username[0]=0;
          strcpy(t.username, thisuser.name);
          strcpy(t.userhour, save1);
          strcpy(t.usermin, save2);
          sh_write(f, (void *)(&t), sizeof(tmod));
          sh_close(f);
        } else {
          done=0;
        }
      break;
      case 'E':
        done = 0;
        prt(1, "Hour (0-24)? ");
        input(save1, 2);
        nl();
        prt(2, "Minute (0-59)? ");
        input(save2, 2);
        nl();
        j=(60*(atoi(save1)) + (atoi(save2)));
        sprintf(s1, "%sTIMEMOD.DAT", syscfg.datadir);
        f = sh_open(s1, O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
        currrec = filelength(f) / (long)sizeof(tmod);
        /* Check to see if user already signed up for time. */
        while ((currrec > 0) && (!hangup))
        {
          sh_lseek(f, (currrec - 1) * (long)sizeof(tmod), SEEK_SET);
          currrec--;
          sh_read(f, (void *)(&t), sizeof(tmod));

          /* If time already taken then exit */
          /* j = requested time...i=one of the taken times.  */

          i = 60*(atoi(t.userhour)) + (atoi(t.usermin));
          if ((j>=i) && (j<=i+15))
          {
            prt(2, "Time span already reserved! Try another time.");
            nl();
            done=1;
            break;
          }
        }
        sh_close(f);
        sprintf(s1, "%sTIMEMOD.DAT", syscfg.datadir);
        f = sh_open(s1, O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
        currrec = filelength(f) / (long)sizeof(tmod);
        /* Find users record and allow editing */
        while ((currrec > 0) && (!hangup) && (!done))
        {
          sh_lseek(f, (currrec - 1) * (long)sizeof(tmod), SEEK_SET);
          currrec--;
          sh_read(f, (void *)(&t), sizeof(tmod));
          /* If thisuser.name = t.username then */
          if (!strcmp(thisuser.name, t.username))
          {
            sh_lseek(f, (currrec) * (long)sizeof(tmod), SEEK_SET);
            strcpy(t.userhour, save1);
            strcpy(t.usermin, save2);
            sh_write(f, (void *)(&t), sizeof(tmod));
            sh_close(f);
            nl();
            currrec = 0.0;
          }
        }
        sh_close(f);
      break;
      case 'D':
        sprintf(s1, "%sTIMEMOD.DAT", syscfg.datadir);
        f = sh_open1(s1, O_RDWR | O_BINARY);
        strcpy(s1, syscfg.datadir);
        strcat(s1, "TIMEMOD.TMP");
        remove(s1);
        t2file = sh_open(s1, O_RDWR | O_CREAT | O_APPEND | O_BINARY, S_IREAD | S_IWRITE);
        currrec = filelength(f) / (long)sizeof(tmod);
        /* Check to see if user already signed up for time. */
        while ((currrec > 0) && (!hangup))
        {
          sh_lseek(f, (currrec - 1) * (long)sizeof(tmod), SEEK_SET);
          currrec--;
          sh_read(f, (void *)(&t), sizeof(tmod));
          /* If thisuser.name = t.username then exit */
          if (strcmp(thisuser.name, t.username))
            sh_write(t2file, (void *)(&t), sizeof(tmod));
        }
        sh_close(f);
        sh_close(t2file);
        sprintf(s1, "%sTIMEMOD.DAT", syscfg.datadir);
        remove(s1);
        chdir("DATA");
        rename("TIMEMOD.TMP", "TIMEMOD.DAT");
        chdir("..");
        nl();
      break;
      case 'L':
        nl();
        prt(7, "User Name                       Time");
        nl();
        prt(3, "------------------------------- ---------");
        nl();
        sprintf(s1, "%sTIMEMOD.DAT", syscfg.datadir);
        f=sh_open1(s1, O_RDONLY | O_BINARY);
        currrec=filelength(f) / sizeof(tmod);
        for (i=0; i<currrec; i++)
        {
          sh_lseek(f, (long) (i * sizeof(tmod)), SEEK_SET);
          sh_read(f, (void *)(&t), sizeof(tmod));
          npr("%s%s%s:%s\r\n", t.username, charstr(33-strlen(t.username), ' '),
               t.userhour, t.usermin);
        }
        nl();
        sh_close(f);
      break;
      case '?': printmenu(40); break;
    }
  } while ((!done) && (!hangup));
  nl();
}

void check_time_window(void)
{
  tmod t;
  struct tm *currtime;
  long currrec, secs;
  char fname[81];
  int f, timetmp, holdtime, delta=24*60,  nextwindow=-1;
  int found=0, firstwindow=24*60;

  time_next_call = 0;
  time(&secs);
  currtime = localtime(&secs);
  holdtime = 60*currtime->tm_hour + currtime->tm_min;
  sprintf(fname, "%sTIMEMOD.DAT", syscfg.datadir);
  f = sh_open1(fname, (O_RDWR | O_BINARY));
  currrec = filelength(f) / (long)sizeof(tmod);
  while (currrec>0 && !hangup)
  {
    sh_lseek(f, (currrec - 1) * (long)sizeof(tmod), SEEK_SET);
    currrec--;
    sh_read(f, (void *)(&t), sizeof(tmod));
    timetmp = atoi(t.userhour)*60 + atoi(t.usermin);
    if (timetmp < firstwindow)
      firstwindow = timetmp;
    if ( holdtime>=timetmp && holdtime<=timetmp+WINDOWSIZE && !found)
    {
      if (strcmp(thisuser.name, t.username))
      {
        pl("A time window is currently active.  Please call back later.");
        hangup=1;
      } else {
        found++;
      }
    } else {
       if ( timetmp-holdtime<delta && timetmp-holdtime>0 &&
           strcmp(thisuser.name, t.username) &&
           !found) {
          nextwindow = timetmp;
       }
    }
  }
  if (nextwindow==-1 && firstwindow!=24*60)
    nextwindow = firstwindow;
  if (nextwindow!=-1 && nextwindow < holdtime)
    holdtime = holdtime - 24*60;
  strcpy(wd_username, t.username);
  wd_holdtime = holdtime;
  wd_nextwindow = nextwindow;             /* quick and dirty, but works. */
  sh_close(f);
}

[Step 2]

Load MMENU.C and do the following change to function mainmenu:

=      case '#':
=        nl();
=        pl(get_string(939));
=        nl();
=      case '*':
=#ifdef RIPDRIVE
=        rd_coff();
=#endif
=        sublist();
=#ifdef RIPDRIVE
=        rd_con();
=#endif
=        break;
+      case '%': timeedit(); break;
=    }
=  }

[Step 2]

Load BBS.C and go to function main and do the following changes:

=            write_inst(INST_LOC_MAIN,usub[cursub].subnum,INST_FLAGS_NONE);
=            mainmenu();
=          break;
=        }
=      }
+      if (time_next_call)
+        thisuser.extratime += time_next_call;
=      logoff();
=      end_rip();
=    }

[Step 4]

Load VARDEC.H and do add the following structure at the end of confrec:

/* Time Window's structure */
typedef struct {
        char            username[31];  /* Name of owner */
        char            userhour[51];  /* Hour of reservation */
        char            usermin[51];   /* Mins of reservation */
        char            reserved[30];  /* Reserved for later use */
} tmod;

[Step 5]

Load LILO.C and do the following change to function getuser:

=        npr("%d!",i);
=        nl();
=        continue;
=      }
=      ok=1;
=      actsl = syscfg.newusersl;
=      topscreen();
+      check_time_window();
=      outstr(get_string(357));

And lower in function logon:

=  }
=  if (live_user) {
=    nl();
+    if ( wd_nextwindow!=-1 &&
+         wd_holdtime*60+(long int) nsl() > wd_nextwindow*60 &&
+         wd_holdtime < wd_nextwindow &&
+         strcmp(wd_username, thisuser.name)) {
+      wd_nextwindow *= 60;
+      wd_holdtime *= 60;
+      time_next_call = nsl() - (wd_nextwindow - wd_holdtime);
+      thisuser.extratime -= time_next_call;
+      pl("\76A time window will soon be active.  Your time has been reduced.");
+      nl();
+    }
=
=    outstr(get_string(237));
=    pl(nam(&thisuser,usernum));
=    outstr(get_string(363)); npr("%d\r\n", (int) ((nsl()+30)/60.0));

[Step 6]

Load VARS.H and do the following changes:

=               ver_no2[51],wwiv_net_no[20], xdate[9], *xenviron[50],
*               dlfn[81],edlfn[81], nete[5], irt_sub[81], wd_username[31];

Lower...

= __EXTRN__ long hanguptime1, last_time_c, nscandate, this_date,
=                timelastchar1, quotes_nrm_l, quotes_ind_l,
*                mult_time, num_listed, wd_holdtime, wd_nextwindow;
=
= __EXTRN__ unsigned long *dir_dates, *sub_dates, g_flags;
=
= __EXTRN__ unsigned long *qsc, *qsc_n, *qsc_q, *qsc_p;
=
=
* __EXTRN__ float batchtime, time_next_call;
=

And then add this line at the end of the file:

/* Time Window's Size (Minutes) */
#define WINDOWSIZE 15

[Step 7]

Update your menus to add "%" as the time window (or reservation) and add the
file MENU40.MSG to your GFILES directory.

[Step 8]

That's it, simply do a MAKE FCNS and recompile the entire system.

Enhancements of this modification will be done by request, if you like this
modification, please tell us what can be added to this modification and it
will be our pleasure to update it. We plan to add a "day" field and to
auto-remove the time window after the user logs on, and we plan many
enhancements of the modification. A better instance support and multiple
configuration should be added to the list with a v4.24 version, since
configuration will be easier with the WWIV.INI file.


French Proverb: Si l'on force trop, la corde casse; Si l'on ne force pas assez,
                la corde joue mal.

For comments, bug report and suggestion, e-mail at the following address:

Nicolas LeBlanc  2@20302.WWIVnet (aka Spotnick)
                 -> spotnick@gamemaster.qc.ca
Martin Bourdages 242@20306 / 3@20302.WWIVnet (aka Dark Shadow)
                 -> martin.bourdages@radio.magicnet.com

                 =>   French Mod Division Support Sub   <=
                                SubType: FMD
                           Host: @20302 (WWIVnet)
                      Scan sublist for other networks

        Read PRODUCTS.FMD for the full list of our support systems.

[EOF]
