// ************************************************************************* //
// Begin COMMON mod, functions that are common amoung many Asylum releases   //
// If you get a duplicate function error, then you have it installed twice   //
// remove your oldest duplicated functions.                                  //
// ************************************************************************* //
// These are the non-overlayed functions to help out on speed

#include "vars.h"
#pragma hdrstop


#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <conio.h>



// Will search the batch queue for the file specified by fn and return where it
// is in the batch queue
int find_batch_queue(char *fn)
{
  int i;

  for (i=0; i<numbatch; i++) {
    if (strcmp(fn,batch[i].filename)==0)
//      if (batch[i].sending)
        return(i);
  }

  return(-1);
}


// Removes a file off the batch queue specified by fn
void remove_batch(char *fn)
{
  int x;
  
  x = find_batch_queue(fn);
  if(x > -1)
    delbatch(x);
}


void BEEP(void)
{
  outstr("\007");
}

// Clears to end of line
void EOL(void)
{
  outstr("\033[K");
}

// This will count how many items you have in a list, but the list is defined
// as a regualr char string, therefore you must define how wide and how many
// coloumns you have.  The list must end in a 0 for this function to find the
// end of it...
int pd_amount_in_list(char *list, int rows, int cols)
{
  int x=0;
  while(list[x*(cols)] && !hangup)
  {
    ++x;
    if(x>=rows)
      return(rows);
  }
  return(x);
}



// This will 'strip' all white spaces from the front and end of a string
// Will turn '     This is me   ' -=> 'This is me'
// 4.23 has a trimstr which will 'trim' the left part of the string
char * strip_string(char *string)
{
  int x=0, y;
  while(isspace(string[x]) && string[x] && !hangup)
    ++x;
    
  y=strlen(string);
  memmove(string, string+x, y-x+1);
  string[y-x]=0;
  
  y=strlen(string);
  --y;
  
  while(isspace(string[y]) && y >= 0 && !hangup)
    --y;
    
  string[y+1]=0;
  
  
  return(string);
}

// Fixes one of wwiv's 'aligned' files ie... "FILE    .ARJ" -> "FILE.ARJ"
char *unalign(char *filename)
{
  char *temp, *exttemp;

  temp=strstr(filename, " ");
  if(temp)
  {
    temp[0]=0;
    ++temp;

    exttemp=strstr(temp, ".");
    if(exttemp)
      strcat(filename, exttemp);
  }
  return(filename);
}

