/*
 * assign a WPS .SUBJECT EA to a file.
 * SUBJ for help.
 */

oldsubj = ''
parse arg filename text
text = left(text,40)
text = strip(text)
filename = strip(filename)
if left(filename,1) = d2c(34) then
do
  text = ''
  parse arg filename
  filename = substr(filename,2)
  if right(filename,1) = d2c(34) then
    filename = left(filename,length(filename) - 1)
end
if filename = '/?' then filename = ''
if filename \= '' then
do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
  if text = '' then
  do
    /* note how this obtains and displays an existing .SUBJECT EA
       you can use this as a pattern for your own rexx programs that
       manipulate .SUBJECT EAs */
    if SysGetEA(filename,'.SUBJECT','oldsubj') = 0 then
    text = oldsubj
    do
      if text \= '' then
        say 'Current .SUBJECT: 'substr(text,5)
    end
    /* get input from user for new subject text */
    say 'Enter new .SUBJECT (or press CTRL-C then [Enter] to abort): '
    pull text
    text = left(text,40)
    text = strip(text)
  end
  if text \= '' then
  do
    /* build the .SUBJECT EA data in variable description.
       note that variable text contains the string,
       and description is prepared with essential information,
       then has the string added to it.  you can use this as a
       pattern for writing your own rexx programs that manipulate
       .SUBJECT EAs. */
    description = 'FDFF'x || d2c(length(text)) || '00'x || text
    /* now place the constructed EA data into the file's .SUBJECT EA */
    call SysPutEA filename,'.SUBJECT',description
    /* grab EA again and display for feedback to user */
    call SysGetEA filename,'.SUBJECT','text'
    say filename"'s subject is now: "substr(text,5)
  end
  else
  do
    /* erase the old .SUBJECT EA */
    call SysPutEA filename,'.SUBJECT',''
    if oldsubj \= '' then
      say 'Erased 'filename"'s subject."
  end
end
else
do
  say 'SUBJ is a utility to set .SUBJECT EAs from the command line.'
  say ''
  say 'Usage: SUBJ filename text for subject'
  say '    or SUBJ filename (display old subject, allows entry of new)'
  say ''
  say ' filename is required.  If filename contains blanks, surround filename'
  say ' with quote marks and do _not_ give a subject on the command line (must'
  say ' be entered interactively).'
  say ''
  say 'Examples: SUBJ filename'
  say '          SUBJ filename A most useful comment'
  say '          SUBJ 'd2c(34)'a long filename'd2c(34)
  say ''
  say 'Hector wuz here.'
end
