
(**********************************************************************)
(* Simple program to build two random encryption-code strings, and    *)
(* then save them to disk.                                            *)
(**********************************************************************)

program Make_Random_Encryption_Codes;

type          (* 20 character string definition.                      *)
  st_20 = string[20];

var           (* String index variable.                               *)
  Index,

              (* Used to store the value of "ioresult".               *)
  ErrorCode : byte;

              (* 2 encryption-code strings.                           *)
  Ecode1,
  Ecode2    : st_20;

              (* Temporary file varialble.                            *)
  TempFile  : file;

              (* Main program execution block.                        *)
BEGIN
              (* Clear the encryption-code strings.                   *)
  fillchar(Ecode1, sizeof(Ecode1), 0);
  fillchar(Ecode2, sizeof(Ecode2), 0);

              (* Set the length byte for both encryption-code strings *)
              (* to 20.                                               *)
  Ecode1[0] := #20;
  Ecode2[0] := #20;

              (* Ensure that the data will be random.                 *)
  randomize;

              (* Assign random data to each of the encryption-code    *)
              (* strings.                                             *)
  for Index := 1 to 20 do
    begin
      Ecode1[Index] := chr(random(256));
      Ecode2[Index] := chr(random(256))
    end;

              (* Open first encryption-code string file.              *)
  assign(TempFile, 'ECODE1.DAT');
  {$I-}
  rewrite(TempFile, 1);
  {$I+}

              (* Check for errors.                                    *)
  ErrorCode := ioresult;
  if (ErrorCode <> 0) then
    begin
      writeln(' Error ', ErrorCode, ' opening "ECODE1.DAT" file.');
      halt
    end;

              (* Write first ecryption-code string to disk.           *)
  writeln;
  writeln(' Writing first encryption-code to disk.');
  blockwrite(TempFile, Ecode1, succ(length(Ecode1)));

              (* Check for errors.                                    *)
  ErrorCode := ioresult;
  if (ErrorCode <> 0) then
    begin
      writeln(' Error ', ErrorCode,
                                 ' writing data to "ECODE1.DAT" file.');
      halt
    end;

              (* Close first encryption-code string file.             *)
  close(TempFile);

              (* Check for errors.                                    *)
  ErrorCode := ioresult;
  if (ErrorCode <> 0) then
    begin
      writeln(' Error ', ErrorCode, ' closing "ECODE1.DAT" file.');
      halt
    end;

              (* Open second encryption-code string file.             *)
  assign(TempFile, 'ECODE2.DAT');
  {$I-}
  rewrite(TempFile, 1);
  {$I+}

              (* Check for errors.                                    *)
  ErrorCode := ioresult;
  if (ErrorCode <> 0) then
    begin
      writeln(' Error ', ErrorCode, ' opening "ECODE2.DAT" file.');
      halt
    end;

              (* Write second ecryption-code string to disk.          *)
  writeln;
  writeln(' Writing second encryption-code to disk.');
  blockwrite(TempFile, Ecode2, succ(length(Ecode2)));

              (* Check for errors.                                    *)
  ErrorCode := ioresult;
  if (ErrorCode <> 0) then
    begin
      writeln(' Error ', ErrorCode,
                                 ' writing data to "ECODE2.DAT" file.');
      halt
    end;

              (* Close second encryption-code string file.            *)
  close(TempFile);

              (* Check for errors.                                    *)
  ErrorCode := ioresult;
  if (ErrorCode <> 0) then
    begin
      writeln(' Error ', ErrorCode, ' closing "ECODE1.DAT" file.');
      halt
    end

END.


