// ==========================================================================
// 						Class Specification : CXString
// ==========================================================================

// Header file : xstring.h

// Source : Periphere NV (R.Mortelmans)
// Creation Date : 	   2nd November 1995
// Last Modification : 2nd November 1995
                          
// //////////////////////////////////////////////////////////////////////////

// Properties:
//	NO	Abstract class (does not have any objects)
//	YES	Derived from CString

//	NO	Is a Cwnd.                     
//	NO	Two stage creation (constructor & Create())
//	NO	Has a message map
//	NO  Needs a resource (template)

//	YES	Persistent objects (saveable on disk)      
//	NO	Uses exceptions

// //////////////////////////////////////////////////////////////////////////

// Desciption :         
//		Here some usefulle extensions to the CString class are made available                                              

// Remark:
//		A "white space" character is a character in the range 0x09 - 0x0D or 0x20.
//			0x09 : HT : Horizontal Tab	(\t)
//			0x0A : LF : Linefeed        (part of \n)
//			0x0B : VT : Vertical Tab    (\v)
//			0x0C : FF : Formfeed		(\f)
//			0x0D : CR : Carriage return (part of \n)
//			0x20 : space
//		

// Prerequisites (necessary conditions):
//		

/////////////////////////////////////////////////////////////////////////////

#ifndef __XSTRING_H__
#define __XSTRING_H__

class CXString : public CString
{
// Data members -------------------------------------------------------------
public:
protected:
	static char cDecimalCharacter;
private:
	
// Member functions ---------------------------------------------------------
public:
	CXString();
	// --- In  :
	// --- Out : 
	// --- Returns :
	// --- Effect : Contructor of object
	//				It will initialize the internal state

	CXString::CXString(const char* psz);
	// --- In  : psz
	// --- Out : 
	// --- Returns :
	// --- Effect : Contructor of object out of a pointer to const char
	//				(conversion operator)
	
	CXString(const CString& sSource);
	// --- In  : sSource
	// --- Out : 
	// --- Returns :
	// --- Effect : Contructor of object out of a CString object
	//				(conversion operator)

	CXString(LONG nSource);
	// --- In  : nSource
	// --- Out : 
	// --- Returns :
	// --- Effect : Contructor of object out of an int
	//				(conversion operator)

	CXString(const CXString& sString);
	// --- In  : xString : the CXString object to be copied
	// --- Out : 
	// --- Returns : 
	// --- Effect : this is the copy constructor

	CXString& operator=(const CXString& sString);
    // --- In  : xString : the CXString object to be copied
	// --- Out : 
	// --- Returns : 
	// --- Effect : this is the assignment operator

	BOOL CXString::operator==(const CXString& s2) const;
	// --- In  : s2 : The second string
	// --- Out : 
	// --- Returns : Whether the 2 strings (this and s2) are the same
	// --- Effect :  This function compares the 2 contents of the string, 
	//				 regardless whether they contain NULL-characters
	//				 This patches the unexpected behaviour of CString::operator== when a string
	//				 contains NULL-characters

	int GetInt() const;
	// --- In  : 
	// --- Out : 
	// --- Returns : The numeric value represented in the string.
	// --- Effect :  The conversion stops at the first character it does not 
	//				 recognize as part of the number

	long GetLongInt() const;
	// --- In  : 
	// --- Out : 
	// --- Returns : The numeric value represented in the string.
	// --- Effect :  The conversion stops at the first character it does not 
	//				 recognize as part of the number

	void LTrim();
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : Removes leading white spaces

	void RTrim();
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : Removes trailing white spaces

	void XTrim();
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : Replaces multiple white space characters by one space character

	BOOL IsInt();
	// --- In  : 
	// --- Out : 
	// --- Returns : Whether the string contains only digits (TRUE) or not (FALSE)
	//				 Digits are the characters 0 ... 9
	// --- Effect :  
	
	BOOL IsNumber();
	// --- In  : 
	// --- Out : 
	// --- Returns : Whether the string represents a valid number
	// --- Effect :  A valid number has the syntax :
	// 		[whitespace] [sign] [digits] [.digits] [ {d | D | e | E}[sign]digits] [whitespace]
	// 		A whitespace consists of space and tab characters, which are ignored; 
	// 		sign is either plus (+) or minus (-); and digits are one or more 
	// 		decimal digits. If no digits appear before the decimal point, 
	// 		at least one must appear after the decimal point. 
	// 		The decimal digits can be followed by an exponent, which consists of 
	// 		an introductory letter (b, D, e, or E) and an optionally signed decimal integer.
	
	void Format(const char* pszFormat, const char** rglpsz, int nString);
	// --- In  :pszFormat : The format specifier containing %1, %2 etc
	//			rglpsz : Pointer to array of strings that must replace %1 etc
	//			nString : The number of strings in the array
	// --- Out : 
	// --- Returns :
	// --- Effect : Substitues all occurences of %1, %2 etc by the corresponding string
	//				in the array
	
	void BarToNull();
	// --- In  :
	// --- Out : 
	// --- Returns :
	// --- Effect : Replaces all the vertical bars ('|') in this string
	//              by NULL-characters
	//				The length of the string stay the same
	//				Because there are NULL-characters embedded within the string
	//              now, be careful when using certain functions

	virtual ~CXString();
	// --- In  :
	// --- Out : 
	// --- Returns :
	// --- Effect : Destructor of object

protected:

private:

};

#endif
// ==========================================================================
