// --------------------------------------------------------------------------
//  FLIP32.CPP           copyright (c) 1996-97, Xavier Defrang (aka brioche)
// --------------------------------------------------------------------------
//  simple demonstration of what FLIP32 is able to do...
// --------------------------------------------------------------------------
//  e-mail: 106146.1452@compuserve.com
// --------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "types.h"
#include "flip32.h"

#define FLI_NAME "nice.fli"

UBYTE *vga = (UBYTE *)0xa0000;

// --------------------------------------------------------------------------

void flip32_play( void )
{
 framecnt = 0;
 while ( !kbhit() ) 
 {
  fread( &framehdr, 0x10, 1, flifile );
  fread( framebuf, framehdr.size-0x10, 1, flifile );
  flip32_unpack( framebuf, vga, framehdr.chunks );
  flip32_wait( flihdr.speed );  
  if ( framecnt++ == flihdr.frames ) 
  {
   fseek( flifile, 0x80, SEEK_SET );
   framecnt = 0;
  }
 }
}

// --------------------------------------------------------------------------

void printmsg( const char *msg )
{
 printf( "[FLIP32] %s\n", msg );
}

// --------------------------------------------------------------------------

void main( void )
{
 vmode( 0x03 );

 puts( "FLIP32 version 0.6B  by Xavier Defrang" );
 puts( "32-bit protected mode animation player\n" );

 if ( !( flip32_init() ) ) return;

 if ( !( flip32_load( FLI_NAME ) ) )
 {
  flip32_done();
  return;
 }

 printmsg( "press any key to play animation..." );

 getch();

 vmode( 0x13 );

 flip32_play();

 vmode( 0x03 );

 flip32_close();

 flip32_done();

 printmsg( "ending." );
}
