 
Flic Files (.FLI) Format description:
 
     The details of a FLI file are moderately complex, but the
idea behind it is simple: don't bother storing the parts of a
frame that are the same as the last frame.  Not only does this
save space, but it's very quick.  It's faster to leave a pixel
alone than to set it.
 
     A FLI file has a 128-byte header followed by a sequence of
frames. The first frame is compressed using a bytewise run-length
compression scheme.  Subsequent frames are stored as the
difference from the previous frame.  (Occasionally the first
frame and/or subsequent frames are uncompressed.)  There is one
extra frame at the end of a FLI which contains the difference
between the last frame and the first frame.
 
     The FLI header:
 
     byte size name      meaning
     offset
 
     0    4    size      Length of file, for programs that want
                         to read the FLI all at once if possible.
     4    2    magic     Set to hex AF11.  Please use another
                         value here if you change format (even to
                         a different resolution) so Autodesk
                         Animator won't crash trying to read it.
     6    2    frames    Number of frames in FLI.  FLI files have
                         a maxium length of 4000 frames.
     8    2    width     Screen width (320).
     10   2    height    Screen height (200).
     12   2    depth     Depth of a pixel (8).
     14   2    flags     Must be 0.
     16   2    speed     Number of video ticks between frames.
     18   4    next      Set to 0.
     22   4    frit      Set to 0.
     26   102  expand    All zeroes -- for future enhancement.
 
     Next are the frames, each of which has a header:
 
     byte size name      meaning
     offset
     0    4    size      Bytes in this frame.  Autodesk Animator
                         demands that this be less than 64K.
     4    2    magic     Always hexadecimal F1FA
     6    2    chunks    Number of 'chunks' in frame.
     8    8    expand    Space for future enhancements.  All
                         zeros.
 
     After the frame header come the chunks that make up the
frame.  First comes a color chunk if the color map has changed
from the last frame.  Then comes a pixel chunk if the pixels have
changed.  If the frame is absolutely identical to the last frame
there will be no chunks at all.
 
     A chunk itself has a header, followed by the data.  The
chunk header is:
 
     byte size name meaning
     offset
     0    4    size Bytes in this chunk.
     4    2    type Type of chunk (see below).
 
     There are currently five types of chunks you'll see in a FLI
file.
 
     number    name      meaning
     11        FLI_COLOR Compressed color map
     12        FLI_LC    Line compressed -- the most common type
                         of compression for any but the first
                         frame.  Describes the pixel difference
                         from the previous frame.
     13        FLI_BLACK Set whole screen to color 0 (only occurs
                         on the first frame).
     15        FLI_BRUN  Bytewise run-length compression -- first
                         frame only
     16        FLI_COPY  Indicates uncompressed 64000 bytes soon
                         to follow.  For those times when
                         compression just doesn't work!
 
     The compression schemes are all byte-oriented.  If the
compressed data ends up being an odd length a single pad byte is
inserted so that the FLI_COPY's always start at an even address
for faster DMA.
 
FLI_COLOR Chunks
     The first word is the number of packets in this chunk. This
is followed directly by the packets.  The first byte of a packet
says how many colors to skip.  The next byte says how many colors
to change.  If this byte is zero it is interpreted to mean 256. 
Next follows 3 bytes for each color to change (one each for red,
green and blue).
 
FLI_LC Chunks
     This is the most common, and alas, most complex chunk.   The
first word (16 bits) is the number of lines starting from the top
of the screen that are the same as the previous frame. (For
example, if there is motion only on the bottom line of screen
you'd have a 199 here.)  The next word is the number of lines
that do change.  Next there is the data for the changing lines
themselves.  Each line is compressed individually; among other
things this makes it much easier to play back the FLI at a
reduced size.
 
     The first byte of a compressed line is the number of packets
in this line.  If the line is unchanged from the last frame this 
is zero.  The format of an individual packet is:
 
skip_count
size_count
data
 
     The skip count is a single byte.  If more than 255 pixels
are to be skipped it must be broken into 2 packets. The size
count is also a byte.  If it is positive, that many bytes of data
follow and are to be copied to the screen.  If it's negative a
single byte follows, and is repeated -skip_count times.
 
     In the worst case a FLI_LC frame can be about 70K.  If it
comes out to be 60000 bytes or more Autodesk Animator decides
compression isn't worthwhile and saves the frame as FLI_COPY.
 
FLI_BLACK Chunks
     These are very simple.  There is no data associated with
them at all. In fact they are only generated for the first frame
in Autodesk Animator after the user selects NEW under the FLIC
menu.
 
FLI_BRUN Chunks
     These are much like FLI_LC chunks without the skips.  They
start immediately with the data for the first line, and go line-
by-line from there.  The first byte contains the number of
packets in that line.  The format for a packet is:
 
size_count
data
 
     If size_count is positive the data consists of a single byte
which is repeated size_count times. If size_count is negative
there are -size_count bytes of data which are copied to the
screen. In Autodesk Animator if the "compressed" data shows signs
of exceeding 60000 bytes the frame is stored as FLI_COPY instead.
 
FLI_COPY Chunks
     These are 64000 bytes of data for direct reading onto the
screen.
 
-----------------------------------------------------------------------
And here's the PRO extensions:
-----------------------------------------------------------------------
 
This is supplemental info on the AutoDesk Animator FLI and FLC formats.
 
The following is an attempt at describing the newer chunks and frames
that are not described in the Turbo C FLI library documentation.
 
  Chunk type       Chunk ID 
  ----------       -----------
  FLI_DELTA        7 (decimal)
  
  First WORD (16 bits) is the number of compressed lines to follow.  Next
  is the data for the changing lines themselves, always starting with the
  first line.   Each line is compressed individually.
 
  The first WORD (16 bits) of a compressed line is the number of packets in
  the line.  If the number of packets is a negative skip -packets lines.
  If the number of packets is positive, decode the packets.  The format of
  an individual packet is:
 
  skip_count
  size_count
  data
 
  The skip count is a single byte.  If more than 255 pixels are to be
  skipped, it must be broken into 2 packets.  The size_count is also a byte.
  If it is positive, that many WORDS of data follow and are to be copied to
  the screen.  If it is negative, a single WORDS value follows, and is to be
  repeated -size_count times.
  
  Chunk type       Chunk ID 
  ----------       -----------
  FLI_256_COLOR    4 (decimal)
 
  The first WORD is the number of packets in this chunk.  This is followed
  directly by the packets.  The first byte of a packet is how many colors
  to skip.  The next byte is how many colors to change.  If this number is
  0, (zero), it means 256.  Next follow 3 bytes for each color to change.
  (One each for red, green and blue).
 
  The only difference between a FLI_256_COLOR chunk (type 4 decimal) and a
  FLI_COLOR chunk (type 11 decimal) is that the values in the type 4 chunk
  range from 0 to 255, and the values in a type 11 chunk range from 0 to 63.
 
  NOTE:  WORD  refer to a 16 bit int in INTEL (Little Endian) format.
         WORDS refer to two-bytes (16 bits) of consecutive data. (Big Endian)
 
  .FLC special frames and chunks
 
  FLC's may contain all the above chunks plus one other:
 
  Chunk type       Chunk ID 
  ----------       -----------
  FLI_MINI         18 (decimal) 12 (Hex)
 
  From what I understand,  this is a miniture 64 x 32 version of the first
  frame in FLI_BRUN format, used as an button for selecting flc's from
  within Animator Pro.  Simply do nothing with this chunk.
 
  FLC New Frame
 
  FLC's also contains a frame with the magic bytes set to hex 00A1.  This
  is the first frame in the .flc file.  Actually it isn't a frame at all
  but to have several chunks within it that specify file location info
  specific to Animator Pro.  IE:  filepath, font to use, and .COL file info.
  This FRAME may be skipped while loading.  That's right!  Ignore it!  The
  frame header is the same length as all other frames.  So you may read the
  frame header, then skip past the rest of the frame.
 
 
  NOTE:  When reading the FLI header on the newer FLI and FLC files, the
  FLI signature bytes are AF12 instead of AF11 used in the older FLI files.
  Also, you cannot ignore the screen width and height they may not be
  320 x 200.
 
  Allowable screen sizes include:
 
  320 x 200, 640 x 480, 800 x 600, 1280 x 1024
 
 
  NOTE:  the delay value between frames appears to be in 1000th's of a
  second instead of 70th's.
 
If you have any questions or more info on the FLI or FLC formats,
please let me know.
 
Mike Haaland
 
CompuServe : 72300,1433
Delphi     : MikeHaaland
Internet   : mike@htsmm1.las-vegas.nv.us
Usenet     : ...!htsmm1.las-vegas.nv.us!mike
 
-----------------------------------------------------------------------
Can someone archive this somewhere and can the FAQ writer add a pointer
to it, please.
 
Mike Haaland
 
CompuServe : 72300,1433
Delphi     : MikeHaaland
Internet   : mike@htsmm1.las-vegas.nv.us
Usenet     : ...!htsmm1.las-vegas.nv.us!mike
--
 
 



