; void __asm decode_lc (register __a0 UBYTE *chunkbuf,
;                       register __a1 UBYTE *chunky,
;                       register __a3 UBYTE *dirty_list);

; void __asm decode_lc_xlate (register __a0 UBYTE *chunkbuf,
;                             register __a1 UBYTE *chunky,
;                             register __a2 UBYTE *xlate,
;                             register __a3 UBYTE *dirty_list);

		xdef	_decode_lc
		xdef	_decode_lc_xlate

		xref	_screen_width
		xref	_screen_width32

TRUE		equ	1

;  UBYTE a5 *chunky2;
;  UWORD d3 lines, d4 packets, d6 start;
;  UBYTE d5 bsize
;  d2 = TRUE
;  2nd low byte of d0 is always 0

_decode_lc:	movem.l	d2-d6/a2-a3/a5-a6,-(sp)

		moveq	#TRUE,d2	; d2 = TRUE
		moveq	#0,d0

		moveq	#0,d6		; start = *chunkbuf++;
		move.b	(a0)+,d6

		move.b	(a0)+,d1	; start |= (*chunkbuf++ << 8);
		lsl.w	#8,d1
		or.w	d1,d6

		move.w	(_screen_width),d1
		mulu	d6,d1		; chunky = &chunky[start * screen_width];
		adda.l	d1,a1

		lsr.l	#5,d1		; dirty_list = &dirty_list[start * screen_width32];
		adda.l	d1,a3

		moveq	#0,d3		; lines = *chunkbuf++;
		move.b	(a0)+,d3

		move.b	(a0)+,d1	; lines |= (*chunkbuf++ << 8);
		lsl.w	#8,d1
		or.w	d1,d3

		bra.b	end_loop1	; for ( ; lines > 0; lines--) {

loop1:		movea.l	a1,a5		; chunky2 = chunky;

		moveq	#0,d4		; for (packets = *chunkbuf++; packets > 0; packets--) {
		move.b	(a0)+,d4
		bra.b	end_loop2

loop2:		move.b	(a0)+,d0	; chunky2 += *chunkbuf++;
		adda.w	d0,a5

		move.l	a5,d6		; start = (chunky2 - chunky) >> 5;
		sub.l	a1,d6
		lsr.l	#5,d6

		move.b	(a0)+,d5	; bsize = *chunkbuf++;

		bpl.b	1$		; if (bsize > 127) {

		move.b	(a0)+,d0	; memset (chunky2, *chunkbuf++, 256-bsize);
2$:		move.b	d0,(a5)+
		addq.b	#1,d5
		bne.b	2$

		bra.b	4$		; } else {

1$:		move.b	(a0)+,(a5)+	; memcpy (chunky2, chunkbuf, bsize);
		subq.b	#1,d5		; chunkbuf += bsize;
		bne.b	1$

4$:		move.l	a5,d1		; memset (&dirty_list[start], TRUE,
		subq.l	#1,d1		;   ((chunky2-1-chunky) >> 5)-start+1);
		sub.l	a1,d1
		lsr.l	#5,d1
		sub.w	d6,d1
		addq.w	#1,d1
		lea	(a3,d6.w),a6
12$:		move.b	d2,(a6)+
		subq.w	#1,d1
		bne.b	12$

end_loop2:	dbra	d4,loop2

		adda.w	(_screen_width),a1	; chunky += screen_width;
		adda.w	(_screen_width32),a3	; dirty_list += screen_width32;

end_loop1:	dbra	d3,loop1

		movem.l	(sp)+,d2-d6/a2-a3/a5-a6
		rts


;------------------------------------------------------------------------

;  UBYTE a5 *chunky2;
;  UWORD d3 lines, d4 packets, d6 start;
;  UBYTE d5 bsize
;  d2 = TRUE
;  2nd low byte of d0 is always 0

_decode_lc_xlate: movem.l	d2-d6/a2-a3/a5-a6,-(sp)

		moveq	#TRUE,d2
		moveq	#0,d0

		moveq	#0,d6		; start = *chunkbuf++;
		move.b	(a0)+,d6

		move.b	(a0)+,d1	; start |= (*chunkbuf++ << 8);
		lsl.w	#8,d1
		or.w	d1,d6

		move.w	(_screen_width),d1
		mulu	d6,d1		; chunky = &chunky[start * screen_width];
		adda.l	d1,a1

		lsr.l	#5,d1		; dirty_list = &dirty_list[start * screen_width32];
		adda.l	d1,a3

		moveq	#0,d3		; lines = *chunkbuf++;
		move.b	(a0)+,d3

		move.b	(a0)+,d1	; lines |= (*chunkbuf++ << 8);
		lsl.w	#8,d1
		or.w	d1,d3

		bra.b	end_loopx1	; for ( ; lines > 0; lines--) {

loopx1:		movea.l	a1,a5		; chunky2 = chunky;

		moveq	#0,d4		; for (packets = *chunkbuf++; packets > 0; packets--) {
		move.b	(a0)+,d4
		bra.b	end_loopx2

loopx2:		move.b	(a0)+,d0	; chunky2 += *chunkbuf++;
		adda.w	d0,a5

		move.l	a5,d6		; start = (chunky2 - chunky) >> 5;
		sub.l	a1,d6
		lsr.l	#5,d6

		move.b	(a0)+,d5	; bsize = *chunkbuf++;

		bpl.b	1$		; if (bsize > 127) {

		move.b	(a0)+,d0	; memset (chunky2, xlate[*chunkbuf++], 256-bsize);
		move.b	(a2,d0.w),d0	; chunky2 += bsize;
2$:		move.b	d0,(a5)+
		addq.b	#1,d5
		bne.b	2$

		bra.b	4$		; } else {

1$:		move.b	(a0)+,d0	; for ( ; bsize > 0; bsize--)
		move.b	(a2,d0.w),(a5)+	; *chunky2++ = xlate[*chunkbuf++];
		subq.b	#1,d5
		bne.b	1$

4$:		move.l	a5,d1		; memset (&dirty_list[start], TRUE,
		subq.l	#1,d1		;   ((chunky2-1-chunky) >> 5)-start+1);
		sub.l	a1,d1
		lsr.l	#5,d1
		sub.w	d6,d1
		addq.w	#1,d1
		lea	(a3,d6.w),a6
12$:		move.b	d2,(a6)+
		subq.w	#1,d1
		bne.b	12$

end_loopx2:	dbra	d4,loopx2

		adda.w	(_screen_width),a1	; chunky += screen_width;
		adda.w	(_screen_width32),a3	; dirty_list += screen_width32;

end_loopx1:	dbra	d3,loopx1

		movem.l	(sp)+,d2-d6/a2-a3/a5-a6
		rts

		end
