Program SinF32;

  Uses
    Fixed32,CompF32;

  Const
    XRes=319;
    YRes=199;
    TopLeft:TFixedComplex=(a:Trunc(-2*FixedOne);
                           b:Trunc(2*FixedOne));
    BottomRight:TFixedComplex=(a:Trunc(2*FixedOne);
                               b:Trunc(-2*FixedOne));
    MaxIter=64;
    Power:TFixedComplex=(a:Trunc(2.0*FixedOne);
                         b:Trunc(0.0*FixedOne));
    Bound:TFixed=4*FixedOne;
    Initial:TFixedComplex=(a:Trunc(0.0*FixedOne);
                           b:Trunc(0.0*FixedOne));
    Invert=False;

  Procedure SetPallette;                {Set the Palette}
    var
      a:Byte;
    begin
      for a:=0 to 63 do
        begin
          port[$3c8]:=a;                {Palette Number}
          port[$3c9]:=0;                {R}
          port[$3c9]:=a;                {G}
          port[$3c9]:=a;                {B}

          port[$3c8]:=64+a;
          port[$3c9]:=a;
          port[$3c9]:=63;
          port[$3c9]:=63-a;

          port[$3c8]:=128+a;
          port[$3c9]:=63;
          port[$3c9]:=63-a;
          port[$3c9]:=0;

          port[$3c8]:=192+a;
          port[$3c9]:=63-a;
          port[$3c9]:=0;
          port[$3c9]:=0;
        end;
    end;

  Procedure VideoSync;
    begin
      asm
        mov dx,$03DA;                        {Check for sync}
       @frame:
        in al,dx;
        test al,$8;
        jz @frame;
       @besure:
        in al,dx;
        test al,$8;
        jnz @besure;
      end;
    end;

  Procedure CyclePallette;
    var
      r,b,g:Byte;
      r1,b1,g1:Byte;
      Count:Byte;
    begin
      VideoSync;

      port[$3c7]:=1;
      r:=port[$3c9];
      g:=port[$3c9];
      b:=port[$3c9];

      for Count:=1 to 254 do
        begin
          port[$3c7]:=Count+1;
          r1:=port[$3c9];
          g1:=port[$3c9];
          b1:=port[$3c9];

          port[$3c8]:=Count;
          port[$3c9]:=r1;
          port[$3c9]:=g1;
          port[$3c9]:=b1;
        end;

      port[$3c8]:=255;
      port[$3c9]:=r;
      port[$3c9]:=g;
      port[$3c9]:=b;
    end;


  Procedure SetMode13;
    begin
      asm
        mov ax,$13;                          {Video Mode 13}
        int $10;
      end;
    end;

  Procedure SetModeText;
    begin
      asm
        mov ax,$3;                           {Text Mode}
        int $10;
      end;
    end;

  Function KeyPressed:Boolean;
    var
      a:byte;
    begin
      asm
        mov ah,$11;                          {See if key pressed}
        int $16;
        mov a,0;
        jz @KeyNotPressed;
        mov a,1;
       @KeyNotPressed:
      end;
      KeyPressed:=a=1;
    end;

  Procedure WaitKeyPressed;
    begin
      asm
       @KeyNotPressed:
        Call CyclePallette;
        mov ah,$11;                          {See if key pressed}
        int $16;
        jz @KeyNotPressed;

       @KeyPressed:
        mov ah,$16;                          {Clear the Keypressed}
        int $16;
      end;
    end;

  Procedure PutPixel(x,y:Word; Color:Byte);
    begin
      Mem[$A000:(y shl 8)+(y shl 6)+x]:=Color;
    end;

  Function GetPixel(x,y:Word):Byte;
    begin
      GetPixel:=Mem[$A000:(y shl 8)+(y shl 6)+x];
    end;

  Procedure CalcMandelbrot;
    var
      delta:TFixedComplex;
      z:TFixedComplex;
      p:TFixedComplex;
      c:TFixedComplex;
      x,y:Word;
      Iteration:Byte;

    Function InBounds:Boolean;
      begin
        if (Bound<(FixedSqr(z.a)+FixedSqr(z.b))) then
          begin
            InBounds:=False;
            Exit;
          end;
        If Iteration>MaxIter then
          begin
            InBounds:=False;
            Exit;
          end;
        InBounds:=True;
      end;

    Procedure Iterate;
      begin
        z:=Initial;
        Iteration:=0;
        if Invert then
          FixedComplexInv(p,c)
        else
          c:=p;

        While InBounds do
          begin
            FixedComplexSin(z,z);
            FixedComplexAdd(z,c,z);
            Inc(Iteration);
          end;

        PutPixel(x,y,Iteration);
      end;

    begin
      delta.a:=(BottomRight.a-TopLeft.a) div XRes;
      delta.b:=(BottomRight.b-TopLeft.b) div YRes;
      p.b:=TopLeft.b;
      for y:=0 to YRes do
        begin
          p.a:=TopLeft.a;
          for x:=0 to XRes do
            begin
              Iterate;
              p.a:=p.a+delta.a;
              if KeyPressed then
                Exit;
            end;
          p.b:=p.b+delta.b;
          if KeyPressed then
            Exit;
        end;
    end;

begin
  SetMode13;
  SetPallette;
  CalcMandelbrot;
  WaitKeyPressed;
  SetModeText;
end.
