Program PlasF32;

  Uses
    Fixed32;

  Procedure SetPal;                     {Set the Palette}
    var
      a:Byte;
    begin
      for a:=0 to 63 do
        begin
          port[$3c8]:=a;                {Palette Number}
          port[$3c9]:=0;                {R}
          port[$3c9]:=a;                {G}
          port[$3c9]:=a;                {B}

          port[$3c8]:=64+a;
          port[$3c9]:=a;
          port[$3c9]:=63;
          port[$3c9]:=63-a;

          port[$3c8]:=128+a;
          port[$3c9]:=63;
          port[$3c9]:=63-a;
          port[$3c9]:=0;

          port[$3c8]:=192+a;
          port[$3c9]:=63-a;
          port[$3c9]:=0;
          port[$3c9]:=0;
        end;
    end;

  Procedure VideoSync;
    begin
      asm
        mov dx,$03DA;                        {Check for sync}
       @frame:
        in al,dx;
        test al,$8;
        jz @frame;
       @besure:
        in al,dx;
        test al,$8;
        jnz @besure;
      end;
    end;

  Procedure CyclePallette;
    var
      r,b,g:Byte;
      r1,b1,g1:Byte;
      Count:Byte;
    begin
      VideoSync;

      port[$3c7]:=1;
      r:=port[$3c9];
      g:=port[$3c9];
      b:=port[$3c9];

      for Count:=1 to 254 do
        begin
          port[$3c7]:=Count+1;
          r1:=port[$3c9];
          g1:=port[$3c9];
          b1:=port[$3c9];

          port[$3c8]:=Count;
          port[$3c9]:=r1;
          port[$3c9]:=g1;
          port[$3c9]:=b1;
        end;

      port[$3c8]:=255;
      port[$3c9]:=r;
      port[$3c9]:=g;
      port[$3c9]:=b;
    end;


  Procedure SetMode13;
    begin
      asm
        mov ax,$13;                          {Video Mode 13}
        int $10;
      end;
    end;

  Procedure SetModeText;
    begin
      asm
        mov ax,$3;                           {Text Mode}
        int $10;
      end;
    end;

  Procedure WaitKeyPressed;
    begin
      asm
       @KeyNotPressed:
        Call CyclePallette;
        mov ah,$11;                          {See if key pressed}
        int $16;
        jz @KeyNotPressed;

       @KeyPressed:
        mov ah,$16;                          {Clear the Keypressed}
        int $16;
      end;
    end;

  Procedure PutPixel(x,y:Word; Color:Byte);
    begin
      Mem[$A000:(y shl 8)+(y shl 6)+x]:=Color;
    end;

  Function GetPixel(x,y:Word):Byte;
    begin
      GetPixel:=Mem[$A000:(y shl 8)+(y shl 6)+x];
    end;

  Procedure NewColor(x1,y1,x,y,x2,y2:Word);
    var
      Color:Integer;
    begin
      if GetPixel(x,y)=0 then
        begin
          Color:=x2-x1+y2-y1+1;
          Color:=(Random mod (Color shl 1+1))-Color;
          Color:=Color+(GetPixel(x1,y1)+GetPixel(x2,y2)+1) shr 1;
          if Color<1 then
            Color:=1;
          if Color>255 then
            Color:=255;
          PutPixel(x,y,Byte(Color));
        end;
    end;

  Procedure Plasma(x1,y1,x2,y2:Word);
    var
      x,y:Word;
      Color:Byte;
    begin
      if not((x2-x1<2) and (y2-y1<2)) then
        begin
          x:=(x1+x2) shr 1;
          y:=(y1+y2) shr 1;

          NewColor(x1,y1,x,y1,x2,y1);
          NewColor(x2,y1,x2,y,x2,y2);
          NewColor(x1,y2,x,y2,x2,y2);
          NewColor(x1,y1,x1,y,x1,y2);

          PutPixel(x,y,(GetPixel(x1,y1)+GetPixel(x2,y1)+GetPixel(x2,y2)+
                        GetPixel(x1,y2)+2) shr 2);

          Plasma(x1,y1,x,y);
          Plasma(x,y1,x2,y);
          Plasma(x,y,x2,y2);
          Plasma(x1,y,x,y2);
        end;
    end;

Begin
  SetMode13;
  SetPal;

  PutPixel(0,0,255);
  PutPixel(319,0,255);
  PutPixel(319,199,1);
  PutPixel(0,199,1);

  Plasma(0,0,319,199);

  WaitKeyPressed;
  SetModeText;
End.
