{Brought to you by the Vegetable Rights Activist.  If you do not know who I
 am, then you do not know who I am.  I am a lone coder who groks 42 and
 eats at taco bell.  I am also dyslexic, so excuse any miss spellings.  I
 have been programing for about 13 years on my own.  Most of the programming
 skills I have aquired have been self taught.  Pascal is my native language.
 I also know C, C++, Fortran, and basic (but then again who doesn't know
 basic).  This is also my first try at using assembly.  I always thought
 that I would never need to learn assembly, but when your trying to do
 realtime fractal animation, you have to.  If you look at the .ASM file you
 will notice I documented the hell out of it, like I said this is my first
 time using assembly.  Oh, by the way my real name is Eric Nixon. (NO, there
 is no relation that I know of, and by the way he was a great president, he
 just got caught.  Bill and Opus for '96, for those who liked Bloom County
 better than Poutland, I mean Outland.).}

{This math library uses fixed point integer mathematics and covers most of
 the basic math routines that are needed. I don't know why I am putting this
 next clause in here, but every body else does.  I am not resposible for
 any damage or hair loss due to the use of this unit.  Use at your own risk.
 Some of the math routines get a little off, maybe 1 or 2.  Since this is a
 fixed point library you loose some accuracy with repetitive math functions.}

Unit Fixed32;

Interface

{$F+}                               {All assembler functions must be far.}
{$A+}
{$G+}
{$R-}
{$S-}
{$I-}
{$Q-}
{$D-}
{$L-}
{$Y-}
{$N-}
{$E-}

  Const                             {Wanted to use constants instead of
                                     variables, so they are not portible
                                     between the asm modual and the unit.}
    FixedShift=22;                  {Must be the same as the ASM.}
    FixedOne=1 shl FixedShift;
    FixedNearOneUp=Trunc(FixedOne/0.9);
    FixedNearOneDown=Trunc(FixedOne*0.9);
    Pi=3.14159265359;
    e=2.71828182846;
    FixedPi=Trunc(Pi*FixedOne);
    Fixed2Pi=Trunc(Pi*(FixedOne shl 1));
    Fixed1_2Pi=Trunc(Pi*(FixedOne shr 1));
    Fixede=Trunc(e*FixedOne);
    MaxPos=$7FFFFFFF;
    MaxNeg=$80000001;

  Type
    TFixed=LongInt;                 {What type is TFixed}

  {I classify all of my functions in this unit with a 'Fixed' prefix,
   except two convertion functions.  Any function with 'NoCheck' as a
   suffix, no checking for overflow will be done.  Even though these
   functions are much faster, I do not recommend using them.}


  {The following functions convert a fixed point number to real or an
   integer, and vis versa.}
  Function RealToFixed(a:Real):TFixed;
  Function IntToFixed(a:Integer):TFixed;
  Function FixedToInt(a:TFixed):Integer;
  Function FixedToReal(a:TFixed):Real;


  {Multiply}
  Function FixedMult(a,b:TFixed):TFixed;
  Function FixedMultNoCheck(a,b:TFixed):TFixed;


  {Divide,  The Div2 function divides the number by 2 using the assembly
   'sar', since pascal only offers x DIV 2 which is much slower, I put
   this in here.}
  Function FixedDiv(a,b:TFixed):TFixed;
  Function FixedDivNoCheck(a,b:TFixed):TFixed;
  Function FixedDiv2(a:TFixed):TFixed;


  {Invert (1/x)}
  Function FixedInv(a:TFixed):TFixed;
  Function FixedInvNoCheck(a:TFixed):TFixed;


  {Square}
  Function FixedSqr(a:TFixed):TFixed;
  Function FixedSqrNoCheck(a:TFixed):TFixed;


  {Square root}
  Function FixedSqrt(a:TFixed):TFixed;


  {Exponent (e^x)}
  Function FixedExp(a:TFixed):TFixed;


  {Natural log}
  Function FixedLn(a:TFixed):TFixed;


  {Sine, and Hyperbolic functions}
  Function FixedSin(a:TFixed):TFixed;
  Function FixedASin(a:TFixed):TFixed;
  Function FixedSinh(a:TFixed):TFixed;
  Function FixedASinh(a:TFixed):TFixed;


  {Cosine, and Hyperbolic functions}
  Function FixedCos(a:TFixed):TFixed;
  Function FixedACos(a:TFixed):TFixed;
  Function FixedCosh(a:TFixed):TFixed;
  Function FixedACosh(a:TFixed):TFixed;


  {Tangent, and Hyperbolic functions}
  Function FixedTan(a:TFixed):TFixed;
  Function FixedATan(a:TFixed):TFixed;
  Function FixedTanh(a:TFixed):TFixed;
  Function FixedATanh(a:TFixed):TFixed;


  {Takes a number to the power of another (a^b)}
  Function FixedPower(a,b:TFixed):TFixed;


  {Returns a random number between 1 and 0}
  Function FixedRandom:TFixed;
  {Returns a random longint}
  Function Random:LongInt;
  {Initializes random function gernerator to whatever you want}
  Procedure InitRandom(Seed,Mult,Incr:TFixed);

Implementation

{$L Fixed32.obj}

  Procedure FixedInit;External;


  Function RealToFixed(a:Real):TFixed;
    begin
      RealToFixed:=Trunc(a*FixedOne);
    end;

  Function IntToFixed(a:Integer):TFixed;
    begin
      IntToFixed:=a shl FixedShift;
    end;

  Function FixedToInt(a:TFixed):Integer;
    begin
      FixedToInt:=a shr FixedShift;
    end;

  Function FixedToReal(a:TFixed):Real;
    Const
      One_Over=1/(FixedOne);
    begin
      FixedToReal:=a*One_Over;
    end;

  Function FixedMult(a,b:TFixed):TFixed;External;
  Function FixedMultNoCheck(a,b:TFixed):TFixed;External;


  Function FixedDiv(a,b:TFixed):TFixed;External;
  Function FixedDivNoCheck(a,b:TFixed):TFixed;External;
  Function FixedDiv2(a:TFixed):TFixed;External;


  Function FixedInv(a:TFixed):TFixed;
    begin
      FixedInv:=FixedDiv(FixedOne,a);
    end;
  Function FixedInvNoCheck(a:TFixed):TFixed;
    begin
      FixedInvNoCheck:=FixedDivNoCheck(FixedOne,a);
    end;


  Function FixedSqr(a:TFixed):TFixed;External;
  Function FixedSqrNoCheck(a:TFixed):TFixed;External;


  Function FixedSqrt(a:TFixed):TFixed;External;


  Function FixedExp(a:TFixed):TFixed;External;


  Function FixedLn(a:TFixed):TFixed;External;


  Function FixedSin(a:TFixed):TFixed;External;
  Function FixedASin(a:TFixed):TFixed;
    begin          { ASin(x)=ATan(x/Sqrt(1-Sqr(x)))) }
      FixedASin:=FixedATan(FixedDiv(a,FixedSqrt(FixedOne-FixedSqr(a))));
    end;
  Function FixedSinh(a:TFixed):TFixed;
    begin          { Sinh(x)=(e^x-e^(-x))/2 }
                   { Since we are working with a fixed point, using a
                     larger exponent keeps the accuracy higher. }
      if a<0 then
        begin
          a:=FixedExp(-a);
          FixedSinh:=-FixedDiv2(a-FixedInv(a));
        end
      else
        begin
          a:=FixedExp(a);
          FixedSinh:=FixedDiv2(a-FixedInv(a));
        end;
    end;
  Function FixedASinh(a:TFixed):TFixed;
    begin          { ASinh(x)=ln(x+(x^2+1)^(1/2)) }
      FixedASinh:=FixedLn(a+FixedSqrt(FixedSqr(a)+FixedOne));
    end;


  Function FixedCos(a:TFixed):TFixed;External;
  Function FixedACos(a:TFixed):TFixed;
    begin          { ACos(x)=ATan(Sqrt(1-Sqr(x))/x)) }
      FixedACos:=FixedATan(FixedDiv(FixedSqrt(FixedOne-FixedSqr(a)),a));
    end;
  Function FixedCosh(a:TFixed):TFixed;
    begin          { Cosh(x)=(e^x+e^(-x))/2 }
                   { Since we are working with a fixed point, using a
                     larger exponent keeps the accuracy higher. }
      if a<0 then
        begin
          a:=FixedExp(-a);
          FixedCosh:=FixedDiv2(a+FixedInv(a));
        end
      else
        begin
          a:=FixedExp(a);
          FixedCosh:=FixedDiv2(a+FixedInv(a));
        end;
    end;
  Function FixedACosh(a:TFixed):TFixed;
    begin          { ACosh(x)=ln(x+(x^2-1)^(1/2)) }
                   { Since my Sqrt always takes the Abs of number before
                     execution, I have to work around it.}
      if a>=FixedOne then
        FixedACosh:=FixedLn(a+FixedSqrt(FixedSqr(a)-FixedOne))
      else
        FixedACosh:=MaxPos;
    end;


  Function FixedTan(a:TFixed):TFixed;External;
  Function FixedArcTan(a:TFixed):TFixed;External;
  Function FixedATan(a:TFixed):TFixed;
    begin          { My ArcTangent function was lacking when a value
                     close to 1 was used as an input.  When a value of
                     1 is used it takes about 3 seconds to calculate,
                     because of the sum is divided linearly instead of
                     exponentialy.  The equation I use to convert the
                     input, I came up with accidentaly when I was showing
                     a friend how the divine ratio was derived.  The
                     divine ratio is a aproximatly 1.61803398875.  When
                     this ratio is inverted, the fractional part stays
                     the same.  I said OK, you have some fractional part
                     called x, then the equation is x=1/(n+x), were n is
                     an integer.  I did some math and came up with
                     x=(-n+(n^2+4)^(1/2))/2.  If you put 1 in for n you
                     get the ratio above inverted.  Well I started to
                     punch in other numbers for n, and found that when
                     n=2, the ArcTan of the answer was Pi/8 or 22.5
                     degrees.  After this I said "GRUVY" (Just joking
                     actualy I said "Cooool.").  I tried looking up this
                     angle in my many (but too few) math books and found
                     it nowhere.  And that is where I left it for about
                     two months, until I came up with this problem.
                     Originaly I was trying to find ATan(A/2), but to
                     no grand finish.  Then I remembered my discovery,
                     and said "Hey!" (Hey is for horses, and besides
                     they pee in it too.) I came up with Pi/8 with
                     the divine ratio equation above, it took me about
                     two hours to figure it out (and I almost did not
                     make it alive).  I have no proof that the equation
                     works, but with trial and error, you will find that
                     it actualy works.  Lets say the Tan(a)=A, well
                     ATan(A)=a of course, of course, a horse is a horse,
                     of course, of course (WAKE UP!!!!  No more Nick at
                     Night for you.).  Well ultimatly I came up with
                     x=ATan((A^2+1)^(1/2)-A)=(Pi/2-a)/2.  So to solve
                     for 'a', I get a=Pi/2-2*x.  If I actualy came
                     up with a new equation, and you are actualy still
                     reading this, I deserve a medal of valor, if it's
                     not a new equation, then kiss my assemtote.  This
                     type of thing came up one time before when my
                     girlfriend in high school came up with an equation
                     for perfect numbers, and found out later that
                     Euclid did it in the 1400's, without a calculator.

                     I just spent a little time and came up with a proof
                     for the equation.  Very simple geometry, but I'm going
                     to let you figure this one out on your own.}
      if a<0 then
        if (-a<FixedNearOneUp) and (-a>FixedNearOneDown) then
          FixedATan:=-Fixed1_2Pi+
            (FixedArcTan(FixedSqrt(FixedSqr(a)+FixedOne)+a)) shl 1
        else
          FixedATan:=FixedArcTan(a)
      else
        if (a<FixedNearOneUp) and (a>FixedNearOneDown) then
          FixedATan:=Fixed1_2Pi-
            (FixedArcTan(FixedSqrt(FixedSqr(a)+FixedOne)-a)) shl 1
        else
          FixedATan:=FixedArcTan(a);
    end;
  Function FixedTanh(a:TFixed):TFixed;
    var
      Temp:TFixed;
    begin          { Tanh(x)=(e^x-e^(-x))/(e^x+e^(-x)) }
                   { Since we are working with a fixed point, using a
                     positive exponent before inverting the number keeps
                     the accuracy higher. }
      if a<0 then
        begin
          a:=FixedExp(-a);
          Temp:=FixedInv(a);
          FixedTanh:=-FixedDiv(a-Temp,a+Temp);
        end
      else
        begin
          a:=FixedExp(a);
          Temp:=FixedInv(a);
          FixedTanh:=FixedDiv(a-Temp,a+Temp);
        end;
    end;
  Function FixedATanh(a:TFixed):TFixed;
    begin          { ATanh(x)=ln((1+x)/(1-x))/2 }
      FixedATanh:=FixedDiv2(FixedLn(FixedDiv(a+FixedOne,FixedOne-a)));
    end;


  Function FixedPower(a,b:TFixed):TFixed;
    begin          {a^b=e^(b*ln(a))}
      FixedPower:=FixedExp(FixedMult(b,FixedLn(a)));
    end;


  Function FixedRandom:TFixed;External;
  Function Random:TFixed;External;
  Procedure InitRandom(Seed,Mult,Incr:TFixed);External;

begin
  FixedInit;
end.
