;Brought to you by Eric Nixon the Vegetable Rights Activist

;My first asm modual, so no wise cracks.  Some of the routines here are
;actualy faster than the NPU.  Sure I'm using integer math, but still I
;think it is cool.  I commented the hell out of this modual, just for my
;sanity, not yours

.MODEL large,PASCAL
.386

.DATA
   AllSet      EQU 0FFFFFFFFh ;Just for the hell of it
   MaxPos      EQU 07FFFFFFFh ;Max positive number
   MaxNeg      EQU 080000001h ;Max negetiv number
   FixedShift  EQU 22         ;Fixed point position, must be 28>=x>=16
   FixedFrac   EQU AllSet shr (32-FixedShift)  ;Mask for fraction part
   FixedOne    EQU 1 shl FixedShift     ;Fixed point number = to one
   FixedNegOne EQU -FixedOne  ;Fixed point number = to negetive one
   Fe          EQU 0ADF85459h ;Fixed point at 30  e
   F1_e        EQU 05E2D58D9h ;Fixed point at 32  1/e
   FPi         EQU 0C90FDAA2h ;Fixed point at 30  pi
   F1_Pi       EQU 0517CC1B8h ;Fixed point at 32  1/pi
   Fixede      dd  FixedOne,?
               dd  ?,?,?,?,?,?
               dd  ?,?,?      ;e^n n=0..10  10 is the largest e^n can get
   Fixed1_e    dd  FixedOne,?
               dd  ?,?,?,?,?,?
               dd  ?,?,?,?,?,?
               dd  ?,?,?,?,?,?
               dd  ?          ;1/(e^n) n=0..20 with FixedShift at max 20
                              ; has an answer of 0
   FixedPi     dd  ?          ;pi
   Fixed1_Pi   dd  ?          ;1/pi
   Fixed2Pi    dd  ?          ;2*pi
   Fixed1_2Pi  dd  ?          ;1/2*pi
   Factorial   dd  ?,?,?,?,?,?
               dd  ?,?,?,?,?,AllSet
               dd  AllSet     ;n!  n=2..14, the last two is for final divide
                              ; in FixedExp,FixedCos,FixedSin
   Maxe        dw  ?          ;e^Maxe is the largest integer power of e
   RandSeed    dd  03E5D1A7Fh ;Random seed for Random number generator
   RandMult    dd  062B82E21h ;Random multiplier
   RandIncr    dd  026912DABh ;Random increment

.CODE
  FixedInit PROC FAR
    PUBLIC FixedInit

                              ;Find Maxe, which is counted in cx
                              ;It basicaly finds the integer value of
                              ; ln(MaxPos)
    xor cx,cx                 ;Zero cx
    mov ebx,Fe                ;Load ebx with Fe (remember Fe's fixed point
                              ; is at 30)
    shr ebx,30-FixedShift     ;Convert Fe to current fixed point
    mov eax,MaxPos            ;Load eax with the maximum positive number
  MaxeTest:                   ;Loop to divide MaxPos by e to find Maxe
    mov edx,eax               ;Copy eax into edx to create a number in eax:edx
    sar edx,32-FixedShift     ;Shift edx to right
    shl eax,FixedShift        ;Shift eax to left, now number is in eax:edx
    div ebx                   ;Divide by converted Fe
    inc cx                    ;Add one to Maxe
    cmp eax,FixedOne          ;Compare results, of divide, to one
    jg MaxeTest               ;Jump if greater than one
    dec cx                    ;Decrease Maxe by one
    mov Maxe,cx               ;Copy cx to Maxe

                              ;Find Fixede by e^n=e^(n-1)*e
                              ;I load di with a bit point counter, to keep
                              ; trak of where the the current point is in the
                              ; answer.  If I used the Fixed point e^n gets
                              ; errors.
    mov si,OFFSET Fixede      ;Load offset of Fixede array to si
    add si,4                  ;Move to next location in array
    mov ebx,Fe                ;Load Fe to ebx
    mov edx,ebx               ;Copy Fe to edx
    mov di,30                 ;Initialize bit point counter
  Finde:                      ;Multiplication loop to find e^2 to e^Maxe
    mov eax,edx               ;Copy answer to eax
    mov es,cx                 ;Move current count to es for shift
    mov cx,di                 ;Copy Fixed point counter
    sub cx,FixedShift         ;Find how far to shift point
    shr edx,cl                ;Do shift
    adc edx,0                 ;If carry, round up
    mov [si],edx              ;Copy e^n to array
    mul ebx                   ;Multiply e^(Maxe-cx+1) by Fe
    bsr ecx,edx               ;Scan edx for first bit to find how far to shift
    sub ecx,31                ;I need 31-ecx, so I have to do it this way
    neg ecx
    shld edx,eax,cl           ;Do shift
    sub di,2                  ;Modify bit point counter
    add di,cx                 ;Modify bit point counter if shift occured
    add si,4                  ;Move to next location in array
    mov cx,es                 ;Restore counter
    loop Finde                ;Keep on looping, cx is Maxe

                              ;Find Fixed1_e by 1/(e^n)=1/(e^(n-1))*1/e
                              ;I could go farther than Maxe, but why bother,
                              ; only Fixede is important
    mov si,OFFSET Fixed1_e    ;Load offset of Fixed1_e array to si
    add si,4                  ;Move to next location in array
    mov ebx,F1_e              ;Load ebx with F1_e (remember F1_e's fixed point
                              ; is at 32)
    mov eax,ebx               ;Copy F1_e to eax
    shr eax,32-FixedShift     ;Convert F1_e to current fixed point
    mov cx,20                 ;Array of 20
  Find1_e:                    ;Multiplication loop to find (1/e)^2 to
                              ; (1/e)^Maxe
    mov [si],eax              ;Copy (1/e)^n to array
    mul ebx                   ;Multiply (1/e)^(Maxe-cx+1) by F1_e
    mov eax,edx               ;Since F1_e is fixed at 32 no shrd is needed,
                              ; it's all in edx
    add si,4                  ;Move to next location in array
    loop Find1_e              ;Keep on looping

                              ;Find Factorial
    mov si,OFFSET Factorial   ;Load offset of Factorial array to si
    mov cx,11                 ;Load loop counter 2..12, so total of 10
    mov eax,1                 ;Load starting value for Factorial
    mov ebx,eax               ;Shadow it to ebx
  FactorialLoop:              ;Multipication loop for Factorial
    inc ebx                   ;Count multiplier up
    mul ebx                   ;Multiply
    mov [si],eax              ;Copy n! to array
    add si,4                  ;Move to next location in array
    loop FactorialLoop        ;Keep on looping

                              ;Find FixedPi, Fixed2Pi, and Fixed1_2Pi
    mov eax,FPi               ;Load eax with FPi (remember FPi's fixed point
                              ; is at 30)
    shr eax,29-FixedShift     ;Convert FPi to current fixed point
    mov Fixed2Pi,eax          ;Copy into storage
    shr eax,1                 ;Divide by 2
    mov FixedPi,eax           ;Copy into storage
    shr eax,1                 ;Divide by 2
    mov Fixed1_2Pi,eax        ;Copy into storage

                              ;Find Fixed1_Pi
    mov eax,F1_Pi             ;Load eax with F1_Pi (remember F1_Pi's fixed
                              ; point is at 32)
    shr eax,32-FixedShift     ;Convert F1_Pi to current fixed point
    mov Fixed1_Pi,eax         ;Copy into storage

    ret
  FixedInit ENDP


  FixedMult PROC FAR a:DWORD,b:DWORD RETURNS result:DWORD
    PUBLIC FixedMult
    mov eax,b                 ;Load b into eax
    imul a                    ;Integer multiply eax by a
    shrd eax,edx,FixedShift   ;Move fixed point and save in eax
    mov ecx,edx               ;Copy high part to ecx
    or ecx,ecx                ;Check if negitive
    jns NotNegMult            ;Jump if not negetive
    neg ecx                   ;Negate
  NotNegMult:
    shr ecx,FixedShift-1      ;Shift in range part of number out of register
    or ecx,ecx                ;Change flags if zero
    je InRangeMult            ;Jump if zero
    mov eax,MaxPos            ;Move MaxPos in eax
    or edx,edx                ;Check to see if original number was negetive
    jns InRangeMult           ;Jump if not
    neg eax                   ;Negate
  InRangeMult:
    mov edx,eax               ;Copy answer to edx
    sar edx,16                ;Prepare for lift off
    ret
  FixedMult ENDP


  FixedMultNoCheck PROC FAR a:DWORD,b:DWORD RETURNS result:DWORD
    PUBLIC FixedMultNoCheck
    mov eax,b                 ;Load b into eax
    imul a                    ;Integer multiply eax by a
    shrd eax,edx,FixedShift   ;Move fixed point and save in eax
    sar edx,FixedShift-16     ;edx was unchanged but shift it for return DX:AX
    ret                       ;No error is returned if result is larger than
                              ; 32 bits
  FixedMultNoCheck ENDP


  FixedDiv PROC FAR a:DWORD,b:DWORD RETURNS result:DWORD
    PUBLIC FixedDiv
    mov ebx,b                 ;Load b into ebx
    or ebx,ebx                ;Set flags if zero
    jne NotZeroDiv            ;Jump if not divide by zero
    mov eax,a                 ;Load a to find sign
    or eax,eax                ;Find sign
    js NegDivZero             ;Jump if negetive
    mov eax,MaxPos            ;Load MaxPos for return of positive infinity
    jmp EndDiv                ;Jump to end and return MaxPos
  NegDivZero:
    mov eax,MaxNeg            ;Load MaxNeg for return of negetive infinity
    jmp EndDiv                ;Jump to end and return MaxNeg
  NotZeroDiv:                 ;Start divide
    mov eax,a                 ;Load eax with a
    mov ecx,eax               ;Copy to a to ecx for storage
    cdq                       ;Sign extend a
    idiv ebx                  ;Divide by b
    or eax,eax                ;Check sign
    js NegDiv                 ;Jump if negetive
    shr eax,31-FixedShift     ;Shift for check overflow
    or eax,eax                ;Check if zero
    je ActualDivide           ;Jump if zero
    mov eax,MaxPos            ;Load with MaxPos if out of range
    jmp EndDiv                ;Jump to end
  NegDiv:
    neg eax                   ;Negate
    shr eax,31-FixedShift     ;Shift for check overflow
    or eax,eax                ;Check if zero
    je ActualDivide           ;Jump if zero
    mov eax,MaxNeg            ;Load with MaxNeg if out of range
    jmp EndDiv                ;Jump to end
  ActualDivide:
    mov eax,ecx               ;Move a to eax
    mov edx,eax               ;Copy a to edx
    sar edx,32-FixedShift     ;Shift edx to right
    shl eax,FixedShift        ;Shift eax to left, now a is in eax:edx
    idiv ebx                  ;Integer divide by b, answer in eax
  EndDiv:                     ;Used for jump if b=0
    mov edx,eax               ;Copy answer to edx
    sar edx,16                ;Shift edx for return DX:AX
    ret
  FixedDiv ENDP


  FixedDivNoCheck PROC FAR a:DWORD,b:DWORD RETURNS result:DWORD
    PUBLIC FixedDivNoCheck
    mov eax,a                 ;Load eax with a
    mov edx,eax               ;Copy a to edx
    sar edx,32-FixedShift     ;Shift edx to right
    shl eax,FixedShift        ;Shift eax to left, now a is in eax:edx
    idiv DWORD PTR b          ;Integer divide by b, answer in eax
    mov edx,eax               ;Copy answer to edx
    sar edx,16                ;Shift edx for return DX:AX
    ret                       ;The only error returned will be if b=0
                              ;No error is returned if result is larger than
                              ; 32 bits
  FixedDivNoCheck ENDP


  FixedDiv2 PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedDiv2
    mov eax,a
    sar eax,1
    mov edx,eax
    sar edx,16
    ret
  FixedDiv2 ENDP


  FixedSqr PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedSqr
    mov eax,a                 ;Load b into eax
    imul eax                  ;Integer multiply eax by a
    shrd eax,edx,FixedShift   ;Move fixed point and save in eax
    shr edx,FixedShift        ;Shift in range part of number out of register
    or edx,edx                ;Change flags if zero
    je InRangeSqr             ;Jump if zero
    mov eax,MaxPos            ;Move MaxPos in eax
  InRangeSqr:
    mov edx,eax               ;Copy answer to edx
    sar edx,16                ;Prepare for lift off
    ret
  FixedSqr ENDP


  FixedSqrNoCheck PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedSqrNoCheck
    mov eax,a                 ;Load a into eax
    imul eax                  ;Integer multiply eax by eax
    shrd eax,edx,FixedShift   ;Move fixed point and save in eax
    sar edx,FixedShift-16     ;edx was unchanged but shift it for return DX:AX
    ret                       ;No error is returned if result is larger than
                              ; 32 bits
  FixedSqrNoCheck ENDP


  FixedSqrt PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedSqrt          ;Returns the Sqrt(ABS(a))
    xor eax,eax               ;Initialize return to be zero
    mov ebx,a                 ;Load a into eax
    or ebx,ebx                ;Set flags
    je EndSqrt                ;Leave if zero
    jns NotNegSqrt            ;Jump if not negetive
    neg ebx                   ;Negate
  NotNegSqrt:
    mov eax,1                 ;Load with one
    bsr ecx,ebx               ;Find bit index of original number
    sub cl,FixedShift         ;Find how far off shift point
    sar cl,1                  ;Divide by two
    add cl,1                  ;Add one to index, in case "a" is less than one
    add cl,FixedShift         ;Add shift point back into number
    shl eax,cl                ;Shift left to create start value
    mov ecx,eax               ;Store in ecx
  SqrtLoop:
    or ecx,ecx                ;Check if zero
    je EndSqrt                ;Leave if zero
    shr ecx,1                 ;Divide by two
    push eax                  ;Push answer for multiplication
    mul eax                   ;Multiply eax by eax
    shrd eax,edx,FixedShift   ;Move fixed point and save in eax
    cmp ebx,eax               ;Check if same
    pop eax                   ;Restore eax
    je EndSqrt                ;Leave if equal
    js LessThanSqrt           ;Jump if sign, number is not negetive, just
                              ; just out of range
    jl LessThanSqrt           ;Jump if less
  GreaterThanSqrt:
    shr edx,FixedShift        ;Check for number overflow
    or edx,edx                ;Is it zero
    jne LessThanSqrt          ;Subtract instead number is out of range
    add eax,ecx               ;Add thingy to other thingy
    jmp SqrtLoop              ;Loop
  LessThanSqrt:
    sub eax,ecx               ;Subtract thingy to other thingy
    jmp SqrtLoop              ;Loop
  EndSqrt:
    mov edx,eax
    shr edx,16
    ret
  FixedSqrt ENDP


  FixedExp PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedExp
                              ;e^x=sum n=0-infinity of (x^n)/(n!)
                              ;The first part will take the integer part of e^n
                              ;I'm using the power rule x^(c+d)=(x^c)*(x^d)
                              ;The x^n would get to large if I did not do this
                              ;I am also using precalulated e^n for integer
                              ; values, this makes the code go faster
    mov eax,a                 ;Load a into eax
    or eax,eax                ;Check sign
    js NegExp                 ;Jump if negetive
    mov ebx,eax               ;Copy into ebx
    shr eax,FixedShift        ;Get rid of fraction
    cmp ax,Maxe               ;Compare with the maximum integer value of e^x
    jle NotInfinintExp        ;Jump if not out of range
    mov eax,MaxPos            ;If out of range load with positive infinity
    jmp EndExp                ;Jump and exit
  NotInfinintExp:
    mov si,OFFSET Fixede      ;Load offset of Fixed1_e array to si
    shl ax,2                  ;Multiply by 4 for index with si
    add si,ax                 ;Add to si to index array
    mov edi,[si]              ;Load index e into edi
    and ebx,FixedFrac         ;Mask only the fractional part
    jmp EndFindIntExp         ;Done here
  NegExp:
    mov si,OFFSET Fixed1_e    ;Load offset of Fixed1_e array to si
    mov ebx,eax               ;Copy into ebx
    neg eax                   ;Change the sign
    shr eax,FixedShift        ;Get rid of fraction
    inc eax                   ;Add one so output is always positive for rest
                              ; of expression.
    cmp eax,20                ;Compare with max array index
    jle NotZeroExp            ;Jump if not out of range
    mov eax,0                 ;If out of range load with 0
    jmp EndExp                ;Jump and exit
  NotZeroExp:
    shl eax,2                 ;Multiply by 4 for index with si
    add si,ax                 ;Add to si to index array
    mov edi,[si]              ;Load index e into edi
    shl eax,FixedShift-2      ;Shift back to original position.
    sub ebx,eax               ;This will always give me a positive number
                              ; because I added one earlyer
  EndFindIntExp:
                              ;Now onto e to the fractional part
                              ;Currently x is in ebx and 0<=x<=1
                              ;The first two steps, I do not need to go
                              ; through the loop, because when n=0 the answer
                              ; is always 1 and when n=1 then answer is always
                              ; x.  This way I can just start out the first
                              ; two steps with x+1.  But I am leaving the +1
                              ; until the end, because I am moving the fixed
                              ; point to 31.  ecx is where I keep my sum.
                              ; eax is where I keep x^n and ebx is where I
                              ; keep x.
    shl ebx,31-FixedShift     ;Move Fixed point to 31
    mov ecx,ebx               ;Copy to ecx
    mov eax,ebx               ;Copy to eax
    mov si,OFFSET Factorial   ;Load si with index to Factorial array
  ExpLoop:
    mul ebx                   ;Multiply x^(n-1)*x to get x^n
    shrd eax,edx,31           ;Move fixed point and save in eax
    push eax                  ;Push x^n temporaraly
    xor edx,edx               ;Clear edx for div
    div DWORD PTR [si]        ;Divide x^n/n! for sum
    mov edx,eax               ;Save in edx for compare with 0
    add ecx,eax               ;Add to sum
    pop eax                   ;Restore eax to x^n
    add si,4                  ;Increment index to factorial array
    or edx,edx                ;Set flags
    jne ExpLoop               ;Jump if x^n/n! is not 0
  EndExpLoop:                 ;Dummy label
    mov eax,edi               ;Copy e^(integer part) to eax
    mul ecx                   ;Multiply by sum
    shrd eax,edx,31           ;Remember fixed point of sum was 31
    add eax,edi               ;The sum was supposed to be sum+1
    or eax,eax                ;Check to see if summ overflowed into negetive
    jns EndExp                ;Jump if not overflow
    mov eax,MaxPos            ;Return MaxPos, I do it this way because I'm
                              ; lazy and did not want to calculate the real
                              ; Maxe that was not integer
  EndExp:
    mov edx,eax
    sar edx,16
    ret
  FixedExp ENDP


  FixedLn PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedLn
                              ;ln(1+y)=ln(x)=sum n=0-infinity of
                              ; ((-1)^n*(y)^(n+1))/(n+1), so y=x-1
                              ;This equation only works if -1<y<1 or 0<x<2
                              ;The first part will take x and divide by e^n
                              ; where n is an integer from 1 to Maxe
                              ;Of coures I am going to use the precalculated
                              ; values for e^n
                              ;This will only get me a value of 0<x<e, so I
                              ; will have to divide by e again
                              ;I will only divide by e again if the output
                              ; ends up greater than one
                              ;I do this so 0<x<1, this will make y always
                              ; -1<y<0.  Then I can make the equation
                              ; simpliler and convert it to
                              ; -(abs(y)^(n+1))/(n+1), this way I do not have
                              ; to keep track of (-1)^n
                              ;This also makes it so when I divide by e^n, n
                              ; is not the truncated value of the answer, but
                              ; one more than the answer.
                              ;I came up with a few equations that might
                              ; interest you but might bore you.  They are
                              ; ln(x)=ln(x)-n+n=ln(x)-ln(e^n)+n=ln(x/(e^n))+n
                              ;This is how I am able to divide out the e^n
                              ; where n is an integer between 1 and Maxe
                              ;Now of coure I while check to see if x is
                              ; negetive first
                              ;To make things worse I will try to make 1/e<x<1
    mov eax,a                 ;Move x to eax
    or eax,eax                ;Check if negetive
    jg StartLnTest            ;Jump if not negetive or zero
    mov eax,MaxNeg            ;Remember the antisa (no I did not mean Alamo)
    jmp EndLn                 ;Return error
  StartLnTest:
    xor ecx,ecx               ;Clear counter
    cmp eax,FixedOne          ;Skip x/(e^n) if less than one
    je StartLn                ;If 1 then just do it
    jl TestLnLess             ;Do jump
    mov si,OFFSET Fixede      ;Load offset of array of e^n
    add si,4                  ;Move array ptr to e^1
  TestLnGreater:              ;Dummy jump point, just for discription
    inc ecx                   ;Increment counter
  LnGreaterTestLoop:
    cmp eax,[si]              ;Compare x to e^n
    jl EndLnGreaterTest       ;Jump out of loop if not greater or equal
    add si,4                  ;Move array ptr to next e^n
    inc ecx                   ;Increment counter
    cmp cx,Maxe               ;Check if in range of Maxe
    jle LnGreaterTestLoop     ;If still in range jump
    mov ebx,F1_e              ;Load ebx with 1/e
    mul ebx                   ;This will only happen if x>(e^Maxe)
                              ;I do this to make sure that the ultimate answer
                              ; will give me x<1 as quoted above
    mov eax,edx               ;F1_e has a fixed point of 32
    sub si,4                  ;Keep array pointer where it was
  EndLnGreaterTest:
    mov edx,eax               ;Prepare for division
    shr edx,32-FixedShift     ;Shift edx to right
    shl eax,FixedShift        ;Shift eax to left, now a is in eax:edx
    div DWORD PTR [si]        ;Divide by e^n
    shl ecx,FixedShift        ;Turn counter into fixed point
    jmp StartLn               ;Jump past the test less side
  TestLnLess:
    cmp eax,Fixed1_e[4]
    jg StartLn                ;Do jump
    mov si,OFFSET Fixede      ;Load offset of array of e^n
    add si,4                  ;Move array ptr to e^1
    mov di,OFFSET Fixed1_e    ;Load offset of array of (1/e)^n
    add di,8                  ;Move array ptr to (1/e)^2
    inc ecx                   ;Increment counter
    mov ebx,Fe                ;Load ebx with e.  Did it here so not in loop
  LnLessTestLoop:
    cmp eax,[di]              ;Compare x to (1/e)^n
    jg EndLnLessTest          ;Jump out of loop if not greater or equal
    add si,4                  ;Move array ptr to next e^n
    add di,4                  ;Move array ptr to next e^n
    inc ecx                   ;Increment counter
    cmp cx,Maxe               ;Check if in range of Maxe
    jle LnLessTestLoop        ;If still in range jump
    mul ebx                   ;This will only happen if x<((1/e)^Maxe)
                              ;I do this to make sure that the ultimate answer
                              ; will give me x<1 as quoted above
    shrd eax,edx,30           ;Fe has a fixed point of 30
    sub si,4                  ;Keep array pointer where it was
    sub di,4                  ;Keep array pointer where it was
    jmp LnLessTestLoop        ;Do it again because (1/e)^n n=0..20
  EndLnLessTest:
    mul DWORD PTR [si]        ;Multiply by e^n
    shrd eax,edx,FixedShift   ;Do shift
    shl ecx,FixedShift        ;Turn counter into fixed point
    neg ecx                   ;Negate counter
  StartLn:
    sub eax,FixedOne          ;Subtract one
    neg eax                   ;Since eax will always be negetive after
                              ; subtract (It will, trust me.) I am converting
                              ; it to a positive number, and do my modified
                              ; equation without the (-1)^n.  Pretty cool eh?
    mov edi,ecx               ;Save counter value
    shl eax,32-FixedShift     ;Convert number to a fixed point of 32, I do to
                              ; remove some instructions when finding x^(n+1)
    mov ebx,eax               ;x will be stored in ebx
    mov ecx,eax               ;Temporary location of the sum for precalc
    mul ebx                   ;Initialize to x^2 n=1
    mov eax,edx               ;Move answer to eax
    shr edx,1                 ;Divide by two
    add edx,ecx               ;Add x+x^2/2, this is the first two sums in the
                              ; series
    mov ecx,3                 ;Initialize n=2, since the value I want is n+1
                              ; for the equation, I added one
  LnLoop:                     ;During the loop eax=x^(n+1), ebx=x, ecx=n+1
                              ; edx=sum (this value is usually pushed on the
                              ; stack
    push edx                  ;Push sum onto stack
    mul ebx                   ;Multipliy x by x^n
    mov eax,edx               ;Put answer in eax
    xor edx,edx               ;Clear edx for division
    mov esi,eax               ;Temporaraly store x^(n+1) in esi
    div ecx                   ;Divide by n+1
    pop edx                   ;Pop sum to edx
    add edx,eax               ;Add x^(n+1)/(n+1) to sum
    inc ecx                   ;Increment n+1
    or eax,eax                ;Check if x^(n+1)/(n+1) is zero yet
    mov eax,esi               ;restore x^n (this is after increment on n)
    jne LnLoop                ;Jump if not zero
  EndLnLoop:                  ;Dummy label
    shr edx,32-FixedShift     ;Return fixed point to original value
    neg edx                   ;Negate answer like it was suposed to be
    mov eax,edi               ;Restore counter
    add eax,edx               ;Add the two together
  EndLn:
    mov edx,eax
    sar edx,16
    ret
  FixedLn ENDP



  FixedCos PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedCos           ;cos(x)=sum of n=0 to infinity of
                              ; (-1)^n*x^(2*n)/((2*n)!)
                              ;Because the equation requires that x^(2*n)
                              ; I have to convert x to quadrants, because
                              ; answer will go out of range real quick
                              ;To make it easy on me I am going to so the
                              ; math of my conversion, not an explanation
                              ;y:=(x DIV (pi/2)) and 3
                              ;z:=(x MOD (pi/2))
                              ;if y=0 a:=0
                              ;if y=1 z:=pi/2-z a:=1
                              ;if y=2 a:=1
                              ;if y=3 z:=pi/2-z a:=0
                              ;cos(x):=(1-2*(a))*cos(z)
    mov eax,a                 ;Load a to eax
    or eax,eax                ;Change flags if negetive
    jns NotAbsCos             ;Jump if not negetive
    neg eax                   ;Negate a if it was negetive
  NotAbsCos:
    xor edx,edx               ;Prepare for division
    div Fixed1_2Pi            ;Divide by pi/2, MOD part in edx, and DIV part
                              ; in eax
    xor di,di                 ;This is where I store whether the final answer
                              ; is negated or not
    and eax,3                 ;MOD quadrant by 4 and set flags
    jz EndConvertCos          ;Jump if no conversion nesecary
    sub eax,2                 ;Subtract 2 to see if in quadrant 1 or 2
    jg NotNegOutCos           ;Jump if final answer not negetive
    xor di,1
  NotNegOutCos:
    shr eax,1                 ;Move first bit into carry flag, this will find
                              ; if in quadrant 1 and 3
    jnc EndConvertCos         ;Beam me out of here Scotty
    sub edx,Fixed1_2Pi        ;Subtract pi/2
  EndConvertCos:
                              ;Since the equation has x^(2*n) I am using x^2
                              ; as my multiplier, this will also make it
                              ; always positive, so I won't have to do integer
                              ; mul or div
                              ;As usual I will do the first two steps of n=0
                              ; and n=1, the answer will be 1-x^2/2
                              ;I will be keeping x^2 in ebx, x^(2*n) in ecx,
                              ; and the sum in edx
    mov eax,edx               ;Copy x to eax
    imul eax                  ;Square it
    shrd eax,edx,FixedShift   ;Convert back to fixed point
    mov ebx,eax               ;Copy x^2 to ebx
    mov ecx,eax               ;Copy x^2 to ecx
    mov edx,FixedOne          ;Load edx with one
    shr eax,1                 ;Divide x^2 by 2 for first step
    sub edx,eax               ;Subtract 1 by x^2/2
    mov si,OFFSET Factorial[8];Array of Factorial, starting with 4!
  CosLoop:
    push edx                  ;Push sum
    mov eax,ecx               ;Copy x^(2*n-2) to eax
    mul ebx                   ;Multiply x^(2*n-2) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov ecx,eax               ;Copy x^(2*n) to ecx
    xor edx,edx               ;Clear edx for division
    div DWORD PTR [si]        ;Divide by (2*n)!
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    jz EndCosLoop             ;End if answer=0
    add si,8                  ;Increment factorial array by 2 to (2*n+2)!
    add edx,eax               ;Add x^(2*n)/(2*n)! to sum

    push edx                  ;Push sum
    mov eax,ecx               ;Copy x^(2*n-2) to eax
    mul ebx                   ;Multiply x^(2*n-2) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov ecx,eax               ;Copy x^(2*n) to ecx
    xor edx,edx               ;Clear edx for division
    div DWORD PTR [si]        ;Divide by (2*n)!
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    jz EndCosLoop             ;End if answer=0
    add si,8                  ;Increment factorial array by 2 to (2*n+2)!
    sub edx,eax               ;Subtract x^(2*n)/(2*n)! to sum
    jmp CosLoop               ;Loop again
  EndCosLoop:
    or di,di                  ;Check if final output should be negetive
    jz NotNegCos              ;Jump if not
    neg edx                   ;Negate output
  NotNegCos:
    mov eax,edx
    sar edx,16
    ret
  FixedCos ENDP


  FixedSin PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedSin           ;sin(x)=sum of n=0 to infinity of
                              ; (-1)^n*x^(2*n+1)/((2*n+1)!)
                              ;Because the equation requires that x^(2*n+1)
                              ; I have to convert x to quadrants, because
                              ; answer will go out of range real quick
                              ;To make it easy on me I am going to so the
                              ; math of my conversion, not an explanation
                              ;a:=1-x/(abs(x))
                              ;y:=(x DIV (pi/2)) and 3
                              ;z:=(x MOD (pi/2))
                              ;if y=0 nothing to convert
                              ;if y=1 z:=pi/2-z
                              ;if y=2 a:=a xor 1
                              ;if y=3 a:=a xor 1  z:=pi/2-z
                              ;sin(x):=(1-2*(a))*sin(z)
    mov eax,a                 ;Load a to eax
    xor di,di                 ;This is where I store whether the final output
                              ; is negated
    or eax,eax                ;Change flags if negetive
    jns NotAbsSin             ;Jump if not negetive
    xor di,1                  ;If negetive final output is negated
    neg eax                   ;Negate a if it was negetive
  NotAbsSin:
    xor edx,edx               ;Prepare for division
    div Fixed1_2Pi            ;Divide by pi/2, MOD part in edx, and DIV part
                              ; in eax
    and eax,3                 ;MOD quadrant by 4 and set flags
    jz EndConvertSin          ;Jump if no conversion nesecary
    sub eax,2                 ;Subtract 2 to see if in quadrant 2 or 3
    jl NotNegOutSin           ;Jump if final answer not negetive
    xor di,1                  ;Change the sign of the final output
  NotNegOutSin:
    shr eax,1                 ;Move first bit into carry flag, this will find
                              ; if in quadrant 1 and 3
    jnc EndConvertSin         ;Beam me out of here Scotty
    sub edx,Fixed1_2Pi        ;Subtract pi/2
    neg edx                   ;Change the sign
  EndConvertSin:
                              ;Since the equation has x^(2*n+1) I am using x^2
                              ; as my multiplier, since I moved the quadrants
                              ; around so much I also made x^(2*n+1)
                              ; always positive, so I won't have to do integer
                              ; mul or div
                              ;This time I will start out with only n=0
                              ;I will be keeping x^2 in ebx, x^(2*n+1) in ecx,
                              ; and the sum in edx
    mov eax,edx               ;Copy x to eax
    mov ecx,edx               ;Copy x to ecx
    imul eax                  ;Square it
    shrd eax,edx,FixedShift   ;Convert back to fixed point
    mov ebx,eax               ;Copy x^2 to ebx
    mov edx,ecx               ;Load edx with x
    mov si,OFFSET Factorial[4];Array of Factorial, starting with 3!
  SinLoop:
    push edx                  ;Push sum
    mov eax,ecx               ;Copy x^(2*n-1) to eax
    mul ebx                   ;Multiply x^(2*n-1) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov ecx,eax               ;Copy x^(2*n+1) to ecx
    xor edx,edx               ;Clear edx for division
    div DWORD PTR [si]        ;Divide by (2*n+1)!
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    jz EndSinLoop             ;End if answer=0
    add si,8                  ;Increment factorial array by 2 to (2*n+3)!
    sub edx,eax               ;Subtract x^(2*n+1)/(2*n+1)! to sum

    push edx                  ;Push sum
    mov eax,ecx               ;Copy x^(2*n-1) to eax
    mul ebx                   ;Multiply x^(2*n-1) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov ecx,eax               ;Copy x^(2*n+1) to ecx
    xor edx,edx               ;Clear edx for division
    div DWORD PTR [si]        ;Divide by (2*n+1)!
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    jz EndSinLoop             ;End if answer=0
    add si,8                  ;Increment factorial array by 2 to (2*n+3)!
    add edx,eax               ;Add x^(2*n+1)/(2*n+1)! to sum
    jmp SinLoop               ;Loop again
  EndSinLoop:
    or di,di                  ;Check if final output should be negetive
    jz NotNegSin              ;Jump if not
    neg edx                   ;Negate output
  NotNegSin:
    mov eax,edx
    sar edx,16
    ret
  FixedSin ENDP



  FixedTan PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedTan           ;tan(x)=sin(x)/cos(x)
                              ;sin(x)=sum of n=0 to infinity of
                              ; (-1)^n*x^(2*n+1)/((2*n+1)!)
                              ;cos(x)=sum of n=0 to infinity of
                              ; (-1)^n*x^(2*n)/((2*n)!)
                              ;Since both equations have x^2 as a continual
                              ; multiplier, I will be using it for both
                              ;To make it easy on me I am going to so the
                              ; math of my conversion, not an explanation
                              ;y:=(x DIV (pi/2)) and 3
                              ;z:=(x MOD (pi/2))
                              ;if y=0 a:=0
                              ;if y=1 z:=pi/2-z a:=1
                              ;if y=2 a:=0
                              ;if y=3 z:=pi/2-z a:=1
                              ;tan(x):=(1-2*(a))*sin(z)/cos(z)
    mov eax,a                 ;Load a to eax
    xor di,di                 ;This is where I store whether the final output
                              ; is negated
    or eax,eax                ;Change flags if negetive
    jns NotAbsSinTan          ;Jump if not negetive
    neg eax                   ;Negate a if it was negetive
    xor di,1                  ;Change final output to negetive
  NotAbsSinTan:
    xor edx,edx               ;Prepare for division
    div Fixed1_2Pi            ;Divide by pi/2, MOD part in edx, and DIV part
                              ; in eax
    and eax,3                 ;MOD quadrant by 4 and set flags
    jz EndConvertTan          ;Jump if no conversion nesecary
    shr eax,1                 ;Shift first bit out to carry to see if in
                              ; quadrant 1 or 3
    jnc EndConvertTan         ;Jump if no carry
    xor di,1                  ;Change the sign of the final output
    sub edx,Fixed1_2Pi        ;Subtract pi/2
    neg edx                   ;Change the sign
  EndConvertTan:
                              ;Since the equation has x^(2*n+1) I am using x^2
                              ; as my multiplier, Since I moved the quadrants
                              ; around so much I also made x^(2*n+1)
                              ; always positive, so I won't have to do integer
                              ; mul or div
                              ;This time I will start out with only n=0
                              ;I will be keeping x^2 in ebx, x^(2*n+1) in ecx,
                              ; and the sum in edx
    mov eax,edx               ;Copy x to eax
    mov ecx,edx               ;Copy x to ecx
    imul eax                  ;Square it
    shrd eax,edx,FixedShift   ;Convert back to fixed point
    mov ebx,eax               ;Copy x^2 to ebx
    mov edx,ecx               ;Load edx with x
    mov si,OFFSET Factorial[4];Array of Factorial, starting with 3!
  SinTanLoop:
    push edx                  ;Push sum
    mov eax,ecx               ;Copy x^(2*n-1) to eax
    mul ebx                   ;Multiply x^(2*n-1) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov ecx,eax               ;Copy x^(2*n+1) to ecx
    xor edx,edx               ;Clear edx for division
    div DWORD PTR [si]        ;Divide by (2*n+1)!
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    jz EndSinTanLoop          ;End if answer=0
    add si,8                  ;Increment factorial array by 2 to (2*n+3)!
    sub edx,eax               ;Subtract x^(2*n+1)/(2*n+1)! to sum

    push edx                  ;Push sum
    mov eax,ecx               ;Copy x^(2*n-1) to eax
    mul ebx                   ;Multiply x^(2*n-1) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov ecx,eax               ;Copy x^(2*n+1) to ecx
    xor edx,edx               ;Clear edx for division
    div DWORD PTR [si]        ;Divide by (2*n+1)!
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    jz EndSinTanLoop          ;End if answer=0
    add si,8                  ;Increment factorial array by 2 to (2*n+3)!
    add edx,eax               ;Add x^(2*n+1)/(2*n+1)! to sum
    jmp SinTanLoop            ;Loop again
  EndSinTanLoop:
    push edx                  ;push sin(x) on stack

                              ;cos(x)=sum of n=0 to infinity of
                              ; (-1)^n*x^(2*n)/((2*n)!)
                              ;As usual I will do the first two steps of n=0
                              ; and n=1, the answer will be 1-x^2/2
                              ;I will be keeping x^2 in ebx, x^(2*n) in ecx,
                              ; and the sum in edx
                              ;Remember ebx still holds x^2
    mov ecx,ebx               ;Copy x^2 to ecx
    mov eax,ebx               ;Copy x^2 to eax
    mov edx,FixedOne          ;Load edx with one
    shr eax,1                 ;Divide x^2 by 2 for first step
    sub edx,eax               ;Subtract 1 by x^2/2
    mov si,OFFSET Factorial[8];Array of Factorial, starting with 4!
  CosTanLoop:
    push edx                  ;Push sum
    mov eax,ecx               ;Copy x^(2*n-2) to eax
    mul ebx                   ;Multiply x^(2*n-2) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov ecx,eax               ;Copy x^(2*n) to ecx
    xor edx,edx               ;Clear edx for division
    div DWORD PTR [si]        ;Divide by (2*n)!
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    jz EndCosTanLoop          ;End if answer=0
    add si,8                  ;Increment factorial array by 2 to (2*n+2)!
    add edx,eax               ;Add x^(2*n)/(2*n)! to sum

    push edx                  ;Push sum
    mov eax,ecx               ;Copy x^(2*n-2) to eax
    mul ebx                   ;Multiply x^(2*n-2) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov ecx,eax               ;Copy x^(2*n) to ecx
    xor edx,edx               ;Clear edx for division
    div DWORD PTR [si]        ;Divide by (2*n)!
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    jz EndCosTanLoop          ;End if answer=0
    add si,8                  ;Increment factorial array by 2 to (2*n+2)!
    sub edx,eax               ;Subtract x^(2*n)/(2*n)! to sum
    jmp CosTanLoop            ;Loop again
  EndCosTanLoop:




    or edx,edx                ;Set flags if zero
    pop eax                   ;Pop sin(x) off of stack
    jne NotZeroDivTan         ;Jump if not divide by zero
    mov eax,MaxPos            ;Load MaxPos for return of positive infinity
    jmp EndDivTan             ;Jump to end and return MaxPos
  NegDivZeroTan:
    mov eax,MaxNeg            ;Load MaxNeg for return of negetive infinity
    jmp NotNegTan             ;Jump to end and return MaxNeg
  NotZeroDivTan:              ;Start divide
    mov ecx,eax               ;Copy to sin(x) to ecx for storage
    mov ebx,edx               ;Copy to cos(x) to ebx for storage
    cdq                       ;Sign extend sin(x)
    idiv ebx                  ;Divide by cos(x)
    or eax,eax                ;Check sign
    js NegDivTan              ;Jump if negetive
    shr eax,31-FixedShift     ;Shift for check overflow
    or eax,eax                ;Check if zero
    je ActualDivideTan        ;Jump if zero
    mov eax,MaxPos            ;Load with MaxPos if out of range
    jmp EndDivTan             ;Jump to end
  NegDivTan:
    neg eax                   ;Negate
    shr eax,31-FixedShift     ;Shift for check overflow
    or eax,eax                ;Check if zero
    je ActualDivideTan        ;Jump if zero
    mov eax,MaxNeg            ;Load with MaxNeg if out of range
    jmp EndDivTan             ;Jump to end
  ActualDivideTan:
    mov eax,ecx               ;Move sin(x) to eax
    mov edx,eax               ;Copy sin(x) to edx
    sar edx,32-FixedShift     ;Shift edx to right
    shl eax,FixedShift        ;Shift eax to left, now a is in eax:edx
    idiv ebx                  ;Integer divide by cos(x), answer in eax
  EndDivTan:
    or di,di                  ;Check if final output is negetive
    je NotNegTan              ;Jump if not
    neg eax                   ;Just do it already
  NotNegTan:
    mov edx,eax
    sar edx,16
    ret
  FixedTan ENDP


  FixedArcTan PROC FAR a:DWORD RETURNS result:DWORD
    PUBLIC FixedArcTan        ;atan(x)=sum of n=0 to infinity of
                              ; (-1)^n*x^(2*n+1)/(2*n+1)
                              ;Because the equation requires that x^(2*n+1)
                              ; I have to invert x if it is greater than one,
                              ; and pi/2 subtract answer
    mov ebx,a                 ;Load x to ebx
    xor di,di                 ;This is where I store whether the final output
                              ; is negated, and if I have to subtract answer
                              ; from pi/2
    or ebx,ebx                ;Change flags if negetive
    jns NotAbsATan            ;Jump if not negetive
    xor di,2                  ;If negetive final output is negated
    neg ebx                   ;Negate a if it was negetive
  NotAbsATan:
    mov eax,FixedOne          ;Move FixedOne into eax for division
    cmp ebx,eax               ;Check if greater than one
    jle NoInvATan             ;Jump If less than one or equal
    mov edx,eax               ;Copy to edx for conversion
    sar edx,32-FixedShift     ;Shift edx to right
    shl eax,FixedShift        ;Shift eax to left, now a is in eax:edx
    div ebx                   ;Divide one by a, answer in eax
    xor di,1                  ;Subtract final answer from pi/2
    mov ebx,eax               ;Copy answer ebx
  NoInvATan:

                              ;Since the equation has x^(2*n+1) I am using x^2
                              ; as my multiplier, since I moved the quadrants
                              ; around so much I also made x^(2*n+1)
                              ; always positive, so I won't have to do integer
                              ; mul or div
                              ;This time I will start out with only n=0
                              ;I will be keeping x^(2*n+1) in eax, x^2 in ebx,
                              ; 2*n+1 in ecx and the sum in edx
    mov eax,ebx               ;Copy x to eax
    mul eax                   ;Square it
    shrd eax,edx,FixedShift   ;Convert back to fixed point
    mov edx,ebx               ;Load edx with x (sum)
    mov ebx,eax               ;Copy x^2 to ebx
    mov eax,edx               ;Load eax with x (x^(2*n+1))
    mov ecx,1                 ;Load ecx with n (2*n+1)
  ATanLoop:
    push edx                  ;Push sum
    mul ebx                   ;Multiply x^(2*n-1) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov esi,eax               ;Copy x^(2*n+1) to esi
    xor edx,edx               ;Clear edx for division
    add ecx,2                 ;Add 2 to (2*n-1) to get (2*n+1)
    div ecx                   ;Divide x^(2*n+1) by (2*n+1)
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    je EndATanLoop            ;End if answer=0
    sub edx,eax               ;Subtract x^(2*n+1)/(2*n+1) to sum
    mov eax,esi               ;Restore x^(2*n+1) to eax

    push edx                  ;Push sum
    mul ebx                   ;Multiply x^(2*n-1) by x^2
    shrd eax,edx,FixedShift   ;Convert to fixed point
    mov esi,eax               ;Copy x^(2*n+1) to esi
    xor edx,edx               ;Clear edx for division
    add ecx,2                 ;Add 2 to (2*n-1) to get (2*n+1)
    div ecx                   ;Divide x^(2*n+1) by (2*n+1)
    pop edx                   ;Restore sum to edx
    or eax,eax                ;Check if answer=0
    je EndATanLoop            ;End if answer=0
    add edx,eax               ;Subtract x^(2*n+1)/(2*n+1) to sum
    mov eax,esi               ;Restore x^(2*n+1) to eax
    jmp ATanLoop              ;Play it again Sam
  EndATanLoop:
    shr di,1                  ;Move first bit into carry, to see if sub needed
    jnc NoSubATan             ;Jump if not
    mov eax,Fixed1_2Pi        ;Load eax with pi/2
    sub eax,edx               ;Subtract pi/2 by answer
    mov edx,eax               ;Move answer back to edx
  NoSubATan:
    shr di,1                  ;Move second bit into carry, to see if negate
    jnc NotNegATan            ;Jump if not
    neg edx                   ;Negate output
  NotNegATan:
    mov eax,edx
    sar edx,16
    ret
  FixedArcTan ENDP


  FixedRandom PROC FAR RETURNS result:DWORD
    PUBLIC FixedRandom
    mov eax,RandMult
    mul RandSeed
    add eax,RandIncr
    mov RandSeed,eax
    shr eax,32-FixedShift
    mov edx,eax
    sar edx,16
    ret
  FixedRandom ENDP


  Random PROC FAR RETURNS result:DWORD
    PUBLIC Random
    mov eax,RandMult
    mul RandSeed
    add eax,RandIncr
    mov RandSeed,eax
    mov edx,eax
    sar edx,16
    ret
  Random ENDP


  InitRandom PROC FAR Seed:DWORD,Mult:DWORD,Incr:DWORD
    PUBLIC InitRandom
    mov eax,Seed
    mov RandSeed,eax
    mov eax,Mult
    mov RandMult,eax
    mov eax,Incr
    mov RandIncr,eax
    ret
  InitRandom ENDP

END
