{Brought to you by Eric Nixon the Vegetable Rights Activist}

{I've had a complex number unit for some time, but now that I wrote the a
 fixed point math library, I had to convert it.  The old library was
 extreamly slow, due to the floting point.  I have not fully tested all of
 the functions, but they all should be tested by the time I release this unit.

 I have known about complex numbers for a long time.  I used them for math
 classes in junior high, and that was about the end of it.  But when I started
 writing programs to calculate pi (3.141592654) out to n digits, I came across
 an interesting equation in a book about pi, e^(pi*i)=-1.  When I saw this I
 was amazed, and had to find out how.  I now know that the imaginary part of
 a number used with exponents is the angle, and the real part is the
 magnitude.

 I started using complex numbers for real world applications in electronics,
 were a resistive load is the real part of the number while the capasitive or
 inductive load is represented by the imaginary number (bi is considered the
 imaginary part of the number.).  For series, parallel or any equation used
 for electronics I could use this method of calculating anything for the
 circuit.  Now of course in the higher electronics courses, they show you s
 transfroms, which is similar to my method but s transforms do a little more.
 In electronics they also represent the square root of negetive one with a j
 instead of with i like mathematics, so you won't get confused with current.
 Most college electronic courses teach this method of calculating, but where
 I went to school to get my BAS, they did not (mainly because some of my
 teacher did not know it, as you can tell I am not happy with my education or
 the school I went to).

 Since I was a kid in elementary I was always interested in computer graphics,
 and was amazed at some of the computer generated pictures (not this digitized
 crap you see in some of the games today).  As I recall the graphic animation
 was a square in n dimetional space being rotated though 3 dimentional space.
 It was also done on a cray and all I had was a CGA enhanced IBM PC with 64K
 of RAM and one single sided floppy, and DOS actualy fit on one disk.  I
 started programing in fith grade because of this graphic animation that I
 saw.  I started with some simple sinusoidal wave forms, and away I went.
 Now when I saw fractals being used in Start Trek when the genisis device
 exploded, I said I have to know how that was done.  Of course, at that time,
 I did not know that fractals was used to generate that animation.  I went on
 and found out about Mandelbrot and the equation used to calculate it.  To my
 discovery I found out that complex numbers were used to calculate the
 Mandelbrot series, and most fractals out there.  If you want to learn about
 fractals, I recommend the book "Dynamical Systems and Fractals" by Karl-Heinz
 Becker and Michael Dorfler.

 If you do not know what a complex number is then your chances of getting
 laid is probably higher than mine.  Any equation used for real numbers can
 also be used for complex numbers.  Basicaly a complex number is a number
 multiplied by the square root of negetive one, most of the time this is
 represented by the notation of bi, were i is the square root of negetive one.
 The significance of this is that when added to a real number you get a+bi, or
 a cartesian point, or a headache, which ever comes first.  You could also
 consider a complex number as a vector.  So if you add two complex numbers
 together you get the sum of the vectors.  Now if you multiply two vectors
 (or two complex numbers), your answer will be the magnitude of the vectors
 multiplied and thier angles added to get one vector.  You say, so what.  What
 if one of those vectors had a magnitude of 1?  Well you your final vector
 would end up being rotated by the angle of the vector whose magnitude was 1.
 When you have been working with vector rotation and translation for as long
 as I have, you will find that just multipling two complex number is
 significantly easyer to do than some of my earlyer rotation schemes that I
 learned in trig.  I'm not going to go into the explanation much further
 than this, so bugger off and bite the wax tadpole.

 To start off with, I usualy use a+bi or c+di to represent a complex number.
 I also use z to represent a complex number as a whole.  For those of you who
 have worked with complex numbers for a while, probably don't know how to take
 the ln(z), exp(z), sin(z), cos(z)....  (Just like I don't know how to take
 the factorial of a non-integer negetive, or non-integer positive number.  For
 those of you who don't believe me, pull out your HP 28s or high calculator
 and test it, it can be done says the GOD of math.)  If you have worked with
 the Mandelbrot seiries, try taking z sub n to the power of a complex number
 or a non-integer number.  You will get some interesting results.

 I have now passed the torch and given you the light, and maybe now you will
 see the significance of the number 42.  6*7 no, no, no, that cannot be it.
 If you do not grok complex numbers, then maybe that lobotomy was not such a
 great idea after all.

 Several of the functions in this unit are not needed, but in the future I
 plan on overloading the C++ operators, so forgive the extra functions.}


Unit CompF32;

  Interface

{$F-}
{$A+}
{$G+}
{$R-}
{$S-}
{$I-}
{$Q-}
{$D-}
{$L-}
{$Y-}
{$N-}
{$E-}


  Uses Fixed32;

  Type
    TFixedComplex=Record
      a:TFixed;                     {a is the real part}
      b:TFixed;                     {b is the imaginary part}
    end;
  Const
    Sqrt1_2=0.707106781187;
    FixedSqrt1_2=Trunc(Sqrt1_2*FixedOne);

  {I classify all of my functions and procedures in this unit with a
   'FixedComplex' prefix.  Following the prefix specifies what the
   function does.  I use a couple of suffixes as a modifier to the
   original function.  With a suffix of 'Real', one of the inputs is
   a real number (not floating point, it will still be a fixed point)
   as opposed to a complex number.  With a suffix of 'Imj', one of the
   inputs is an imaginiary number.  The reason I do this is to keep the
   computation time down, and I plan on using overloaded operators later
   in C++.  With a suffix of 'NoCheck', the function will not check to see
   if the fixed point number has overflowed its bounderies.  Even though
   the 'NoCheck' is faster, I do not recomend using them.}
  {Notice I left out the hyperbolic functions out of this unit.  I found out
   while writing the trig functions, that the hyperbolic functions are
   hidden inside the complex trig functions.  What I mean is that the
   hyperbolic answers show up when you take the trig function with an
   imaginary number.}


  {The following are a couple of procedures that write the complex number
   to the screen.  The ones with 'Write' have no carrige return, while the
   'WriteLn' does (Hmmmm... Just like pascal does Eh?).  The procedures with
   'Conv' as a suffix, Convert the fixed number to real before it outputs to
   the screen.}
  Procedure FixedComplexWriteLn(a:TFixedComplex);
  Procedure FixedComplexWrite(a:TFixedComplex);
  Procedure FixedComplexWriteLnConv(a:TFixedComplex);
  Procedure FixedComplexWriteConv(a:TFixedComplex);


  {These are a couple of miscellaneous functions that come in handy.}
  {Conjugate:  Returns the original number with the imaginary part
               negated.}
  {Sign:       Returns the complex number with the same angle but with the
               magnitude reduced, or increased to 1.}
  {Negate:     Returns the real and the imaginary part negated.}
  {Polar:      Returns r+theta*i with input of cartisian a+bi.}
  {Cartisian:  Returns a+bi with input of polar r+theta*i.}
  {Real:       Returns the real part of a complex number.}
  {Imaginary:  Returns the imaginary part of a complex number.}
  {Absolute:   Returns the magnitude of the complex number.}
  {Argument:   Returns the angle of the complex number.}
  Procedure FixedComplexConj(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexSign(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexNeg(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexPolToCar(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexCarToPol(a:TFixedComplex; var c:TFixedComplex);
  Function FixedComplexReal(a:TFixedComplex):TFixed;
  Function FixedComplexImg(a:TFixedComplex):TFixed;
  Function FixedComplexAbs(a:TFixedComplex):TFixed;
  Function FixedComplexArg(a:TFixedComplex):TFixed;


  {Add}
  Procedure FixedComplexAdd(a,b:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexAddReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexAddImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);


  {Subtract (a-b)}
  Procedure FixedComplexSub(a,b:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexSubReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexSubImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);


  {Multiply}
  Procedure FixedComplexMult(a,b:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexMultNoCheck(a,b:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexMultReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexMultRealNoCheck(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexMultImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexMultImgNoCheck(a:TFixedComplex;b:TFixed; var c:TFixedComplex);


  {Multiply by i}
  Procedure FixedComplexMulti(a:TFixedComplex; var c:TFixedComplex);


  {Divide (a/b)}
  Procedure FixedComplexDiv(a,b:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexDivNoCheck(a,b:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexDivReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexDivRealNoCheck(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexDivImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexDivImgNoCheck(a:TFixedComplex;b:TFixed; var c:TFixedComplex);


  {Invert (1/a)}
  Procedure FixedComplexInv(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexInvNoCheck(a:TFixedComplex; var c:TFixedComplex);


  {Square}
  Procedure FixedComplexSqr(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexSqrNoCheck(a:TFixedComplex; var c:TFixedComplex);


  {Square Root}
  Procedure FixedComplexSqrt(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexSqrtReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexSqrtImg(a:TFixed; var c:TFixedComplex);


  {Exponent}
  Procedure FixedComplexExp(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexExpReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexExpImg(a:TFixed; var c:TFixedComplex);


  {Natural Log}
  Procedure FixedComplexLn(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexLnReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexLnImg(a:TFixed; var c:TFixedComplex);


  {Sine}
  Procedure FixedComplexSin(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexSinReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexSinImg(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexASin(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexASinReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexASinImg(a:TFixed; var c:TFixedComplex);


  {Cosine}
  Procedure FixedComplexCos(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexCosReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexCosImg(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexACos(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexACosReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexACosImg(a:TFixed; var c:TFixedComplex);


  {Tangent}
  Procedure FixedComplexTan(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexTanReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexTanImg(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexATan(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexATanHP(a:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexATanReal(a:TFixed; var c:TFixedComplex);
  Procedure FixedComplexATanImg(a:TFixed; var c:TFixedComplex);


  {Number to the power of another number (a^b)}
  Procedure FixedComplexPower(a,b:TFixedComplex; var c:TFixedComplex);
  Procedure FixedComplexPowerReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
  Procedure FixedComplexPowerImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);


Implementation

  Procedure FixedComplexWriteLn(a:TFixedComplex);
    begin
      if a.b>=0 then
        WriteLn('(',a.a,'+',a.b,'i)')
      else
        WriteLn('(',a.a,a.b,'i)');
    end;
  Procedure FixedComplexWrite(a:TFixedComplex);
    begin
      if a.b>=0 then
        Write('(',a.a,'+',a.b,'i)')
      else
        Write('(',a.a,a.b,'i)');
    end;
  Procedure FixedComplexWriteLnConv(a:TFixedComplex);
    begin
      if a.b>=0 then
        WriteLn('(',FixedToReal(a.a):1:7,'+',FixedToReal(a.b):1:7,'i)')
      else
        WriteLn('(',FixedToReal(a.a):1:7,FixedToReal(a.b):1:7,'i)')
    end;
  Procedure FixedComplexWriteConv(a:TFixedComplex);
    begin
      if a.b>=0 then
        Write('(',FixedToReal(a.a):1:7,'+',FixedToReal(a.b):1:7,'i)')
      else
        Write('(',FixedToReal(a.a):1:7,FixedToReal(a.b):1:7,'i)')
    end;


  Procedure FixedComplexConj(a:TFixedComplex; var c:TFixedComplex);
    begin   { Conj(a+bi)=a-bi }
      c.a:=a.a;
      c.b:=-a.b;
    end;
  Procedure FixedComplexSign(a:TFixedComplex; var c:TFixedComplex);
    begin   { r=(a^2+b^2)^(1/2) Sign(a+bi)=a/r+bi/r }
      c.b:=FixedComplexAbs(a);
      c.a:=FixedDiv(a.a,c.b);
      c.b:=FixedDiv(a.b,c.b);
    end;
  Procedure FixedComplexNeg(a:TFixedComplex; var c:TFixedComplex);
    begin   { Neg(a+bi)=-a-bi }
      c.a:=-a.a;
      c.b:=-a.b;
    end;
  Procedure FixedComplexPolToCar(a:TFixedComplex; var c:TFixedComplex);
    begin   { PolToCar(r+theta*i)=a+bi=r*sin(theta)+r*cos(theta) }
      c.a:=FixedMult(a.a,FixedCos(a.b));
      c.b:=FixedMult(a.a,FixedSin(a.b));
    end;
  Procedure FixedComplexCarToPol(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi CarToPol(z)=Abs(z)+Arg(z)i }
      c.a:=FixedComplexAbs(a);
      c.b:=FixedComplexArg(a);
    end;
  Function FixedComplexReal(a:TFixedComplex):TFixed;
    begin   { Real(a+bi)=a }
      FixedComplexReal:=a.a;
    end;
  Function FixedComplexImg(a:TFixedComplex):TFixed;
    begin   { Img(a+bi)=b }
      FixedComplexImg:=a.b;
    end;
  Function FixedComplexAbs(a:TFixedComplex):TFixed;
    begin   { Abs(a+bi)=(a^2+b^2)^(1/2) }
      FixedComplexAbs:=FixedSqrt(FixedSqr(a.a)+FixedSqr(a.b));
    end;
  Function FixedComplexArg(a:TFixedComplex):TFixed;
    var     { Arg(a+bi)=theta }
      Temp:TFixed;
    begin
      if a.a=0 then
        Temp:=Fixed1_2Pi
      else
        Temp:=FixedATan(FixedDiv(a.b,a.a));
      if a.a<0 then
        if a.b<0 then
          Temp:=-FixedPi+Temp
        else
          Temp:=Temp+FixedPi
      else
        if (a.a=0) and (a.b<0) then
          Temp:=-Temp;
      FixedComplexArg:=Temp;
    end;


  Procedure FixedComplexAdd(a,b:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)+(c+di)=(a+c)+(b+d)i }
      c.a:=a.a+b.a;
      c.b:=a.b+b.b;
    end;
  Procedure FixedComplexAddReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)+c=(a+c)+bi }
      c.a:=a.a+b;
      c.b:=a.b;
    end;
  Procedure FixedComplexAddImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)+di=a+(b+d)i }
      c.a:=a.a;
      c.b:=a.b+b;
    end;


  Procedure FixedComplexSub(a,b:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)-(c+di)=(a-c)+(b-d)i }
      c.a:=a.a-b.a;
      c.b:=a.b-b.b;
    end;
  Procedure FixedComplexSubReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)-c=(a-c)+bi }
      c.a:=a.a-b;
      c.b:=a.b;
    end;
  Procedure FixedComplexSubImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)-di=a+(b-d)i }
      c.a:=a.a;
      c.b:=a.b-b;
    end;


  Procedure FixedComplexMult(a,b:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)*(c+di)=(a*c-b*d)+(a*d+b*c)i }
      c.a:=FixedMult(a.a,b.a)-FixedMult(a.b,b.b);
      c.b:=FixedMult(a.a,b.b)+FixedMult(a.b,b.a);
    end;
  Procedure FixedComplexMultNoCheck(a,b:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)*(c+di)=(a*c-b*d)+(a*d+b*c)i }
      c.a:=FixedMultNoCheck(a.a,b.a)-FixedMultNoCheck(a.b,b.b);
      c.b:=FixedMultNoCheck(a.a,b.b)+FixedMultNoCheck(a.b,b.a);
    end;
  Procedure FixedComplexMultReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)*c=a*c+(b*c)i }
      c.a:=FixedMult(a.a,b);
      c.b:=FixedMult(a.b,b);
    end;
  Procedure FixedComplexMultRealNoCheck(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)*c=a*c+(b*c)i }
      c.a:=FixedMultNoCheck(a.a,b);
      c.b:=FixedMultNoCheck(a.b,b);
    end;
  Procedure FixedComplexMultImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)*ci=-(b*c)+(a*c)i }
      c.a:=-FixedMult(a.b,b);
      c.b:=FixedMult(a.a,b);
    end;
  Procedure FixedComplexMultImgNoCheck(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)*ci=-(b*c)+(a*c)i }
      c.a:=-FixedMultNoCheck(a.b,b);
      c.b:=FixedMultNoCheck(a.a,b);
    end;


  Procedure FixedComplexMulti(a:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)*(i)=-b+ai }
      c.a:=-a.b;
      c.b:=a.a;
    end;


  Procedure FixedComplexDiv(a,b:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)/(c+di)=((a+bi)*(c-di))/(c^2+d^2) }
      b.b:=-b.b;
      FixedComplexMult(a,b,c);
      b.a:=FixedSqr(b.a)+FixedSqr(b.b);
      c.a:=FixedDiv(c.a,b.a);
      c.b:=FixedDiv(c.b,b.a);
    end;
  Procedure FixedComplexDivNoCheck(a,b:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)/(c+di)=((a+bi)*(c-di))/(c^2+d^2) }
      b.b:=-b.b;
      FixedComplexMultNoCheck(a,b,c);
      b.a:=FixedSqrNoCheck(b.a)+FixedSqrNoCheck(b.b);
      c.a:=FixedDivNoCheck(c.a,b.a);
      c.b:=FixedDivNoCheck(c.b,b.a);
    end;
  Procedure FixedComplexDivReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)/c=a/c+(b/c)i }
      c.a:=FixedDiv(a.a,b);
      c.b:=FixedDiv(a.b,b);
    end;
  Procedure FixedComplexDivRealNoCheck(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)/c=a/c+(b/c)i }
      c.a:=FixedDivNoCheck(a.a,b);
      c.b:=FixedDivNoCheck(a.b,b);
    end;
  Procedure FixedComplexDivImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)/(di)=b/d-(a/d)i }
      c.a:=FixedDiv(a.b,b);
      c.b:=-FixedDiv(a.a,b);
    end;
  Procedure FixedComplexDivImgNoCheck(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { (a+bi)/(di)=b/d-(a/d)i }
      c.a:=FixedDivNoCheck(a.b,b);
      c.b:=-FixedDivNoCheck(a.a,b);
    end;


  Procedure FixedComplexInv(a:TFixedComplex; var c:TFixedComplex);
    begin   { 1/(a+bi)=(a-bi)/(a^2+b^2) }
      c.b:=FixedSqr(a.a)+FixedSqr(a.b);
      c.a:=FixedDiv(a.a,c.b);
      c.b:=FixedDiv(-a.b,c.b);
    end;
  Procedure FixedComplexInvNoCheck(a:TFixedComplex; var c:TFixedComplex);
    begin   { 1/(a+bi)=(a-bi)/(a^2+b^2) }
      c.b:=FixedSqrNoCheck(a.a)+FixedSqrNoCheck(a.b);
      c.a:=FixedDivNoCheck(a.a,c.b);
      c.b:=FixedDivNoCheck(-a.b,c.b);
    end;


  Procedure FixedComplexSqr(a:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)^2=(a^2-b^2)+(2*a*b)i }
      c.a:=FixedSqr(a.a)-FixedSqr(a.b);
      c.b:=FixedMult(a.a,a.b) shl 1;
    end;
  Procedure FixedComplexSqrNoCheck(a:TFixedComplex; var c:TFixedComplex);
    begin   { (a+bi)^2=(a^2-b^2)+(2*a*b)i }
      c.a:=FixedSqrNoCheck(a.a)-FixedSqrNoCheck(a.b);
      c.b:=FixedMultNoCheck(a.a,a.b) shl 1;
    end;


  Procedure FixedComplexSqrt(a:TFixedComplex; var c:TFixedComplex);
    begin   { z^(1/2)=e^(ln(z)/2) }
      if a.a=0 then
        if a.b=0 then
          begin
            c.a:=0;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexSqrtImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexSqrtReal(a.a,c);
            Exit;
          end;
      FixedComplexLn(a,c);
      c.a:=FixedDiv2(c.a);
      c.b:=FixedDiv2(c.b);
      FixedComplexExp(c,c);
    end;
  Procedure FixedComplexSqrtReal(a:TFixed; var c:TFixedComplex);
    begin   { a^(1/2)=sign(a)^(1/2)*abs(a)^(1/2) }
      if a<0 then
        begin
          c.a:=0;
          c.b:=FixedSqrt(a);
        end
      else
        begin
          c.a:=FixedSqrt(a);
          c.b:=0;
        end;
    end;
  Procedure FixedComplexSqrtImg(a:TFixed; var c:TFixedComplex);
    begin   { (ai)^(1/2)=e^(ln(ai)/2)=abs(a)^(1/2)*(sqrt1_2+sign(a)*sqrt1_2i) }
      c.a:=FixedMult(FixedSqrt(a),FixedSqrt1_2);
      if a<0 then
        c.b:=-c.a
      else
        c.b:=c.a;
    end;


  Procedure FixedComplexExp(a:TFixedComplex; var c:TFixedComplex);
    begin   { e^(a+bi)=e^a(cos(b)+sin(b)i) }
      if a.a=0 then
        if a.b=0 then
          begin
            c.a:=FixedOne;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexExpImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexExpReal(a.a,c);
            Exit;
          end;
      a.a:=FixedExp(a.a);
      c.a:=FixedMult(FixedCos(a.b),a.a);
      c.b:=FixedMult(FixedSin(a.b),a.a);
    end;
  Procedure FixedComplexExpReal(a:TFixed; var c:TFixedComplex);
    begin   { e^a=e^a }
      c.a:=FixedExp(a);
      c.b:=0;
    end;
  Procedure FixedComplexExpImg(a:TFixed; var c:TFixedComplex);
    begin   { e^(bi)=cos(b)+sin(b)i }
      c.a:=FixedCos(a);
      c.b:=FixedSin(a);
    end;


  Procedure FixedComplexLn(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi ln(z)=ln(abs(z))+arg(z)i }
      if a.a=0 then
        if a.b=0 then
          begin
            c.a:=MaxNeg;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexLnImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexLnReal(a.a,c);
            Exit;
          end;
      c.a:=FixedLn(FixedComplexAbs(a));
      c.b:=FixedComplexArg(a);
    end;
  Procedure FixedComplexLnReal(a:TFixed; var c:TFixedComplex);
    begin   { ln(a)=ln(abs(a))+((1-Sign(a))/2)*pi }
      if a<0 then
        begin
          c.a:=FixedLn(-a);
          c.b:=FixedPi;
        end
      else
        begin
          c.a:=FixedLn(a);
          c.b:=0;
        end;
    end;
  Procedure FixedComplexLnImg(a:TFixed; var c:TFixedComplex);
    begin   { ln(ai)=ln(abs(a))+sign(a)*(pi/2) }
      if a<0 then
        begin
          c.a:=FixedLn(-a);
          c.b:=-Fixed1_2Pi;
        end
      else
        begin
          c.a:=FixedLn(a);
          c.b:=Fixed1_2Pi;
        end;
    end;


  Procedure FixedComplexSin(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi sin(z)=((e^(zi)-e^(-zi))/2i }
            { or try sin(a+bi)=sin(a)*cosh(b)+cos(a)*sinh(b) }
      if a.a=0 then
        if a.b=0 then
          begin
            c.a:=0;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexSinImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexSinReal(a.a,c);
            Exit;
          end;
      c.a:=FixedSin(a.a);
      c.b:=FixedCos(a.a);
      a.a:=FixedExp(a.b);
      a.b:=FixedInv(a.a);
      c.a:=FixedDiv2(FixedMult(a.a+a.b,c.a));
      c.b:=FixedDiv2(FixedMult(a.a-a.b,c.b));
    end;
  Procedure FixedComplexSinReal(a:TFixed; var c:TFixedComplex);
    begin   { sin(a)=sin(a) }
      c.a:=FixedSin(a);
      c.b:=0;
    end;
  Procedure FixedComplexSinImg(a:TFixed; var c:TFixedComplex);
    begin   { sin(bi)=sinh(b)i }
      c.a:=0;
      c.b:=FixedSinh(a);
    end;
  Procedure FixedComplexASin(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi ASin(z)=-ln((zi+(1-(z)^2)^(1/2)))i }
       if a.a=0 then
        if a.b=0 then
          begin
            c.a:=0;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexASinImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexASinReal(a.a,c);
            Exit;
          end;
      FixedComplexSqr(a,c);
      c.a:=FixedOne-c.a;
      c.b:=-c.b;
      FixedComplexSqrt(c,c);
      c.a:=-a.b+c.a;
      c.b:=a.a+c.b;
      FixedComplexLn(c,a);
      c.a:=a.b;
      c.b:=-a.a;
    end;
  Procedure FixedComplexASinReal(a:TFixed; var c:TFixedComplex);
    begin
      If Abs(a)>FixedOne then
        If a<0 then
          begin
            c.a:=-Fixed1_2Pi;
            c.b:=FixedACosh(-a);
          end
        else
          begin
            c.a:=Fixed1_2Pi;
            c.b:=-FixedACosh(a);
          end
      else
        begin
          c.a:=FixedSin(a);
          c.b:=0;
        end;
    end;
  Procedure FixedComplexASinImg(a:TFixed; var c:TFixedComplex);
    begin
      c.a:=0;
      c.b:=FixedASinh(a);
    end;


  Procedure FixedComplexCos(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi cos(z)=((e^(zi)+e^(-zi))/2 }
            { or try cos(a+bi)=cos(a)*cosh(b)-sin(a)*sinh(b)i }
      if a.a=0 then
        if a.b=0 then
          begin
            c.a:=FixedOne;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexCosImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexCosReal(a.a,c);
            Exit;
          end;
      c.a:=FixedCos(a.a);
      c.b:=FixedSin(a.a);
      a.a:=FixedExp(a.b);
      a.b:=FixedInv(a.a);
      c.a:=FixedDiv2(FixedMult(a.a+a.b,c.a));
      c.b:=FixedDiv2(FixedMult(a.b-a.a,c.b));
    end;
  Procedure FixedComplexCosReal(a:TFixed; var c:TFixedComplex);
    begin   { cos(a)=cos(a) }
      c.a:=FixedCos(a);
      c.b:=0;
    end;
  Procedure FixedComplexCosImg(a:TFixed; var c:TFixedComplex);
    begin   { cos(bi)=cosh(b) }
      c.a:=FixedCosh(a);
      c.b:=0;
    end;
  Procedure FixedComplexACos(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi ACos(z)=-ln(z+(z^2-1)^(1/2))i }
            { When the signs of the real value and the complex value are
              opposite, the output differs than what my HP says.  So I do
              not know what HP is doing, my equation is the same as thiers
              and I've done the equation on the HP and it comes up the the
              right value, but not thier own.  What ever gave me the idea
              of doing this in the first place.  Well at least
              a=Cos(ACos(a)), Whatever the answer is suposed to be. }
      if a.a=0 then
        if a.b=0 then
          begin
            c.a:=Fixed1_2Pi;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexACosImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexACosReal(a.a,c);
            Exit;
          end;
      FixedComplexSqr(a,c);
      c.a:=c.a-FixedOne;
      FixedComplexSqrt(c,c);
      a.a:=a.a+c.a;
      a.b:=a.b+c.b;
      FixedComplexLn(a,a);
      c.a:=a.b;
      c.b:=-a.a;
    end;
  Procedure FixedComplexACosReal(a:TFixed; var c:TFixedComplex);
    begin
      If Abs(a)>FixedOne then
        If a<0 then
          begin
            c.a:=FixedPi;
            c.b:=FixedACosh(-a);
          end
        else
          begin
            c.a:=FixedPi;
            c.b:=FixedACosh(a);
          end
      else
        begin
          c.a:=FixedACos(a);
          c.b:=0;
        end;
    end;
  Procedure FixedComplexACosImg(a:TFixed; var c:TFixedComplex);
    begin
      c.a:=Fixed1_2Pi;
      c.b:=FixedASinh(-a);
    end;


  Procedure FixedComplexTan(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi tan(z)=sin(z)/cos(z) }
            { tan(z)=(e^(zi)-e^(-zi))/((e^(zi)+e^(-zi))i) }
            { tan(a+bi)=(tan(a)+tanh(b)i)/(1-tan(a)*tanh(b)i) }
            { tan(a+bi)=(sin(a)cos(a)+sinh(b)cosh(b)i)/(sinh(b)^2+cos(a)^2) }
      if a.a=0 then
        if a.b=0 then
          begin
            c.a:=0;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexTanImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexTanReal(a.a,c);
            Exit;
          end;
      a.a:=FixedTan(a.a);
      a.b:=FixedTanh(a.b);
      c.a:=FixedOne;
      c.b:=-FixedMult(a.a,a.b);
      FixedComplexDiv(a,c,c);
     end;
  Procedure FixedComplexTanReal(a:TFixed; var c:TFixedComplex);
    begin   { tan(a)=tan(a) }
      c.a:=FixedTan(a);
      c.b:=0;
    end;
  Procedure FixedComplexTanImg(a:TFixed; var c:TFixedComplex);
    begin   { tan(bi)=tanh(b)i }
      c.a:=0;
      c.b:=FixedTanh(a);
    end;
  Procedure FixedComplexATan(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi ATan(z)=-i*ln((1+zi)/(1-zi))/2 }
            { If a=0 and b is negetive, the answer differs from my HP.
              This equation I derived is correct and so is thiers, I
              decided to use mine instead.  For both functions
              a=Tan(ATan(a)) }
      if a.a=0 then
        if a.b=0 then
          begin
            c.a:=0;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexATanImg(a.b,c);
            Exit;
          end
      else
        if a.b=0 then
          begin
            FixedComplexATanReal(a.a,c);
            Exit;
          end;
      c.a:=FixedOne-a.b;
      c.b:=a.a;
      a.a:=FixedOne+a.b;
      a.b:=-c.b;
      FixedComplexDiv(c,a,a);
      FixedComplexLn(a,a);
      c.a:=FixedDiv2(a.b);
      c.b:=-FixedDiv2(a.a);
    end;
  Procedure FixedComplexATanHP(a:TFixedComplex; var c:TFixedComplex);
    begin   { z=a+bi ATan(z)=i*ln((i+z)/(i-z))/2 }
            { I've been testing all of my functions against my HP 28S
              and found that the equation that I derived for the ArcTan
              did not come up with the same answer when 0-bi (b<>1) was
              an input.  I looked up the ArcTan function in the HP manual,
              and this is it.  Mathmaticaly they are equal.  All they did
              was bring the negetive inside the ln as a -1 power and invert
              the inside of the ln and multiply the inside by i/i=1.  These
              are all legal moves for math but the answers like I said are
              not equal.  It concerns me that maybe they know something that
              I do not, so I put thier equation in here.  For both answers,
              taking the tangent will return the original z. }
      c.a:=-a.a;
      c.b:=FixedOne-a.b;
      a.a:=c.a;
      a.b:=FixedOne+a.b;
      FixedComplexDiv(a,c,a);
      FixedComplexLn(a,a);
      c.a:=-FixedDiv2(a.b);
      c.b:=FixedDiv2(a.a);
    end;
  Procedure FixedComplexATanReal(a:TFixed; var c:TFixedComplex);
    begin   { ATan(a)=ATan(a) }
      c.a:=FixedATan(a);
      c.b:=0;
    end;
  Procedure FixedComplexATanImg(a:TFixed; var c:TFixedComplex);
    begin   { ATan(bi)=-i*ln((1-b)/(1+b))/2 }
      FixedComplexSqrtReal(FixedDiv(FixedOne-a,FixedOne+a),c);
      FixedComplexLn(c,c);
      a:=c.a;
      c.a:=c.b;
      c.b:=-a;
    end;


  Procedure FixedComplexPower(a,b:TFixedComplex; var c:TFixedComplex);
    begin   { a^b=e^(b*ln(a)) }
      if a.b=0 then
        if a.a=0 then
          if (b.b<>0) and (b.a=0) then
            begin
              c.a:=MaxPos;
              c.b:=0;
              Exit;
            end
          else
            begin
              c.a:=0;
              c.b:=0;
              Exit;
            end
        else
          if a.a=FixedOne then
            begin
              c.a:=FixedOne;
              c.b:=0;
              Exit;
            end;
      if b.a=0 then
        if b.b=0 then
          begin
            c.a:=FixedOne;
            c.b:=0;
            Exit;
          end
        else
          begin
            FixedComplexPowerImg(a,b.b,c);
            Exit;
          end
      else
        if b.b=0 then
          begin
            FixedComplexPowerReal(a,b.a,c);
            Exit;
          end;
      FixedComplexLn(a,a);
      FixedComplexMult(a,b,c);
      FixedComplexExp(c,c);
    end;
  Procedure FixedComplexPowerReal(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { a^b=e^(b*ln(a)) }
      FixedComplexLn(a,c);
      c.a:=FixedMult(c.a,b);
      c.b:=FixedMult(c.b,b);
      FixedComplexExp(c,c);
    end;
  Procedure FixedComplexPowerImg(a:TFixedComplex;b:TFixed; var c:TFixedComplex);
    begin   { a^(bi)=e^((bi)*ln(a)) }
      if (a.a=0) and (a.b=0) then
        begin
          c.a:=MaxPos;
          c.b:=0;
          Exit;
        end;
      FixedComplexLn(a,c);
      a.a:=FixedMult(-c.b,b);
      a.b:=FixedMult(c.a,b);
      FixedComplexExp(a,c);
    end;



begin
end.
