// test2dia.cpp : implementation file
//

#include "stdafx.h"
#include "FS_DEMO.h"
#include "test2dia.h"

#include "..\filesys.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTest2Dialog

IMPLEMENT_DYNCREATE(CTest2Dialog, CFormView)

CTest2Dialog::CTest2Dialog()
	: CFormView(CTest2Dialog::IDD)
{
	//{{AFX_DATA_INIT(CTest2Dialog)
	m_Recurse = FALSE;
	m_DirName = _T("");
	m_DirList = _T("");
	m_Normal = FALSE;
	m_ReadOnly = FALSE;
	m_Archive = FALSE;
	m_AllFiles = TRUE;
	m_Volume = FALSE;
	m_Directory = FALSE;
	m_System = FALSE;
	//}}AFX_DATA_INIT
}

CTest2Dialog::~CTest2Dialog()
{
	// No code.
}

void CTest2Dialog::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTest2Dialog)
	DDX_Control(pDX, IDC_DIRLIST, m_DirListBox);
	DDX_Check(pDX, IDC_RECURSE, m_Recurse);
	DDX_Text(pDX, IDC_DIRNAME, m_DirName);
	DDX_LBString(pDX, IDC_DIRLIST, m_DirList);
	DDX_Check(pDX, IDC_NORMAL, m_Normal);
	DDX_Check(pDX, IDC_readonly, m_ReadOnly);
	DDX_Check(pDX, IDC_ARCHIVE, m_Archive);
	DDX_Check(pDX, IDC_ALLFILES, m_AllFiles);
	DDX_Check(pDX, IDC_VOLUME, m_Volume);
	DDX_Check(pDX, IDC_DIRECTORY, m_Directory);
	DDX_Check(pDX, IDC_system, m_System);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTest2Dialog, CFormView)
	//{{AFX_MSG_MAP(CTest2Dialog)
	ON_BN_CLICKED(IDC_DIR_BROWSE, OnDirBrowse)
	ON_LBN_DBLCLK(IDC_DIRLIST, OnDblclkDirlist)
	ON_BN_CLICKED(IDC_GO, OnGo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CTest2Dialog diagnostics

#ifdef _DEBUG
void CTest2Dialog::AssertValid() const
{
	CFormView::AssertValid();
}

void CTest2Dialog::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTest2Dialog message handlers

void CTest2Dialog::OnDirBrowse() 
{
	CFileDialog *pFileDialog = new CFileDialog(TRUE);

	pFileDialog->DoModal();
}

void CTest2Dialog::OnDblclkDirlist() 
{
	// Do something...
}

void CTest2Dialog::OnGo() 
{
	unsigned long mask = 0;
	CFileSystem fs;
	CStringList dir;

	UpdateData(TRUE);

	if ( m_Normal )
		mask |= CFileSystem::normal;
	if ( m_ReadOnly )
		mask |= CFileSystem::readOnly;
	if ( m_Archive )
		mask |= CFileSystem::archive;
	if ( m_System )
		mask |= CFileSystem::system;
	if ( m_Volume )
		mask |= CFileSystem::volume;
	if ( m_Directory )
		mask |= CFileSystem::directory;
	if ( m_AllFiles )
		mask |= CFileSystem::allfiles;

	m_DirListBox.ResetContent();
	if (m_DirName != "")
	{
		fs.GetDirectory(m_DirName, mask, m_Recurse, &dir);
		fs.LoadListBox(&m_DirListBox, &dir);
	}
	else
	{
		MessageBox("File specification required!");
	}
}
