program main;
uses fgmain, fgmisc, fgpr;

const
  CGApatterns : array[0..15] of integer = ($0000,$00FF,$00FF,$00FF,
                                           $02BB,$0000,$0222,$0255,
                                           $00FF,$00FF,$00FF,$0055,
                                           $00AA,$00AA,$00FF,$0277);
var
  color    : integer;
  old_mode : integer;
  new_mode : integer;
  status   : integer;
   
begin
  new_mode := fg_bestmode(320,200,1);
  if (new_mode < 0) or (new_mode = 12) then
  begin
    write('This program requires a 320 ');
    writeln('x 200 color graphics mode.');
    exit;
  end;

  old_mode := fg_getmode;
  fg_setmode(new_mode);

  if (new_mode = 4) then
  begin
    fg_palette(0,0);
    for color := 0 to 15 do
    begin
      fg_pattern(color,CGApatterns[color]);
    end;
  end
  else if (new_mode = 9) or (new_mode = 13) then
     fg_pattern(15,$04F7)
  else
     fg_setrgb(15,38,38,38);

  fg_move(0,199);
  status := fg_showppr('CORAL.PPR'+chr(0),320);
  fg_waitkey;

  fg_setmode(old_mode);
  fg_reset;
end.
