program main;
uses fgmain, fgmisc, fgworld;

var
  new_mode, old_mode : integer;
  xmin, xmax, ymin, ymax : real;

procedure redraw;

begin
  fg_erase;
  fg_setcolor(1);

  fg_movew(0.0,0.0);
  fg_draww(0.0,10.0);
  fg_draww(10.0,10.0);
  fg_draww(10.0,0.0);
  fg_draww(0.0,0.0);
end;

begin
  old_mode := fg_getmode;
  new_mode := fg_automode;

  if (new_mode = 0) then
  begin
    writeln('This program requires graphics.');
    exit;
  end;

  fg_setmode(new_mode);
  fg_initw;

  fg_setworld(0.0,40.0,0.0,30.0);
  redraw;
  fg_waitkey;

  fg_getworld(xmin,xmax,ymin,ymax);
  fg_setworld(0.0,xmax*0.5,0.0,ymax*0.5);
  redraw;
  fg_waitkey;

  fg_setmode(old_mode);
  fg_reset;
end.
