{********************************************************}
{ Structures of FastEcho 1.45a                           }
{ Copyright (c) 1995 by Tobias Burchhardt                }
{********************************************************}
(* Pascal conversion by Robin Heilos                    *)
(* Last revision 22 Oct 1995 by Tobias Burchhardt       *)
(*                                                      *)
(* Please refer to the original C structures for a more *)
(* detailed explanation on how to locate the different  *)
(* parts of the configuration file!                     *)
(********************************************************)


{******************************************************}
{ FASTECHO.CFG = <CONFIG>                              }
{                + <optional extensions>               }
{                + <CONFIG.NodeCnt * Node>             }
{                + <CONFIG.AreaCnt * Area>             }
{******************************************************}

Const

REVISION       = 6;       { current revision     }

{ Note: there is a major change in this revision - the
     Node records have no longer a fixed length !       }

MAX_AREAS      = 3072;    { max # of areas       }
MAX_NODES      = 1024;    { max # of nodes       }
MAX_GROUPS     = 26;      { max # of groups      }
MAX_AKAS       = 32;      { max # of akas        }
MAX_ROUTE      = 15;      { max # of 'vias'      }
MAX_ORIGINS    = 20;      { max # of origins     }

{
  Note: The MAX_AREAS and MAX_NODES are only the absolute maximums
        as the handling is flexible. To get the maximums which are
        used for the config file you read, you have to examine the
        CONFIG.MaxAreas and CONFIG.MaxNodes variables !

  Note: The MAX_AREAS and MAX_NODES maximums are subject to change
        with any new version, therefore - if possible - make hand-
        ling as flexible  possible  and  use  CONFIG.MaxAreas  and
        .MaxNodes whereever possible. But be aware that you  might
        (under normal DOS and depending on the way you handle it)
        hit the 64kB segment limit pretty quickly!

        Same goes for the # of AKAs and Groups - use  the  values
        found in CONFIG.AkaCnt and CONFIG.GroupCnt!
}

{******************************************************}
{ CONFIG.flags                                         }
{******************************************************}

RETEAR                  =$00000001;
AUTOCREATE              =$00000002;
KILLEMPTY               =$00000004;
KILLDUPES               =$00000008;
CLEANTEARLINE           =$00001000;
IMPORT_INNCLUDEUSERSBBS =$00002000;
KILLSTRAYATTACHES       =$00004000;
PURGE_PROCESSDATE       =$00008000;
MAILER_RESCAN           =$00010000;
EXCLUDE_USERS           =$00020000;
EXCLUDE_SYSOPS          =$00040000;
CHECK_DESTINATION       =$00080000;
UPDATE_BBS_CONFIG       =$00100000;
KILL_GRUNGED_DATE       =$00200000;
NOT_BUFFER_EMS          =$00400000;
KEEP_NETMAILS           =$00800000;
NOT_UPDATE_MAILER       =$01000000;
NOT_CHECK_SEMAPHORES    =$02000000;
CREATE_SEMAPHORES       =$04000000;
CHECK_COMPLETE          =$08000000;
RESPOND_TO_RRQ          =$10000000;
TEMP_OUTB_HARDDISK      =$20000000;
FORWARD_PACKETS         =$40000000;
UNPACK_UNPROTECTED      =$80000000;

{******************************************************}
{ CONFIG.mailer                                        }
{******************************************************}
 FrontDoor               =$0001;
 InterMail               =$0002;
 DBridge                 =$0004;
 Binkley                 =$0010;
 PortalOfPower           =$0020;
 McMail                  =$0040;

{******************************************************}
{ CONFIG.BBSSoftware                                   }
{******************************************************}
Type BBSSoft = ( NoBBSSoft , RemoteAccess111, QuickBBS,
                 SuperBBS, ProBoard122 { Unused }, TagBBS,
                 RemoteAccess200, ProBoard130 { Unused },
                 ProBoard200, ProBoard212, Maximus300 );

{******************************************************}
{ CONFIG.CC.what                                       }
{******************************************************}
 Const

 CC_FROM       =         1;
 CC_TO         =         2;
 CC_SUBJECT    =         3;
 CC_KLUDGE     =         4;

{******************************************************}
{ CONFIG.QuietLevel                                    }
{******************************************************}
 QUIET_PACK              =$0001;
 QUIET_UNPACK            =$0002;
 QUIET_EXTERN            =$0004;

{******************************************************}
{ CONFIG.Swapping                                      }
{******************************************************}
 SWAP_TO_XMS             =$0001;
 SWAP_TO_EMS             =$0002;
 SWAP_TO_DISK            =$0004;

{******************************************************}
{ CONFIG.Buffers                                       }
{******************************************************}
 BUF_LARGE               =$0000;
 BUF_MEDIUM              =$0001;
 BUF_SMALL               =$0002;

{******************************************************}
{ CONFIG.arcext.inb/outb                               }
{******************************************************}
Type ARCmailExt =( ARCDigits , ARCHex, ARCAlpha );

{******************************************************}
{ CONFIG.AreaFixFlags                                  }
{******************************************************}
 Const

 ALLOWRESCAN             =$0001;
 KEEPREQUEST             =$0002;
 KEEPRECEIPT             =$0004;
 ALLOWREMOTE             =$0008;
 DETAILEDLIST            =$0010;
 ALLOWPASSWORD           =$0020;
 ALLOWPKTPWD             =$0040;
 ALLOWCOMPRESS           =$0080;
 SCANBEFORE              =$0100;
 ADDRECEIPTLIST          =$0200;
 NOTIFYPASSWORDS         =$0400;

{******************************************************}
{ Area.board (1-200 = Hudson)                          }
{******************************************************}
 NO_BOARD        =$4000; { JAM/Sq/Passthru etc. }
 AREA_DELETED    =$8000; { usually never written}

{******************************************************}
{ Area.flags.storage                                   }
{******************************************************}
 QBBS                =   0;
 FIDO                =   1;
 SQUISH              =   2;
 JAM                 =   3;
 PASSTHRU            =   7;

{******************************************************}
{ Area.flags.atype                                     }
{******************************************************}
 AREA_ECHOMAIL        =   0;
 AREA_NETMAIL         =   1;
 AREA_LOCAL           =   2;
 AREA_BADMAILBOARD    =   3;
 AREA_DUPEBOARD       =   4;

{******************************************************}
{ Types and other definitions                          }
{******************************************************}

Type ARCers   =( ARC_Unknown, ARC_SeaArc, ARC_PkArc, ARC_Pak,
	         ARC_ArcPlus, ARC_Zoo, ARC_PkZip, ARC_Lha, ARC_Arj,
	         ARC_Sqz, ARC_RAR, ARC_UC2 ); { for Unpackers }

NetmailStatus =( NetNormal , NetHold, NetCrash , NetImm );
AreaFixType   =( NoAreaFix , NormalAreaFix, FSC57AreaFix );
AreaFixSendTo =( AreaFix , AreaMgr, AreaLink, EchoMgr );

{******************************************************}
{ Structures                                           }
{******************************************************}

Type Address=Record
      zone,
      net,
      node,
      point : Word;
     End;

Const  _MAXPATH=56;

Type

 MaxPath=Array[1.._MaxPath]   of Char; { 0 terminated }
 Str336           =Array[1..336]        of Char;
 Str32            =Array[1..32]         of Char;
 Str40            =Array[1..40]         of Char;
 StrMaxPathSub4   =Array[1.._MaxPath-4] of Char;
 Str31            =Array[1..31]         of Char;
 Str806           =Array[1..806]        of Char;
 Str36            =Array[1..36]         of Char;
 Str9             =Array[1..9]          of Char;
 Str52            =Array[1..52]         of Char;
 Str4             =Array[1..4]          of Char;
 Str28            =Array[1..28]         of Char;
 Str62            =Array[1..62]         of Char;
 Str6             =Array[1..6]          of Char;

 CCRecord=Record
  What            : Byte;
  ObjectN         : Str31;
  conference      : Word;
 End;

 _rescan_def=Record
   flags : word;
   days : array[1..2] of word;
   msgs : array[1..2] of word;
  End;

  _arcext=record
   inb,
   outb : Byte;
  End;

  SysopRecord=Record
   Name:Str36;
   Resv:LongInt;
  End;

 CONFIGURATION=Record
  revision        : Word;
  flags           : Longint;
  NodeCnt,
  AreaCnt,
  unused1         : Word;
  NetMPath,
  MsgBase,
  InBound,
  OutBound,
  Unpacker,                  { DOS default decompression program  }
  LogFile         : MaxPath;
  unused2         : Str336;
  Unpacker2,                 { OS/2 default decompression program }
  UnprotInBound,
  StatFile,
  SwapPath,
  SemaphorePath,
  BBSConfigPath,
  QueuePath       : MaxPath;
  unused3         : Str32;
  RetearTo        : Str40;
  LocalInBound    : MaxPath;
  ExtAfter,
  ExtBefore       : StrMaxPathSub4;
  Unused4         : Array[1..480] of Byte;
  CC              : Array[1..10] of CCRecord;

  security,
  loglevel         : Byte;
  def_days,
  def_messages     : Word;
  unused5          : Array[1..462] of Byte;
  autorenum,
  def_recvdays     : Word;
  openQQQs,
  Swapping         : Byte;
  compressafter,
  afixmaxmsglen,
  compressfree     : Word;
  TempPath         : MaxPath;
  graphics,
  BBSSoftware      : Byte;
  AreaFixHelp      : MaxPath;
  unused6          : Array[1..504] of Byte;
  AreaFixFlags     : Word;
  QuietLevel,
  Buffers,
  FWACnt,
  GDCnt            : Byte;    { # of ForwardAreaFix records,
                                # of Group Default records }
  rescan_def       : _rescan_def;
  duperecords      : LongInt;
  arcext           : _arcext;
  AFixRcptLen      : Word;
  AkaCnt,
  resv             : Byte;              { # of Aka records stored }
  maxPKT           : Word;
  sharing,
  sorting          : Byte;
  sysops           : Array[1..11] of SysopRecord;
  AreaFixLog,
  TempInBound      : MaxPath;
  maxPKTmsgs,
  RouteCnt,                           { # of PackRoute records }
  maxPACKratio          : Byte;
  SemaphoreTimer        : Byte;
  PackerCnt,
  UnpackerCnt,                        { # of Packers and Unpackers records }
  GroupCnt,
  OriginCnt             : Byte;       { # of GroupNames and Origin records }
  mailer                : Word;
  maxarcsize,maxarcdays : Word;
  reserved              : Str806;
  AreaRecSize,
  GrpDefRecSize,                      { Size  of  Area  and  GroupDefaults }
  MaxAreas,                           { records stored in this file        }
  MaxNodes,                           { Current max values for this config }
  NodeRecSize           : Word;       { Size of each stored Node record    }
  offset                : Longint;    { This is the offset from the current}
End;                                  { file-pointer to the 1st Node       }

{ To directly access the 'Nodes' and/or 'Areas' while bypassing the }
{ Extensions, perform an absolute (from beginning of file) seek to  }
{ sizeof(CONFIG) + CONFIG.offset                                    }
{ If you want to access the 'Areas', you have to add the following  }
{ value to the above formula:  CONFIG.NodeCnt * CONFIG.NodeRecSize  }

 NodeRecord = Record
  addr,                      { Main address                         }
  arcdest      : Address;    { ARCmail fileattach address           }
  aka,
  autopassive,
  newgroup,
  resv1        : Byte;
  flagsByte1   : Byte;
  flagsByte2   : Byte;
  flagsByte3   : Byte;  { 24 bits total ! }

  {
   passive          = 0;
   dddd             = 1;      Type 2+/4D
   arcmail060       = 2;
   tosscan          = 3;
   umlautnet        = 4;
   exportbyname     = 5;
   allowareacreate  = 6;
   disablerescan    = 7;
   arc_status       = 8-9;    NetmailStatus for ARCmail attaches
   arc_direct       = 10;     Direct flag for ARCmail attaches
   noattach         = 11;     don't create a ARCmail file attach
   mgr_status       = 12-13;  NetMailStatus for AreaFix receipts
   mgr_direct       = 14;     Direct flag for ...
   not_help         = 15;
   not_notify       = 16;
   packer           = 17-21;  # of Packer used, 0xf = send .PKT
   packpriority     = 22;     system has priority packing ARCmail
   resv             = 23-24;
  }
  afixflags    : Word;
  {
   type             = 0-1;   Type of AreaFix : None (human),
                             Normal or Advanced (FSC-57)
   noforward        = 2;     Don't forward AFix requests
   allowremote      = 3;
   allowdelete      = 4;     flags for different FSC-57 requests
   allowrename      = 5;     all 3 reserved for future use
   binarylist       = 6;
   addplus          = 7;     add '+' when requesting new area
   addtear          = 8;     add tearline to the end of requests
   sendto           = 9 -11; name of this systems's AreaFix robot
   resv             = 12-15;
  }
  resv2        : Word;
  password     : Str9;       { .PKT password }
  areafixpw    : Str9;       { AreaFix password }
  sec_level    : Word;
  groups       : Longint;    { Bit-field, Byte 0/Bit 7 = 'A' etc.    }
                             { FALSE means group is active           }
  resv3        : Longint;
  resv4,
  maxarcsize   : Word;
  name         : Str36;      { Name of sysop                         }
  Areas        : Byte;	     { Bit-field with CONFIG.MaxAreas / 8    }
                             { bits, Byte 0/Bit 7 is conference #0   }
                             { Total size of each record is stored   }
                             { in CONFIG.NodeRecSize                 }
End;

AreaRecord = Record
 name             : Str52;
 board,			{ 1-200 Hudson, others reserved/special }
 conference,            { 0 ... CONFIG.MaxAreas-1               }
 read_sec,
 write_sec        : Word;
 Info             : Word;
 {
  aka    = 0-7;    0 ... CONFIG.AkaCnt
  group  = 8-15;   0 ... CONFIG.GroupCnt
 }
 flags            : Word;
 {
  storage = 0-3;
  atype   = 4-7;
  origin  = 8-12;    # of origin line
  resv    = 13-15;
 }
 advflags         : Word;
 {
  autoadded  : 0;
  tinyseen   : 1;
  cpd        : 2;
  passive    : 3;
  keepseen   : 4;
  mandatory  : 5;
  keepsysop  : 6;
  killread   : 7;
  disablepsv : 8;
  keepmails  : 9;
  hide       : 10;
  nomanual   : 11;
  umlaut     : 12;
  resv       : 13-15;
 }
 resv1            : Word;
 seenbys,			{ LSB = Aka0, MSB = Aka31      	 }
 resv2            : LongInt;
 days,
 messages,
 recvdays         : Word;
 path             : MaxPath;
 desc             : Str52;
End;

{******************************************************}
{ Optional Extensions                                  }
{******************************************************}
{ These are the variable length extensions between     }
{ CONFIG and the first Node record. Each extension has }
{ a header which contains the info about the type and  }
{ the length of the extension. You can read the fields }
{ using the following algorithm:                       }
{                                                      }
{ offset := 0;                                         }
{ while (offset<CONFIG.offset) do                      }
{  read_header;                                        }
{  if(header.type==EH_abc) then                        }
{   read_and_process_data;                             }
{    else                                              }
{  if(header.type==EH_xyz) then                        }
{   read_and_process_data;                             }
{    else                                              }
{   [...]                                              }
{    else  // unknown or unwanted extension found      }
{  seek_forward(header.offset); // Seek to next header }
{  offset = offset + header.offset + sizeof(header);   }
{ end;                                                 }
{******************************************************}

ExtensionHeader = Record
 typ    : Word;             { EH_...                           }
 offset : LongInt;          { length of field excluding header }
End;


Const EH_AREAFIX      =$0001; { CONFIG.FWACnt * <ForwardAreaFix> }
Type  AreaFixAreaListFormat =(Areas_BBS, Area_List );

ForwardAreaFixRec = Record
 nodenr      : Word;
 flags       : Word;
  {
   newgroup : 0-7;
   active   : 8;
   valid    : 9;
   uncond   : 10;
   format   : 11-13;
   resv     : 14-15;
  }
 filen       : MaxPath;
 sec_level,
 resv1       : Word;
 groups      : Longint;
 resv2       : Str4;
End;

Const EH_GROUPS     =$000C; { CONFIG.GroupCnt * <GroupNames> }

Type GroupNames=Record
 name : Str36;
End;

Const EH_GRPDEFAULTS  =$0006;  { CONFIG.GDCnt * <GroupDefaults> }
			       { Size of each full GroupDefault }
			       { record is CONFIG.GrpDefResSize }
Type GroupDefaults = Record
 group       : Byte;
 resv        : Array[1..15] of Byte;
 Area        : AreaRecord;
 Nodes       : Byte;			{ variable, c.MaxNodes / 8 bytes }
End;

Const EH_AKAS         =$0007;  { CONFIG.AkaCnt * <SysAddress> }
Type SysAddress = Record
 main     : Address;
 domain   : Str28;
 pointnet : Word;
 Flags    : Longint;           { unused       }
End;

Const EH_ORIGINS      =$0008;  { CONFIG.OriginCnt * <OriginLines> }
Type OriginLines = Record
 line : Str62;
End;


Const EH_PACKROUTE    =$0009;  { CONFIG.RouteCnt * <PackRoute> }
Type PackRoute =Record
 Dest   :Address;
 routes :Array[1..MAX_ROUTE] of Address;
End;

Const EH_PACKERS      =$000A;  { CONFIG.Packers * <Packers> (DOS)  }
      EH_PACKERS2     =$100A;  { CONFIG.Packers * <Packers> (OS/2) }

Type Packers = Record
 tag     : Str6;
 command : Array[1.._MAXPATH] of Char;
 list    : Str4;
 ratio   : Byte;
 resv    : Array[1..7] of Byte;
End;

Const EH_UNPACKERS    =$000B;  { CONFIG.Unpackers * <Unpackers> (DOS)  }
      EH_UNPACKERS2   =$100B;  { CONFIG.Unpackers * <Unpackers> (OS/2) }

{ Calling convention:                                      }
{ 0 = change path to inbound directory, 1 = <path> *.PKT,  }
{ 2 = *.PKT <path>, 3 = *.PKT #<path>, 4 = *.PKT -d <path> }

Type Unpackers = Record
 command             :Array[1.._MAXPATH] of Char;
 callingconvention   :Byte;
 resv                :Array[1..7] of Byte;
End;

Const

 EH_RA111_MSG    =$0100;  { Original records of BBS systems }
 EH_QBBS_MSG     =$0101;
 EH_SBBS_MSG     =$0102;
 EH_TAG_MSG      =$0104;
 EH_RA200_MSG    =$0105;
 EH_PB200_MSG    =$0106;  { See BBS package's documentation }
 EH_PB202_MSG    =$0107;  { for details                     }


(********************************************************)
(* FASTECHO.DAT = <STATHEADER>                          *)
(*                + <STATHEADER.NodeCnt * StatNode>     *)
(*                + <STATHEADER.AreaCnt * StatArea>     *)
(********************************************************)

Const STAT_REVISION = 3;

Type Date=record
            year:  Word;
            day:   Word;
            month: Word;
          end;


Type STATHEADER=record
                 signature: array[1..10] of char;
                 revision:  Word;
                 lastupdate: Date;
                 NodeCnt,
                 AreaCnt: Integer;
                 StartNode,
                 StartArea: Longint;
                 NodeSize,
                 AreaSize: Integer;
                 resv: array[1..32] of char;
               end;

Type StatNode=record
                adr: Address;
                Import,
                Export: LongInt;
                Lastimport,
                Lastexport: Date;
                Dupes: LongInt;
                ImportBytes,
                ExportBytes: LongInt;
              end;

Type StatArea=record
                conference: Integer;
                tagcrc: LongInt;
                Import,
                Export: LongInt;
                Lastimport,
                Lastexport: Date;
                Dupes: LongInt;
              end;



