/*
** Program fdb - family tree database generation and manipulation
**
** Copyright (C) 1994 Andy Burrows 
**
**            email: cadellin@corum.me.man.ac.uk (130.88.29.14)
**
** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public Licence as published by the Free
** Software Foundation; either version 1, or any later version.
** 
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
** or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
** more details. It should be included in this distribution in a file 
** called COPYING
**
*/

/*
   this file contains the callback functions for the text entries 
*/

/*#define DEBUG */

/* standard headers */

#include <stdio.h>

/* XView headers */

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/font.h>

/* fdb database definitions header */

#include "definitions.h"

/* surname text entry callback */

int enter_surname(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the surname field of the current person
    */

    strcpy(entry[current_index]->surname, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as surname\n",entry[current_index]->surname);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* forenames text entry callback */

int enter_forenames(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the forenames field of the current person
    */

    strcpy(entry[current_index]->forenames, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as forenames\n",entry[current_index]->forenames);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* maiden name text entry callback */

int enter_maiden_name(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the maiden name field of the current person
    */

    strcpy(entry[current_index]->maiden_name, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as maiden name\n",entry[current_index]->maiden_name);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* birth date text entry callback */

int enter_birth_date(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the birth date field of the current person
    */

    strcpy(entry[current_index]->birth_date, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as birth date\n",entry[current_index]->birth_date);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* 
       encode the date, if there was a problem with the encoding, 
       indicate the failure 
    */

    if((entry[current_index]->encoded_date = 
              encode_date(entry[current_index]->birth_date)) == -1)
        {
        sprintf(error_message,"Unable to Understand Date of Birth Entry %s for %s %s",
                entry[current_index]->birth_date, entry[current_index]->forenames,
                entry[current_index]->surname);
        show_error();
        }

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* birth place text entry callback */

int enter_birth_place(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the birth place field of the current person
    */

    strcpy(entry[current_index]->birth_place, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as birth place\n",entry[current_index]->birth_place);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* baptism date text entry callback */

int enter_baptism_date(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the baptism date field of the current person
    */

    strcpy(entry[current_index]->baptism_date, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as baptism date\n",entry[current_index]->baptism_date);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* baptism place text entry callback */

int enter_baptism_place(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the baptism place field of the current person
    */

    strcpy(entry[current_index]->baptism_place, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as baptism place\n",entry[current_index]->baptism_place);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* marriage date text entry callback */

int enter_marriage_date(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the marriage date field of the current person
    */

    strcpy(entry[current_index]->marriage_date, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as marriage date\n",entry[current_index]->marriage_date);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* marriage place text entry callback */

int enter_marriage_place(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the marriage place field of the current person
    */

    strcpy(entry[current_index]->marriage_place, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as marriage place\n",entry[current_index]->marriage_place);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* death date text entry callback */

int enter_death_date(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the death date field of the current person
    */

    strcpy(entry[current_index]->death_date, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as death date\n",entry[current_index]->death_date);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* death place text entry callback */

int enter_death_place(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the death place field of the current person
    */

    strcpy(entry[current_index]->death_place, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as death place\n",entry[current_index]->death_place);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* resting place text entry callback */

int enter_resting_place(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the resting place field of the current person
    */

    strcpy(entry[current_index]->resting_place, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as resting place\n",entry[current_index]->resting_place);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* occupation text entry callback */

int enter_occupation(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the occupation field of the current person
    */

    strcpy(entry[current_index]->occupation, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as occupation\n",entry[current_index]->occupation);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* notes text entry callback */

int enter_notes(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the notes field of the current person
    */

    strcpy(entry[current_index]->notes, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as notes\n",entry[current_index]->notes);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* birth date source text entry callback */

int enter_birth_source(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the birth source field of the current person
    */

    strcpy(entry[current_index]->birth_source, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as birth source\n",entry[current_index]->birth_source);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* baptism date source text entry callback */

int enter_baptism_source(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the baptism source field of the current person
    */

    strcpy(entry[current_index]->baptism_source, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as baptism source\n",entry[current_index]->baptism_source);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* marriage date source text entry callback */

int enter_marriage_source(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the marriage source field of the current person
    */

    strcpy(entry[current_index]->marriage_source, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as marriage source\n",entry[current_index]->marriage_source);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* date of death source text entry callback */

int enter_death_source(item, event)
Panel_item    item;
Event        *event;
{

switch (event_action(event))
    {
    case '\n':
    case '\r':
    /*
        copy the entered text to the death source field of the current person
    */

    strcpy(entry[current_index]->death_source, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as death source\n",entry[current_index]->death_source);
#endif

    /* set the default file menu selection to save since something has changed */

    xv_set(file_menu, MENU_DEFAULT, 3, NULL);

    /* falls through here */

    case '\t':  /* advance to next text entry without altering current entry */
        return (PANEL_NEXT);
    default:
        return (panel_text_notify(item,event)); /* I don't understand this bit yet! */
    }
}

/* save as file text entry callback */

int enter_save_file_text(item, event)
Panel_item    item;
Event        *event;
{
Xv_object   return_code;
char        footer_string[255];

#ifdef DEBUG
printf("in 'save file as' text entry callback\n");
#endif

/*
   act on the keystroke which called this routine 
*/

switch (event_action(event))
    {
    case '\n':
    case '\r':

    /* copy the entered text to the current database file name */
    strcpy(new_file_name, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as database file name\n",new_file_name);
#endif

    /* call the save database function */

    save_database();

    /* create the footer display string */

    sprintf(footer_string,"Current Database File: %s",file_name);
    xv_set(fdb_frame, FRAME_LEFT_FOOTER, footer_string, NULL);

    /* unshow the "Save as" window */

    if((return_code = xv_set(save_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
        {
        printf("unable to unshow the 'Save as' window\n");
        }

    /* falls through... */

    default:
        return (panel_text_notify(item,event)); 
    }

}

/* load from file text entry callback */

int enter_load_file_text(item, event)
Panel_item    item;
Event        *event;
{
Xv_object   return_code;
char        footer_string[255];

#ifdef DEBUG
printf("in 'load file from' text entry callback\n");
#endif

/*
   act on the keystroke which called this routine 
*/

switch (event_action(event))
    {
    case '\n':
    case '\r':

    /* copy the entered text to the current database file name */
    strcpy(new_file_name, (char *) xv_get(item, PANEL_VALUE));

#ifdef DEBUG
    printf("text **%s** entered as database file name\n",new_file_name);
#endif

    /* call the load database function */

    initialise_database();

    /* update the displays */

    update_panel_items();

    /* create the footer display string */

    sprintf(footer_string,"Current Database File: %s",file_name);
    xv_set(fdb_frame, FRAME_LEFT_FOOTER, footer_string, NULL);

    /* unshow the "Load From" window */

    if((return_code = xv_set(load_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
        {
        printf("unable to unshow the 'Load From' window\n");
        }

    /* falls through... */

    default:
        return (panel_text_notify(item,event)); 
    }

}


