/*
** Program fdb - family tree database generation and manipulation
**
** Copyright (C) 1994 Andy Burrows 
**
**            email: cadellin@corum.me.man.ac.uk (130.88.29.14)
**
** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public Licence as published by the Free
** Software Foundation; either version 1, or any later version.
** 
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
** or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
** more details. It should be included in this distribution in a file 
** called COPYING
**
*/


/*
   function prototypes for family tree database functions
*/

/* database functions */
void           initialise_database();
void           save_database();
void           free_database();
int            create_new_entry();
void           select_entry();
void           deselect_entry();
void           update_panel_items();
void           show_error();
void           encode_date();

/* viewing functions */
void           write_centred();
void           order_children();
void           build_line();
void           draw_line();
void           build_descendants();
void           draw_descendants();
int            distance();
void           user_gen_event();
void           user_des_event();
void           new_view_gen();
void           new_view_des();

/* plotting functions */
void           latex_output();
void           postscript_output();
void           put_moggy();

/* buttons */
void           cancel_save_as();
void           cancel_load_from();
void           cancel_selection();
void           display_mother();
void           display_father();
void           display_sources();
void           dismiss_sources();
void           dismiss_error_frame();
void           dismiss_settings_frame();
void           dismiss_gen_frame();
void           dismiss_des_frame();

/* menu buttons */
void           file_menu_selection();
void           edit_menu_selection();
void           select_menu_selection();
void           deselect_menu_selection();
void           output_menu_selection();
void           view_menu_selection();

/* abbreviated choices */
void           title_chosen();

/* choices */
void           gender_chosen();
void           status_chosen();
void           depth_gen_chosen();
void           depth_des_chosen();
void           add_spaces_chosen();
void           output_type_chosen();
void           use_all_gen();
void           use_all_des();

/* sliders */
void           set_min_text_width();

/* text entries */
    /* in the main database control panel */
int            enter_surname();
int            enter_forenames();
int            enter_maiden_name();
int            enter_birth_date();
int            enter_birth_place();
int            enter_baptism_date();
int            enter_baptism_place();
int            enter_marriage_date();
int            enter_marriage_place();
int            enter_death_date();
int            enter_death_place();
int            enter_resting_place();
int            enter_occupation();
int            enter_notes();
int            enter_birth_source();
int            enter_baptism_source();
int            enter_marriage_source();
int            enter_death_source();
    /* in the "save file as" window */
int            enter_save_file_text();
    /* in the "load file from" window */
int            enter_load_file_text();

/* scrolling list selections */
void           load_file_select();
void           save_file_select();
void           entry_select();
void           display_spouse();
void           display_child();

/* event handlers */
void           surname_event();


