
/* 
 * FCOPY.C - copy one file to another within clipper.
 * This is a sample of evaluating a code block from C only.
 * 
 * Test With Clipper 5.2 only
 * Copyright (c) Peter Kulek Aug 1993
 *
 * Compuserve ID  : 100140,1220
 * 
 * Specialising in Data Driven Object Oriented Applications for EIS & MIS
 *
 */


#include "extend.h"
#include "clipdefs.h"
#include "filesys.api"
#include "fm.api"
#include "item.api"

//#define BUFFER_SIZE 1024
#define BUFFER_SIZE 512
#define IF(x)       if (x) {
#define ELSE        } else {
#define ELSEIF(x)   } else if(x) {
#define ENDIF       }
#define EXIT        break;
#define DOWHILE     while(1) {
#define ENDDO       }

#define MALLOC(x)    _xalloc(x)
#define FREE(x)      _xfree(x)


long _fsCopy(BYTEP ,BYTEP ,ITEM ) ;
void blockeval( EVALINFO,ITEM, ULONG) ;

CLIPPER F_COPY() {
    ITEM block = _itemParam( 3 ) ;
    _retni(-1);
    IF ( ISCHAR(1) && ISCHAR(2) )
        _retnl(_fsCopy((BYTEP)_parc(1),(BYTEP)_parc(2),block));
    ENDIF
    return;
} 

long _fsCopy(BYTEP source,BYTEP dest ,ITEM block) {
        EVALINFO info;  // Create eval Info
        FHANDLE dHANDLE,sHANDLE;
        char    *buffer;
        USHORT  usCount;
        ULONG   ulCount = 0L;
        sHANDLE = _fsOpen(source, FO_READ);
        _evalNew( &info, block ); // Create an object of eval
        IF( ! _fsError() ) 
            dHANDLE = _fsCreate(dest,FC_NORMAL);
            IF( _fsError() ) 
                _fsClose(sHANDLE);
                return( -2L) ;
            ENDIF
            buffer = MALLOC(BUFFER_SIZE);
            IF(buffer == NULL)
                _fsClose(sHANDLE);
                _fsClose(dHANDLE);
                return(-3L) ;
            ENDIF
            usCount = _fsRead(sHANDLE,buffer,BUFFER_SIZE);
            DOWHILE
                ulCount += (ULONG)usCount;
                blockeval(info,block,ulCount);
                _fsWrite(dHANDLE,buffer, usCount);
                usCount = _fsRead(sHANDLE,buffer, BUFFER_SIZE);
                IF (usCount != BUFFER_SIZE )
                    EXIT
                ENDIF
            ENDDO 
            ulCount += (ULONG)usCount;
            blockeval(info,block,ulCount);
            _fsWrite(dHANDLE,buffer,usCount);
            FREE(buffer);
            _fsClose(sHANDLE);
            _fsClose(dHANDLE);
        ENDIF
        _evalRelease( &info );  // Release object
        return( ulCount );
}


// Test Eval of block from C
static void blockeval(EVALINFO info, ITEM block, ULONG count) {
    ITEM     retP;
    IF( _itemType(block) == BLOCK )
        _evalPutParam(&info,_itemPutNL(NULL,count)); // Put parameter on stack
        retP = _evalLaunch( &info );   // Eval code block
        _itemRelease( retP );  // release parameters from stack       
    ENDIF
    return;
}











