// SortWait.cpp : implementation file
//

#include "stdafx.h"
#include "FileCFG.h"
#include "SortWait.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSortWait dialog


CSortWait::CSortWait()
{
	//{{AFX_DATA_INIT(CSortWait)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_bParentDisabled = FALSE;
}

CSortWait::~CSortWait()
{
	if( m_hWnd != NULL ) DestroyWindow();
}

BOOL CSortWait::DestroyWindow()
{
	ReEnableParent();
	return CDialog::DestroyWindow();
}

void CSortWait::OnCancel()
{
}

void CSortWait::ReEnableParent()
{
	if( m_bParentDisabled && (m_pParentWnd != NULL) )
		m_pParentWnd->EnableWindow(TRUE);
	m_bParentDisabled=FALSE;
}

void CSortWait::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSortWait)
	DDX_Control(pDX, IDC_PROGRESS_SORT_WAIT, m_Progress);
	DDX_Control(pDX, IDC_ANIMATE_SORT_WAIT, m_Animation);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSortWait, CDialog)
	//{{AFX_MSG_MAP(CSortWait)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSortWait message handlers

BOOL CSortWait::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	VERIFY(m_Animation.Open(IDR_AVI_WAIT));
	m_Progress.SetStep(1);	
	return TRUE;
}


BOOL CSortWait::Create(CWnd* pParent)
{
	m_pParentWnd = CWnd::GetSafeOwner(pParent);

	if( (m_pParentWnd!=NULL) && m_pParentWnd->IsWindowEnabled() ){
      m_pParentWnd->EnableWindow(FALSE);
      m_bParentDisabled = TRUE;
    }

    if(!CDialog::Create(CSortWait::IDD,pParent))
    {
      ReEnableParent();
      return FALSE;
    }

	return TRUE;
}

void CSortWait::StepIt()
{
	PumpMessages();
	m_Progress.StepIt();
}

void CSortWait::PumpMessages()
{
    // Must call Create() before using the dialog
    ASSERT(m_hWnd!=NULL);

    MSG msg;
    // Handle dialog messages
    while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
    {
      if(!IsDialogMessage(&msg))
      {
        TranslateMessage(&msg);
        DispatchMessage(&msg);  
      }
    }
}