// SelectGroup.cpp : implementation file
//

#include "stdafx.h"
#include "FileCFG.h"
#include "SelectGroup.h"
#include "proboard.h"
#include <stdio.h>
#include <stdlib.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectGroup dialog

const char *CSelectGroup::strNoName = "<empty definition>";


CSelectGroup::CSelectGroup(CWnd* pParent /*=NULL*/)
	: CDialog(CSelectGroup::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectGroup)
	m_SelectAll = FALSE;
	m_GroupNum = -1;
	//}}AFX_DATA_INIT
}


void CSelectGroup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectGroup)
	DDX_Control(pDX, IDC_LIST_GROUPS, m_GroupList);
	DDX_Check(pDX, IDC_CHECK_INCLUDE_ALL, m_SelectAll);
	DDX_LBIndex(pDX, IDC_LIST_GROUPS, m_GroupNum);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectGroup, CDialog)
	//{{AFX_MSG_MAP(CSelectGroup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectGroup message handlers

BOOL CSelectGroup::OnInitDialog() 
{
	char       path[_MAX_PATH];
	TFileGroup group;
	CFile      file;

	CDialog::OnInitDialog();

	sprintf(path, "%s\\FGROUPS.PB", getenv("PROBOARD"));
	if( !file.Open(path, CFile::modeRead|CFile::typeBinary|CFile::shareDenyWrite) ){
		MessageBox("Could not open the group defintion file.","FileCFG/95",MB_OK|MB_ICONSTOP);
		OnCancel();
		return TRUE;	// not really needed, never hits it
	}
	UINT nBytes = file.Read(&group, sizeof(group));
	while( nBytes == sizeof(group) ){
		if( '\0' == group.name[0] ){
			m_GroupList.AddString(strNoName);
		}
		else{
			CString name = group.name;
			name.OemToAnsi();
			m_GroupList.AddString(name);
		}
		nBytes = file.Read(&group, sizeof(group));
	}
	file.Close();
	return TRUE;
}
