// PropFileGroup.cpp : implementation file
//

#include "stdafx.h"
#include "FileCFG.h"
#include "PropFileGroup.h"
#include "proboard.h"
#include <stdlib.h>
#include <stdio.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropFileGroup property page

IMPLEMENT_DYNCREATE(CPropFileGroup, CPropertyPage)

CPropFileGroup::CPropFileGroup() : CPropertyPage(CPropFileGroup::IDD)
{
	//{{AFX_DATA_INIT(CPropFileGroup)
	m_AllGroups = FALSE;
	m_CheckGroup1 = FALSE;
	m_CheckGroup2 = FALSE;
	m_CheckGroup3 = FALSE;
	m_CheckGroup4 = FALSE;
	m_Value1 = -1;
	m_Value2 = -1;
	m_Value3 = -1;
	m_Value4 = -1;
	//}}AFX_DATA_INIT
}

CPropFileGroup::~CPropFileGroup()
{
}

const char *CPropFileGroup::m_StrNoName = "<empty definition>";

void CPropFileGroup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropFileGroup)
	DDX_Control(pDX, IDC_COMBO_GROUP4, m_Group4);
	DDX_Control(pDX, IDC_COMBO_GROUP3, m_Group3);
	DDX_Control(pDX, IDC_COMBO_GROUP2, m_Group2);
	DDX_Control(pDX, IDC_COMBO_GROUP1, m_Group1);
	DDX_Check(pDX, IDC_CHECK_ALL_GROUPS, m_AllGroups);
	DDX_Check(pDX, IDC_CHECK_GROUP1, m_CheckGroup1);
	DDX_Check(pDX, IDC_CHECK_GROUP2, m_CheckGroup2);
	DDX_Check(pDX, IDC_CHECK_GROUP3, m_CheckGroup3);
	DDX_Check(pDX, IDC_CHECK_GROUP4, m_CheckGroup4);
	DDX_CBIndex(pDX, IDC_COMBO_GROUP1, m_Value1);
	DDX_CBIndex(pDX, IDC_COMBO_GROUP2, m_Value2);
	DDX_CBIndex(pDX, IDC_COMBO_GROUP3, m_Value3);
	DDX_CBIndex(pDX, IDC_COMBO_GROUP4, m_Value4);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropFileGroup, CPropertyPage)
	//{{AFX_MSG_MAP(CPropFileGroup)
	ON_BN_CLICKED(IDC_CHECK_GROUP1, OnCheckGroup1)
	ON_BN_CLICKED(IDC_CHECK_GROUP2, OnCheckGroup2)
	ON_BN_CLICKED(IDC_CHECK_GROUP3, OnCheckGroup3)
	ON_BN_CLICKED(IDC_CHECK_GROUP4, OnCheckGroup4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropFileGroup message handlers

void CPropFileGroup::OnCheckGroup1() 
{
	UpdateData(TRUE);
	if( TRUE == m_CheckGroup1 ){
		m_Group1.EnableWindow(TRUE);
	}
	else{
		m_Group1.EnableWindow(FALSE);
	}
}

void CPropFileGroup::OnCheckGroup2() 
{	
	UpdateData(TRUE);
	if( TRUE == m_CheckGroup2 ){
		m_Group2.EnableWindow(TRUE);
	}
	else{
		m_Group2.EnableWindow(FALSE);
	}
}

void CPropFileGroup::OnCheckGroup3() 
{	
	UpdateData(TRUE);
	if( TRUE == m_CheckGroup3 ){
		m_Group3.EnableWindow(TRUE);
	}
	else{
		m_Group3.EnableWindow(FALSE);
	}
}

void CPropFileGroup::OnCheckGroup4() 
{
	UpdateData(TRUE);
	if( TRUE == m_CheckGroup4 ){
		m_Group4.EnableWindow(TRUE);
	}
	else{
		m_Group4.EnableWindow(FALSE);
	}
}

BOOL CPropFileGroup::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	CFile      file;
	char       path[_MAX_PATH];
	TFileGroup group;

	// initialize the group settings here
	sprintf(path, "%s\\FGROUPS.PB", getenv("PROBOARD"));
	if( !file.Open(path, CFile::modeRead|CFile::typeBinary|CFile::shareDenyWrite) ){
		MessageBox("Cannot load group definitions.", "FileCFG/95", MB_OK|MB_ICONSTOP);
		return FALSE;
	}
	UINT bytes  = file.Read(&group, sizeof(group));
	while( bytes == sizeof(group) ){
		CString name;
		if( '\0' == group.name[0] ){
			name = m_StrNoName;
		}
		else{
			name = group.name;
			name.AnsiToOem();
		}
		m_Group1.AddString(name);
		m_Group2.AddString(name);
		m_Group3.AddString(name);
		m_Group4.AddString(name);
		bytes = file.Read(&group, sizeof(group));
	}
	file.Close();

	if( m_CheckGroup1 ) m_Group1.EnableWindow(TRUE);
	if( m_CheckGroup2 ) m_Group2.EnableWindow(TRUE);
	if( m_CheckGroup3 ) m_Group3.EnableWindow(TRUE);
	if( m_CheckGroup4 ) m_Group4.EnableWindow(TRUE);

	return TRUE;
}
