// PropFileLoc.cpp : implementation file
//

#include "stdafx.h"
#include "FileCFG.h"
#include "PropFileLoc.h"
#include <stdlib.h>
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropFileLoc property page

IMPLEMENT_DYNCREATE(CPropFileLoc, CPropertyPage)

CPropFileLoc::CPropFileLoc() : CPropertyPage(CPropFileLoc::IDD)
{
	//{{AFX_DATA_INIT(CPropFileLoc)
	m_FileListPath = _T("");
	m_FileLocation = _T("");
	m_AreaName = _T("");
	m_DateFormat = 0;
	//}}AFX_DATA_INIT
}

CPropFileLoc::~CPropFileLoc()
{
}

void CPropFileLoc::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropFileLoc)
	DDX_Text(pDX, IDC_EDIT_LISTING, m_FileListPath);
	DDV_MaxChars(pDX, m_FileListPath, 79);
	DDX_Text(pDX, IDC_EDIT_LOCATION, m_FileLocation);
	DDV_MaxChars(pDX, m_FileLocation, 79);
	DDX_Text(pDX, IDC_EDIT_NAME, m_AreaName);
	DDV_MaxChars(pDX, m_AreaName, 79);
	DDX_CBIndex(pDX, IDC_COMBO_DATE_STYLE, m_DateFormat);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropFileLoc, CPropertyPage)
	//{{AFX_MSG_MAP(CPropFileLoc)
	ON_BN_CLICKED(IDC_BUTTON_LISTING, OnButtonListing)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropFileLoc message handlers

void CPropFileLoc::OnButtonListing() 
{
	char        curPath[_MAX_PATH], listPath[_MAX_PATH];
	char        listDrive[_MAX_DRIVE], listDir[_MAX_DIR];
	DWORD       nFlags = OFN_HIDEREADONLY|OFN_NOLONGNAMES|OFN_NOTESTFILECREATE|OFN_EXTENSIONDIFFERENT;
	static char szFilter[] = "RA-compatible lists (*.bbs) | *.bbs | PCBoard lists (*.dir) | *.dir | "
							 "Listing files (*.lst) | *.lst | All files (*.*) | *.* ||";

	CFileDialog *dlg = new CFileDialog(TRUE, 0, "Files.*", nFlags, szFilter);

	_splitpath(m_FileListPath, listDrive, listDir, 0, 0);
	_makepath(listPath, listDrive, listDir, 0, 0);
	_getcwd(curPath, sizeof(curPath));
	_chdir(listPath);
	if( dlg ){
		if( IDOK == dlg->DoModal() ){
			m_FileListPath = dlg->GetPathName();
			UpdateData(FALSE);	// xfer to screen
		}
		delete dlg;
	}
	_chdir(curPath);
}

