// this is the file with all structures used
// by FileCFG to work in the ProBoard environment
#ifndef __PROBOARD_H
#define __PROBOARD_H

typedef unsigned char  uchar;
typedef unsigned short ushort;
typedef unsigned long  ulong;
typedef unsigned char  TTime[3];
typedef unsigned char  TFrame[7][6];

#pragma pack(1)

///////////////////////////////////////////////
// File area configuration: FILECFG.PRO
///////////////////////////////////////////////
struct TFileArea{
	char   name[80];
	char   listpath[80];
	char   filepath[80];
	ushort level;       
	ulong  flags;       
	uchar  copyLocal;   
	short  maxfiles;
	short  maxkb;
	uchar  notops;
	uchar  free;
	uchar  groups[4];
	uchar  allGroups;
	uchar  minAge;
	ulong  flagsNot;
	uchar  dateFormat;
	char   extra[2];
};

///////////////////////////////////////////////
// File group configuration: FGROUPS.PB
///////////////////////////////////////////////
struct TFileGroup{
	char   name[80];
	ushort level;
	ulong  flags;
	ulong  flagsNote;
	char   extra[10];
};

typedef TFileGroup TMesgGroup;

///////////////////////////////////////////////
// The filebase index: FILESIDX.PB
///////////////////////////////////////////////
struct TFileIndex{
	char   name[13];
	ushort area;
};

///////////////////////////////////////////////
// Main system configuration: CONFIG.PRO
///////////////////////////////////////////////
struct TProConfig{
	char   shellmsg[81];
	char   sysopname[36];
	char   txtpath[61];
	char   mnupath[61];
	char   msgpath[61];
	char   uploadpath[61];
	char   editorname[61];
	ushort newuserlevel;
	short  newuserloglevel;
	ulong  newuserflags;
	short  max_passinput;
	short  min_passlength;
	short  inactivity_time;
	short  max_sysop_pages;
	short  pagebell_length;
	short  mailcheck;
	short  europe;
	short  numnodes;
	uchar  allowansi;
	uchar  allowavatar;
	short  discrete;
	short  askphone;
	short  allowoneushort;
	ushort crashlevel;
	ulong  crashflags;
	ushort attachlevel;
	ulong  attachflags;
	short  allowmsgupload;
	short  allowstacking;
	TTime  page_start;
	TTime  page_end;
	short  handshaking;
	short  allowalias;
	short  loglocal;
	short  doswap;
	char   originline[61];
	char   nodelistdir[61];
	char   sysopkeys[10][60];
	TTime  dl_start;
	TTime  dl_end;
	short  uploadspace;
	char   pvtuploadpath[61];
	char   quotestring[6];
	uchar  fastmode;
	uchar  extra_uchar_1;
	uchar  killsent;
	uchar  multiline;
	uchar  egamode;
	uchar  showuserinfo;
	char   pexpath[61];
	uchar  allowquicklogin;
	uchar  suspendmsgtime;
	short  securityboard;
	uchar  pwdmessages;
	uchar  extra_uchar_2;
	char   bbsname[36];
	char   pwdchar;
	short  tb_maxtimedeposit;
	short  tb_maxkbdeposit;
	short  tb_maxtimewithdrawal;
	short  tb_maxkbwithdrawal;
	short  usage_days;
	char   systempwd[16];
	uchar  usesystempwd;
	uchar  askbirthdate;
	short  binlogdays;
	uchar  binloglocal;
	short  pageArea;
	uchar  indexfiles;
	uchar  checkdupes;
	uchar  killdupes;
	uchar  ignore_ext;
	char   RIPpath[61];
	char   iconspath[61];
	char   location[36];
	char   phone[26];
	char   QWKid[9];
	ushort IObuffersize;
	TFrame pagingHours;
	char   defaultLanguage[9];
	uchar  addUploaderName;
	TFrame downloadHours;
	uchar  askdataphone;
	uchar  askfaxphone;
	uchar  askaddress;
	uchar  asksex;
	uchar  askdateformat;
	uchar  askstate;
	uchar  askcountry;
	short  fuzzyRate;
	uchar  hidePassushort;
	uchar  valConfirm;
	char   extra_char_1[17];
	char   extChat[81];
	char   virScanCommand[61];
	uchar  virScanType;
	char   virScanSemaphore[13];
	uchar  listColorTag;
	uchar  listColorFileName;
	uchar  listColorSize;
	uchar  listColorDate;
	uchar  listColorCounter;
	uchar  listColorDesc;
	uchar  listColorSeperator;
	uchar  listColorMissing;
	uchar  hideFileCounter;
	uchar  disableRIP;
	char   extra_char_2[81];
	uchar  virScanFailedAction;
	ushort virScanFailedArea;
	char   extra[5];
};

#pragma pack ()
#endif