// GlobalFile.cpp : implementation file
//

#include "stdafx.h"
#include "FileCFG.h"
#include "GlobalFile.h"
#include "proboard.h"
#include <stdio.h>
#include <stdlib.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGlobalFile dialog

const char *CGlobalFile::m_StrNoName = "<empty definition>";

CGlobalFile::CGlobalFile(CWnd* pParent /*=NULL*/)
	: CDialog(CGlobalFile::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGlobalFile)
	m_AllGroups = 2;
	m_CDROM = 2;
	m_Free = 2;
	m_Tops = 2;
	m_CheckGroup1 = FALSE;
	m_CheckGroup2 = FALSE;
	m_CheckGroup3 = FALSE;
	m_CheckGroup4 = FALSE;
	m_CheckLevel = FALSE;
	m_CheckListEdit = FALSE;
	m_CheckFileLocation = FALSE;
	m_CheckMaxBytes = FALSE;
	m_CheckMaxFiles = FALSE;
	m_CheckMinAge = FALSE;
	m_Group1 = 0;
	m_Group2 = 0;
	m_Group3 = 0;
	m_Group4 = 0;
	m_ListReplace = _T("");
	m_ListWith = _T("");
	m_LocationReplace = _T("");
	m_LocationWith = _T("");
	m_MaxBytes = 0;
	m_MaxFiles = 0;
	m_MinAge = 0;
	m_Level = 0;
	//}}AFX_DATA_INIT
}


void CGlobalFile::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGlobalFile)
	DDX_Control(pDX, IDC_COMBO_GROUP4, m_ListGroup4);
	DDX_Control(pDX, IDC_COMBO_GROUP3, m_ListGroup3);
	DDX_Control(pDX, IDC_COMBO_GROUP2, m_ListGroup2);
	DDX_Control(pDX, IDC_COMBO_GROUP1, m_ListGroup1);
	DDX_Check(pDX, IDC_CHECK_FLAGS_ALL_GROUPS, m_AllGroups);
	DDX_Check(pDX, IDC_CHECK_FLAGS_CDROM, m_CDROM);
	DDX_Check(pDX, IDC_CHECK_FLAGS_FREE, m_Free);
	DDX_Check(pDX, IDC_CHECK_FLAGS_TOPS, m_Tops);
	DDX_Check(pDX, IDC_CHECK_GROUP1, m_CheckGroup1);
	DDX_Check(pDX, IDC_CHECK_GROUP2, m_CheckGroup2);
	DDX_Check(pDX, IDC_CHECK_GROUP3, m_CheckGroup3);
	DDX_Check(pDX, IDC_CHECK_GROUP4, m_CheckGroup4);
	DDX_Check(pDX, IDC_CHECK_LEVEL, m_CheckLevel);
	DDX_Check(pDX, IDC_CHECK_LIST, m_CheckListEdit);
	DDX_Check(pDX, IDC_CHECK_LOCATION, m_CheckFileLocation);
	DDX_Check(pDX, IDC_CHECK_MAX_BYTES, m_CheckMaxBytes);
	DDX_Check(pDX, IDC_CHECK_MAX_FILES, m_CheckMaxFiles);
	DDX_Check(pDX, IDC_CHECK_MIN_AGE, m_CheckMinAge);
	DDX_CBIndex(pDX, IDC_COMBO_GROUP1, m_Group1);
	DDX_CBIndex(pDX, IDC_COMBO_GROUP2, m_Group2);
	DDX_CBIndex(pDX, IDC_COMBO_GROUP3, m_Group3);
	DDX_CBIndex(pDX, IDC_COMBO_GROUP4, m_Group4);
	DDX_Text(pDX, IDC_EDIT_LIST_REPLACE, m_ListReplace);
	DDV_MaxChars(pDX, m_ListReplace, 79);
	DDX_Text(pDX, IDC_EDIT_LIST_WITH, m_ListWith);
	DDV_MaxChars(pDX, m_ListWith, 79);
	DDX_Text(pDX, IDC_EDIT_LOCATION_REPLACE, m_LocationReplace);
	DDV_MaxChars(pDX, m_LocationReplace, 79);
	DDX_Text(pDX, IDC_EDIT_LOCATION_WITH, m_LocationWith);
	DDV_MaxChars(pDX, m_LocationWith, 79);
	DDX_Text(pDX, IDC_EDIT_MAX_BYTES, m_MaxBytes);
	DDV_MinMaxInt(pDX, m_MaxBytes, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_MAX_FILES, m_MaxFiles);
	DDV_MinMaxInt(pDX, m_MaxFiles, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_MIN_AGE, m_MinAge);
	DDV_MinMaxByte(pDX, m_MinAge, 0, 255);
	DDX_Text(pDX, IDC_EDIT_LEVEL, m_Level);
	DDV_MinMaxInt(pDX, m_Level, 0, 65535);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGlobalFile, CDialog)
	//{{AFX_MSG_MAP(CGlobalFile)
	ON_BN_CLICKED(IDC_CHECK_GROUP1, OnCheckGroup1)
	ON_BN_CLICKED(IDC_CHECK_GROUP2, OnCheckGroup2)
	ON_BN_CLICKED(IDC_CHECK_GROUP3, OnCheckGroup3)
	ON_BN_CLICKED(IDC_CHECK_GROUP4, OnCheckGroup4)
	ON_BN_CLICKED(IDC_CHECK_LEVEL, OnCheckLevel)
	ON_BN_CLICKED(IDC_CHECK_LIST, OnCheckList)
	ON_BN_CLICKED(IDC_CHECK_LOCATION, OnCheckLocation)
	ON_BN_CLICKED(IDC_CHECK_MAX_BYTES, OnCheckMaxBytes)
	ON_BN_CLICKED(IDC_CHECK_MAX_FILES, OnCheckMaxFiles)
	ON_BN_CLICKED(IDC_CHECK_MIN_AGE, OnCheckMinAge)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGlobalFile message handlers

BOOL CGlobalFile::OnInitDialog() 
{
	CFile      file;
	char       path[_MAX_PATH];
	TFileGroup group;
	int        nGroups = 0;

	CDialog::OnInitDialog();

	// now load some group defintions in the lists
	sprintf(path, "%s\\FGROUPS.PB", getenv("PROBOARD"));
	if( !file.Open(path, CFile::modeRead|CFile::typeBinary|CFile::shareDenyWrite) ){
		MessageBox("Unable to load group definitions.", "FileCFG/95",MB_OK|MB_ICONSTOP);
		OnCancel();
		return TRUE;	// hardly necessary, OnCancel() will close it
	}
	UINT nBytes = file.Read(&group, sizeof(group));
	while( sizeof(group) == nBytes ){
		CString name;

		if( '\0' == group.name[0] ) name = m_StrNoName;
		else{
			name = group.name;
			name.OemToAnsi();
		}
		m_ListGroup1.AddString(name);
		m_ListGroup2.AddString(name);
		m_ListGroup3.AddString(name);
		m_ListGroup4.AddString(name);
		nBytes = file.Read(&group, sizeof(group));
	}
	file.Close();

	m_Group1 = m_Group2 = m_Group3 = m_Group4 = 0;
	UpdateData(FALSE);
	return TRUE;
}

void CGlobalFile::OnCheckGroup1() 
{
	UpdateData(TRUE);	// get data from control
	if( m_CheckGroup1 ) GetDlgItem(IDC_COMBO_GROUP1)->EnableWindow(TRUE);
	else GetDlgItem(IDC_COMBO_GROUP1)->EnableWindow(FALSE);
}

void CGlobalFile::OnCheckGroup2() 
{
	UpdateData(TRUE);	// get data from control
	if( m_CheckGroup2 ) GetDlgItem(IDC_COMBO_GROUP2)->EnableWindow(TRUE);
	else GetDlgItem(IDC_COMBO_GROUP2)->EnableWindow(FALSE);
}

void CGlobalFile::OnCheckGroup3() 
{
	UpdateData(TRUE);	// get data from control
	if( m_CheckGroup3 ) GetDlgItem(IDC_COMBO_GROUP3)->EnableWindow(TRUE);
	else GetDlgItem(IDC_COMBO_GROUP3)->EnableWindow(FALSE);
}

void CGlobalFile::OnCheckGroup4() 
{
	UpdateData(TRUE);	// get data from control
	if( m_CheckGroup4 ) GetDlgItem(IDC_COMBO_GROUP4)->EnableWindow(TRUE);
	else GetDlgItem(IDC_COMBO_GROUP4)->EnableWindow(FALSE);
}

void CGlobalFile::OnCheckLevel() 
{
	UpdateData(TRUE);
	if( m_CheckLevel ) GetDlgItem(IDC_EDIT_LEVEL)->EnableWindow(TRUE);
	else GetDlgItem(IDC_EDIT_LEVEL)->EnableWindow(FALSE);
}

void CGlobalFile::OnCheckList() 
{
	UpdateData(TRUE);
	if( m_CheckListEdit ){
		GetDlgItem(IDC_EDIT_LIST_REPLACE)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_LIST_WITH)->EnableWindow(TRUE);
	}
	else{
		GetDlgItem(IDC_EDIT_LIST_REPLACE)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_LIST_WITH)->EnableWindow(FALSE);
	}
}

void CGlobalFile::OnCheckLocation() 
{
	UpdateData(TRUE);
	if( m_CheckFileLocation ){
		GetDlgItem(IDC_EDIT_LOCATION_REPLACE)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_LOCATION_WITH)->EnableWindow(TRUE);
	}
	else{
		GetDlgItem(IDC_EDIT_LOCATION_REPLACE)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_LOCATION_WITH)->EnableWindow(FALSE);
	}
}

void CGlobalFile::OnCheckMaxBytes() 
{
	UpdateData(TRUE);
	if( m_CheckMaxBytes ) GetDlgItem(IDC_EDIT_MAX_BYTES)->EnableWindow(TRUE);
	else GetDlgItem(IDC_EDIT_MAX_BYTES)->EnableWindow(FALSE);
}

void CGlobalFile::OnCheckMaxFiles() 
{
	UpdateData(TRUE);
	if( m_CheckMaxFiles ) GetDlgItem(IDC_EDIT_MAX_FILES)->EnableWindow(TRUE);
	else GetDlgItem(IDC_EDIT_MAX_FILES)->EnableWindow(FALSE);
}

void CGlobalFile::OnCheckMinAge() 
{
	UpdateData(TRUE);
	if( m_CheckMinAge ) GetDlgItem(IDC_EDIT_MIN_AGE)->EnableWindow(TRUE);
	else GetDlgItem(IDC_EDIT_MIN_AGE)->EnableWindow(FALSE);
}
